// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory.
// Licensed under the GNU GPL Version 2, or (at your option) any later version.

#include "FE.h"

#include <stdexcept>

using namespace std;

namespace SyFi
{

	StandardFE:: StandardFE()
	{
		p = NULL;
		order = -1;
		description = "StandardFE";
	}

	StandardFE:: StandardFE(Polygon& p_, unsigned int order)
	{
		p = NULL;
		set_polygon(p_);
		set_order(order);
		description = "StandardFE";
	}

	StandardFE:: ~StandardFE()
	{
		if (p)
		{
			delete p;
		}
	}

	unsigned int StandardFE:: nbf() const
	{
		return Ns.size();
	}

	std::string StandardFE:: str()
	{
		return description;
	}

	void StandardFE:: compute_basis_functions()
	{
		cout <<"StandardFE compute_basis_functions not implemented."<<endl;
		cout <<"Use some derived class like e.g. LagrangeFE."<<endl;
	}

	Polygon& StandardFE:: get_polygon()
	{
		if(!p)
		{
			throw std::runtime_error("No polygon has been set!");
		}
		return *p;
	}

	void StandardFE:: set_polygon(Polygon& p_)
	{
		Ns.clear();
		dofs.clear();
		if (p)
		{
			delete p;
		}
		p = p_.copy();
	}

	unsigned int StandardFE:: get_order()
	{
		return order;
	}

	void StandardFE:: set_order(unsigned int order_)
	{
		Ns.clear();
		dofs.clear();
		order = order_;
	}

	GiNaC::ex StandardFE:: dof(unsigned int i)
	{
		if ( i < 0 || i > nbf()-1)
		{
			throw(std::out_of_range("The index is out of range!"));
		}
		return dofs[i];
	}

	GiNaC::ex StandardFE::N(unsigned int i)
	{
		if ( i < 0 || i > nbf()-1)
		{
			throw(std::out_of_range("The index is out of range!"));
		}
		return Ns[i];
	}

}								 // namespace SyFi
