// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory.
// Licensed under the GNU GPL Version 2, or (at your option) any later version.

#ifndef FE_IS_INCLUDED
#define FE_IS_INCLUDED

#include <string>
#include "Polygon.h"

namespace SyFi
{

	class FE
	{
		public:
			FE() {}
			virtual ~FE() {}

								 // Set polygonal domain
			virtual void set_polygon(Polygon& p) = 0;
								 // Get polygonal domain
			virtual Polygon& get_polygon() = 0;

								 // precompute basis functions
			virtual void compute_basis_functions() = 0;
								 // Number of basis functions/ degrees of freedom
			virtual unsigned int nbf() const = 0;
								 // The i'th basis function
			virtual GiNaC::ex N(unsigned int i) = 0;
								 // The i'th degree of freedom
			virtual GiNaC::ex dof(unsigned int i) = 0 ;
			virtual std::string str() = 0;
	};

	class StandardFE : public FE
	{
		protected:
			GiNaC::exvector  Ns;
			GiNaC::exvector  dofs;
			Polygon* p;
			unsigned int order;
			std::string description;

		public:
			StandardFE();
			StandardFE(Polygon& p, unsigned int order);
			virtual ~StandardFE();

			virtual void set_order(unsigned int order);
			virtual unsigned int  get_order();

			virtual void set_polygon(Polygon& p);
			virtual Polygon& get_polygon();

			virtual void compute_basis_functions();
			virtual unsigned int nbf() const;
			virtual GiNaC::ex N(unsigned int i);
			virtual GiNaC::ex dof(unsigned int i);
			virtual std::string str();
	};
}
#endif
