#!/usr/bin/env python

__authors__ = "Martin Sandve Alnes"
__date__ = "2008-09-04 -- 2008-10-17"

import unittest
import os, sys, glob, shutil, commands

import ufl
from ufl import *
import SyFi
import sfc as sfc

from cell_assembly import assemble_on_cell


def num_integrals(form):
    return (form.num_cell_integrals(), form.num_exterior_facet_integrals(), form.num_interior_facet_integrals())


_test_temp_dir = "temp_dir"
_done_test_temp_dir = "done_temp_dir"
class QuadJitTest(unittest.TestCase):
    def __init__(self, *args, **kwargs):
        unittest.TestCase.__init__(self, *args, **kwargs)
        shutil.rmtree(_done_test_temp_dir, ignore_errors=True)
        os.mkdir(_done_test_temp_dir)
    
    def setUp(self):
        #print "Running sfc jit test in testdir"
        #print "Imported SyFi from location", SyFi.__file__
        #print "Imported sfc  from location", sfc.__file__
        self.options = sfc.default_options()
        self.options.compilation.cache_dir = os.path.abspath("test_cache")
        self.options.code.integral.integration_method = "quadrature"
        # Generate code in a clean directory:
        shutil.rmtree(_test_temp_dir, ignore_errors=True)
        os.mkdir(_test_temp_dir)
        os.chdir(_test_temp_dir)
    
    def tearDown(self):
        dirs = glob.glob("*")
        os.chdir("..")
        for d in dirs:
            os.rename(os.path.join(_test_temp_dir, d), os.path.join(_done_test_temp_dir, d))
    
    def testSetup(self):
        pass
    
    def testJitMass(self):
        "Test the mass matrix."
        element = FiniteElement("CG", "triangle", 1)
        v = TestFunction(element)
        u = TrialFunction(element)
        a = u*v*dx
        form = sfc.jit(a, options = self.options)
        self.assertTrue(form.rank() == 2)
        self.assertTrue(form.num_coefficients() == 0)
        self.assertTrue(num_integrals(form) == (1,0,0))
        A = assemble_on_cell(form, "triangle", coeffs=[5.43])
        # TODO: Assert correct result


tests = [QuadJitTest]

if __name__ == "__main__":
    unittest.main()

