// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory.
// Licensed under the GNU GPL Version 2, or (at your option) any later version.

#ifndef LAGRANGEFE_IS_INCLUDED
#define LAGRANGEFE_IS_INCLUDED

#include "FE.h"

namespace SyFi
{

	class Lagrange : public StandardFE
	{
		public:
			Lagrange();
			Lagrange(Polygon& p, unsigned int order = 1);
			virtual ~Lagrange() {}

			virtual void compute_basis_functions();
	};

	class VectorLagrange : public StandardFE
	{
		protected:
			unsigned int size;
		public:
			VectorLagrange();
			VectorLagrange(Polygon& p, unsigned int order = 1, unsigned int size = 0);
			~VectorLagrange() {}

			virtual void set_size(unsigned int size_);
			virtual void compute_basis_functions();
	};

	class TensorLagrange : public StandardFE
	{
		protected:
			unsigned int size;
		public:
			TensorLagrange();
			TensorLagrange(Polygon& p, unsigned int order = 1, unsigned int size = 0);
			~TensorLagrange() {}

			virtual void set_size(unsigned int size_);
			virtual void compute_basis_functions();
	};

	GiNaC::ex lagrange(unsigned int order, Polygon& p, const std::string & a);
	GiNaC::lst lagrangev(unsigned int no_fields, unsigned int order, Polygon& p, const std::string & a);

}								 // namespace SyFi
#endif
