// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory.
// Licensed under the GNU GPL Version 2, or (at your option) any later version.

#ifndef CONTAINERS_IS_INCLUDED
#define CONTAINERS_IS_INCLUDED

#include <string>
#include <vector>
#include <list>
#include <set>
#include <map>

#include <ginac/ginac.h>

namespace SyFi
{

	// container typedefs
	typedef std::pair<GiNaC::symbol, GiNaC::ex>               symexpair;
	typedef std::list< std::pair<GiNaC::symbol, GiNaC::ex> >  symexlist;

	//typedef std::vector<GiNaC::ex>                            exvector;
	typedef std::list<GiNaC::ex>                              exlist;
	typedef std::set<GiNaC::ex, GiNaC::ex_is_less>            exset;
	//typedef std::map<GiNaC::ex, GiNaC::ex, GiNaC::ex_is_less> exmap;
	typedef std::map<GiNaC::ex, int, GiNaC::ex_is_less>       ex_int_map;

}								 // namespace SyFi
#endif
