// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory
//
// This file is part of SyFi.
//
// SyFi is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// SyFi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with SyFi. If not, see <http://www.gnu.org/licenses/>.

#ifndef TIMEELEMENT_IS_INCLUDED
#define TIMEELEMENT_IS_INCLUDED

#include "FE.h"

namespace SyFi
{

	class SpaceTimeDomain : public Polygon
	{
		Line* time_line;
		Polygon* polygon;
		public:
			SpaceTimeDomain(Line& time_line_, Polygon& polygon_);
			SpaceTimeDomain(const SpaceTimeDomain& space_time_domain_);

			Polygon& get_space_domain() const { return *((*polygon).copy()); }
			Line& get_time_domain() const { return *((*time_line).copy()); }

			virtual unsigned int no_space_dim() const;

			virtual Line line(unsigned int i) const;

			virtual GiNaC::ex repr(Repr_format = SUBS_PERFORMED) const;
			virtual const std::string str() const;

			virtual GiNaC::ex integrate(GiNaC::ex f, Repr_format format = SUBS_PERFORMED);

			virtual SpaceTimeDomain* copy() const;
	};

	class SpaceTimeElement : public StandardFE
	{
		int order;
		Line* time_line;
		StandardFE* fe;

		public:
			SpaceTimeElement();
			SpaceTimeElement(Line* time_line_, unsigned int order_, StandardFE* fe_);
			virtual ~SpaceTimeElement() {}

			void set_time_domain(Line* line);
			void set_order_in_time(unsigned int order);
			void set_spatial_element(StandardFE* fe);
			virtual void compute_basis_functions();
	};

}								 // namespace SyFi
#endif
