// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory
//
// This file is part of SyFi.
//
// SyFi is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// SyFi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with SyFi. If not, see <http://www.gnu.org/licenses/>.

#ifndef UTILITIES_IS_INCLUDED
#define UTILITIES_IS_INCLUDED

#include <string>

#include <ginac/ginac.h>

#include "containers.h"

namespace SyFi
{
        extern const int version_major;
        extern const int version_minor;
        extern const char* version_micro;

	// dirac delta function
	int dirac(unsigned int i, unsigned int j);

	// string utilities
	std::string int2string(int i);

	std::string istr(const std::string & a, int b);

	std::string istr(const std::string & a, int b, int c);

	std::string lst2string(GiNaC::lst& l);
	//std::string lst2string(GiNaC::exvector& v);

	//GiNaC::lst compute_functions(GiNaC::lst& equations, GiNaC::lst& variables, GiNaC::lst& space);

	// print functions
	#ifndef SWIG
	void print(GiNaC::exvector& v);
	void print(GiNaC::lst& l);
	void print(GiNaC::exmap m);
	void print(ex_int_map m);
	void print(std::map<std::pair<unsigned int,unsigned int>, GiNaC::ex> & A);
	#endif

}								 // namespace SyFi
#endif
