
 
 






/* === S Y N F I G ========================================================= */
/*!	\file nodebase.h
**	\brief Template Header
**
**	$Id: nodebase.px 341 2007-03-16 08:24:58Z dooglus $
**
**	\legal
**	Copyright (c) 2002-2005 Robert B. Quattlebaum Jr., Adrian Bentley
**
**	This package is free software; you can redistribute it and/or
**	modify it under the terms of the GNU General Public License as
**	published by the Free Software Foundation; either version 2 of
**	the License, or (at your option) any later version.
**
**	This package is distributed in the hope that it will be useful,
**	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**	General Public License for more details.
**	\endlegal
*/
/* ========================================================================= */

/* === S T A R T =========================================================== */

#ifndef __SYNFIG_NODEBASE_H
#define __SYNFIG_NODEBASE_H

/* === H E A D E R S ======================================================= */

#include "../protocol.h"
#include "../string.h"
#include "../guid.h"
#include <sigc++/slot.h>

/* === M A C R O S ========================================================= */

/* === T Y P E D E F S ===================================================== */

/* === C L A S S E S & S T R U C T S ======================================= */

namespace synfig {
namespace Proto {

typedef int Query;
typedef int NodeList;

class NodeBase : public Protocol
{
public:

	
	sigc::slot< GUID > _slot_get_guid_const;
	GUID get_guid()const {
		return _slot_get_guid_const();
	}


	sigc::slot< void, GUID > _slot_set_guid;
	void set_guid(GUID v1) {
		return _slot_set_guid(v1);
	}



	
	sigc::slot< float, int,int > _slot_func_test;
	float func_test(int v1, int v2) {
		return _slot_func_test(v1, v2);
	}


	
	sigc::slot< String > _slot_get_id_const;
	String get_id()const {
		return _slot_get_id_const();
	}


	sigc::slot< void, String > _slot_set_id;
	void set_id(String v1) {
		return _slot_set_id(v1);
	}



	
	sigc::slot< NodeHandle > _slot_get_root_const;
	NodeHandle get_root()const {
		return _slot_get_root_const();
	}


	sigc::slot< void, NodeHandle > _slot_set_root;
	void set_root(NodeHandle v1) {
		return _slot_set_root(v1);
	}



	
	sigc::slot< sigc::signal<void> > _slot_signal_changed;
	sigc::signal<void> signal_changed() {
		return _slot_signal_changed();
	}

	
	sigc::slot< sigc::signal<void> > _slot_signal_deleted;
	sigc::signal<void> signal_deleted() {
		return _slot_signal_deleted();
	}

		
	
	sigc::slot< const NodeList > _slot_get_parents_const;
	const NodeList get_parents()const {
		return _slot_get_parents_const();
	}

	
	sigc::slot< const NodeList > _slot_get_children_const;
	const NodeList get_children()const {
		return _slot_get_children_const();
	}


	
	sigc::slot< NodeList, Query > _slot_query_children;
	NodeList query_children(Query v1) {
		return _slot_query_children(v1);
	}


}; // END of class Proto::NodeBase

}; // END of namespace Proto
}; // END of namespace synfig

/* === E N D =============================================================== */

#endif
