C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=EVATYP,SSI=0
C
                        SUBROUTINE EVATYP
C                       *****************
C
C     ---------------------------------------------------------
     * (NN,NDIELE,NODE,NELE,NDMAT,NREF,NDREF, 
     *  LFFLU,LFCOU,LFRES,LFRAY,NBFACE,LPDIR)
C     ---------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------                                                           *
C       EVALUATION DES TYPES DE FACETTES D'UN ELEMENT EN 2D ET 3D      *
C       On regarde si les facettes sont :                              *
C               - couplees                                             *
C               - couplee mais portant des Dirichlet                   *
C               - avec condition de flux                               *
C               - avec condition de flux mais portant des Dirichlet    *
C               - avec condition d'echange mais portant des Dirichlet  *
C                                                                      *
C  En 2D des facettes du type :                                        *
C                                                                      *
C    D ------- F -------- F     ou    D ------- D -------- F           *
C                                                                      *
C                                                                      *
C                                                                      *
C  En 3D des facettes du type :                                        *
C                                                                      *
C   D --- F --- F        D --- D --- D       F --- F --- F             *
C   \           /        \           /       \           /             *
C    \         /          \         /         \         /              *
C     F       F            D       D           D       D               *
C      \     /              \     /             \     /                *
C       \   /                \   /               \   /                 *
C         F                    F                   D                   *
C                                                                      *
C       donc en realite des que la facette possede au moins            *
C       un noeud de type flux, il est necessaire de la prendre         *
C       en compte dans le maillage des faces de flux                   *
C       en imposant Flux=0 au(x) noeud(s) Dirichlet                    *
C       Un tel noeud Dirichlet doit par consequent egalement           *
C       appartenir a la liste des noeuds avec flux !                   *
C       Cette meme remarque est vraie pour des facettes possedant      *
C       noeuds couples et Dirichlet et coefficient d'echange et        *
C       Dirichlet                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   ! NN     !   E  ! D  ! NUMERO DE L'ELEMENT COURANT                 !
C   ! NODE   !   E  ! D  ! CONNECTIVITE DU MAILLAGE                    !
C   ! NELE   !   E  ! D  ! NOMBRE D'ELEMENTS DU MAILLAGE               !
C   ! NDMAT  !   E  ! D  ! NOMBRE DE NOEUDS DES ELEMENTS               !
C   ! NREF   !   E  ! M  ! REFERENCES DES NOEUDS DU MAILLAGE           !
C   ! NDIREF !   E  ! D  ! DIMENSION DU TABLEAU DES REFERENCES         !
C   ! LFFLUi !   L  ! R  ! INDIQUE SI LA FACE i APPARTIENT AU MAILLAGE !
C   !        !      !    ! DES NOEUDS AVEC CONDITION DE FLUX           !
C   ! LFCOUi !   L  ! R  ! INDIQUE SI LA FACE i APPARTIENT AU MAILLAGE !
C   !        !      !    ! DES NOEUDS COUPLES                          !
C   ! LPDIR  !  TL  ! R  ! INDIQUE SI LE POINT i PORTE UN DIRICHLET EN !
C   !        !      !    ! EN APPARTENANT A UNE FACE DE TYPE FLUX      !
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :  
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON
C**********************************************************************
C
#include "xrefer.h"
#include "optct.h"
C
C**********************************************************************
C
      INTEGER NDX
      PARAMETER (NDX= 10)
C
C.. Variables externes
      INTEGER NN,NDIELE,NDREF,NELE,NDMAT,NODE(NELE,NDMAT),NREF(NDREF)
      INTEGER NBFACE
      LOGICAL LFFLU(NBFACE),LFCOU(NBFACE),LFRES(NBFACE),LFRAY(NBFACE)
      LOGICAL LPDIR(NDMAT)

C.. Variables internes
      LOGICAL LFLU(NDX),LCOU(NDX),LDIR(NDX),LRES(NDX),LRAYT(NDX)
      INTEGER N(NDX),NR(NDX),M,L,N1,N2,N3,N4,N5,N6,NS,NF
C
C**********************************************************************
C     FONCTIONS IMPLICITES
C**********************************************************************
C
C
C**********************************************************************
C
C     0. INITIALISATIONS
C     ==================
C
      DO 10 M=1,NDMAT
        N(M) = NODE(NN,M)
   10 CONTINUE 
C
      DO 20 M=1,NDMAT
        NR(M) = NREF(N(M))
   20 CONTINUE 
C
      DO 30 M=1,NDMAT
        LFLU(M) = .FALSE.
   30 CONTINUE 
C
      DO 40 M=1,NDMAT
        LCOU(M) = .FALSE.
   40 CONTINUE 
C
      DO 50 M=1,NBFACE
        LFFLU(M) = .FALSE.
   50 CONTINUE 
C
      DO 60 M=1,NBFACE
        LFCOU(M) = .FALSE.
   60 CONTINUE 
C
      DO 70 M=1,NDMAT
        LDIR(M) = .FALSE.
   70 CONTINUE
C
      DO 80 M=1,NDMAT
        LRES(M) = .FALSE.
   80 CONTINUE
C
      DO 90 M=1,NBFACE
        LFRES(M) = .FALSE.
   90 CONTINUE
C
      DO 94 M=1,NDMAT
        LRAYT(M) = .FALSE.
   94 CONTINUE
C
      DO 95 M=1,NBFACE
        LFRAY(M) = .FALSE.
   95 CONTINUE
C
      DO 99 M=1,NDMAT
        LPDIR(M) = .FALSE.
   99 CONTINUE
C
C
C     1. REPERAGE DU TYPE DES NOEUDS
C     ==============================
C
      DO 110 M=1,NRFMAX
C
       DO 111 L=1,NDMAT
C
        IF ( IREFSC(M).NE.0 .AND. ABS(NR(L)).EQ.M .OR.
     &       IREFSF(M).NE.0 .AND. ABS(NR(L)).EQ.M .OR.
     &       IREFSE(M).NE.0 .AND. ABS(NR(L)).EQ.M .OR.
     &       IREFRE(M).NE.0 .AND. ABS(NR(L)).EQ.M .OR.
     &       IREFRA(M).NE.0 .AND. ABS(NR(L)).EQ.M .OR.
     &       IREFRI(M).NE.0 .AND. ABS(NR(L)).EQ.M )
     &       LFLU(L) = .TRUE.
C
         IF ( IREFSC(M).NE.0 .AND. ABS(NR(L)).EQ.M ) LCOU(L) = .TRUE.
C
         IF ( IREFSD(M).NE.0 .AND. ABS(NR(L)).EQ.M ) LDIR(L) = .TRUE.
C
         IF ( IREFRE(M).NE.0 .AND. ABS(NR(L)).EQ.M ) LRES(L) = .TRUE.
C
         IF ( IREFRA(M).NE.0 .AND. ABS(NR(L)).EQ.M ) LRAYT(L) = .TRUE.
C
  111  CONTINUE
C
  110 CONTINUE
C
C
C     2- CAS DE LA DIMENSION 2
C     ========================
C
      IF (NCTHFS.NE.2 .AND. NDIELE.EQ.2) THEN
C
       DO 200 NS = 1,NBFACE
C
        N1 = NS
        N2 = NS+3
        N3 = NS+1
        IF (N3.EQ.4) N3=1
C
        IF (LCOU(N1) .AND. LCOU(N2) .AND. LCOU(N3)) LFCOU(NS) = .TRUE.
C
        IF (LRAYT(N1) .AND. LRAYT(N2) .AND. LRAYT(N3)) 
     *                                              LFRAY(NS) = .TRUE.
C
        IF (LRES(N1) .AND. LRES(N2) .AND. LRES(N3)) LFRES(NS) = .TRUE.
C
        IF (LFLU(N1) .OR. LFLU(N3)) THEN
           IF (LFLU(N2) .OR. LDIR(N2)) LFFLU(NS) = .TRUE.
        ENDIF
C
        IF (LFFLU(NS)) THEN
          IF (LDIR(N1) .AND. NR(N1).GT.0)  LPDIR(N1) = .TRUE.
          IF (LDIR(N2) .AND. NR(N2).GT.0)  LPDIR(N2) = .TRUE.
          IF (LDIR(N3) .AND. NR(N3).GT.0)  LPDIR(N3) = .TRUE.
C
          IF (LDIR(N1) .AND. NREF(N(N1)).GT.0) NREF(N(N1))= - NR(N1)
          IF (LDIR(N2) .AND. NREF(N(N2)).GT.0) NREF(N(N2))= - NR(N2)
          IF (LDIR(N3) .AND. NREF(N(N3)).GT.0) NREF(N(N3))= - NR(N3)
        ENDIF
C
  200  CONTINUE
        
C
C
C     3. CAS DE LA DIMENSION 3
C     ========================
C
      ELSEIF (NDIELE.EQ.3) THEN
C
C
       DO 300 NF = 1,NBFACE
C
        IF (NF.EQ.1) THEN
          N1 = 1
          N2 = 5
          N3 = 2
          N4 = 6
          N5 = 3
          N6 = 7
        ELSEIF (NF.EQ.2) THEN
          N1 = 1
          N2 = 5
          N3 = 2
          N4 = 9
          N5 = 4
          N6 = 8
        ELSEIF (NF.EQ.3) THEN
          N1 = 1
          N2 = 7
          N3 = 3
          N4 = 10
          N5 = 4
          N6 = 8
        ELSE 
          N1 = 2
          N2 = 6
          N3 = 3
          N4 = 10
          N5 = 4
          N6 = 9
        ENDIF
C
        IF (LCOU(N1) .AND. LCOU(N2) .AND. LCOU(N3) .AND.
     &      LCOU(N4) .AND. LCOU(N5) .AND. LCOU(N6)) LFCOU(NF) = .TRUE.
C
        IF (LRAYT(N1) .AND. LRAYT(N2) .AND. LRAYT(N3) .AND.
     &      LRAYT(N4) .AND. LRAYT(N5) .AND. LRAYT(N6)) 
     &                                              LFRAY(NF) = .TRUE.
C
        IF (LRES(N1) .AND. LRES(N2) .AND. LRES(N3) .AND.
     &      LRES(N4) .AND. LRES(N5) .AND. LRES(N6)) LFRES(NF) = .TRUE.
C
        IF (LFLU(N1) .OR. LFLU(N2) .OR. LFLU(N3) .OR.
     &      LFLU(N4) .OR. LFLU(N5) .OR. LFLU(N6)) THEN
             IF ( (LFLU(N2).OR.LDIR(N2)) .AND.
     &            (LFLU(N4).OR.LDIR(N4)) .AND.
     &            (LFLU(N6).OR.LDIR(N6)) ) LFFLU(NF) = .TRUE.
        ENDIF
C
        IF (LFFLU(NF)) THEN
          IF (LDIR(N1) .AND. NR(N1).GT.0)  LPDIR(N1) = .TRUE.
          IF (LDIR(N2) .AND. NR(N2).GT.0)  LPDIR(N2) = .TRUE.
          IF (LDIR(N3) .AND. NR(N3).GT.0)  LPDIR(N3) = .TRUE.
          IF (LDIR(N4) .AND. NR(N4).GT.0)  LPDIR(N4) = .TRUE.
          IF (LDIR(N5) .AND. NR(N5).GT.0)  LPDIR(N5) = .TRUE.
          IF (LDIR(N6) .AND. NR(N6).GT.0)  LPDIR(N6) = .TRUE.
C
C         Marquage des Dirichlet
          IF (LDIR(N1) .AND. NREF(N(N1)).GT.0) NREF(N(N1))= - NR(N1)
          IF (LDIR(N2) .AND. NREF(N(N2)).GT.0) NREF(N(N2))= - NR(N2)
          IF (LDIR(N3) .AND. NREF(N(N3)).GT.0) NREF(N(N3))= - NR(N3)
          IF (LDIR(N4) .AND. NREF(N(N4)).GT.0) NREF(N(N4))= - NR(N4)
          IF (LDIR(N5) .AND. NREF(N(N5)).GT.0) NREF(N(N5))= - NR(N5)
          IF (LDIR(N6) .AND. NREF(N(N6)).GT.0) NREF(N(N6))= - NR(N6)
        ENDIF
C
  300  CONTINUE
C
C
C
C     4- CAS DU MODELE COQUE
C     ======================
C
      ELSE
C
        NF = 1
C
        N1 = 1
        N2 = 2
        N3 = 3
        N4 = 4
        N5 = 5
        N6 = 6
C
        IF (LCOU(N1) .AND. LCOU(N2) .AND. LCOU(N3) .AND.
     &      LCOU(N4) .AND. LCOU(N5) .AND. LCOU(N6)) LFCOU(NF) = .TRUE.
C
        IF (LRES(N1) .AND. LRES(N2) .AND. LRES(N3) .AND.
     &      LRES(N4) .AND. LRES(N5) .AND. LRES(N6)) LFRES(NF) = .TRUE.
C
        IF (LFLU(N1) .OR. LFLU(N2) .OR. LFLU(N3) .OR.
     &      LFLU(N4) .OR. LFLU(N5) .OR. LFLU(N6)) THEN
             IF ( (LFLU(N2).OR.LDIR(N2)) .AND.
     &            (LFLU(N4).OR.LDIR(N4)) .AND.
     &            (LFLU(N6).OR.LDIR(N6)) ) LFFLU(NF) = .TRUE.
        ENDIF
C
        IF (LFFLU(NF)) THEN
          IF (LDIR(N1) .AND. NR(N1).GT.0)  LPDIR(N1) = .TRUE.
          IF (LDIR(N2) .AND. NR(N2).GT.0)  LPDIR(N2) = .TRUE.
          IF (LDIR(N3) .AND. NR(N3).GT.0)  LPDIR(N3) = .TRUE.
          IF (LDIR(N4) .AND. NR(N4).GT.0)  LPDIR(N4) = .TRUE.
          IF (LDIR(N5) .AND. NR(N5).GT.0)  LPDIR(N5) = .TRUE.
          IF (LDIR(N6) .AND. NR(N6).GT.0)  LPDIR(N6) = .TRUE.
C
          IF (LDIR(N1) .AND. NREF(N(N1)).GT.0) NREF(N(N1))= - NR(N1)
          IF (LDIR(N2) .AND. NREF(N(N2)).GT.0) NREF(N(N2))= - NR(N2)
          IF (LDIR(N3) .AND. NREF(N(N3)).GT.0) NREF(N(N3))= - NR(N3)
          IF (LDIR(N4) .AND. NREF(N(N4)).GT.0) NREF(N(N4))= - NR(N4)
          IF (LDIR(N5) .AND. NREF(N(N5)).GT.0) NREF(N(N5))= - NR(N5)
          IF (LDIR(N6) .AND. NREF(N(N6)).GT.0) NREF(N(N6))= - NR(N6)
        ENDIF
        
C
C
      ENDIF
C     =====
C
C--------
C FORMATS
C--------
C----
C FIN
C----
C
      RETURN
      END

