C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE IFICCT
C                       *****************
C
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :
C ----------
C
C       INITIALISATION DES NUMEROS LOGIQUES DES FICHIERS DE SYRTHES
C       -----------------------------------------------------------
C
C
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !           !    !    !                                              !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /NLOFIC/  !    ! R  ! TOUTES LES VARIABLES                         !
C !___________!____!____!______________________________________________!
C
C     TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C            L (LOGIQUE)   .. ET TYPES COMPOSES (EX : TR TABLEAU REEL)
C     MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (AUXILIAIRE MODIFIE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ----
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : ????
C
C-----------------------------------------------------------------------
C     BIBLIOTHEQUES EXTERIEURES   :  ---
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  (VOIR LA SIGNIFICATION COMPLETE DANS LECDON)
C **********************************************************************
C
#include "nlofes.h"
#include "nlofct.h"
C     
C***********************************************************************
C
C     1- ECRAN, CLAVIER
C     -----------------
      NFECRA = 6
      NFCLAV = 5
C
C     2- Conditions aux limites (syrthes.data)
C     ---------------------------------------
      NFCLCT = 50
C
C     3- Solide : maillage Simail
C     ---------------------------
      NFSGCT = 51
C
C     4- Solide : geometrie EF, resultat, chrono, suite 
C     -------------------------------------------------
C                                        (format SYRTHES)
        NFGGCT = 52
        NFGRCT = 53 
        NFGCCT = 54
        NFGSCT = 55
C
C     5- Fluide : geometrie EF, resultats, chrono noeuds couples
C     ----------------------------------------------------------
C                                                 (format SYRTHES)
        NFGFCT = 56
        NFRFCT = 57
        NFCFCT = 58
C
C     6- Solide : historiques en temps
C     --------------------------------
        NFHRCT = 59
C
C
C     7- Solide : stockage des correspondants
C     ---------------------------------------
        NFCOCT = 60

C     8- Solide : rayonnement
C     -----------------------
        NFSGRA = 61
        NFGGRA = 62
        NFGRRA = 63
        NFGCRA = 64
        NFFFRA = 65
C
C     9- Conditions aux limites pour le rayonnement (syrthes.ray)
C     -----------------------------------------------------------
        NFCLRA = 66
C 
C     10- Solide/fluide - rayonnement : stockage des coorespondants
C     -----------------------------------------------------------
        NFCORA = 67
C
C     11- Historiques en temps rayonnement
C     ------------------------------------
        NFHIRA = 68
C
C     12- Suite MSTS - Resultat
C     ------------------------
        NFSMRA = 69
        NFRMRA = 70
        NFEMRA = 71
C
      RETURN
      END
