C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=IPERIO,SSI=0
C
                        SUBROUTINE IPERIO
C                       *****************
C
     * (CTYP,VV,NVV,NBPRIO,NBCOPR,NDIM,NPOINS,NPRIOS,NREFS,IREF,NB,
     *  COORDS,NPER1,NPER2,XTR,YTR,ZTR)
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------   INITIALISATION DES CORRESPONDANCES POUR LA PERIODICITE  *
C                                                                      *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS                    !
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   ! CTYP   !   C  ! D  ! TYPE DE TRANSFORMATION  (T,R,TR ou RT)      !
C   ! VV     !  TR  ! D  ! DONNEES DE LA TRANSFORMATION GEOMETRIQUE    !
C   ! NVV    !   E  ! D  ! TAILLE DU TABLEAU VV (IE : NBRE DE DONNEES) !
C   ! NBPRIO !   E  ! D  ! NBRE DE NOEUDS PERIODIQUES                  !
C   ! NBCOPR !   E  ! D  ! NBRE DE CORRESPONDANTS D'UN NOEUD PERIODIQUE!
C   ! NDIM   !   E  ! D  ! DIMENSION DU PROBLEME                       !
C   ! NPOINS !   E  ! D  ! NOMBRE DE NOEUDS SOLIDES                    !
C   ! NPRIOS !  TE  ! M  ! NUMERO GLOB DU NOEUD PERIODIQUE ET NUMEROS  !
C   !        !      !    ! LOCAUX DE SES CORRESPONDANTS                !
C   ! COORDS !  TR  ! D  ! COORDONNEES DES NOEUDS                      !
C   ! IREF   !  TE  ! D  ! REFERENCES IMPLIQUEES                       !
C   ! NB     !   E  ! D  ! NOMBRE DE REFERENCES IMPLIQUEES             !
C   !NPER1,NPER2 TE ! A  ! TABLEAUX DE TRAVAIL                         !
C   !XTR,YTR,ZTR TR ! A  ! TABLEAUX DE TRAVAIL                         !
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/NLOFES/!      ! D  !                                             !
C   !/XREFER/!      ! D  !                                             !
C   !__________________________________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : CORPER,ROTATS
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : LECLIM
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON 
C**********************************************************************
C
#include "nlofes.h"
#include "xrefer.h"
C
C**********************************************************************
C
C..Variables externes
      CHARACTER*1 CTYP
      INTEGER NVV,NDIM,NPOINS,NBPRIO,NBCOPR,NB
      INTEGER IREF(NRFMAX),NPRIOS(NBPRIO,1+NBCOPR),NREFS(NPOINS)
      INTEGER NPER1(NPOINS),NPER2(NPOINS)
      DOUBLE PRECISION VV(NVV),COORDS(NPOINS,NDIM)
C
C..Variables internes
      INTEGER N,N1,M,NB1,NB2,NR,NG
      DOUBLE PRECISION PI,X,Y,Z,XT,YT,ZT
      DOUBLE PRECISION TX,TY,TZ,ARX,ARY,ARZ,AROTX,AROTY,AROTZ
      DOUBLE PRECISION XTR(NPOINS),YTR(NPOINS),ZTR(NPOINS)
      LOGICAL LVERIF
C
C**********************************************************************
C
C     0- Initialisations
C     ==================
      LVERIF = .FALSE.
C
      DO 10 N=1,NPOINS
        NPER1(N) = 0
        NPER2(N) = 0
        XTR(N)  = 0.
        YTR(N)  = 0.
        ZTR(N)  = 0.
   10 CONTINUE
C
      NB1 = 0
      NB2 = 0
C
      N = 0
   11 N = N + 1
      IF (IREF(N).GT.0) THEN
        GOTO 11
      ENDIF
      NB1 = N - 1
C
      NB2 = NB - NB1 - 1
C
C
C     1- Reperage des noeuds concernes : on constitue les deux listes
C        de noeuds en vis-a-vis
C     ===============================================================
C
      DO 100 N1=1,NB1
        NR = IREF(N1)
        DO 110 M=1,NBPRIO
          IF (NREFS(NPRIOS(M,1)).EQ.NR) NPER1(M) = M
  110   CONTINUE
  100 CONTINUE
C
      DO 120 N1=NB1+1,NB
        NR = IREF(N1)
        DO 130 M=1,NBPRIO
          IF (NREFS(NPRIOS(M,1)).EQ.NR) NPER2(M) = M
  130   CONTINUE
  120 CONTINUE
C
C     2- Transformation des coordonnees des noeuds de la liste 1
C     ==========================================================
C
      PI = 3.141592654
C
      IF (CTYP.EQ.'T') THEN
        TX = VV(1)
        TY = VV(2)
        TZ = VV(3)
        DO 210 N=1,NBPRIO
          IF (NPER1(N).GT.0) THEN
            NG = NPRIOS(N,1)
            XTR(NG) = COORDS(NG,1) + TX
            YTR(NG) = COORDS(NG,2) + TY
            IF (NDIM.EQ.3) ZTR(NG) = COORDS(NG,3) + TZ
          ENDIF
  210   CONTINUE
        CALL CORPER(NDIM,NPOINS,NBPRIO,NBCOPR,NPRIOS,NPER1,NPER2,
     &              COORDS,XTR,YTR,ZTR)
C
      ELSEIF (CTYP.EQ.'R') THEN
        TX = VV(1)
        TY = VV(2)
        TZ = VV(3)
        ARX = VV(4) * PI / 180.
        ARY = VV(5) * PI / 180.
        ARZ = VV(6) * PI / 180.
        AROTX = VV(7) * PI / 180.
        AROTY = VV(8) * PI / 180.
        AROTZ = VV(9) * PI / 180.
C
C
         DO 220 N=1,NBPRIO
          IF (NPER1(N).GT.0) THEN
            NG = NPRIOS(N,1)
            X = COORDS(NG,1)
            Y = COORDS(NG,2)
            Z = 0.
            IF (NDIM.EQ.3) Z = COORDS(NG,3)
            CALL ROTATS (X,Y,Z,XT,YT,ZT,TX,TY,TZ,
     *                   ARX,ARY,ARZ,AROTX,AROTY,AROTZ)
            XTR(NG) = XT
            YTR(NG) = YT
            IF (NDIM.EQ.3) ZTR(NG) = ZT
          ENDIF
  220   CONTINUE
C
        CALL CORPER(NDIM,NPOINS,NBPRIO,NBCOPR,NPRIOS,NPER1,NPER2,
     &              COORDS,XTR,YTR,ZTR)
C
      ENDIF
C
C
C
C
C--------
C FORMATS
C--------
C----
C FIN
C----
C
      RETURN
      END
