C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE TOUTA0
C                       *****************
C
C     -------------------------------------------------------------
     *(NPOINS,NELEMS,NELESS,NELEUS,NELEPR,NELERC,NELERA,
     * NBCOUS,NBFLUS,NBDIRS,NBECHS,NBFLVS,NBRESS,
     * NBRAYS,NBRAIS,NBPRIO,NBMOBS,NBCOPR,
     * NDIELE,NDMATS,NDMASS,NBFACE,NCOEMA,NBPHYS,NBICOR,
     * NBFFLU,NBFECH,NBFRAI,NPOINR,NELRAY,NNSRAY,NNFRAY,NNERAY,
     * NFCFRA,NFCSRA,NFTIRA,NFFIRA,NFPERA,NFMST,NFMSTE)
C     -------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C
C FONCTION :
C ----------
C     MISE A ZERO INITIALE DES VARIABLES RELATIVES AU SOLIDE
C
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NPOINS   !  E ! R  ! NOMBRE DE NOEUDS DU MAILLAGE SOLIDE          !
C !  NELEMS   !  E ! R  ! NOMBRE D'ELTS DU MAILLAGE VOL SOLIDE         !
C !  NELESS   !  E ! R  ! NOMBRE D'ELTS DU MAILLAGE SURF SOLIDE        !
C !  NELEUS   !  E ! R  ! NBRE D'ELTS DU MAILLAGE SURF SOLIDE AVEC FLUX!
C !  NELEPR   !  E ! R  ! NBRE D'ELTS DU MAIL VOL SOLIDE PERIODIQUE    !
C !  NBCOUS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES COUPLES             !
C !  NELERA   !  E ! R  ! NBRE D'ELTS DU MAIL SURF SOLIDE AVEC RAYONNT !
C !  NBFLUS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC CL DE TYPE FLUX!
C !  NBDIRS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC CL DIRICHLET   !
C !  NBECHS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC CL COEF ECH    !
C !  NBFLVS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC FLUX VOLUMIQUE !
C !  NBRESS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC CL RESI CONTACT!
C !  NBRAYS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC RAYONNEMENT    !
C !  NBRAIS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC RAYONNEMENT INF!
C !  NBFRAI   !  E ! R  ! NOMBRE DE FACES SOLIDES AVEC RAYONNEMENT INF !
C !  NBPRIO   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES PERIODIQUES         !
C !  NBMOBS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES EN MOUVEMENT        !
C !  NBCOPR   !  E ! R  ! NBRE DE CORRESPONDANTS POUR LES NOEUDS PERIOD!
C !  NDIELE   !  E ! R  ! DIMENSION DES ELTS DU PB (2 OU 3)            !
C !  NDMATS   !  E ! R  ! NOMBRE DE NOEUDS DES ELTS VOL SOLIDES        !
C !  NDMASS   !  E ! R  ! NOMBRE DE NOEUDS DES ELTS SURF SOLIDES       !
C !  NBFACE   !  E ! R  ! NOMBRE DE FACES DES ELTS VOL SOLIDES         !
C !  NCOEMA   !  E ! R  ! NOMBRE DE COEF EXTRA DIAG DES MATRICES ELEM  !
C !  NBPHYS   !  E ! R  ! NOMBRE DE VARIABLES PHYSIQUES SUR LE SOLIDE  !
C !  NBICOR   !  E ! R  ! NOMBRE D'INFO SUR LES CORRSPONDANTS (1 ou 2) !
C !  NPOINR   !  E ! R  ! NOMBRE DE NOEUDS DU MAILLAGE RAYONNEMENT     !
C !  NELRAY   !  E ! R  ! NOMBRE D'ELEMENTS DU MAILLAGE RAYONNEMENT    !
C !  NNSRAY   !  E ! R  ! NOMBRE DE NOEUDS COUPLE AU SOLIDE            !
C !  NNFRAY   !  E ! R  ! NOMBRE DE NOEUDS COUPLE AU FLUIDE            !
C !  NNERAY   !  E ! R  ! NOMBRE DE NOEUDS DE TYPE ENTREE/SORTIE       !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !___________!____!____!______________________________________________!
C !___________!____!____!______________________________________________!
C
C     TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C            L (LOGIQUE)   .. ET TYPES COMPOSES (EX : TR TABLEAU REEL)
C     MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (AUXILIAIRE MODIFIE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME APPELANT     :  
C
C     SOUS PROGRAMME(S) APPELE(S) : IFICCT,INOMCT,OPENCT,LECMCL,EVADIM
C
C***********************************************************************
C
      IMPLICIT NONE        
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "nlofct.h"
#include "fichct.h"
#include "syrth.h"
#include "xrefer.h"
C
C **********************************************************************
C
C
C.. Variables externes
C
      INTEGER NPOINS,NELEMS,NELESS,NELEUS,NELEPR,NELERC,NELERA
      INTEGER NBCOUS,NBFLUS,NBDIRS,NBECHS,NBFLVS,NBRESS
      INTEGER NBRAYS,NBRAIS,NBPRIO,NBMOBS,NBCOPR
      INTEGER NDIELE,NDMATS,NDMASS,NBFACE,NCOEMA,NBPHYS,NBICOR
      INTEGER NBFFLU,NBFECH,NBFRAI,NPOINR,NELRAY,NNSRAY,NNFRAY,NNERAY
      INTEGER NFCFRA,NFCSRA,NFTIRA,NFFIRA,NFPERA,NFMST,NFMSTE
C
      INTEGER N
C
C***********************************************************************
C
       NPOINS = 0
       NELEMS = 0
       NELESS = 0
       NELEUS = 0
       NELEPR = 0
       NELERC = 0
       NELERA = 0
       NBCOUS = 0
       NBFLUS = 0
       NBDIRS = 0
       NBECHS = 0
       NBFLVS = 0
       NBRESS = 0
       NBRAYS = 0
       NBRAIS = 0
       NBPRIO = 0
       NBMOBS = 0
       NBCOPR = 0
       NDIELE = 0
       NDMATS = 0
       NDMASS = 0
       NBFACE = 0
       NCOEMA = 0
       NBPHYS = 0
       NBICOR = 0
       NBFFLU = 0
       NBFECH = 0
       NBFRAI = 0
       NPOINR = 0
       NELRAY = 0
       NNSRAY = 0
       NNFRAY = 0
       NNERAY = 0
       NFCSRA = 0
       NFCFRA = 0
       NFTIRA = 0
       NFFIRA = 0
       NFPERA = 0
       NFMST  = 0
       NFMSTE = 0
C
       DO N=1,NRFMAX
         IREFFC(N)=0
         IREFSC(N)=0
         IREFSD(N)=0
         IREFSF(N)=0
         IREFSE(N)=0
         IREFSV(N)=0
         IREFRE(N)=0
         IREFRA(N)=0
         IREFPR(N)=0
         IREFMO(N)=0
         IREFRI(N)=0
         IREFRF(N)=0
         IRERCS(N)=0
         IRERCF(N)=0
         IRERTI(N)=0
         IRERFI(N)=0
         IRERPE(N)=0
         IRESTE(N)=0
         IRESTF(N)=0
         IRESTS(N)=0
         IRESTB(N)=0
         IRESTC(N)=0
       ENDDO
C
      END
