/*-----------------------------------------------------------------------

SYRTHES version 3.4
-------------------

This file is part of the SYRTHES Kernel, element of the
thermal code SYRTHES.

Copyright (C) 1988-2008 EDF S.A., France

contact: syrthes-support@edf.fr


The SYRTHES Kernel is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

The SYRTHES Kernel is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty
of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.


You should have received a copy of the GNU General Public License
along with the Code_Saturne Kernel; if not, write to the
Free Software Foundation, Inc.,
51 Franklin St, Fifth Floor,
Boston, MA  02110-1301  USA

-----------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "med.h"

#define max(a,b) (a>b  ? a:b)
#define min(a,b) (a<b  ? a:b)

FILE  *fsyrg,*fsyrr,*fsyr2;
med_idt fmed;
char nom_maill[MED_TAILLE_NOM+1]="Calcul SYRTHES";

void entete(int *,int *,int *,int *);
void ecrit_syrthes(int,int,int,int,int,double,double*);
void geom_syr(int,int,int,int,int*,double*,int*,int*,int*);
void entete_resu_syr(int *,double *,int *);
void resu_syr(int,double*,char*);
void ecrit_geom_med(int,int,int,int,int*,double*,int*,int*,int);
void ecrit_resu_med(int,int,int,double,double*,char*,int,int,int,int,int*);
med_int * convertit_int_en_med_int(int*,int,int*);
med_float * convertit_double_en_med_float(double*,int,int*);
void creeP1(int,int,int,double*,int*,int*,int*,
	    int,int, double*,int*,int*,int*);   
void creeP1decoup(int,int,int*,int*,int,int,int*,int*);   

/*|======================================================================|
  | SYRTHES 3.4                                       COPYRIGHT EDF 2009 |
  |======================================================================|
  | AUTEURS  : I. RUPP                                                   |
  |======================================================================|
  | syrthes2med                                                          |
  |        Convert SYRTHES results files into MED 2.3 format             |
  |======================================================================| */

main (argc,argv)

     int	argc;
     char *argv[];
{
  int numarg,i,ndim,nelem,nbno,npoin,nt,npoi1,nbscal,nbnoP1;
  int *node,*nrefn,*nrefe,nbenr,acreer;
  int *nrefnP1,*nodeP1,*quelP2, *nrefeP1,nelemP1;
  int maillP1=0,maillP1decoup=0,mult,na,isResu;
  double temps,*coord,*var,*coordP1,*varP1;
  char *s,ch[90];
  med_int ndim_med;
  med_err ret_med;
  char nom_champ[MED_TAILLE_NOM+1];


  numarg=0;
  maillP1decoup=0;
  na =1;
  isResu=0;

  while (++numarg < argc)
    {

      s = argv[numarg];

      if (strcmp (s, "-h") == 0) 
        {
          printf("\n syrthes2med : transform results from Syrthes 3.4 to MED format 2.3\n");
          printf("       Usage : syrthes2med  -h  : help\n");
          printf("               syrthes2med  [-P1 | -decoupP1] syrthes_geom mesh.med \n");
          printf("               syrthes2med  [-P1 | -decoupP1] syrthes_geom syrthes_resu resu.med \n");
          printf("                 --> option  -P1       => suppress P2 (quadratic) nodes\n");
          printf("                 --> option  -decoupP1 => split quadratic elements in linear elements\n");
          printf("                 --> without option    => write quadratic elements (default)\n\n");
          exit(0);
        }
      else if (strcmp (s, "-P1") == 0) 
        {
          na=2;
          maillP1=1;
          maillP1decoup=0;
        }
      else if (strcmp (s, "-decoupP1") == 0) 
        {
          na=2;
          maillP1=0;
          maillP1decoup=1;
        }
    }

  /* ouverture des fichiers */

  if(argc < 3)
    {
      printf ("usage : syrthes2med [-P1 | -decoupP1] syrthes_geom mesh.med \n");
      printf ("        syrthes2med [-P1 | -decoupP1] syrthes_geom syrthes_resu resu1.med \n");
      exit(1) ;
    }
  if (argc==na+3) isResu=1;
  else isResu=0;

  if ((fsyrg=fopen(argv[na],"r")) == NULL)
    {
      printf("Unable to open file %s\n",argv[na]);	
      exit(1) ;
    }
  if (isResu)
    if ((fsyrr=fopen(argv[na+1],"r")) == NULL)
      {
        printf("Unable to open file %s\n",argv[na+1]);	
        exit(1) ;
      }
  
  if ((fmed=MEDouvrir(argv[na+1+isResu],MED_CREATION)) < 0) 
    {
      printf("Unable to open file %s\n",argv[na+1+isResu]);	
      exit(1) ;
    }

  
  printf("\n\n");
  printf("===============================================================\n");
  printf("                         SYRTHES2MED                           \n");
  printf("                  SYRTHES --> MED  INTERFACE                   \n");
  printf("===============================================================\n");

  printf("\n\nTransform SYRTHES results files to MED format\n");

  /* on suppose ici que l'on a recupere l'option pour savoir si */
  /* on veut un maillage P1 ou P2                               */
  /* maillP1=1 ==> on obtient un maillage P1 en supprimant les noeuds P2   */
  /* mailldecoup=1 ==> on obtient un maillage P1 en decoupant les elements */
  /* pour le moment, on force l'option */

  if (maillP1==1)
    printf("\n--> Transfer results on a P1 mesh (linear elements) (suppress quadratic nodes)\n");
  else if (maillP1decoup==1)
    printf("\n--> Transfer results on a P1 mesh (linear elements) (split quadratic elements in linear elements)\n");


  printf("\n\nRead Syrthes geometry...\n");
  entete(&ndim,&npoin,&nelem,&nbno);
  coord=(double*)malloc(ndim*npoin * sizeof(double));
  node=(int*)malloc(nbno*nelem * sizeof(int));
  nrefn=(int*)malloc(npoin * sizeof(int));
  nrefe=(int*)malloc(nelem * sizeof(int));
  geom_syr(ndim,npoin,nelem,nbno,node,coord,nrefn,nrefe,&npoi1);

  if (maillP1)
    {
      if (nbno==10) nbnoP1=4;
      if (nbno==6) nbnoP1=3;
      coordP1=(double*)malloc(ndim*npoi1 * sizeof(double));
      nodeP1=(int*)malloc(nbnoP1*nelem * sizeof(int));
      nrefnP1=(int*)malloc(npoi1 * sizeof(int));
      quelP2=(int*)malloc(npoi1 * sizeof(int));
      creeP1(npoin,nbno,nelem,coord,nrefn,node,nrefe,
	     npoi1,nbnoP1,coordP1,nrefnP1,nodeP1,
	     quelP2);   
    }

  if (maillP1decoup)
    {
      if (ndim==2) {mult=4;nbnoP1=3;}
      if (ndim==3) {mult=8;nbnoP1=4;}
      nelemP1=nelem*mult;
      nodeP1=(int*)malloc(nbno*nelemP1 * sizeof(int));
      nrefeP1=(int*)malloc(nelemP1 * sizeof(int));

      printf("\n P1 mesh generation by splitting elements :\n");
      printf("   Dimension                    %d\n",ndim);
      printf("   Number of nodes              %d\n",npoin);
      printf("   Number of elements           %d\n",nelemP1);
      printf("   Number of nodes per element  %d\n",nbnoP1);

      creeP1decoup(nbno,nelem,node,nrefe,
		   nbnoP1,nelemP1,nodeP1,nrefeP1);   
    }

  printf("\nWriting MED geometry... ");
  if (maillP1)    
    ecrit_geom_med(ndim,npoi1,nelem,nbnoP1,nodeP1,coordP1,nrefnP1,nrefe,npoi1);
  else if (maillP1decoup)
    ecrit_geom_med(ndim,npoin,nelemP1,nbnoP1,nodeP1,coord,nrefn,nrefeP1,npoi1);
  else
    ecrit_geom_med(ndim,npoin,nelem,nbno,node,coord,nrefn,nrefe,npoi1);

  printf("ok\n\n");

  if(isResu)
    {
      printf("Results conversion...\n");
      var=(double*)malloc(npoin * sizeof(double));
      
      nbenr=0;
      
      while (fgets(ch,90,fsyrr))
        {
          if ( !strncmp(ch,"*",1) )
            {
              nbenr++;
              if (nbenr==1) acreer=1; else acreer=0;
              entete_resu_syr(&nt,&temps,&nbscal);
              if (nbscal!=1){nbscal=1;}
              for (i=0;i<nbscal;i++)
                {
                  resu_syr(npoin,var,nom_champ);
                  printf("      MED write: timestep=%d time=%f field=%s\n\n",
                         nt,temps,nom_champ);
                  ecrit_resu_med(argc,npoin,nt,temps,var,nom_champ,nbenr,acreer,
                                 maillP1,npoi1,quelP2);
                }
            }
        }
    }

  printf("\n\n");
  printf("===============================================================\n");
  printf("                        SYRTHES2MED                           \n");
  printf("                       End of process                         \n");
  printf("===============================================================\n");
  printf("\n");

  fclose(fsyrg);
  if (isResu) fclose(fsyrr);
  ret_med=MEDfermer(fmed);

}

/*|======================================================================|
  | SYRTHES 3.4                                       COPYRIGHT EDF 2009 |
  |======================================================================|
  | AUTEURS  : I. RUPP                                                   |
  |======================================================================|
  | entete                                                               |
  |        read head of SYRTHES geometry file                            |
  |======================================================================| */

void entete(int *ndim,int *npoin,int *nelem,int *nbno)
{
  char ch[90];

  fgets(ch,90,fsyrg);
  fgets(ch,90,fsyrg);
  fgets(ch,90,fsyrg);
  fscanf(fsyrg,"%s%s%s%d\n",ch,ch,ch,ndim);
  fgets(ch,90,fsyrg);
  fscanf(fsyrg,"%s%s%s%s%s%d",ch,ch,ch,ch,ch,npoin);
  fscanf(fsyrg,"%s%s%s%s%d",ch,ch,ch,ch,nelem);
  fscanf(fsyrg,"%s%s%s%s%s%s%s%d",ch,ch,ch,ch,ch,ch,ch,nbno);

  printf("   Dimension                    %d\n",*ndim);
  printf("   Number of nodes              %d\n",*npoin);
  printf("   Number of elements           %d\n",*nelem);
  printf("   Number of nodes per element  %d\n",*nbno);
}


/*|======================================================================|
  | SYRTHES 3.4                                       COPYRIGHT EDF 2009 |
  |======================================================================|
  | AUTEURS  : I. RUPP                                                   |
  |======================================================================|
  | geom_syr                                                             |
  |        read SYRTHES geometry file                                    |
  |======================================================================| */

void geom_syr(int ndim,int npoin,int nelem,int nbno,int *node,
	      double *coord, int *nrefn,int *nrefe,int *npoi1)
{
  char ch[130],ch66[6];
  char ch02[12],ch1[12],ch2[12],ch3[12],ch4[12],ch5[12],ch6[12],ch7[12],ch8[12],ch9[12],ch10[12];
  double z;
  int n,i,j,*np1,nref;

  fgets(ch,90,fsyrg); //printf(" --- lu --- %s", ch);
  fgets(ch,90,fsyrg); //printf(" --- lu --- %s", ch);
  fgets(ch,90,fsyrg); //printf(" --- lu --- %s", ch);
  fgets(ch,90,fsyrg); //printf(" --- lu --- %s", ch);
  fgets(ch,90,fsyrg); //printf(" --- lu --- %s", ch);

  /* coordonnees noeuds maillage SYRTHES */

  if (ndim==2) 
    {
      for (n=0;n<npoin;n++) 
        {
          fscanf(fsyrg,"%s",ch);
          if (strlen(ch)==1 && (strncmp(ch,"-",1)==0))
            fscanf(fsyrg,"%d%d%lf%lf%lf",&i,(nrefn+n),(coord+n),(coord+n+npoin),&z);
          else
            fscanf(fsyrg,"%d%lf%lf%lf",(nrefn+n),(coord+n),(coord+n+npoin),&z);
        }
    }
  else
    {
      for (n=0;n<npoin;n++) 
        {
          fscanf(fsyrg,"%s",ch);
          if (strlen(ch)==1 && (strncmp(ch,"-",1)==0))
            fscanf(fsyrg,"%d%d%lf%lf%lf",&i,(nrefn+n),(coord+n),(coord+n+npoin),(coord+n+npoin*2));
          else
            fscanf(fsyrg,"%d%lf%lf%lf",(nrefn+n),(coord+n),(coord+n+npoin),(coord+n+npoin*2));
        }
    }

  printf("\n   --> End of Syrthes nodes coordinates read\n");


  /* connectivite maillage SYRTHES */

  fgets(ch,90,fsyrg); //printf(" --- lu --- %s", ch);
  fgets(ch,90,fsyrg); //printf(" --- lu --- %s", ch);
  fgets(ch,90,fsyrg); //printf(" --- lu --- %s", ch);
  fgets(ch,90,fsyrg); //printf(" --- lu --- %s", ch);

  /* attention, on modifie la lecture pour avoir un tableau du type node(nbno,nelem) 
     --> ceci n'est plus fait avec MED 2.1.
     on conserve, comme dans Syrthes, un tableau  node(nelem,nbno)                  */

  if (nbno==6)

  /* --- triangles 6 : NON TESTE */

    for (i=0;i<nelem;i++)
      {
        /* Attention suite a une remarque de Yvan --> pour etre totalement adherent a la norme
           on modifie la numerotation med2.1 :
           1  2  3  4  5  6  (au sens syrthes - normale vers le haut)
           |
           v
           1  3  2  6  5  4  (au sens med - normale vers le bas)
           Attention implicitement on se retrouve en convention med 2.1
        */

        fscanf(fsyrg,"%d%d%d%d%d%d%d%d",&n,(nrefe+i),
               (node+i),        (node+i+nelem*2),(node+i+nelem),
               (node+i+nelem*5),(node+i+nelem*4),(node+i+nelem*3)); 
        
      }

  else

    /* --- tetras 10 */

    for (i=0;i<nelem;i++)

      {

        /* Attention suite a une remarque de Yvan --> pour etre totalement adherent a la norme
           on modifie la numerotation med2.1 :
           1  2  3  4  5  6  7  8  9  10  (au sens syrthes - normale interieure)
           |
           v
           1  3  2  4  7  6  5  8  10  9  (au sens med - normale exterieure)
           Attention implicitement on se retrouve en convention med 2.1
        */

	fscanf(fsyrg,"%d%d%d%d%d%d%d%d%d%d%d%d",&n,(nrefe+i),
	       (node+i),        (node+i+nelem*2),(node+i+nelem),
	       (node+i+nelem*3),(node+i+nelem*6),(node+i+nelem*5),  
	       (node+i+nelem*4),(node+i+nelem*7),(node+i+nelem*9),  
	       (node+i+nelem*8));  

/*  	printf("%10d -- %3d -- %10d %10d %10d %10d %10d %10d %10d %10d %10d %10d\n",i,nrefe[i], */
/*  	       node[i],        node[i+nelem*2],node[i+nelem],  node[i+nelem*3], */
/*  	       node[i+nelem*6],node[i+nelem*5],node[i+nelem*4],node[i+nelem*7], */
/*  	       node[i+nelem*9],node[i+nelem*8]); */
      }

  printf("   --> End of Syrthes connectivity read\n");
  
  /* compte des noeuds P1 */
  np1=(int*)malloc(npoin*sizeof(int));
  for (i=0;i<npoin;i++) *(np1+i)=0;
  if (nbno==6)
    for (i=0;i<nelem;i++) {np1[node[i]-1]=1;np1[node[i+nelem]-1]=1;
      np1[node[i+nelem*2]-1]=1;}
  else
    for (i=0;i<nelem;i++) {np1[node[i]-1]=1;np1[node[i+nelem]-1]=1;
      np1[node[i+nelem*2]-1]=1;np1[node[i+nelem*3]-1]=1;}
  *npoi1=0; for (i=0;i<npoin;i++) if (np1[i]) *npoi1+=1; 
  
  free(np1);
  printf("   --> Number of P1 nodes = %d\n",*npoi1);

}

/*|======================================================================|
  | SYRTHES 3.4                                       COPYRIGHT EDF 2009 |
  |======================================================================|
  | AUTEURS  : I. RUPP                                                   |
  |======================================================================|
  | entete_resu_syr                                                      |
  |        read head of SYRTHES results file                             |
  |======================================================================| */

void entete_resu_syr(int *nt,double *temps,int *nbscal)
{
  int i,n1,n2,n3,n4,n5;
  char ch[90],ch4[4];
  char chlong[200];
  double dt;

  /* on passe l'entete (-1 ligne deja lue avant)*/
  for (i=0;i<3;i++)
    {
      fgets(chlong,200,fsyrr); //printf(" --- lu --- %s", chlong);
    }
  fscanf(fsyrr,"%s%d%d%d%d%d%d",ch4,&n1,&n2,&n3,&n4,&n5);
  printf("ndim=%d, ndiele=%d, nelem=%d, npoin=%d, nscal=%d\n",n1,n2,n3,n4,n5);
  fgets(chlong,200,fsyrr); //printf(" --- lu --- %s", chlong);
  fscanf(fsyrr,"%s%d%lf%lf",ch4,nt,temps,&dt);
  printf("timestep %d, time = %f, delta t = %f\n",*nt, *temps, dt);
  fgets(ch,90,fsyrr);
  for (i=0;i<3;i++)
    {
      fgets(ch,90,fsyrr); //printf(" --- lu --- %s", ch);
    }

  printf("      Reading timestep %d (%f seconds)\n",*nt,*temps);
}

/*|======================================================================|
  | SYRTHES 3.4                                       COPYRIGHT EDF 2009 |
  |======================================================================|
  | AUTEURS  : I. RUPP                                                   |
  |======================================================================|
  | resu_syr                                                             |
  |        read SYRTHES results file                                     |
  |======================================================================| */

void resu_syr(int npoin,double *var,char *nom_champ)
{
  int nbl,i,j;
  char chlong[200];

  /* on lit le nom de la variable */
  fscanf(fsyrr,"%s",nom_champ);
  for (i=0;i<2;i++)
    {
      fgets(chlong,200,fsyrr);
      //printf(" --- lu --- %s", chlong);
    }

  nbl=npoin/6;
  for (i=0;i<nbl;i++) 
    {
      j=i*6;
      fscanf(fsyrr,"%13lf%13lf%13lf%13lf%13lf%13lf",
             (var+j),(var+j+1),(var+j+2),
             (var+j+3),(var+j+4),(var+j+5));
    }
  for (i=nbl*6;i<npoin;i++) fscanf(fsyrr,"%13lf",(var+i));       
}

/*|======================================================================|
  | SYRTHES 3.4                                       COPYRIGHT EDF 2009 |
  |======================================================================|
  | AUTEURS  : I. RUPP                                                   |
  |======================================================================|
  | ecrit_syrthes                                                        |
  |        write SYRTHES results file                                    |
  |======================================================================| */
void ecrit_syrthes(int ndim,int npoinm,int nelemm,int npoinp1m,
                   int nt,double temps,double *varm)
{
  int nbscal,i,nv;
  int idiscr=2;
  char *version,*date,*titre;
  double rdtts=0;
 
  version="     3.3";
  date="      TODAY";
  titre="CALCUL SYRTHES";


  nbscal=1;

  fprintf(fsyr2,"************************************************************************\n");
  fprintf(fsyr2,"SYRTHES\n");
  fprintf(fsyr2,"************************************************************************\n");
  fprintf(fsyr2,"C1C*    NDIM  NDIELE   NELEM   NBNP1   NBNP2  NBSCAL\n");
  fprintf(fsyr2,"C2C*%8d%8d%8d%8d%8d%8d\n",
          ndim,ndim,nelemm,npoinp1m,npoinm,nbscal);
  fprintf(fsyr2,"C3C*    NPDT           TEMPS              DT\n");
  fprintf(fsyr2,"C4C*%8d%16.6e%16.6e\n",nt,temps,rdtts);
  fprintf(fsyr2,"C5C* VERSION            DATE\n");
  fprintf(fsyr2,"C6C*%s     %s\n",version,date);
  fprintf(fsyr2,"************************************************************************\n");


  nv=npoinm/6;
  fprintf(fsyr2,"TEMPERATURE\n%1d-----------\n",idiscr);
  for (i=0;i<nv*6;i+=6) fprintf(fsyr2,"%13.6e%13.6e%13.6e%13.6e%13.6e%13.6e\n",
                                *(varm+i),*(varm+i+1),*(varm+i+2),*(varm+i+3),*(varm+i+4),*(varm+i+5));
  for (i=nv*6;i<npoinm;i++) fprintf(fsyr2,"%13.6e",*(varm+i));
  if (npoinm-nv*6) fprintf(fsyr2,"\n");
}

/*|======================================================================|
  | SYRTHES 3.4                                       COPYRIGHT EDF 2009 |
  |======================================================================|
  | AUTEURS  : I. RUPP                                                   |
  |======================================================================|
  | ecrit_geom_med                                                       |
  |        write MED geometry                                            |
  |======================================================================| */
void ecrit_geom_med(int ndim,int npoin,int nelem,int nbno,int *node,
                    double *coord, int *nrefn,int *nrefe,int npoi1)
{
  int i,libere,nf;
  int nbf,nrefmax=200;
  int *itrav,*ir,*ifa;

  med_err ret_med=0;
  med_int ndim_med,npoin_med,nelem_med,natt_med,attide_med,attval_med,ngro_med;
  med_int numfam_med;
  med_int *node_med,*nrefn_med,*itrav_med;
  med_float *coord_med;
  
  char nom_coo2[2*MED_TAILLE_PNOM+1]= "x       y       " ;
  char nom_coo3[3*MED_TAILLE_PNOM+1]= "x       y       z       " ;
  char uni_coo2[2*MED_TAILLE_PNOM+1]= "m       m       " ;
  char uni_coo3[3*MED_TAILLE_PNOM+1]= "m       m       m       " ;

  char nom_fam[MED_TAILLE_NOM+1];
  char attdes[MED_TAILLE_DESC+1]="Reference";
  char gro[MED_TAILLE_DESC+1]=" ";
  char des[MED_TAILLE_DESC+1]=" ";


  /* initialisations */
  ndim_med=(med_int)ndim;
  npoin_med=(med_int)npoin;
  nelem_med=(med_int)nelem;

  node_med=convertit_int_en_med_int(node,nbno*nelem,&libere);
  coord_med=convertit_double_en_med_float(coord,npoin*ndim,&libere);
  nrefn_med=convertit_int_en_med_int(nrefn,npoin,&libere);

  /* creation du maillage*/
  ret_med=MEDmaaCr(fmed,nom_maill,ndim_med,MED_NON_STRUCTURE,des);

  /*ecriture des noeuds */

  if (ndim==2)
    ret_med=MEDcoordEcr(fmed,nom_maill,ndim_med,coord_med,MED_NO_INTERLACE,
                        npoin_med,MED_CART,nom_coo2,uni_coo2);
  else    
    ret_med=MEDcoordEcr(fmed,nom_maill,ndim_med,coord_med,MED_NO_INTERLACE,
                        npoin_med,MED_CART,nom_coo3,uni_coo3);
			


  /*ecriture des elements */
  
  if (nbno==3)
    ret_med=MEDconnEcr(fmed,nom_maill,ndim_med,node_med,MED_NO_INTERLACE,nelem_med,
                       MED_MAILLE,MED_TRIA3,MED_NOD);
  else if (nbno==4)
    ret_med=MEDconnEcr(fmed,nom_maill,ndim_med,node_med,MED_NO_INTERLACE,nelem_med,
                       MED_MAILLE,MED_TETRA4,MED_NOD);
  else if (nbno==6)
    ret_med=MEDconnEcr(fmed,nom_maill,ndim_med,node_med,MED_NO_INTERLACE,nelem_med,
                       MED_MAILLE,MED_TRIA6,MED_NOD);
  else if(nbno==10)
    ret_med=MEDconnEcr(fmed,nom_maill,ndim_med,node_med,MED_NO_INTERLACE,nelem_med,
                       MED_MAILLE,MED_TETRA10,MED_NOD);
  else
    {printf("\n syrthes2med only deals with TRIA3, TRIA6, TETRA4 and TETRA10\n");
      exit(0);}

 
  /* Creation des familles pour les noeuds */
  nbf=0;
  itrav=(int*)malloc(max(npoin,nelem)*sizeof(int));
  ir=(int*)malloc(nrefmax*sizeof(int));
  ifa=(int*)malloc(nrefmax*sizeof(int));
  for (i=0;i<nrefmax;i++) ir[i]=ifa[i]=0;
  for (i=0;i<npoin;i++) itrav[i]=0;
  for (i=0;i<npoin;i++) 
    if (nrefn[i]!=0 && itrav[nrefn[i]]==0)
      {
        itrav[nrefn[i]]=1;
        nbf++;
        ir[nbf]=nrefn[i];
      }
  printf("number of families : %d\n",nbf);

  for (i=0;i<nrefmax;i++)  ifa[ir[i]]=i;

  for (i=0;i<npoin;i++) 
    {itrav[i]=0; if (nrefn[i]!=0) itrav[i]=ifa[nrefn[i]];}

  /* creation famille 0 */
  strcpy(nom_fam,"FAMILLE_0");
  numfam_med=0;
  ret_med=MEDfamCr(fmed,nom_maill,nom_fam,numfam_med,
                   &attide_med,&attval_med,attdes,0,gro,0);

  /* creation des autres familles de noeuds*/
  attide_med=1; natt_med=1; ngro_med=0;
  strcpy(attdes,"Couleur de noeud");
  for (nf=0;nf<nbf;nf++)
    {
      numfam_med=nf+1;
      strcpy(nom_fam,"FAMILLE_NOEUD_");
      sprintf(nom_fam,"%s%d",nom_fam,numfam_med);
      attval_med=ir[nf+1];
      ret_med=MEDfamCr(fmed,nom_maill,nom_fam,numfam_med,
                       &attide_med,&attval_med,attdes,natt_med,gro,ngro_med);
  
    } 

  /* ecriture des familles de noeuds */
  itrav_med=convertit_int_en_med_int(itrav,npoin,&libere);
  ret_med=MEDfamEcr(fmed,nom_maill,itrav_med,npoin_med,MED_NOEUD,0);



  /* Creation des familles pour les elements */
  nbf=0;
  for (i=0;i<nrefmax;i++) ir[i]=ifa[i]=0;
  for (i=0;i<nelem;i++) itrav[i]=0;
  for (i=0;i<nelem;i++) 
    if (nrefe[i]!=0 && itrav[nrefe[i]]==0)
      {
        itrav[nrefe[i]]=1;
        nbf++;
        ir[nbf]=nrefe[i];
      }

  for (i=0;i<nrefmax;i++)  ifa[ir[i]]=i;

  /* les numeros de famille d'element doivent etre negatives */
  for (i=0;i<nelem;i++) 
    {itrav[i]=0; if (nrefe[i]!=0) itrav[i]=-ifa[nrefe[i]];}


  /* creation des autres familles d'elements */
  attide_med=1; natt_med=1; ngro_med=0;
  strcpy(attdes,"Couleur d element");
  for (nf=0;nf<nbf;nf++)
    {
      numfam_med=-(nf+1);
      strcpy(nom_fam,"FAMILLE_ELEMENT_");
      sprintf(nom_fam,"%s%d",nom_fam,(nf+1));
      attval_med=ir[nf+1];
      ret_med=MEDfamCr(fmed,nom_maill,nom_fam,numfam_med,
                       &attide_med,&attval_med,attdes,natt_med,gro,ngro_med);
  
    } 

  /* ecriture des familles des elements */
  itrav_med=convertit_int_en_med_int(itrav,nelem,&libere);
  if (nbno==3)
    ret_med=MEDfamEcr(fmed,nom_maill,itrav_med,nelem_med,MED_MAILLE,MED_TRIA3);
  else if (nbno==4)
    ret_med=MEDfamEcr(fmed,nom_maill,itrav_med,nelem_med,MED_MAILLE,MED_TETRA4);
  else if (nbno==6)
    ret_med=MEDfamEcr(fmed,nom_maill,itrav_med,nelem_med,MED_MAILLE,MED_TRIA6);
  else if (nbno==10)
    ret_med=MEDfamEcr(fmed,nom_maill,itrav_med,nelem_med,MED_MAILLE,MED_TETRA10);
  else
    {printf("\n syrthes2med only deals with TRIA3, TRIA6, TETRA4 and TETRA10\n");
      exit(0);}
}

/*|======================================================================|
  | SYRTHES 3.4                                       COPYRIGHT EDF 2009 |
  |======================================================================|
  | AUTEURS  : I. RUPP                                                   |
  |======================================================================|
  | ecrit_resu__med                                                      |
  |        write MED results                                             |
  |======================================================================| */
void ecrit_resu_med(int argc,int npoin,int nt,double temps,
                    double *var,char *nom_champ,int num_ordre,int acreer,
                    int maillP1,int npoi1,int *quelP2)
{
  int libere,i;
  char ch1[12],ch2[12];
  
  double *varP1;

  med_err ret_med=0;
  med_int npoin_med;
  med_float *var_med;
  med_int nb_comp=1;
  
  char nom_comp[MED_TAILLE_PNOM+1]="Temperat";
  char nom_unit[MED_TAILLE_PNOM+1]="SI      ";


  if (maillP1)
    {
      varP1=(double*)malloc(npoi1*sizeof(double));
      for (i=0;i<npoi1;i++) varP1[i]=var[quelP2[i]];
    }



  /* initialisation */
  strncpy(nom_comp,nom_champ,MED_TAILLE_PNOM);

  if (maillP1)
    {
      var_med=convertit_double_en_med_float(varP1,npoi1,&libere);
      npoin_med=(med_int)npoi1;
    }
  else
    {
      var_med=convertit_double_en_med_float(var,npoin,&libere);
      npoin_med=(med_int)npoin;
    }


  /* creation du champ */
  if (acreer) ret_med=MEDchampCr(fmed,nom_champ,MED_FLOAT64,nom_comp,nom_unit,nb_comp);
  
  /* ecriture du champ */
  ret_med=MEDchampEcr(fmed,nom_maill,nom_champ,(unsigned char*)var_med,
                      MED_NO_INTERLACE,
                      npoin_med,
                      MED_NOGAUSS,MED_ALL,MED_NOPFL,MED_NO_PFLMOD,
                      MED_NOEUD,0,nt,"",temps,MED_NONOR);
}

/*|======================================================================|
  | SYRTHES 3.4                                       COPYRIGHT EDF 2009 |
  |======================================================================|
  | AUTEURS  : I. RUPP                                                   |
  |======================================================================|
  | convertit....                                                        |
  |        conversion to MED internal format                             |
  |======================================================================| */

med_int* convertit_int_en_med_int(int *tab,int nb,int* libere)
{
  int i;
  med_int *tab_med;

  if (sizeof(med_int) == sizeof(int)) 
    {
      *libere=0;
      return (med_int*)tab ;
    }
  else
    {
      tab_med=(med_int*)malloc(nb*sizeof(med_int));
      *libere=1;
      for (i=0;i<nb;i++) tab_med[i]=(med_int)tab[i];
      return tab_med;
    }
}

med_float* convertit_double_en_med_float(double *tab,int nb,int* libere)
{
  int i;
  med_float *tab_med;

  if (sizeof(med_float) == sizeof(double)) 
    {
      *libere=0;
      return (med_float*)tab ;
    }
  else
    {
      tab_med=(med_float*)malloc(nb*sizeof(med_float));
      *libere=1;
      for (i=0;i<nb;i++) tab_med[i]=(med_float)tab[i];
      return tab_med;
    }
}

/*|======================================================================|
  | SYRTHES 3.4                                       COPYRIGHT EDF 2009 |
  |======================================================================|
  | AUTEURS  : I. RUPP                                                   |
  |======================================================================|
  | creeP1                                                               |
  |        extract the P1 mesh                                           |
  |======================================================================| */

void creeP1(int npoin,int nbno,int nelem,
            double *coord,int *nrefn,int *node,int *nrefe,
            int npoi1,int nbnoP1,
            double *coordP1,int *nrefnP1,int *nodeP1,
            int *quelP2)
{
  int i,j,nn,np;
  int *trav,*quelP1;

  /* rq : quelP2(npoi1) numero P2 de chaque noeud P1 */
  /*      quelP1(npoin) numero P1 de chaque noeud P2 ou -1 si pas un noeud P1 */


  trav=(int*)malloc(npoin*sizeof(int));
  quelP1=(int*)malloc(npoin*sizeof(int));

  for (i=0;i<npoin;i++) {quelP1[i]=-1; trav[i]=-1;}
  for (i=0;i<npoi1;i++) {quelP2[i]=-1;}

  /* marquage des noeuds P1 */
  for (i=0;i<nelem;i++)
    for (j=0;j<nbnoP1;j++)
      {
        np=node[i+j*nelem]-1;   /* attention, ici on passe en numerotation 0,n-1 */
        trav[np]=1;
      }

  /* numerotation des noeuds P1 */
  for (nn=0,i=0;i<npoin;i++)
    {
      if (trav[i]>0)
        {
          quelP1[i]=nn;
          quelP2[nn]=i;  /* quelP2 fournit des numeros de 0 a n-1 */
          nn++;
        }
    }


  /* on bascule le tableau des noeuds */
  for (i=0;i<nelem;i++)
    for (j=0;j<nbnoP1;j++)
      {
        nodeP1[i+j*nelem]=quelP1[node[i+j*nelem]-1] + 1;
      }


  /* on bascule le tableau de coordonnees et des references*/
  nn=0;
  for (i=0;i<npoin;i++)
    {
      if (trav[i]>0)
        {
          coordP1[nn]=coord[i];
          coordP1[nn+npoi1]=coord[i+npoin];
          if (nbnoP1>3) coordP1[nn+npoi1*2]=coord[i+npoin*2];
          nrefnP1[nn]=nrefn[i];
          nn++;
        }
    }

  free(trav);
  free(quelP1);
}

/*|======================================================================|
  | SYRTHES 3.4                                       COPYRIGHT EDF 2009 |
  |======================================================================|
  | AUTEURS  : I. RUPP                                                   |
  |======================================================================|
  | creeP1                                                               |
  |        create the P1 mesh                                            |
  |======================================================================| */

void creeP1decoup(int nbno,int nelem,int *node,int *nrefe,
                  int nbnoP1,int nelemP1,int *nodeP1,int *nrefeP1)   
{
  int i,j,nn,np;
  
  if (nbno==6)
    {
      nn=0;
      for (i=0;i<nelem;i++)
        {
          nrefeP1[nn]=nrefe[i];
          nodeP1[nn]           = node[i]; 
          nodeP1[nn+nelemP1]   = node[i+3*nelem]; 
          nodeP1[nn+2*nelemP1] = node[i+5*nelem]; 
          nn++;

          nrefeP1[nn]=nrefe[i];
          nodeP1[nn]           = node[i+1*nelem]; 
          nodeP1[nn+nelemP1]   = node[i+4*nelem]; 
          nodeP1[nn+2*nelemP1] = node[i+3*nelem]; 
          nn++;

          nrefeP1[nn]=nrefe[i];
          nodeP1[nn]           = node[i+2*nelem]; 
          nodeP1[nn+nelemP1]   = node[i+5*nelem]; 
          nodeP1[nn+2*nelemP1] = node[i+4*nelem]; 
          nn++;

          nrefeP1[nn]=nrefe[i];
          nodeP1[nn]           = node[i+3*nelem]; 
          nodeP1[nn+nelemP1]   = node[i+4*nelem]; 
          nodeP1[nn+2*nelemP1] = node[i+5*nelem]; 
          nn++;
        }

    }
  else
    {
      nn=0;
      for (i=0;i<nelem;i++)
        {
          nrefeP1[nn]=nrefe[i];
          nodeP1[nn]           = node[i+0*nelem]; 
          nodeP1[nn+nelemP1]   = node[i+4*nelem]; 
          nodeP1[nn+2*nelemP1] = node[i+6*nelem]; 
          nodeP1[nn+3*nelemP1] = node[i+7*nelem]; 
          nn++;

          nrefeP1[nn]=nrefe[i];
          nodeP1[nn]           = node[i+4*nelem]; 
          nodeP1[nn+nelemP1]   = node[i+1*nelem]; 
          nodeP1[nn+2*nelemP1] = node[i+5*nelem]; 
          nodeP1[nn+3*nelemP1] = node[i+8*nelem]; 
          nn++;

          nrefeP1[nn]=nrefe[i];
          nodeP1[nn]           = node[i+6*nelem]; 
          nodeP1[nn+nelemP1]   = node[i+5*nelem]; 
          nodeP1[nn+2*nelemP1] = node[i+2*nelem]; 
          nodeP1[nn+3*nelemP1] = node[i+9*nelem]; 
          nn++;

          nrefeP1[nn]=nrefe[i];
          nodeP1[nn]           = node[i+7*nelem]; 
          nodeP1[nn+nelemP1]   = node[i+8*nelem]; 
          nodeP1[nn+2*nelemP1] = node[i+9*nelem]; 
          nodeP1[nn+3*nelemP1] = node[i+3*nelem]; 
          nn++;

          nrefeP1[nn]=nrefe[i];
          nodeP1[nn]           = node[i+4*nelem]; 
          nodeP1[nn+nelemP1]   = node[i+5*nelem]; 
          nodeP1[nn+2*nelemP1] = node[i+6*nelem]; 
          nodeP1[nn+3*nelemP1] = node[i+7*nelem]; 
          nn++;

          nrefeP1[nn]=nrefe[i];
          nodeP1[nn]           = node[i+5*nelem]; 
          nodeP1[nn+nelemP1]   = node[i+8*nelem]; 
          nodeP1[nn+2*nelemP1] = node[i+7*nelem]; 
          nodeP1[nn+3*nelemP1] = node[i+4*nelem]; 
          nn++;

          nrefeP1[nn]=nrefe[i];
          nodeP1[nn]           = node[i+5*nelem]; 
          nodeP1[nn+nelemP1]   = node[i+9*nelem]; 
          nodeP1[nn+2*nelemP1] = node[i+6*nelem]; 
          nodeP1[nn+3*nelemP1] = node[i+7*nelem]; 
          nn++;

          nrefeP1[nn]=nrefe[i];
          nodeP1[nn]           = node[i+7*nelem]; 
          nodeP1[nn+nelemP1]   = node[i+9*nelem]; 
          nodeP1[nn+2*nelemP1] = node[i+8*nelem]; 
          nodeP1[nn+3*nelemP1] = node[i+5*nelem]; 
          nn++;

        }
    }
}
