//Filename: ide_info.h
/*
 * Sysinfo
 * Copyright (C) Nil Gradisnik 2005 <ghaefb@gmail.com>
 * 
 * Sysinfo is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 2, or (at your option) any later version.
 * 
 * sysinfo is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with main.cc.  See the file "COPYING".  If not,
 * write to:  The Free Software Foundation, Inc.,
 *            59 Temple Place - Suite 330,
 *            Boston,  MA  02111-1307, USA.
 */

#ifndef IDE_INFO_H
#define IDE_INFO_H

#include <iostream>
#include <fstream>
#include <iomanip>

//global variables
Glib::ustring hdamedia = "unknown";
Glib::ustring hdamodel = "unknown";
Glib::ustring hdacapa = "unknown";
Glib::ustring hdacache = "unknown";

Glib::ustring hdbmedia = "unknown";
Glib::ustring hdbmodel = "unknown";
Glib::ustring hdbcapa = "unknown";
Glib::ustring hdbcache = "unknown";

Glib::ustring hdcmedia = "unknown";
Glib::ustring hdcmodel = "unknown";
Glib::ustring hdccapa = "unknown";
Glib::ustring hdccache = "unknown";

Glib::ustring hddmedia = "unknown";
Glib::ustring hddmodel = "unknown";
Glib::ustring hddcapa = "unknown";
Glib::ustring hddcache = "unknown";

//read hda info
void Hda() {
	
	std::ifstream check("/proc/ide/hda");
	if (!check.good()) {}
		else {
			
		//read hda media
		std::ifstream media("/proc/ide/hda/media");
		if (!media.good()) {}
			else {
				char line[80];
				media.getline(line,80,'\n');
				
				hdamedia = line;
			}
		media.close();
			
		//read hda model
		std::ifstream model("/proc/ide/hda/model");
		if (!model.good()) {}
			else {
				char line[80];
				model.getline(line,80,'\n');
				
				hdamodel = line;
			}
		model.close();
			
		//read hda capacity
		std::ifstream capa("/proc/ide/hda/capacity");
		if (!capa.good()) {}
			else {
				char unitsGb[5] = " Gb", unitsMb[5] = " Mb";
				char result[30], result1[30];
				char line[30];
				capa.getline(line,30,'\n');
				
				//char to int
				double numbers = atoi(line);
				numbers = numbers/2;
				double numbers1 = numbers;
				
				//Mb Gb check
				if (numbers >= 1000000) {
					numbers = numbers/1000000;
					char chars[35];
					sprintf(chars, "%g", numbers);
					
					strcpy(result,chars);
					strcat(result,unitsGb);
				}
				else if (numbers <= 999999) {
					numbers = numbers/1000;
					char chars[35];
					sprintf(chars, "%g", numbers);
					
					strcpy(result,chars);
					strcat(result,unitsMb);
				}
				
				double numbersA = numbers1;
				//Mb Gb check
				if (numbersA >= 1000000) {
					numbersA = numbersA/1048576;
					char chars[35];
					sprintf(chars, "%g", numbersA);
					
					strcpy(result1,chars);
					strcat(result1,unitsGb);
				}
				else if (numbersA <= 999999) {
					numbersA = numbersA/1024;
					char chars[35];
					sprintf(chars, "%g", numbersA);
					
					strcpy(result1,chars);
					strcat(result1,unitsMb);
				}
				
				strcat(result,"  (actual - ");
				strcat(result,result1);
				strcat(result,")");
				
				hdacapa = result;
			}
		capa.close();
			
		//read hda cache
		std::ifstream cache("/proc/ide/hda/cache");
		if (!cache.good()) {}
			else {
				char units[5] = " Mb";
				char line[80];
				cache.getline(line,80,'\n');
				
				//char to int
				double numbers= atoi(line);
				numbers = numbers / 1024;
				
				//int to char
				char chars[50];
				sprintf(chars, "%g", numbers);
				
				strcat(chars,units);
				
				hdacache = chars;
			}
		cache.close();
	}
	check.close();
}

//read hdb info
void Hdb() {
	
	std::ifstream check("/proc/ide/hdb");
	if (!check.good()) {}
		else {
			
		//read hdb media
		std::ifstream media("/proc/ide/hdb/media");
		if (!media.good()) {}
			else {
				char line[80];
				media.getline(line,80,'\n');
				hdbmedia = line;
			}
		media.close();
			
		//read hdb model
		std::ifstream model("/proc/ide/hdb/model");
		if (!model.good()) {}
			else {
				char line[80];
				model.getline(line,80,'\n');
				
				hdbmodel = line;
			}
		model.close();
			
		//read hdb capacity
		std::ifstream capa("/proc/ide/hdb/capacity");
		if (!capa.good()) {}
			else {
				char unitsGb[5] = " Gb", unitsMb[5] = " Mb";
				char result[30], result1[30];
				char line[30];
				capa.getline(line,30,'\n');
				
				//char to int
				double numbers = atoi(line);
				numbers = numbers/2;
				double numbers1 = numbers;
				
				//Mb Gb check
				if (numbers >= 1000000) {
					numbers = numbers/1000000;
					char chars[35];
					sprintf(chars, "%g", numbers);
					
					strcpy(result,chars);
					strcat(result,unitsGb);
				}
				else if (numbers <= 999999) {
					numbers = numbers/1000;
					char chars[35];
					sprintf(chars, "%g", numbers);
					
					strcpy(result,chars);
					strcat(result,unitsMb);
				}
				
				double numbersA = numbers1;
				//Mb Gb check
				if (numbersA >= 1000000) {
					numbersA = numbersA/1048576;
					char chars[35];
					sprintf(chars, "%g", numbersA);
					
					strcpy(result1,chars);
					strcat(result1,unitsGb);
				}
				else if (numbersA <= 999999) {
					numbersA = numbersA/1024;
					char chars[35];
					sprintf(chars, "%g", numbersA);
					
					strcpy(result1,chars);
					strcat(result1,unitsMb);
				}
				
				strcat(result,"  (actual - ");
				strcat(result,result1);
				strcat(result,")");
				
				hdbcapa = result;
			}
		capa.close();
			
		//read hdb cache
		std::ifstream cache("/proc/ide/hdb/cache");
		if (!cache.good()) {}
			else {
				char units[5] = " Mb";
				char line[80];
				cache.getline(line,80,'\n');
				
				//char to int
				double numbers = atoi(line);
				numbers = numbers / 1024;
				
				//int to char
				char chars[50];
				sprintf(chars, "%g", numbers);
				
				strcat(chars,units);
				
				hdbcache = chars;
			}
		cache.close();
	}
	check.close();
}

//read hdc info
void Hdc() {
	
	std::ifstream check("/proc/ide/hdc");
	if (!check.good()) {}
		else {
			
		//read hdc media
		std::ifstream media("/proc/ide/hdc/media");
		if (!media.good()) {}
			else {
				char line[80];
				media.getline(line,80,'\n');
				hdcmedia = line;
			}
		media.close();
			
		//read hdc model
		std::ifstream model("/proc/ide/hdc/model");
		if (!model.good()) {}
			else {
				char line[80];
				model.getline(line,80,'\n');
	
				hdcmodel = line;
			}
		model.close();
			
		//read hdc capacity
		std::ifstream capa("/proc/ide/hdc/capacity");
		if (!capa.good()) {}
			else {
				char unitsGb[5] = " Gb", unitsMb[5] = " Mb";
				char result[30], result1[30];
				char line[30];
				capa.getline(line,30,'\n');
				
				//char to int
				double numbers = atoi(line);
				numbers = numbers/2;
				
				double numbers1 = numbers;
				
				//Mb Gb check
				if (numbers >= 1000000) {
					numbers = numbers/1000000;
					
					char chars[35];
					sprintf(chars, "%g", numbers);
					strcpy(result,chars);
					strcat(result,unitsGb);
				}
				else if (numbers <= 999999) {
					numbers = numbers/1000;
					char chars[35];
					sprintf(chars, "%g", numbers);
					
					strcpy(result,chars);
					strcat(result,unitsMb);
				}
				
				double numbersA = numbers1;
				//Mb Gb check
				if (numbersA >= 1000000) {
					numbersA = numbersA/1048576;
					char chars[35];
					sprintf(chars, "%g", numbersA);
					
					strcpy(result1,chars);
					strcat(result1,unitsGb);
				}
				else if (numbersA <= 999999) {
					numbersA = numbersA/1024;
					char chars[35];
					sprintf(chars, "%g", numbersA);
					
					strcpy(result1,chars);
					strcat(result1,unitsMb);
				}
				
				strcat(result,"  (actual - ");
				strcat(result,result1);
				strcat(result,")");
				
				hdccapa = result;
			}
		capa.close();
			
		//read hdc cache
		std::ifstream cache("/proc/ide/hdc/cache");
		if (!cache.good()) {}
			else {
				char units[5] = " Mb";
				char line[80];
				cache.getline(line,80,'\n');
				
				//char to int
				double numbers= atoi(line);
				numbers = numbers / 1024;
				
				//int to char
				char chars[50];
				sprintf(chars, "%g", numbers);

				strcat(chars,units);
				
				hdccache = chars;
			}
		cache.close();
	}
	check.close();
}

//read hdd info
void Hdd() {
	
	std::ifstream check("/proc/ide/hdd");
	if (!check.good()) {} 
	else {
			
		//read hdd media
		std::ifstream media("/proc/ide/hdd/media");
		if (!media.good()) {}
			else {
				char line[80];
				media.getline(line,80,'\n');
				hddmedia = line;
			}
		media.close();
			
		//read hdd model
		std::ifstream model("/proc/ide/hdd/model");
		if (!model.good()) {}
			else {
				char line[80];
				model.getline(line,80,'\n');
				
				hddmodel = line;
			}
		model.close();
			
		//read hdd capacity
		std::ifstream capa("/proc/ide/hdd/capacity");
		if (!capa.good()) {}
			else {
				char unitsGb[5] = " Gb", unitsMb[5] = " Mb";
				char result[30], result1[30];
				char line[30];
				capa.getline(line,30,'\n');
				
				//char to int
				double numbers = atoi(line);
				numbers = numbers/2;
				double numbers1 = numbers;
				
				//Mb Gb check
				if (numbers >= 1000000) {
					numbers = numbers/1000000;
					char chars[35];
					sprintf(chars, "%g", numbers);
					
					strcpy(result,chars);
					strcat(result,unitsGb);
				}
				else if (numbers <= 999999) {
					numbers = numbers/1000;
					char chars[35];
					sprintf(chars, "%g", numbers);
					
					strcpy(result,chars);
					strcat(result,unitsMb);
				}
				
				double numbersA = numbers1;
				//Mb Gb check
				if (numbersA >= 1000000) {
					numbersA = numbersA/1048576;
					char chars[35];
					sprintf(chars, "%g", numbersA);
					
					strcpy(result1,chars);
					strcat(result1,unitsGb);
				}
				else if (numbersA <= 999999) {
					numbersA = numbersA/1024;
					char chars[35];
					sprintf(chars, "%g", numbersA);
					
					strcpy(result1,chars);
					strcat(result1,unitsMb);
				}
				
				strcat(result,"  (actual - ");
				strcat(result,result1);
				strcat(result,")");
				
				hddcapa = result;
			}
		capa.close();
			
		//read hdd cache
		std::ifstream cache("/proc/ide/hdd/cache");
		if (!cache.good()) {}
			else {
				char units[5] = " Mb";
				char line[80];
				cache.getline(line,80,'\n');
				
				//char to int
				double numbers= atoi(line);
				numbers = numbers / 1024;
				
				//int to char
				char chars[50];
				sprintf(chars, "%g", numbers);
				
				strcat(chars,units);
				
				hddcache = chars;
			}
		cache.close();
	}
	check.close();
}



#endif //IDE_INFO_H

//ghaefb
