//Filename: memory_info.h
/*
 * Sysinfo
 * Copyright (C) Nil Gradisnik 2005 <ghaefb@gmail.com>
 * 
 * Sysinfo is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 2, or (at your option) any later version.
 * 
 * sysinfo is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with main.cc.  See the file "COPYING".  If not,
 * write to:  The Free Software Foundation, Inc.,
 *            59 Temple Place - Suite 330,
 *            Boston,  MA  02111-1307, USA.
 */

#ifndef MEMORY_INFO_H
#define MEMORY_INFO_H

#include <iostream>
#include <fstream>

//global variables
Glib::ustring meminfo1 = "unknown";
Glib::ustring meminfo2 = "unknown";
Glib::ustring meminfo3 = "unknown";
Glib::ustring meminfo4 = "unknown";
Glib::ustring meminfo5 = "unknown";
Glib::ustring meminfo6 = "unknown";
Glib::ustring meminfo7 = "unknown";
double mem_total;
double mem_free;
double mem;

//meminfo1
void Meminfo1() {
	
	std::ifstream text("/proc/meminfo");
	char temp[150];
	char line[150];
	while (!text.eof()) {
		text.getline(line,150,'\n');
		if(strstr(line, "MemTotal")) {
			char units[5] = " Mb";
			int i = 0, j = 14;
			while((line[j] != '\0')) {
				temp[i] = line[j];
				i++; j++;
			}
			//char to int
			int numbers= atoi(temp);
			numbers = numbers/1000;
			mem_total = numbers;
			
			//int to char
			char chars[50];
			sprintf(chars, "%d", numbers);
			
			strcat(chars,units);
			
			meminfo1 = chars;
		}
	}
	text.close();
}

//meminfo2
void Meminfo2() {
	
	std::ifstream text("/proc/meminfo");
	char temp[150];
	char line[150];
	while (!text.eof()) {
		text.getline(line,150,'\n');
		if(strstr(line, "MemFree")) {
			char units[5] = " Mb";
			int i = 0, j = 12;
			while((line[j] != '\0')) {
				temp[i] = line[j];
				i++; j++;
			}
			
			//char to int
			int numbers= atoi(temp);		
			numbers = numbers/1000;
			mem_free = numbers;
		
			//int to char
			char chars[50];
			sprintf(chars, "%d", numbers);
			
			strcat(chars,units);
			
			meminfo2 = chars;

		}
	}
	text.close();
}

//meminfo_progress
void Meminfo_progress()
{
	mem = mem_total - mem_free; 
	mem = mem / mem_total;
}

//meminfo3
void Meminfo3() {
	
	std::ifstream text("/proc/meminfo");
	char temp[150];
	char line[150];
	int a = 0;
	while (!text.eof() && a < 1) {
		text.getline(line,150,'\n');
		if(strstr(line, "Cached")) {
			char units[5] = " Mb";
			int i = 0, j = 14;
			while((line[j] != '\0')) {
				temp[i] = line[j];
				i++; j++;
			}
			//char to int
			int numbers= atoi(temp);
			numbers = numbers/1000;
			
			//int to char
			char chars[50];
			sprintf(chars, "%d", numbers);
			
			strcat(chars,units);
			
			meminfo3 = chars;
			a++;
		}
	}
	text.close();
}

//meminfo4
void Meminfo4() {
	
	std::ifstream text("/proc/meminfo");
	char temp[150];
	char line[150];
	while (!text.eof()) {
		text.getline(line,150,'\n');
		if(strstr(line, "Active")) {
			char units[5] = " Mb";
			int i = 0, j = 14;
			while((line[j] != '\0')) {
				temp[i] = line[j];
				i++; j++;
			}
			//char to int
			int numbers= atoi(temp);
			numbers = numbers/1000;
			
			//int to char
			char chars[50];
			sprintf(chars, "%d", numbers);
			
			strcat(chars,units);
			
			meminfo4 = chars;
		}
	}
	text.close();
}

//meminfo5
void Meminfo5() {
	
	std::ifstream text("/proc/meminfo");
	char temp[150];
	char line[150];
	while (!text.eof()) {
		text.getline(line,150,'\n');
		if(strstr(line, "Inactive")) {
			char units[5] = " Mb";
			int i = 0, j = 14;
			while((line[j] != '\0')) {
				temp[i] = line[j];
				i++; j++;
			}
			//char to int
			int numbers= atoi(temp);
			numbers = numbers/1000;
			
			//int to char
			char chars[50];
			sprintf(chars, "%d", numbers);
			
			strcat(chars,units);
			
			meminfo5 = chars;
		}
	}
	text.close();
}

//meminfo6
void Meminfo6() {
	
	std::ifstream text("/proc/meminfo");
	char temp[150];
	char line[150];
	while (!text.eof()) {
		text.getline(line,150,'\n');
		if(strstr(line, "SwapTotal")) {
			char units[5] = " Mb";
			int i = 0, j = 14;
			while((line[j] != '\0')) {
				temp[i] = line[j];
				i++; j++;
			}
			//char to int
			int numbers= atoi(temp);
			numbers = numbers/1000;
			
			//int to char
			char chars[50];
			sprintf(chars, "%d", numbers);
			
			strcat(chars,units);
			
			meminfo6 = chars;
		}
	}
	text.close();
}

//meminfo7
void Meminfo7() {
	
	std::ifstream text("/proc/meminfo");
	char temp[150];
	char line[150];
	while (!text.eof()) {
		text.getline(line,150,'\n');
		if(strstr(line, "SwapFree")) {
			char units[5] = " Mb";
			int i = 0, j = 14;
			while((line[j] != '\0')) {
				temp[i] = line[j];
				i++; j++;
			}
			//char to int
			int numbers= atoi(temp);
			numbers = numbers/1000;
			
			//int to char
			char chars[50];
			sprintf(chars, "%d", numbers);
			
			strcat(chars,units);
			
			meminfo7 = chars;
		}
	}
	text.close();
}


#endif //MEMORY_INFO_H

//ghaefb
