//Filename: nvidia_info.h
/*
 * Sysinfo
 * Copyright (C) Nil Gradisnik 2005 <ghaefb@gmail.com>
 * 
 * Sysinfo is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 2, or (at your option) any later version.
 * 
 * sysinfo is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with main.cc.  See the file "COPYING".  If not,
 * write to:  The Free Software Foundation, Inc.,
 *            59 Temple Place - Suite 330,
 *            Boston,  MA  02111-1307, USA.
 */

#ifndef NVIDIA_INFO_H
#define NVIDIA_INFO_H

#include <iostream>
#include <fstream>

//global variables
Glib::ustring nvi_mod = "unknown";
Glib::ustring nvi_agp = "unknown";
Glib::ustring nvi_fw = "unknown";
Glib::ustring nvi_sba = "unknown";
Glib::ustring nvi_ver = "no accelerated linux driver detected";

//nvidia graphics card
void Nvidia() {
	
	//read model 
	std::ifstream mod("/proc/driver/nvidia/cards/0");
	if (!mod.good()) {}
	else {
		while (!mod.eof()) {
			char line[80];
			mod.getline(line,80,'\n');
			
    		if(strstr(line, "Model:")) {
				nvi_mod = line;
				nvi_mod.erase(0, 10);
			}
		}
	}
	mod.close();
	
	//read agp rate
	std::ifstream agp("/proc/driver/nvidia/agp/status");
	if (!agp.good()) {}
	else {
		while (!agp.eof()) {
			char line[80];
			agp.getline(line,80,'\n');
			
		    if(strstr(line, "AGP Rate")) {
				nvi_agp = line;
				nvi_agp.erase(0, 12);
			}
		}
	}
	agp.close();
		
	//read fastwrite status
	std::ifstream fw("/proc/driver/nvidia/agp/status");
	if (!fw.good()) {}
	else {
		while (!fw.eof()) {
			char line[80];
			fw.getline(line,80,'\n');
				
			if(strstr(line, "Fast Writes")) {
				nvi_fw = line;
				nvi_fw.erase(0, 15);
			}
		}
	}
	fw.close();
		
	//read sba status
	std::ifstream sba("/proc/driver/nvidia/agp/status");
	if (!sba.good()) {}
	else {
		while (!sba.eof()) {
			char line[80];
			sba.getline(line,80,'\n');
			
			if(strstr(line, "SBA")) {
				nvi_sba = line;
				nvi_sba.erase(0, 8);
			}
		}
	}
	sba.close();
		
	//read driver version
	std::ifstream ver("/proc/driver/nvidia/version");
	if (!ver.good()) {}
    else {
		char line[80];
		ver.getline(line,80,'\n');
		
		nvi_ver = line;
		nvi_ver.erase(0, 14);
	}
	ver.close();
}


#endif //NVIDIA_INFO_H

//ghaefb
