//Filename: other_info.h
/*
 * Sysinfo
 * Copyright (C) Nil Gradisnik 2005 <ghaefb@gmail.com>
 * 
 * Sysinfo is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 2, or (at your option) any later version.
 * 
 * sysinfo is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with main.cc.  See the file "COPYING".  If not,
 * write to:  The Free Software Foundation, Inc.,
 *            59 Temple Place - Suite 330,
 *            Boston,  MA  02111-1307, USA.
 */

#ifndef OTHER_INFO_H
#define OTHER_INFO_H

#include <iostream>
#include <fstream>

//global variables
Glib::ustring sound1 = "";
Glib::ustring sound2 = "";
Glib::ustring inp1 = "";
Glib::ustring inp2 = "";
Glib::ustring inp3 = "";
Glib::ustring inp4 = "";
Glib::ustring inp5 = "";
Glib::ustring inp6 = "";
Glib::ustring sw = "unknown";
Glib::ustring sh = "unknown";

//read sound card model
void Sound() {

	std::ifstream cards("/proc/asound/cards");
	if (!cards.good()) {}
		else {
			int foo = 0;
			
			while (!cards.eof()) {
				Glib::ustring temp;
				char line[150];
				cards.getline(line,150,'\n');
				
				temp = line;
				temp.erase(0, 21);
				
				if ( foo == 0 )
					sound1 = temp;
				if ( foo == 1 )
					sound2 = temp;
				
				foo++;
			}
		}
	cards.close();
}

//input devices
void Inputdev() {
	
	std::ifstream inp("/proc/bus/input/devices");
	if (!inp.good()) {}
	else {
		int a = 0;
		while (!inp.eof()) {
			//first input device
			if (a == 0) {
				char line[80];
				inp.getline(line,80,'\n');
				
				if(strstr(line, "Name")) {
					inp1 = line;
					inp1.erase(0, 8);
					a++;
				}
			}
			//second input device
			else if (a == 1) {
				char line[80];
				inp.getline(line,80,'\n');
				
			    if(strstr(line, "Name")) {
					inp2 = line;
					inp2.erase(0, 8);
					a++;
				}
			}
			//third input device
			else if (a == 2) {
				char line[80];
				inp.getline(line,80,'\n');
					
				if(strstr(line, "Name")) {
					inp3 = line;
					inp3.erase(0, 8);
					a++;
				}
			}
			//forth input device
			else if (a == 3) {
				char line[80];
				inp.getline(line,80,'\n');
				
				if(strstr(line, "Name")) {
					inp4 = line;
					inp4.erase(0, 8);
					a++;
				}
			}
			//fifth input device
			else if (a == 4) {
				char line[80];
				inp.getline(line,80,'\n');
				
				if(strstr(line, "Name")) {
					inp5 = line;
					inp5.erase(0, 8);
					a++;
				}
			}
			//sixth input device
			else if (a == 5) {
				char line[80];
				inp.getline(line,80,'\n');
				
				if(strstr(line, "Name")) {
					inp6 = line;
					inp6.erase(0, 8);
					a++;
				}
			}
		}
	}
	inp.close();
}

//screen resolution
void Screen()
{
	int width;
	int height;
	width = gdk_screen_width();
	height = gdk_screen_height();
	
	char w[10];
	sprintf(w, "%d", width);
	char h[10];
	sprintf(h, "%d", height);
	
	sw = w;
	sh = h;
}

#endif //OTHER_INFO_H

//ghaefb
