// start of definition 
if (!window.TabbrowserService) {

if (!('TabbrowserServiceModules' in window))
	window.TabbrowserServiceModules = [];
if (!('gTSWindowOpenerType' in window))
	var gTSWindowOpenerType = null;
if (!('gTSOpenTabTimer' in window))
	var gTSOpenTabTimer = null;

var gTSDOMWindowOpenObserver;

	
// ^uuEŮg@\ 
// extensions for the tabbrowser widget
 
// static class "TabbrowserService" 
var TabbrowserService =
{
	debug : false,

	activated : false,
	onQuit    : false,

	get initialized()
	{
		return this.activated;
	},

	prefs : [],

	startWithOpenURLRequest   : false,

	referrerBlockers : [
		'http://ime.nu/',
		'http://pinktower.com/'
	],
	
	// 萔 
	XULNS : 'http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul',
	XHTMLNS : 'http://www.w3.org/1999/xhtml',
	XLinkNS : 'http://www.w3.org/1999/xlink',
	knsIRDFResource    : Components.interfaces.nsIRDFResource,
	knsIRDFLiteral     : Components.interfaces.nsIRDFLiteral,
	knsISupportsString : ('nsISupportsWString' in Components.interfaces) ? Components.interfaces.nsISupportsWString : Components.interfaces.nsISupportsString,

	kBookmarksCommentSep : ':::::: tabextensions: Don\'t Edit after This Line ::::::',
	kBookmarksInfoSepStart : '<tabextensions>',
	kBookmarksInfoSepEnd   : '</tabextensions>',

	ZOOM_MAX : ('ZoomManager' in window ? ZoomManager.prototype.MAX : 2000 ),
	ZOOM_MIN : ('ZoomManager' in window ? ZoomManager.prototype.MIN : 1 ),
	
	get kNC_URL() 
	{
		if (!this._kNC_URL)
			this._kNC_URL = this.RDF.GetResource('http://home.netscape.com/NC-rdf#URL');
		return this._kNC_URL;
	},
	_kNC_URL : null,
 
	get kNC_Keyword() 
	{
		if (!this._kNC_Keyword)
			this._kNC_Keyword = this.RDF.GetResource('http://home.netscape.com/NC-rdf#ShortcutURL');
		return this._kNC_Keyword;
	},
	_kNC_Keyword : null,
 
	get kNC_NAME() 
	{
		if (!this._kNC_NAME)
			this._kNC_NAME = this.RDF.GetResource('http://home.netscape.com/NC-rdf#Name');
		return this._kNC_NAME;
	},
	_kNC_NAME : null,
 
	get kNC_DESC() 
	{
		if (!this._kNC_DESC)
			this._kNC_DESC = this.RDF.GetResource('http://home.netscape.com/NC-rdf#Description');
		return this._kNC_DESC;
	},
	_kNC_DESC : null,
 
	get kNC_WebPanel() 
	{
		if (!this._kNC_WebPanel)
			this._kNC_WebPanel = this.RDF.GetResource('http://home.netscape.com/NC-rdf#WebPanel');
		return this._kNC_WebPanel;
	},
	_kNC_WebPanel : null,
 
	DOMWindowOpenObserver : { 
		WindowManager : Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator),
		DOMWindow : Components.interfaces.nsIDOMWindow,
		target : null,

		get browserWindow()
		{
			var targets = this.WindowManager.getEnumerator('navigator:browser'),
				target;
			while (targets.hasMoreElements())
			{
				target = targets.getNext().QueryInterface(this.DOMWindow);
				if (target != this.target)
					return target;
			}
			return null;
		},

		observe : function(aSubject, aTopic, aData)
		{
//			dump('tabextensions : on'+aTopic+'\n');
			if (aTopic != 'domwindowopened')
				return;

			this.onObserve(aSubject, this);
		},
		onObserve : function(aSubject, aThis)
		{
			var win = aThis.target = aSubject;
			var nav = aThis.browserWindow;

			// if there is no navigator window, do nothing.
			if (!nav) return;

			if (!win.location.href) {
				nav.setTimeout(aThis.onObserve, 0, win, aThis);
				return;
			}

			var TS = nav.TabbrowserService;
			if (win.location.href != TS.browserURI) // this is not browser
				return;

			 // if the window has been reopened by another thread, end this.)
			if (win.gTSWindowOpenerType) return;

			win.gTSWindowOpenerType = (win.opener) ? 'XULWindow' :
							(
								!('arguments' in win) &&
								!('__tabextensions__opener' in win) &&
								(TS.winHookMode || TS.opentabforJS)
							) ? 'ContentWindow' :
							'PlatformNative' ;


			// ignore "reopen new windows as new tabs" behavior if this window is loaded into a frame, like the DOM Inspector's browser.
			if (win != Components.lookupMethod(win, 'top').call(win)) return;
			var docShell = win.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
					.getInterface(Components.interfaces.nsIWebNavigation)
					.QueryInterface(Components.interfaces.nsIDocShellTreeItem);
			if (docShell.parent) return;
/*
			var baseWindow = docShell.treeOwner
					.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
					.getInterface(Components.interfaces.nsIXULWindow)
					.QueryInterface(Components.interfaces.nsIBaseWindow);
*/

			if (
				(
					win.gTSWindowOpenerType == 'PlatformNative' &&
					(
						TS.winHookMode == 1 ||
						TS.platformNativeBehavior == 1 ||
						TS.platformNativeBehavior == 2
					)
				) ||
				(TS.winHookMode == 2 && win.gTSWindowOpenerType != 'ContentWindow')
				) {
				if (
					(
						TS.winHookMode == 2 &&
						win.gTSWindowOpenerType == 'XULWindow' &&
						win.location.href.match(/^(chrome:\/\/navigator\/content\/(navigator.xul)?|chrome:\/\/browser\/content\/(browser.xul)?)$/)
					) ||
					(
						win.gTSWindowOpenerType == 'PlatformNative' &&
						(
							TS.winHookMode == 2 ||
							(
								(
									TS.winHookMode == 1 ||
									TS.platformNativeBehavior == 0 ||
									TS.platformNativeBehavior == 2
								) &&
								(
									!TS.getPref('browser.tabs.extensions.platform_native.allow_window_for_homepage') ||
									!TS.isDefaultStartup(win) ||
									(!('arguments' in win ) || win.arguments.length != 1)
								)
							)
						)
					)
					) {
if (TS.debug) dump('TABEXTENSIONS: window is opened with not the home page\n');
					TS.hideWindow(win);
					TS.openTabInsteadSelfInternal(win, TS);
				}
			}
			else if ( // window.open̎sɐɎsꍇ̃tFCZ[t
				win.gTSWindowOpenerType == 'ContentWindow' &&
				(TS.winHookMode || TS.opentabforJS)
				) {
if (TS.debug) dump('TABEXTENSIONS: window is opened by "target" links or JavaScript in webpages\n');
				TS.hideWindow(win);
				win.gTSWindowShouldBeDestructed = true;
				win.gTSOpenTabTimer = win.setTimeout(TS.openTabInsteadSelfInternal, 100, win, TS);
			}
			else if (win.gTSWindowOpenerType == 'PlatformNative') {
if (TS.debug) dump('TABEXTENSIONS: window is opened by platform native\n');
				TS.hideWindow(win);
				TS.checkWindowShouldBeOpenedForSameURI(win);
			}
		}
	},
  
	// properties 
	
	get isNewTypeBrowser() 
	{
		return this.browserURI.match(/^chrome:\/\/browser\//) ? true : false ;
	},
 
	get isBrowserWindow() 
	{
		return (Components.lookupMethod(window, 'top').call(window).document.documentElement.getAttribute('windowtype') == 'navigator:browser');
	},
 
	get browserURI() 
	{
		if (!this._browserURI) {
			var handler = Components.classes['@mozilla.org/commandlinehandler/general-startup;1?type=browser'].getService(Components.interfaces.nsICmdLineHandler);
			var uri = handler.chromeUrlForTask;
			if (uri.charAt(uri.length-1) == '/')
				uri = uri.replace(/chrome:\/\/([^\/]+)\/content\//, 'chrome://$1/content/$1.xul');
			this._browserURI = uri;
		}
		return this._browserURI;
	},
	_browserURI : null,
 
	get browser() 
	{
		if (this._browser === void(0)) {
			this._browser = document.getElementById('content');
			if (this._browser && this._browser.localName != 'tabbrowser')
				this._browser = null;
		}
		var b = this.browsers;
		return this._browser ? this._browser : b.length ? b[0] : null ;
	},
//	_browser : null,
	
	get popupNodeOwnerBrowser() 
	{
		if (
			!document.popupNode ||
			!document.popupNode.ownerDocument
			)
			return null;

		var b = this.browsers;
		if (!b || !b.length) return null;

		for (var i in b)
			if (
				b[i].contentDocument &&
				b[i].contentDocument.defaultView == Components.lookupMethod(document.popupNode.ownerDocument.defaultView, 'top').call(document.popupNode.ownerDocument.defaultView)
				)
				return b[i];

		return null;
	},
  
	get browsers() 
	{
		return document.getElementsByTagNameNS(this.XULNS, 'tabbrowser');
	},
 
	get browserWindow() 
	{
		return this.WindowManager.getMostRecentWindow('navigator:browser');
	},
 
	get browserWindows() 
	{
		var browserWindows = [];

		var targets = this.WindowManager.getEnumerator('navigator:browser'),
			target;
		while (targets.hasMoreElements())
		{
			target = targets.getNext().QueryInterface(Components.interfaces.nsIDOMWindowInternal);
			browserWindows.push(target);
		}

//		return browserWindows;

		// rearrange with z-order
		var ordered = this.browserWindowsWithZOrder;
		var results = [];
		var i, j;
		for (i in ordered)
			for (j in browserWindows)
				if (ordered[i] == browserWindows[j]) {
					results.push(browserWindows[j]);
					browserWindows.splice(j, 1);
					break;
				}

		return results.concat(browserWindows); // result + rest windows (have not shown yet)
	},
	
	get browserWindowsWithZOrder() 
	{
		var browserWindows = [];

		var targets = this.WindowManager.getZOrderDOMWindowEnumerator('navigator:browser', true),
			target;
		while (targets.hasMoreElements())
		{
			target = targets.getNext().QueryInterface(Components.interfaces.nsIDOMWindowInternal);
			browserWindows.push(target);
		}

		return browserWindows;
	},
  
	get BookmarksDS() 
	{
		if (!this._BookmarksDS) {
			this._BookmarksDS = this.RDF.GetDataSource('rdf:bookmarks');
			try {
				this._BookmarksDS = this._BookmarksDS.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);
				this._BookmarksDS = this._BookmarksDS.QueryInterface(Components.interfaces.nsIBookmarksService);
			}
			catch(e) {
				alert(e);
			}
		}
		return this._BookmarksDS;
	},
	_BookmarksDS : null,
 
	get BookmarksDatabase() 
	{
		if (!this._BookmarksDatabase) {
			this._BookmarksDatabase = Components.classes['@mozilla.org/rdf/datasource;1?name=composite-datasource'].createInstance(Components.interfaces.nsIRDFCompositeDataSource);

			this._BookmarksDatabase.AddDataSource(this.BookmarksDS);
			this._BookmarksDatabase.AddDataSource(this.RDF.GetDataSource('rdf:files'));
			this._BookmarksDatabase.AddDataSource(this.RDF.GetDataSource('rdf:localsearch'));
			this._BookmarksDatabase.AddDataSource(this.RDF.GetDataSource('rdf:internetsearch'));
		}
		return this._BookmarksDatabase;
	},
	_BookmarksDatabase : null,
 
	get datasource() 
	{
		if (!this._datasource) {
			uri = this.profileURL+'tabextensions.rdf';

			// if the file doesn't exist, create it.
			var tempLocalFile = this.getFileFromURL(uri);

			if (!tempLocalFile.exists())
				tempLocalFile.create(tempLocalFile.NORMAL_FILE_TYPE, 0644);

			// create datasource object
			try {
				this._datasource = this.RDF.GetDataSource(uri);
			}
			catch(e) {
				alert('Tabbrowser Extesions: Launching error');
			}
		}
		return this._datasource;
	},
	_datasource : null,
	
	// only for backward compatibility 
	get bookmarksData()
	{
		if (!this._bookmarksData)
			this._bookmarksData = new pRDFDataR('Bookmarks', this.datasource.URI, 'bag', 'http://white.sakura.ne.jp/~piro/rdf#', 'chrome://tabextensions/content/tabextensions.rdf#', '%itemID%');

		if (this._bookmarksData.length != this._bookmarksData._resources.length)
			this._bookmarksData.reset();

		return this._bookmarksData;
	},
	_bookmarksData : null,
 
	get iconData() 
	{
		if (!this._iconData)
			this._iconData = new pRDFDataR('RelatedIcons', this.datasource.URI, 'bag', 'http://white.sakura.ne.jp/~piro/rdf#', 'chrome://tabextensions/content/tabextensions.rdf#');

		if (this._iconData.length != this._iconData._resources.length)
			this._iconData.reset();

		return this._iconData;
	},
	_iconData : null,
 
	get JSWindowOpenExceptionsWhite() 
	{
		if (!this._JSWindowOpenExceptionsWhite)
			this._JSWindowOpenExceptionsWhite = new pRDFDataR('JSWindowOpenExceptions', this.datasource.URI, 'bag', 'http://white.sakura.ne.jp/~piro/rdf#', 'chrome://tabextensions/content/tabextensions.rdf#');

		if (this._JSWindowOpenExceptionsWhite.length != this._JSWindowOpenExceptionsWhite._resources.length)
			this._JSWindowOpenExceptionsWhite.reset();

		return this._JSWindowOpenExceptionsWhite;
	},
	_JSWindowOpenExceptionsWhite : null,
 
	get JSWindowOpenExceptionsBlack() 
	{
		if (!this._JSWindowOpenExceptionsBlack)
			this._JSWindowOpenExceptionsBlack = new pRDFDataR('JSWindowOpenExceptionsBlackList', this.datasource.URI, 'bag', 'http://white.sakura.ne.jp/~piro/rdf#', 'chrome://tabextensions/content/tabextensions.rdf#');

		if (this._JSWindowOpenExceptionsBlack.length != this._JSWindowOpenExceptionsBlack._resources.length)
			this._JSWindowOpenExceptionsBlack.reset();

		return this._JSWindowOpenExceptionsBlack;
	},
	_JSWindowOpenExceptionsBlack : null,
  
	get profileURL() 
	{
		if (!this._profileURL) {
			const DIR = Components.classes['@mozilla.org/file/directory_service;1'].getService(Components.interfaces.nsIProperties);
			var dir = DIR.get('ProfD', Components.interfaces.nsILocalFile);

			var tempLocalFile = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
			tempLocalFile.initWithPath(dir.path);

			var uri;
			try {
				uri = this.IOService.newFileURI(tempLocalFile).spec;
			}
			catch(e) { // [[interchangeability for Mozilla 1.1]]
				uri = this.IOService.getURLSpecFromFile(tempLocalFile);
			}

			if (!uri.match(/\/$/)) uri += '/';

			this._profileURL = uri;
		}
		return this._profileURL;
	},
	_profileURL : null,
 
	get strbundle() 
	{
		if (!this._strbundle) {
			const STRBUNDLE = Components.classes['@mozilla.org/intl/stringbundle;1'].getService(Components.interfaces.nsIStringBundleService);
			this._strbundle = STRBUNDLE.createBundle('chrome://tabextensions/locale/tabextensions.properties');
		}
		return this._strbundle;
	},
	_strbundle : null,
 
	// preferences 
	
	get winHookMode() 
	{
		return this.getPref('browser.tabs.extensions.window_hook_mode');
	},
 
	get platformNativeBehavior() 
	{
		return this.getPref('browser.tabs.extensions.platform_native.behavior');
	},
 
	get preventSameURLTab() 
	{
		return this.getPref('browser.tabs.extensions.prevent_same_uri_tab');
	},
 
	get isGroupMode() 
	{
		return this.getPref('browser.tabs.extensions.group.enabled');
	},
 
	get reuseCurrentBlankTab() 
	{
		return this.getPref('browser.tabs.extensions.reuse_current_blank_tab');
	},
 
	get bookmarkGroupBehavior() 
	{
		var groupBehavior = this.getPref('browser.tabs.extensions.bookmarkgroup_behavior');
		/*
			0: append to current tabset
			1: insert to current group
			10: replace all tabs
			11: replace current group
			20: replace current tab when only one tab is open
				(normally append to current tabset)
			21: replace current tab when only one tab is open
				(normally insert to current group)
		*/

		if (!this.isGroupMode)
			if (groupBehavior == 1)
				groupBehavior = 0;
			else if (groupBehavior == 11)
				groupBehavior = 10;
			else if (groupBehavior == 21)
				groupBehavior = 20;

		switch (groupBehavior)
		{
			case 0:
			case 1:
			case 10:
			case 11:
			case 20:
			case 21:
				break;

			default:
				groupBehavior = 0;
				break;
		}

		return groupBehavior;
	},
 
	get opentabforBookmarks() 
	{
		return this.getPref('browser.tabs.opentabfor.bookmarks');
	},
 
	get opentabforJS() 
	{
		return this.getPref('browser.tabs.opentabfor.windowopen');
	},
 
	get loadInBackground() 
	{
		return this.getPref('browser.tabs.loadInBackground');
	},
	
	get loadInBackgroundWindow() 
	{
		return this.getPref('browser.tabs.extensions.loadInBackgroundWindow');
	},
  
	get shouldSaveBookmarksStatus() 
	{
		return this.getPref('browser.tabs.extensions.bookmarks.save_status');
	},
	
	get shouldSaveBookmarksPermissions() 
	{
		return this.getPref('browser.tabs.extensions.bookmarks.save_permissions');
	},
  
	get viewSourceInTab() 
	{
		return this.getPref('browser.tabs.extensions.view_source_tab');
	},
  
	// XPConnect 
	
	get Prefs() 
	{
		if (!this._Prefs) {
			this._Prefs = Components.classes['@mozilla.org/preferences;1'].getService(Components.interfaces.nsIPrefBranch);
		}
		return this._Prefs;
	},
	_Prefs : null,
	
	getPref : function(aPrefstring) 
	{
		try {
			switch (this.Prefs.getPrefType(aPrefstring))
			{
				case this.Prefs.PREF_STRING:
					return this.Prefs.getComplexValue(aPrefstring, this.knsISupportsString).data;
					break;
				case this.Prefs.PREF_INT:
					return this.Prefs.getIntPref(aPrefstring);
					break;
				default:
					return this.Prefs.getBoolPref(aPrefstring);
					break;
			}
		}
		catch(e) {
		}

		return null;
	},
 
	setPref : function(aPrefstring, aNewValue, aPrefObj) 
	{
		var pref = aPrefObj || this.Prefs ;
		var type;
		try {
			type = typeof aNewValue;
		}
		catch(e) {
			type = null;
		}

		switch (type)
		{
			case 'string':
				var string = ('@mozilla.org/supports-wstring;1' in Components.classes) ?
						Components.classes['@mozilla.org/supports-wstring;1'].createInstance(this.knsISupportsString) :
						Components.classes['@mozilla.org/supports-string;1'].createInstance(this.knsISupportsString) ;
				string.data = aNewValue;
				pref.setComplexValue(aPrefstring, this.knsISupportsString, string);
				break;
			case 'number':
				pref.setIntPref(aPrefstring, parseInt(aNewValue));
				break;
			default:
				pref.setBoolPref(aPrefstring, aNewValue);
				break;
		}
		return true;
	},
 
	clearPref : function(aPrefstring) 
	{
		try {
			this.Prefs.clearUserPref(aPrefstring);
		}
		catch(e) {
		}

		return;
	},
  
	get RDF() 
	{
		if (!this._RDF) {
			this._RDF = Components.classes['@mozilla.org/rdf/rdf-service;1'].getService(Components.interfaces.nsIRDFService);
		}
		return this._RDF;
	},
	_RDF : null,
 
	get WindowManager() 
	{
		if (!this._WindowManager) {
			this._WindowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator);
		}
		return this._WindowManager;
	},
	_WindowManager : null,
 
	get WindowWatcher() 
	{
		if (!this._WindowWatcher) {
			this._WindowWatcher = Components.classes['@mozilla.org/embedcomp/window-watcher;1'].getService(Components.interfaces.nsIWindowWatcher);
		}
		return this._WindowWatcher;
	},
	_WindowWatcher : null,
 
	get IOService() 
	{
		if (!this._IOService) {
			this._IOService = Components.classes['@mozilla.org/network/io-service;1'].getService(Components.interfaces.nsIIOService);
		}
		return this._IOService;
	},
	_IOService : null,
 
	get GlobalHistory() 
	{
		if (!this._GlobalHistory) {
			this._GlobalHistory = Components.classes['@mozilla.org/browser/global-history;1'].getService(Components.interfaces.nsIGlobalHistory);
		}
		return this._GlobalHistory;
	},
	_GlobalHistory : null,
 
	get GlobalHistory2() 
	{
		if (!this._GlobalHistory2) {
			this._GlobalHistory2 = Components.classes['@mozilla.org/browser/global-history;2'].getService(Components.interfaces.nsIGlobalHistory2);
		}
		return this._GlobalHistory2;
	},
	_GlobalHistory2 : null,
 
	get BrowserHistory() 
	{
		if (!this._BrowserHistory) {
			try {
				this._BrowserHistory = Components.classes['@mozilla.org/browser/global-history;2'].getService(Components.interfaces.nsIBrowserHistory);
			}
			catch(e) { // old implementation(?)
				this._BrowserHistory = this.GlobalHistory.QueryInterface(Components.interfaces.nsIBrowserHistory);
			}
		}
		return this._BrowserHistory;
	},
	_BrowserHistory : null,
 
	get PromptService() 
	{
		if (!this.mPromptService)
			this.mPromptService = Components.classes['@mozilla.org/embedcomp/prompt-service;1'].getService(Components.interfaces.nsIPromptService);
		return this.mPromptService;
	},
	mPromptService : null,
 
	get WalletService() 
	{
		if (!this._WalletService &&
			'nsIWalletService' in Components.interfaces &&
			'@mozilla.org/wallet/wallet-service;1' in Components.classes) {
			this._WalletService = Components.classes['@mozilla.org/wallet/wallet-service;1'].getService(Components.interfaces.nsIWalletService);
		}
		return this._WalletService;
	},
	_WalletService : null,
 
	get URIFixup() 
	{
		if (!this._URIFixup) {
			this._URIFixup = Components.classes['@mozilla.org/docshell/urifixup;1'].getService(Components.interfaces.nsIURIFixup);
		}
		return this._URIFixup;
	},
	_URIFixup : null,
 
	get ObserverService() 
	{
		if (!this._ObserverService) {
			this._ObserverService = Components.classes['@mozilla.org/observer-service;1'].getService(Components.interfaces.nsIObserverService);
		}
		return this._ObserverService;
	},
	_ObserverService : null,
 
	get TextToSubURI() 
	{
		if (!this._TextToSubURI)
			this._TextToSubURI = Components.classes['@mozilla.org/intl/texttosuburi;1'].getService(Components.interfaces.nsITextToSubURI);
		return this._TextToSubURI;
	},
	_TextToSubURI : null,
 
	get ConsoleService() 
	{
		if (!this._ConsoleService)
			this._ConsoleService = Components.classes['@mozilla.org/consoleservice;1'].getService(Components.interfaces.nsIConsoleService);
		return this._ConsoleService;
	},
	_ConsoleService : null,
   
	// utilities 
	
	unescapeString : function(aString) 
	{
		aString = String(aString || '');
		var unescapedAsStr = unescape(aString);
		var unescapedAsURI = this.unescape(aString);
		return (this.escape(unescapedAsURI) == aString) ? unescapedAsURI : unescapedAsStr ;
	},
	
	escape : function(aString) 
	{
		return this.TextToSubURI.ConvertAndEscape('UTF-8', String(aString || '').replace(/ /g, '%20')).replace(/%2520/g, '%20').replace(/%2B/g, '+');
	},
 
	unescape : function(aString) 
	{
		return this.TextToSubURI.UnEscapeAndConvert('UTF-8', String(aString || '').replace(/%%20/g, '+').replace(/\+/g, '%2B'));
	},
  
	getInnerTextOf : function(aNode) 
	{
		if (!aNode || !aNode.firstChild) return '';
		var node = aNode.firstChild;

		var depth = 1,
			ret   = [];

		traceTree:
		while (node && depth > 0) {
			if (node.hasChildNodes()) {
				node = node.firstChild;
				depth++;
			} else {
				if (node.nodeType == Node.TEXT_NODE)
					ret.push(node.nodeValue);
				else if (node.alt)
					ret.push(node.alt);

				while (!node.nextSibling) {
					node = node.parentNode;
					depth--;
					if (!node) break traceTree;
				}
				node = node.nextSibling;
			}
		}
		return ret.join('');
	},
 
	getSelectionSource : function(aWindow, aFormat, aSelection) 
	{
		var w = aWindow || document.commandDispatcher.focusedWindow;
		var selection = aSelection ? aSelection : w.getSelection() ;

		if (!selection) return '';

		var pSelection = selection.QueryInterface(Components.interfaces.nsISelectionPrivate),
			cType      = w.document.contentType,
			ret;

		if (!pSelection) return '';

		try {
			ret = pSelection.toStringWithFormat(aFormat || cType, 128+256, 0);
		}
		catch(e) {
			ret = pSelection.toStringWithFormat('text/xml', 128+256, 0);
		}
		return ret.replace(/ _moz-userdefined="[^"]*"/g, '');
	},
 
	makeURIFromSpec : function(aURI) 
	{
		try {
			var newURI;
			aURI = aURI || '';
			if (aURI && aURI.match(/^file:/)) {
				var tempLocalFile;
				try {
					var fileHandler = this.IOService.getProtocolHandler('file').QueryInterface(Components.interfaces.nsIFileProtocolHandler);
					tempLocalFile = fileHandler.getFileFromURLSpec(aURI);
				}
				catch(ex) { // [[interchangeability for Mozilla 1.1]]
					try {
						tempLocalFile = this.IOService.getFileFromURLSpec(aURI);
					}
					catch(ex) { // [[interchangeability for Mozilla 1.0.x]]
						tempLocalFile = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
						this.IOService.initFileFromURLSpec(tempLocalFile, aURI);
					}
				}
				newURI = this.IOService.newFileURI(tempLocalFile); // we can use this instance with the nsIFileURL interface.
			}
			else {
				try {
					newURI = this.IOService.newURI(aURI, null, null);
				}
				catch(ex) {
					newURI = Components.classes['@mozilla.org/network/standard-url;1'].createInstance(Components.interfaces.nsIURI);
					newURI.spec = aURI;
				}
			}

			return newURI;
		}
		catch(e){
		}
		return null;
	},
 
	makeFileWithPath : function(aPath) 
	{
		var newFile = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
		newFile.initWithPath(aPath);
		return newFile;
	},
 
	getFileFromURL : function(aURL) 
	{
		var tempLocalFile;
		try {
			var fileHandler = this.IOService.getProtocolHandler('file').QueryInterface(Components.interfaces.nsIFileProtocolHandler);
			tempLocalFile = fileHandler.getFileFromURLSpec(aURL);
		}
		catch(e) { // [[interchangeability for Mozilla 1.1]]
			try {
				tempLocalFile = this.IOService.getFileFromURLSpec(aURL);
			}
			catch(ex) { // [[interchangeability for Mozilla 1.0.x]]
				tempLocalFile = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
				this.IOService.initFileFromURLSpec(tempLocalFile, aURL);
			}
		}
		return tempLocalFile;
	},
 
	fixupURI : function(aString) 
	{
		var testURI = this.URIFixup.createFixupURI(aString || 'about:blank', this.URIFixup.FIXUP_FLAG_ALLOW_KEYWORD_LOOKUP);
		return (testURI) ? testURI.spec : null ;
	},
 
	isSameHost : function(aURI1, aURI2) 
	{
		return (this.getHost(aURI1) == this.getHost(aURI2));
	},
	
	getHost : function(aURI) 
	{
		if (this.getPref('browser.tabs.opentabfor.outerlink.level') > 1) {
			var host = aURI.split('//');
			if (host.length > 1) {
				host = host[1].split('/');
				return (host.length > 1 && host[1].match(/^(~|\%7[eE])/)) ? host[0]+'/'+host[1] : host[0] ;
			}
		}
		else {
			try {
				return this.makeURIFromSpec(aURI).host;
			}
			catch(e) {
			}
		}
		return null;
	},
  
	// bookmarks 
	
	get isNewTypeBookmarks() 
	{
		var type   = this.RDF.GetResource('http://www.w3.org/1999/02/22-rdf-syntax-ns#type');
		var folder = this.RDF.GetResource('http://home.netscape.com/NC-rdf#Folder');
		var roots  = this.BookmarksDS.GetSources(type, folder, true);
		roots.getNext();
		return roots.hasMoreElements();
	},
 
	isBookmarked : function(aIDOrURI) 
	{
		if (!aIDOrURI) return false;
		if (aIDOrURI.match(/^rdf:/)) return true;

		// for old Mozilla
		try {
			if ('IsBookmarked' in this.BookmarksDS) // NS7
				return this.BookmarksDS.IsBookmarked(aIDOrURI);
			else
				return this.BookmarksDS.isBookmarked(aIDOrURI);
		}
		catch(e) {
		}

		return false;
	},
 
	// get bookmark resources from URI 
	getBookmarkResourcesFromURI : function(aURIOrID)
	{
		// old implementation
		var res = this.RDF.GetResource(aURIOrID);
		if (this.BookmarksDS.GetTarget(res, this.kNC_URL, true))
			return [res];

		var resources = this.BookmarksDS.GetSources(this.kNC_URL, this.RDF.GetLiteral(aURIOrID), true);
		var ret = [];
		while (resources.hasMoreElements())
			ret.push(resources.getNext().QueryInterface(this.knsIRDFResource));

		return ret;
	},

	getBookmarkResourceFromKeyword : function(aKeyword, aURI)
	{
		if (!aURI || !aKeyword) return null;

		var res = this.RDF.GetResource(aKeyword);

		var resources = this.BookmarksDS.GetSources(this.kNC_Keyword, this.RDF.GetLiteral(aKeyword), true);

		while (resources.hasMoreElements())
		{
			res = resources.getNext().QueryInterface(this.knsIRDFResource);

			uri = this.getURIForBookmark(res.Value);
			if (aURI.indexOf(uri.split('%s')[0]) == 0)
				return res;
		}
		return null;
	},
 
	getURIForBookmark : function(aID) 
	{
		if (!aID.match(/^rdf:/)) return aID;

		var uriRes = this.BookmarksDS.GetTarget(this.RDF.GetResource(aID), this.kNC_URL, true);
		try {
			if (uriRes) {
				uriRes = uriRes.QueryInterface(this.knsIRDFLiteral);
				if (uriRes && uriRes.Value)
					return uriRes.Value;
			}
		}
		catch(e) {
		}

		return null;
	},
 
	// ubN}[NɋL^ꂽt@𓾂it@̋Uj 
	// get the referrer for a bookmark (to camouflage referrer)
	getReferrerForBookmark : function(aID)
	{
		if (!this.isBookmarked(aID)) return null;
		try {
			var desc = this.loadBookmarkStatusInternal(aID);
			if (desc && desc.match(/referrerURI=/))
				return this.makeURIFromSpec(desc.match(/referrerURI=(.*)[\n|\r]*/)[1]);
		}
		catch(e) {
		}
		return null;
	},
 
	getTextZoomForBookmark : function(aID) 
	{
		if (!this.isBookmarked(aID)) return null;
		try {
			var desc = this.loadBookmarkStatusInternal(aID);
			var zoom = desc ? desc.match(/textZoom=([0-9]+)/) : null ;
			if (this.getPref('browser.tabs.extensions.bookmarks.save_textZoom') &&
				zoom)
				return Math.min(Math.max(parseInt(zoom[1]), this.ZOOM_MIN), this.ZOOM_MAX);
		}
		catch(e) {
		}
		return null;
	},
 
	getFixedLabelForBookmark : function(aID) 
	{
		if (!this.isBookmarked(aID)) return null;
		try {
			var desc = this.loadBookmarkStatusInternal(aID);
			if (this.getPref('browser.tabs.extensions.bookmarks.use_fixed_label') ||
				(desc && desc.match(/useFixedLabel=(true|yes|1)/)))
				return this.getNameForBookmark(aID);
		}
		catch(e) {
		}
		return null;
	},
 
	getNameForBookmark : function(aID) 
	{
		try {
			return this.BookmarksDS.GetTarget(this.RDF.GetResource(aID), this.kNC_NAME, true).QueryInterface(this.knsIRDFLiteral).Value;
		}
		catch(e) {
		}

		return null;
	},
 
	setNameForBookmark : function(aNewName, aID) 
	{
		if (!this.isBookmarked(aID))
			return;

		var res     = this.RDF.GetResource(aID);
		var oldName = this.getNameForBookmark(aID);

		if (aNewName === void(0)) {
			var history = this.RDF.GetDataSource('rdf:history');
			aNewName = history.GetTarget(this.RDF.GetResource(aID), this.kNC_NAME, true);
			aNewName = aNewName ? aNewName.QueryInterface(this.knsIRDFLiteral).Value : null ;
			if (!aNewName) aNewName = aURI;
		}

		if ((!oldName && !aNewName) || oldName == aNewName) return;

		if (oldName && !aNewName)
			this.BookmarksDS.Unassert(
				res,
				this.kNC_NAME,
				this.RDF.GetLiteral(oldName)
			);
		else if (!oldName && aNewName)
			this.BookmarksDS.Assert(
				res,
				this.kNC_NAME,
				this.RDF.GetLiteral(aNewName),
				true
			);
		else
			this.BookmarksDS.Change(
				res,
				this.kNC_NAME,
				this.RDF.GetLiteral(oldName),
				this.RDF.GetLiteral(aNewName)
			);

		try {
			this.BookmarksDS.Flush();
		}
		catch(e) {
		}
	},
 
	// ubN}[NɋL^ꂽACR𓾂 
	// get the icon for a bookmark
	getIconForBookmark : function(aURI, aOnlyUserDefined)
	{
		if (!aURI) return '';

		aURI = this.getURIForBookmark(aURI);
		if (!aURI) return '';

		var icon;

		if (!this.isBookmarked(aURI)) {
			// get icon from icon data
			var dir = aURI.split('#')[0].split('?')[0].replace(/[^\/]+$/, '').replace(/\/$/, '').split('/');

			while(dir.length && !icon)
			{
				icon = this.iconData.getData(dir.join('/')+'/', 'IconURI');
				if (icon)
					break;
				else
					dir.splice(dir.length-1, 1);
			}

			if (!icon) return '';
		}

		if (!icon) icon = this.iconData.getData(aURI, 'IconURI');

		if (!icon && !aOnlyUserDefined) {
			try {
				var res = this.getBookmarkResourcesFromURI(aURI);
				for (var i in res)
				{
					icon = this.BookmarksDatabase.GetTarget(
							res[i],
							this.RDF.GetResource('http://home.netscape.com/NC-rdf#Icon'),
							true
						);
					icon = (icon) ? icon.QueryInterface(this.knsIRDFLiteral).Value : '' ;
					if (icon) break;
				}
			}
			catch(e) {
				icon = '';
			}
		}
		return icon;
	},
 
	// ubN}[NɋL^ꂽACR[U[`̃ACRŏ㏑ 
	// override bookmark's icon by user's icon
	setIconForBookmark : function(aURI, aIconURI)
	{
		aURI = this.getURIForBookmark(aURI);
		if (!aURI || !this.isBookmarked(aURI)) return;

		if (aIconURI) this.iconData.setData(aURI, 'IconURI', aIconURI);

		var icon = aIconURI || this.iconData.getData(aURI, 'IconURI');

		// add entry to icon data
		var dir = aURI.split('#')[0].split('?')[0].replace(/[^\/]+$/, '').replace(/\/$/, '')+'/';
		if (icon)
			this.iconData.setData(dir, 'IconURI', icon);
		else if (this.iconData.getData(dir, 'IconURI'))
			this.iconData.removeData(dir);

		// update bookmarks
		try {
			var res = this.getBookmarkResourcesFromURI(aURI);
			var oldIcon;
			for (var i in res)
			{
				oldIcon = this.BookmarksDatabase.GetTarget(
						res[i],
						this.RDF.GetResource('http://home.netscape.com/NC-rdf#Icon'),
						true
					);
				if (oldIcon) break;
			}
			if (
				!oldIcon ||
				oldIcon.QueryInterface(this.knsIRDFLiteral).Value != icon
				)
				this.BookmarksDS.updateBookmarkIcon(aURI, icon);
		}
		catch(e) {
/*
			try {
				this.BookmarksDS.Assert(
					res,
					this.RDF.GetResource('http://home.netscape.com/NC-rdf#Icon'),
					this.RDF.GetLiteral(icon),
					true
				);
			}
			catch(ex) {
			}
*/
		}
	},
 
	// ubN}[NɋL^ꂽŒA[hȂǂ̏Ԃǂݍ 
	// load stored data of the bookmark
	loadBookmarkStatus : function(aID, aInfo, aDescription)
	{
		var info = aInfo || {};
		var desc = aDescription || this.loadBookmarkStatusInternal(aID);
		if (!desc) return info;

		if (this.getPref('browser.tabs.extensions.bookmarks.use_fixed_label') ||
			desc.match(/useFixedLabel=(true|yes|1)/))
			info.useFixedLabel = true;
		if (desc.match(/autoreloadInterval=/)) {
			var interval = desc.match(/autoreloadInterval=([0-9]+)/);
			if (interval)
				info.autoreloadInterval = Math.max(parseInt(interval[1]), 0);
		}
		if (desc.match(/textZoom=/)) {
			var zoom = desc.match(/textZoom=([0-9]+)/);
			if (zoom)
				info.textZoom = Math.min(Math.max(parseInt(zoom[1]), this.ZOOM_MIN), this.ZOOM_MAX);
		}

		var regexp = new RegExp();
		var allowProps = [
				'locked',
				'referrerBlocked',
				'allowPlugins',
				'allowJavascript',
				'allowMetaRedirects',
				'allowSubframes',
				'allowImages'
			];
		for (var i in allowProps)
			if (this.getPref('browser.tabs.extensions.'+allowProps[i]+'.enabled'))
				info[allowProps[i]] = !desc.match(regexp.compile('^'+allowProps[i]+'=(false|no|0)', 'm'));
			else
				info[allowProps[i]] = Boolean(desc.match(regexp.compile('^'+allowProps[i]+'=(true|yes|1)', 'm')));


		if (desc.match(/referrerURI=/))
			info.referrerURI = desc.match(/referrerURI=(.*)[\n\r]*/)[1];
		if (desc.match(/autoreloadPostType=/))
			info.autoreloadPostType = desc.match(/autoreloadPostType=(.*)[\n\r]*/)[1] || '' ;
		if (desc.match(/autoreloadPostData=/))
			info.autoreloadPostData = this.unescape(desc.match(/autoreloadPostData=(.*)[\n\r]*/)[1] || '');

		return info;
	},

	loadBookmarkStatusInternal : function(aURIOrID)
	{
		if (!this.isBookmarked(aURIOrID)) return null;
		var res = this.RDF.GetResource(aURIOrID);

		var desc = this.BookmarksDS.GetTarget(res, this.kNC_DESC, true);
		desc = desc ? desc.QueryInterface(this.knsIRDFLiteral).Value : null ;
		if (!desc || desc.indexOf(this.kBookmarksInfoSepStart) < 0) return null;

		return desc.substring(0, desc.indexOf(this.kBookmarksInfoSepEnd)).substring(desc.indexOf(this.kBookmarksInfoSepStart)+this.kBookmarksInfoSepStart.length+1);
	},
  
	// R_CAOŃACRI 
	chooseIcon : function()
	{
		const nsIFilePicker = Components.interfaces.nsIFilePicker;
		const FP = Components.classes['@mozilla.org/filepicker;1'].createInstance(nsIFilePicker);

		title = this.strbundle.GetStringFromName('bookmarksProperty_chooseIcon');

		FP.init(window, title, nsIFilePicker.modeOpen);

		FP.appendFilter(this.strbundle.GetStringFromName('bookmarksProperty_chooseIconFilterLabel'), '*.ico;*.icon');
		FP.appendFilters(nsIFilePicker.filterImages);
//		FP.appendFilters(nsIFilePicker.filterAll);
		FP.show();

		var icon;
		try {
			icon = FP.file.QueryInterface(Components.interfaces.nsILocalFile);
		}
		catch(e) {
			return '';
		}

		try {
			icon = this.IOService.newFileURI(icon).spec;
		}
		catch(e) { // [[interchangeability for Mozilla 1.1]]
			icon = this.IOService.getURLSpecFromFile(icon);
		}

		return icon || '' ;
	},
 
	shouldSendReferrerWithLinkClick : function(aLinkNode) 
	{
		var linkNode = aLinkNode || TabbrowserService.getLastActiveLink();
		var w, d;
		if (!linkNode ||
			!TabbrowserService.browsers.length ||
			(
				d = (
					w = Components.lookupMethod(linkNode.ownerDocument.defaultView, 'top').call(linkNode.ownerDocument.defaultView)
				).document
			) == window.document)
			return true;

		var b = TabbrowserService.browser,
			t = b.selectedTab;

		for (var i in b.mTabs)
			if (b.mTabs[i].mBrowser.contentDocument == d)
				t = b.mTabs[i];

		return !t.mTabInfo.referrerBlocked;
	},
 
	// ŌɃNbNꂽN𓾂 
	getLastActiveLink : function()
	{
		var target = gContextMenu ? gContextMenu.target : null ;
		if (!target)
			return target;
		else
			return findParentNode(target, 'a') ||
				findParentNode(target, 'area') ||
				findParentNode(target, 'link') ||
//				findParentNode(target, 'q') ||
//				findParentNode(target, 'blockquote') ||
//				findParentNode(target, 'ins') ||
//				findParentNode(target, 'del') ||
				null ;
	},
 
	// NKɂ 
	markLinkVisited : function(aURI, aNode)
	{
		if ('markLinkVisited' in window) { // Firefox
			window.markLinkVisited(aURI, aNode);
			return;
		}

		var uri = this.makeURIFromSpec(aURI);

		var visited;
		try {
			visited = this.GlobalHistory2.isVisited(uri);
		}
		catch(e) { // old implementation
			visited = this.GlobalHistory.isVisited(aURI);
		}
		if (visited || !aNode || !aURI.match(/^(https?|ftp|file|resource|chrome|gopher):/)) return;

		try {
			this.GlobalHistory2.addURI(uri, false, true);
		}
		catch(e) { // old implementation
			try {
				this.GlobalHistory.addPage(aURI);
			}
			catch(ex) {
				return;
			}
		}

		var oldHref = aNode.href;
		aNode.href = '';
		aNode.href = oldHref;
	},
 
	// t@ubJ[ւURIǂׁAłΒuURIAłȂnullA 
	// if the uri contains referrer blocker, this returns the real uri. if not, returns null.
	getRealURI : function(aURI)
	{
		var regexp = new RegExp('^('+this.referrerBlockers.join('|')+')');
		var accessFromReferrerBlocker = aURI.match(regexp);
		if (accessFromReferrerBlocker &&
			this.getPref('browser.tabs.extensions.bypass_referrerblocker')) {
			aURI = aURI.replace(regexp, '');
			if (!aURI.match(/http:\/\//)) aURI = 'http://'+aURI;
			return aURI;
		}
		else return null;
	},
 
	// ^ꂽÕt[ԂiċAj 
	// get a frame from name (reflexive)
	getFrameByName : function(aTop, aName, aCurrent)
	{
		var name = (typeof aName == 'string') ? aName : String(aName) ;
		if (!name) return null;

		if (
			aCurrent &&
			(name.match(/^_(self|top|parent|content)$/) || name == '_main')
			) {
			switch (name.toLowerCase())
			{
				case '_top':
				case '_content':
				case '_main':
					return aTop;

				case '_parent':
					return aCurrent.parent;

				case '_self':
					return aCurrent;

				default:
					break;
			}
		}
		var frames = aTop.frames;
		var frame  = null;
		for (var i = 0; i < frames.length; i++)
		{
			if (frames[i].name == name) return frames[i];
			if (frames[i].frames.length) {
				frame = this.getFrameByName(frames[i], name);
				if (frame) break;
			}
		}
		return frame;
	},
 
	// ZLeB̃`FbN 
	uriSecurityCheck : function(aURI, aSourceURI)
	{
		const nsIScriptSecurityManager = Components.interfaces.nsIScriptSecurityManager;
		var secMan = Components.classes['@mozilla.org/scriptsecuritymanager;1'].getService(nsIScriptSecurityManager);
		try {
			secMan.checkLoadURIStr(aSourceURI, aURI, nsIScriptSecurityManager.STANDARD);
		}
		catch (e) {
			throw 'Load of '+aURI+' denied.';
		}
	},
 
	stopEvent : function(aEvent, aShouldStopParent) 
	{
		aEvent.stopPropagation();
		aEvent.preventCapture();
		aEvent.preventDefault();
		aEvent.preventBubble();

		if (!aShouldStopParent) return;

		var targetNode = this.findParentNodeByProp(aEvent.originalTarget, '__tabextensions__on'+aEvent.type, 'function');
		if (targetNode)
			targetNode.__tabextensions__shouldVoid = true;
	},
 
	findParentNodeByProp : function(aNode, aProp, aType) 
	{
		do {
			if (aProp in aNode && typeof aNode[aProp] == aType)
				return aNode;

			aNode = aNode.parentNode;
		}
		while(aNode && aNode.ownerDocument && aNode != aNode.ownerDocument.documentElement);

		return null;
	},
 
	// popup menupopup in the menubar by id 
	popupMenu : function(aID, aX, aY, aParent)
	{
		var node = document.getElementById(aID);
		if (!node) return;

		var x = (aX === void(0) ? window.screenX+20 : aX ),
			y = (aY === void(0) ? window.screenY+40 : aY );

		node.autoPosition = true;

		node.moveTo(x, y);
		node.showPopup(aParent || node.parentNode, x, y, 'popup', null, null);
	},
 
	popupAlert : function(aMessage) 
	{
		var node = document.getElementById('tabextensions-alert-popup');
		if (!node) return;

		const timeout  = 3000;
		const step     = 10;
		const interval = 1;
		const x = this.browser.selectedTab.mBrowser.boxObject.screenX+10;
		const y = this.browser.selectedTab.mBrowser.boxObject.screenY+10;


		if (node.timerInterval)
			window.clearInterval(node.timerInterval);
		if (node.timerTimeout)
			window.clearTimeout(node.timerTimeout);


		function hidePopup(aStart)
		{
			if (node.timerInterval)
				window.clearInterval(node.timerInterval);

			var count = aStart;
			node.timerInterval = window.setInterval(
				function()
				{
					count -= step;
					node.setAttribute('style', 'max-height: '+Math.max(count, 0)+'px !important;');
					if (node.boxObject.height <= 0) {
						window.clearInterval(node.timerInterval);
						node.popupIsShown = false;
						node.timer = null;
						node.hidePopup();
					}
				},
				interval
			);
		}


		if (node.popupIsShown) {
			node.timerTimeout = window.setTimeout(hidePopup, timeout, node.boxObject.height);
			return;
		}


		node.popupIsShown = true;

		while (node.hasChildNodes())
			node.removeChild(node.lastChild);

		var msg = aMessage.split('\n');
		for (var i in msg)
		{
			node.appendChild(document.createElement('label'));
			node.lastChild.setAttribute('value', msg[i]);
		}

		var count = 0;
		var previousHeight = 0;
		node.setAttribute('style', 'max-height: 0 !important;');

		node.autoPosition = true;
		node.moveTo(x, y);
		node.showPopup(node.parentNode, x, y, 'popup', null, null);

		node.timerInterval = window.setInterval(
			function()
			{
				count += step;
				node.setAttribute('style', 'max-height: '+count+'px !important;');
				if (previousHeight == node.boxObject.height) {
					window.clearInterval(node.timerInterval);
					node.timerTimeout = window.setTimeout(hidePopup, timeout, node.boxObject.height);
				}
				else
					previousHeight = node.boxObject.height;
			},
			interval
		);
	},
 
	closeWindow : function(aWindow, aParentWindow) 
	{
		var win = aWindow || window;
		var nav = aParentWindow;

		if (
			this.isBrowserWindow &&
			!('__tabextensionsCloseWindow__Startup' in win) &&
			!('__tabextensionsCloseWindow__Shutdown' in win)
			) {
			win.__tabextensionsCloseWindow__Startup = win.Startup;
			win.Startup = function() {
				try {
					win.__tabextensionsCloseWindow__Startup();
				}
				catch(e) {
				}
			};
			win.__tabextensionsCloseWindow__Shutdown = win.Shutdown;
			win.Shutdown = function() {
				try {
					win.__tabextensionsCloseWindow__Shutdown();
				}
				catch(e) {
				}
			};
		}

		this.hideWindow(win);

		if (win.document.documentElement)
			win.document.documentElement.removeAttribute('persist'); // prevent to save the position
		win.moveTo(300000, 300000); // move to outside of the screen

		// In some environments, "window.close" crashs Mozilla.
		// We have to use setTimeout to avoid this problem if "window.close" makes a crash.
		if (!this.getPref('browser.tabs.extensions.window_auto_close_timeout')) {
			try {
				this.setPref('browser.tabs.extensions.window_auto_close_timeout', true);
				const pref = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefService);
				pref.savePrefFile(null);

				win.close();

				nav.TabbrowserService.shouldBeClosedWindowsCallbackFunc.push(function() {
					if (win.closed)
						TabbrowserService.setPref('browser.tabs.extensions.window_auto_close_timeout', false);
				});
				nav.setTimeout('TabbrowserService.closeWindowCallback();', 1500);
			}
			catch(e) {
				alert(e);
			}
		}

		if (!win.closed) {
			nav.TabbrowserService.shouldBeClosedWindows.push(win);
			nav.setTimeout('TabbrowserService.closeWindowCallback();', 100);
		}
	},
	closeWindowCallback : function()
	{
		while (this.shouldBeClosedWindows.length)
		{
			if (!this.shouldBeClosedWindows[0].closed)
				this.shouldBeClosedWindows[0].close();
			this.shouldBeClosedWindows.shift();
		}
		while (this.shouldBeClosedWindowsCallbackFunc.length)
		{
			this.shouldBeClosedWindowsCallbackFunc[0]();
			this.shouldBeClosedWindowsCallbackFunc.shift();
		}
	},
	shouldBeClosedWindows : [],
	shouldBeClosedWindowsCallbackFunc : [],
	hideWindow : function(aWindow)
	{
		var baseWin = (aWindow || window).QueryInterface(Components.interfaces.nsIInterfaceRequestor)
					.getInterface(Components.interfaces.nsIWebNavigation)
					.QueryInterface(Components.interfaces.nsIDocShell)
					.QueryInterface(Components.interfaces.nsIDocShellTreeItem)
					.treeOwner
					.QueryInterface(Components.interfaces.nsIBaseWindow);

		baseWin.visibility = false;
//		baseWin.enabled = false;
	},
	showWindow : function(aWindow)
	{
		var baseWin = (aWindow || window).QueryInterface(Components.interfaces.nsIInterfaceRequestor)
					.getInterface(Components.interfaces.nsIWebNavigation)
					.QueryInterface(Components.interfaces.nsIDocShell)
					.QueryInterface(Components.interfaces.nsIDocShellTreeItem)
					.treeOwner
					.QueryInterface(Components.interfaces.nsIBaseWindow);

		baseWin.visibility = true;
//		baseWin.enabled = true;
	},
 
	readFromURI : function(aURI) 
	{
		var uri;
		try {
			uri = aURI.QueryInterface(Components.interfaces.nsIURI);
		}
		catch(e) {
			uri = this.makeURIFromSpec(aURI);
		}

		try {
			var channel = this.IOService.newChannelFromURI(uri);
			var stream  = channel.open();

			var scriptableStream = Components.classes['@mozilla.org/scriptableinputstream;1'].createInstance(Components.interfaces.nsIScriptableInputStream);
			scriptableStream.init(stream);

			var fileContents = scriptableStream.read(scriptableStream.available());

			scriptableStream.close();
			stream.close();

			return fileContents;
		}
		catch(e) {
		}

		return null;
	},
	
	writeToURI : function(aContent, aURL) 
	{
		var file = this.getFileFromURL(aURL);
		if (file.exists()) file.remove(true);

		file.create(file.NORMAL_FILE_TYPE, 0666);

		var stream = Components.classes['@mozilla.org/network/file-output-stream;1'].createInstance(Components.interfaces.nsIFileOutputStream);
		stream.init(file, 2, 0x200, false); // open as "write only"

		stream.write(aContent, aContent.length);

		stream.close();
	},
   
	init : function(aIgnoreInitializedFlag) 
	{
		if (location.href == 'chrome://tabextensions/content/initializeDefaultPref.xul') {
			this.activated = true;
		}

		if (this.activated) return;
		this.activated = true;

		var i;


		var nullPointer;
		nullPointer = this.bookmarksData;
		nullPointer = this.iconData;
		nullPointer = this.JSWindowOpenExceptionsWhite;
		nullPointer = this.JSWindowOpenExceptionsBlack;
		delete nullPointer;

		this.onEventForModules('onBeforeInit');

		this.loadPrefs();

		// Catch up changing of prefs
		if (this.isBrowserWindow) {
			this.addPrefListener(gTSTabMenuPrefListener);
			this.addPrefListener(gTSPlatformNativeBehaviorPrefListener);
			this.addPrefListener(gTWindowModePrefListener);
			this.addPrefListener(gTSOpenTabForWindowOpenPrefListener);

			var w = this.browserWindows;
			for (i in w)
				if (w[i] != window && w[i].gTSDOMWindowOpenObserver) {
					window.gTSDOMWindowOpenObserver = w[i].gTSDOMWindowOpenObserver;
					break;
				}

			if (!window.gTSDOMWindowOpenObserver) {
				window.gTSDOMWindowOpenObserver = this.DOMWindowOpenObserver;
				this.ObserverService.addObserver(window.gTSDOMWindowOpenObserver, 'domwindowopened', false);
			}
		}
		if (this.browser) {
			window.addEventListener('focus', this.onWindowFocus, true);
			window.addEventListener('blur', this.onWindowBlur, true);

			this.addPrefListener(gTSTabbarBlankSpacePrefListener);
			this.addPrefListener(gTSCloseBoxPrefListener);
			this.addPrefListener(gTSLastTabClosingPrefListener);
			this.addPrefListener(gTSTabsAutoHidePrefListener);
			this.addPrefListener(gTSIconOverlayInTabsPrefListener);
			this.addPrefListener(gTSTabbarPlacePrefListener);
			this.addPrefListener(gTSGroupModePrefListener);
			this.addPrefListener(gTSTabsWidthPrefListener);
			this.addPrefListener(gTSTabScrollerPrefListener);
			this.addPrefListener(gTSAnotherBindingPrefListener);

			window.addEventListener('resize', this.onWindowResize, false);
		}

		this.updateTabBrowser();

		if (this.isBrowserWindow) {
			gTSTabMenuPrefListener.observe(null, 'nsPref:changed', null);
			gTSPlatformNativeBehaviorPrefListener.observe(null, 'nsPref:changed', null);
			gTWindowModePrefListener.observe(null, 'nsPref:changed', null);
		}
		if (this.browser) {
			gTSTabbarPlacePrefListener.update();
//			gTSTabbarPlacePrefListener.observe(null, 'nsPref:changed', null);
			gTSIconOverlayInTabsPrefListener.observe(null, 'nsPref:changed', null);
			gTSTabbarBlankSpacePrefListener.observe(null, 'nsPref:changed', null);
			gTSCloseBoxPrefListener.observe(null, 'nsPref:changed', 'browser.tabs.extensions.show_closebox.tab');
			gTSCloseBoxPrefListener.observe(null, 'nsPref:changed', 'browser.tabs.extensions.show_closebox.tabbar');
			gTSLastTabClosingPrefListener.observe(null, 'nsPref:changed', null);
			gTSTabsWidthPrefListener.observe(null, 'nsPref:changed', null);
			gTSTabScrollerPrefListener.observe(null, 'nsPref:changed', null);
			gTSAnotherBindingPrefListener.observe(null, 'nsPref:changed', null);

			var defaultFeaturePrefs = [
					'locked',
					'referrerBlocked',
					'allowPlugins',
					'allowJavascript',
					'allowMetaRedirects',
					'allowSubframes',
					'allowImages'
				];
			var j;
			var t = this.browser.mTabs;
			for (i in t)
				for (j in defaultFeaturePrefs)
					t[i][defaultFeaturePrefs[j]] = this.getPref('browser.tabs.extensions.'+defaultFeaturePrefs[j]+'.enabled');
		}


		if (!this.isNewTypeBrowser) {
			window.addEventListener('close', this.onWindowClose, false);
		}

		var isDefaultStartup = this.isDefaultStartup(window);

		// NIvVœnꂽURIJEBhEǂ
		this.startWithOpenURLRequest = (
			('arguments' in window) &&
			window.arguments.length &&
			window.arguments[0] &&
			!isDefaultStartup
		);

		this.onEventForModules('onAfterInit');

		window.setTimeout('TabbrowserService.initWithDelay('+isDefaultStartup+');', 1); // Lately Mozilla gets the startup URI as the first argument.

	},
	isDefaultStartup : function(aWindow)
	{
		var isDefaultStartup = false;
		try {
			var browserRegion,
				defaultPage = this.getPref('browser.startup.homepage');
			if (!defaultPage ||
				defaultPage.match(/(chrome|resource):.*\.properties/)) {
				try {
					const STRBUNDLE = Components.classes['@mozilla.org/intl/stringbundle;1'].getService(Components.interfaces.nsIStringBundleService);
					browserRegion = STRBUNDLE.createBundle(defaultPage);

					defaultPage = '';
					try {
						defaultPage = browserRegion.GetStringFromName('browser.startup.homepage');
					}
					catch(e) {
					}
					if (!defaultPage) {
						try {
							defaultPage = browserRegion.GetStringFromName('homePageDefault');
						}
						catch(e) {
						}
					}
				}
				catch(ex) {
				}
			}
			const prefValue = (this.browserWindows.length == 1 || this.getPref('browser.windows.loadOnNewWindow') === null ?
						this.getPref('browser.startup.page') :
						this.getPref('browser.windows.loadOnNewWindow') );
			const startupPage = (prefValue == 2) ? this.BrowserHistory.lastPageVisited :
						(prefValue == 0) ? 'about:blank' :
						defaultPage ;

			isDefaultStartup = ('arguments' in aWindow && aWindow.arguments.length) ?
						((aWindow.arguments[0] || 'about:blank') == startupPage) :
						true ;
		}
		catch(e) {
//			alert(e);
		}
/*
dump([
	'prefValue                 : '+prefValue,
	'defaultPage               : '+defaultPage,
	'startupPage               : '+startupPage,
	'window.arguments[0]       : '+aWindow.arguments[0],
	'isDefaultStartup          : '+isDefaultStartup,
	'-------------------------------------------------------',
	'gHomeButton.getHomePage() : '+gHomeButton.getHomePage(),
	'browser.startup.homepage  : '+this.getPref('browser.startup.homepage')
	].join('\n'));
*/

		return isDefaultStartup;
	},
	
	// fBC̏ 
	initWithDelay : function(aArgumentIsDefaultStartup)
	{
		// reset tab index (we have to do it for Mac OS X)
		var b = this.browsers;
		if (b.length) {
			var rearrangable = this.getPref('browser.tabs.extensions.tab_scroller') != 3;
			function resetTabIndex(aTabBrowser, aResetOrder)
			{
				var tabs = aTabBrowser.mTabs;
				for (var i = 0; i < tabs.length; i++)
				{
					tabs[i].tabIndex = i;
					if (aResetOrder)
						tabs[i].ordinal = tabs[i].tabIndex;
				}
			}
			for (var i = 0; i < b.length; i++)
				resetTabIndex(b[i], rearrangable);
		}


		this.onEventForModules('onBeforeInitWithDelay', { argumentIsDefaultStartup : aArgumentIsDefaultStartup });


//alert('TBE: start to initialize (2nd step)');
		var info = this.loadBookmarkStatus('about:blank', {});


		this.convertOldData();

		// clear garbages
		if (this.getPref('browser.tabs.extensions.auto_cleanUp')) {
			var count = this.getPref('browser.tabs.extensions.auto_cleanUp_count');
			if (count > 9) {
				if ('cleanUp' in this.bookmarksData)
					this.bookmarksData.cleanUp(true);
				else
					this.cleanUpData();

				this.setPref('browser.tabs.extensions.auto_cleanUp_count', 0);
			}
			else {
				this.setPref('browser.tabs.extensions.auto_cleanUp_count', count+1);
			}
		}


		// reset labels
		gTSTabsWidthPrefListener.observe(null, 'nsPref:changed', null);

		// reset icons
		var icons = this.iconData,
			uri,
			icon;
		for (i = 0; i < icons.length; i++)
			try {
				this.BookmarksDS.updateBookmarkIcon(this.unescapeString(icons.item(i).Value.match(/[^:]+$/)), icons.getData(icons.item(i), 'IconURI'));
			}
			catch(e) {
			}

		// sometimes, menuitems in "chevron" are shown as personal toolbar buttons, like "buttons are doubled".
		// this rebuilding is a fix for this problem.
		if (document.getElementById('bookmarks-chevron'))
			document.getElementById('bookmarks-chevron').builder.rebuild();
		if (document.getElementById('bookmarks-ptf'))
			document.getElementById('bookmarks-ptf').builder.rebuild();
//alert('TBE: completely initialized');

		this.onEventForModules('onAfterInitWithDelay', { argumentIsDefaultStartup : aArgumentIsDefaultStartup });
	},
	
	// convert data for the old bookmark implementation to the new one 
	convertOldData : function()
	{
		if (!this.isNewTypeBookmarks && !this.bookmarksData.length)
			return;

		var bookmarks = this.bookmarksData,
			icons     = this.iconData,
			props     = [
				'UseFixedLabel',
				'Locked',
				'ReferrerBlocked',
				'AutoReload',
				'AutoReloadInterval',
				'ForbidPlugins',
				'ForbidJavascript',
				'ForbidMetaRedirects',
				'ForbidSubframes',
				'ForbidImages',
				'ReferrerURI'
			],
			item,
			res,
			value,
			info,
			i, j, k;

		for (i = bookmarks.length-1; i > -1; i--)
		{
			item = bookmarks.item(i);
			if (!item) continue;

			if (item.Value.match(/^rdf:/)) {
				info = {};
				for (j in props)
					if ((value = bookmarks.getData(item, props[j])))
						info[props[j]] = value;

				this.saveBookmarkStatusInternal(item.Value, info);
			}
			else {
				if ((value = bookmarks.getData(item, 'IconURI')))
					icons.setData(item.Value.split('#')[0].split('?')[0].replace(/[^\/]+$/, '').replace(/\/$/, '')+'/', 'IconURI', value);

				res = this.getBookmarkResourcesFromURI(item.Value);
				for (j in res) {
					info = {};
					for (k in props)
						if (value = bookmarks.getData(item, props[k]))
							info[props[k]] = value;

					this.saveBookmarkStatusInternal(res[j].Value, info);
				}
			}

			bookmarks.removeData(item);
			bookmarks.removeResource(item);
		}
	},
 
	// clear all of garbages in the datasource 
	cleanUpData : function()
	{
		var resources = this.datasource.GetAllResources();
		var resource;
		var names, name, value;
		while (resources.hasMoreElements())
		{
			try {
				resource = resources.getNext().QueryInterface(this.knsIRDFResource);

				if (resource.Value.match(/:root$/) ||
					this.datasource.ArcLabelsIn(resource).hasMoreElements())
					continue;

				names = this.datasource.ArcLabelsOut(resource);
				while (names.hasMoreElements())
				{
					try {
						name = names.getNext().QueryInterface(this.knsIRDFResource);
						value = dsource.GetTarget(resource, name, true);
						this.datasource.Unassert(resource, name, value);
					}
					catch(ex) {
					}
				}
			}
			catch(e) {
			}
		}
		this.datasource.Flush();
	},
  
	// tabbrowser̍XV 
	updateTabBrowser : function()
	{
		var b = this.browsers;
		var updateCurrentBrowser;
		for (var i = 0; i < b.length; i++)
		{
			// failsafe
			if (b[i].mPanelContainer.selectedIndex !== 0 &&
				b[i].mTabListeners.length) // this "failsafe" section causes a fatal error in the latest nightly build so I skip it. (2004.1.21)
				b[i].mPanelContainer.selectedIndex = 0;

			this.updateMethods(b[i]);
			this.updateContextMenu(b[i]); // Add new menuitems
			this.supportMovableTabs(b[i]);
			this.updateTabContainer(b[i]);

			// for Firefox
			// Firefox fails to execute "constructor" of tabs. why?
			b[i].mTabContainer.selectedIndex = 0;
			b[i].mTabs[0].setAttribute('first-tab', 'true');
			b[i].mTabs[b[i].mTabs.length-1].setAttribute('last-tab', 'true');
			b[i].mIdentifiedTabs[b[i].selectedTab.tabId] = b[i].selectedTab;
			b[i].selectedTab.__tabextensions__lastFocusedTime = (new Date()).getTime();

			b[i].mTabProgressListenerCreatorInternal.addListenerTo(b[i].selectedTab);

			b[i].startHookingContentAreaEvents();

			b[i].addEventListener('DOMWindowClose', b[i].onWindowCloseInLastTabEventListener, true);

			// reset tabbrowserReadyState
			b[i].addEventListener('close', this.onTabbrowserWindowClose, true);
			// failsafe
			b[i].addEventListener('unload', this.onTabbrowserWindowUnload, true);

			b[i].addEventListener('XULTabbrowserTabLoading', this.onXULTabbrowserTabLoading, false);
			b[i].addEventListener('XULTabbrowserTabLoad', this.onXULTabbrowserTabLoad, false);
			b[i].addEventListener('XULTabbrowserTabAdded', this.onXULTabbrowserTabAdded, false);
			b[i].addEventListener('XULTabbrowserTabRemoved', this.onXULTabbrowserTabRemoved, false);
			b[i].addEventListener('XULTabbrowserTabMoved', this.onXULTabbrowserTabMoved, false);
//			b[i].addEventListener('XULTabbrowserTabGroupModified', this.onXULTabbrowserTabGroupModified, false);
			b[i].addEventListener('XULTabbrowserTabStatusChange', this.onXULTabbrowserTabStatusChange, false);
			b[i].addEventListener('XULTabbrowserTabDrop', this.onXULTabbrowserTabDrop, false);
			b[i].addEventListener('XULTabbrowserURIDrop', this.onXULTabbrowserURIDrop, false);
			// open tabs in other windows if "addTab" is canceled
			b[i].addEventListener('XULTabbrowserAddTabCanceled', this.onXULTabbrowserAddTabCanceled, false);


			// To fix the problem "window is always focued even if I prevent window-focus by a pref in the 'Focus' pref panel"
			updateCurrentBrowser = String(b[i].updateCurrentBrowser);
			if (updateCurrentBrowser.match(/window._content.focus\(\)/)) {
				eval('b[i].updateCurrentBrowser = '+updateCurrentBrowser.replace(/window._content.focus\(\)/g, 'gBrowser.setFocusInternal(_content);').replace(/^[^\(]*/, 'function'));
			}
			else if (updateCurrentBrowser.match(/setFocus\(element\)/)) {
				eval('b[i].updateCurrentBrowser = '+updateCurrentBrowser.replace(/Components.lookupMethod\(element, "focus"\).call\(element\);/g, 'tabBrowser.setFocusInternal(element);').replace(/^[^\(]*/, 'function').replace(/function setFocus/, 'var tabBrowser = this; function setFocus'));
			}
		}
	},
	
	// \bh̏㏑ 
	updateMethods : function(aTabBrowser)
	{
		aTabBrowser.__tabextensions__updatePopupMenu = aTabBrowser.updatePopupMenu;
		aTabBrowser.updatePopupMenu = this.updatePopupMenu;
		aTabBrowser.__tabextensions__addTab = aTabBrowser.addTab;
		aTabBrowser.addTab = this.addTab;
		aTabBrowser.__tabextensions__removeTab = aTabBrowser.removeTab;
		aTabBrowser.removeTab = this.removeTab;

		aTabBrowser.replaceGroup = this.replaceGroup;

		aTabBrowser.getBrowserForTab = this.getBrowserForTab;
		aTabBrowser.onTabClick       = this.onTabClick;

		aTabBrowser.__tabextensions__buildFavIconString = aTabBrowser.buildFavIconString;
		aTabBrowser.buildFavIconString = this.buildFavIconString;
		aTabBrowser.__tabextensions__loadFavIcon = aTabBrowser.loadFavIcon;
		aTabBrowser.loadFavIcon = this.loadFavIcon;
		aTabBrowser.__tabextensions__setTabTitle = aTabBrowser.setTabTitle;
		aTabBrowser.setTabTitle = this.setTabTitle;

		var popups = aTabBrowser.mStrip.getElementsByAttribute('onpopupshowing', '*');
		for (var i = 0; i < popups.length; i++)
			if (popups[i].localName == 'menupopup') {
				popups[i].setAttribute('onpopupshowing', 'this.parentNode.parentNode.parentNode.updatePopupMenu(this, event);');
				popups[i].mTabBrowser = aTabBrowser;
			}

		aTabBrowser.bookmarksManager = {
			isBookmarked : function(aURI)
			{
				return TabbrowserService.isBookmarked(aURI);
			},
			getName : function(aID)
			{
				return TabbrowserService.getNameForBookmark(aID);
			},
			setName : function(aNewName, aID)
			{
				TabbrowserService.setNameForBookmark(aNewName, aID);
			},
			getIcon : function(aURI, aOnlyUserDefined)
			{
				return TabbrowserService.getIconForBookmark(aURI, aOnlyUserDefined);
			},
			setIcon : function(aURI, aIconURI)
			{
				TabbrowserService.setIconForBookmark(aURI, aIconURI);
			},
			edit : function(aID)
			{
				if (!aID || !this.isBookmarked(aID)) return;

				if (TabbrowserService.isNewTypeBrowser) // Firefox
					window.openDialog('chrome://browser/content/bookmarks/bookmarksProperties.xul', '', 'centerscreen,chrome,resizable=no', aID, {});
				else
					window.openDialog('chrome://communicator/content/bookmarks/bm-props.xul', '', 'centerscreen,chrome,dialog=no,resizable=no,dependent', aID, {});
			},
			bookmarkTabGroup : function(aTab, aShouldBookmarkAllTabs)
			{
				TabbrowserService.bookmarkTabGroup(aTab, aShouldBookmarkAllTabs);
			}
		};
	},
 
	// j[ڂ̒ǉ 
	updateContextMenu : function(aTabBrowser)
	{
	try {
		var i;
		var mpopup = aTabBrowser.mTabContainer.previousSibling;


		/*
			1: name menuitems
			2: create "removeOther" item if it doesn't exist
			3: name menuseparators
			4: insert/append extra items and separators
		*/


		// 1: name menuitems
		var ds;
		try {
			ds = this.RDF.GetDataSourceBlocking('chrome://tabextensions/content/tabsContextMenuItems.rdf');
		}
		catch(ex) {
			ds = this.RDF.GetDataSource('chrome://tabextensions/content/tabsContextMenuItems.rdf');
		}
		if (!ds.GetAllResources().hasMoreElements()) {
			dump('ERROR: tabextensions fails to initialize tab\'s context menu.\n');
			return;
		}

		var label,
			res,
			id,
			namedItems = [];
		for (i = 0; i < mpopup.childNodes.length; i++)
		{
			label = mpopup.childNodes[i].getAttribute('label');
			if (!label) continue;

			res = ds.GetSource(
					this.RDF.GetResource('http://white.sakura.ne.jp/~piro/rdf#Label'),
					this.RDF.GetLiteral(label),
					true
				);
			if (!res) continue;

			id = ds.GetTarget(
					res,
					this.RDF.GetResource('http://white.sakura.ne.jp/~piro/rdf#Id'),
					true
				);
			if (!id) continue;

			id = id.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;

			mpopup.childNodes[i].setAttribute('tabid', 'tab-item-'+id);
			namedItems[id] = mpopup.childNodes[i];
		}

		// 2: create "removeOther" and "bookmarkGroup" item
		if (!('removeOther' in namedItems)) {
			this.insertNewItemBefore(mpopup, 'menuseparator', null, null, ['tabid', 'tab-sep-remove']);
			this.insertNewItemBefore(
				mpopup, 'menuitem',
				'label_removeOther', null,
				[
					'oncommand', 'var b = this.parentNode.mTabBrowser; b.removeAllTabsButInternal(b.mContextTab);',
					'tabid', 'tab-item-removeOther',
					'tbattr', 'tabbrowser-multiple'
				]
			);
		}
		var bookmarkGroup;
		if (!('bookmarkGroup' in namedItems)) {
			bookmarkGroup = this.insertNewItemBefore(
				mpopup, 'menuitem',
				'label_bookmarkGroup', null,
				[
					'oncommand', 'var b = this.parentNode.mTabBrowser; b.bookmarksManager.bookmarkTabGroup(b.mContextTab, !b.tabGroupsAvailable);',
					'tabid',     'tab-item-bookmarkGroup',
					'tbattr',    'tabbrowser-multiple',
					'accesskey', this.strbundle.GetStringFromName('label_bookmarkGroup_accesskey')
				]
			);
			this.insertNewItemBefore(mpopup, 'menuseparator', null, bookmarkGroup, ['tabid', 'tab-sep-bookmarkGroup']);
		}

		// 3: name menuseparators
		var separators = [
				'removeOther',   'remove',
				'newTab',        'new',
				'bookmarkGroup', 'bookmarkGroup',
				'removeTab',     'removeOneTab',
				'reloadAll',     'reload' // for old context menu
			];
		for (i = 0; i < separators.length; i += 2)
		{
			if (
				!(separators[i] in namedItems) ||
				!namedItems[separators[i]] ||
				!('nextSibling' in namedItems[separators[i]]) ||
				!namedItems[separators[i]].nextSibling ||
				namedItems[separators[i]].nextSibling.localName != 'menuseparator'
				)
				continue;

			namedItems[separators[i]].nextSibling.setAttribute('tabid', 'tab-sep-'+separators[i+1]);
		}

		if (namedItems['removeTab'].nextSibling) {
			// In old versions, Mozilla Firebird doesn't have "Close Other Tabs", so the item is generated and put after the "Close Tab".
			if (namedItems['removeTab'].nextSibling.getAttribute('tabid') == 'tab-item-removeOther')
				this.insertNewItemBefore(mpopup, 'menuseparator', null, namedItems['removeOther'], ['tabid', 'tab-sep-removeOneTab']);
		}
		else if (namedItems['removeOther'].nextSibling.getAttribute('tabid') == 'tab-sep-remove') { // for new context menu of Mozilla Firebird/Firefox (later 2003/8/8)
			// In this version, "Close Other Tabs" is previous to the "Close Tab" (a separator is in between them), and, "Close Other Tabs" is just next to the "Reload All".
			namedItems['removeOther'].nextSibling.setAttribute('tabid', 'tab-sep-removeOneTab');
			this.insertNewItemBefore(mpopup, 'menuseparator', null, namedItems['removeOther'], ['tabid', 'tab-sep-remove']);
		}



		// 4: insert/append extra items and separators

		var ref = mpopup.getElementsByAttribute('tabid', 'tab-sep-reload').length ? mpopup.getElementsByAttribute('tabid', 'tab-item-removeTab')[0] :
				bookmarkGroup ? bookmarkGroup.previousSibling :
				null ;
		if (!ref) {
			this.insertNewItemBefore(mpopup, 'menuseparator', null, null, ['tabid', 'tab-sep-reload']);
		}

		// ^üړ
		// move tab to left/right
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_moveLeft', ref,
			[
				'label-for-horizontal-tabbar', this.strbundle.GetStringFromName('label_moveLeftHorizontal'),
				'label-for-vertical-tabbar', this.strbundle.GetStringFromName('label_moveLeftVertical'),
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.moveTabBy(b.mContextTab, -1);',
				'tabid', 'tab-item-moveLeft'
			]
		);
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_moveRight', ref,
			[
				'label-for-horizontal-tabbar', this.strbundle.GetStringFromName('label_moveRightHorizontal'),
				'label-for-vertical-tabbar', this.strbundle.GetStringFromName('label_moveRightVertical'),
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.moveTabBy(b.mContextTab, 1);',
				'tabid', 'tab-item-moveRight'
			]
		);

		this.insertNewItemBefore(mpopup, 'menuseparator', null, ref, ['tabid', 'tab-sep-move']);

		// ^u̕
		// duplicate tabs
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_duplicateTab', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.duplicateTab(b.mContextTab);',
				'tabid', 'tab-item-duplicateTab'
			]
		);
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_duplicateTabInWindow', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.duplicateTabInWindow(b.mContextTab);',
				'tabid', 'tab-item-duplicateInWindow'
			]
		);

		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_setFixedLabelFor', ref,
			[
				'oncommand', 'this.parentNode.hidePopup(); var b = this.parentNode.mTabBrowser; b.setFixedLabelFor(b.mContextTab);',
				'tabid', 'tab-item-setFixedLabelFor'
			]
		);

		// ^ǔŒ
		// lock tabs
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_toggleTabLocked', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.toggleTabLocked(b.mContextTab);',
				'type', 'checkbox',
				'tabid', 'tab-item-lockTab'
			]
		);

		// t@̃ubN
		// block referrer from tabs
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_toggleReferrerBlocked', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.toggleReferrerBlocked(b.mContextTab);',
				'type', 'checkbox',
				'tabid', 'tab-item-blockReferrer'
			]
		);

		// [h
		// auto-reload
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_toggleTabAutoReload', ref,
			[
				'oncommand', 'this.parentNode.hidePopup(); var b = this.parentNode.mTabBrowser; b.toggleTabAutoReload(b.mContextTab);',
				'type', 'checkbox',
				'tabid', 'tab-item-autoreload'
			]
		);


		// ̑̋@\
		var advanced = this.insertNewItemBefore(mpopup, 'menu', 'label_allow', ref, ['tabid', 'tab-item-allow']);
		this.insertNewItemBefore(advanced, 'menupopup');
		this.insertNewItemBefore(
			advanced.firstChild, 'menuitem',
			'label_allowPlugins', null,
			[
				'oncommand', 'var b = this.parentNode.parentNode.parentNode.mTabBrowser; b.toggleDocShellPropertyFor(b.mContextTab, \'allowPlugins\');',
				'type', 'checkbox',
				'tabid', 'tab-item-allowPlugins'
			]
		);
		this.insertNewItemBefore(
			advanced.firstChild, 'menuitem',
			'label_allowJavascript', null,
			[
				'oncommand', 'var b = this.parentNode.parentNode.parentNode.mTabBrowser; b.toggleDocShellPropertyFor(b.mContextTab, \'allowJavascript\');',
				'type', 'checkbox',
				'tabid', 'tab-item-allowJavascript'
			]
		);
		this.insertNewItemBefore(
			advanced.firstChild, 'menuitem',
			'label_allowMetaRedirects', null,
			[
				'oncommand', 'var b = this.parentNode.parentNode.parentNode.mTabBrowser; b.toggleDocShellPropertyFor(b.mContextTab, \'allowMetaRedirects\');',
				'type', 'checkbox',
				'tabid', 'tab-item-allowMetaRedirects'
			]
		);
		this.insertNewItemBefore(
			advanced.firstChild, 'menuitem',
			'label_allowSubframes', null,
			[
				'oncommand', 'var b = this.parentNode.parentNode.parentNode.mTabBrowser; b.toggleDocShellPropertyFor(b.mContextTab, \'allowSubframes\');',
				'type', 'checkbox',
				'tabid', 'tab-item-allowSubframes'
			]
		);
		this.insertNewItemBefore(
			advanced.firstChild, 'menuitem',
			'label_allowImages', null,
			[
				'oncommand', 'var b = this.parentNode.parentNode.parentNode.mTabBrowser; b.toggleDocShellPropertyFor(b.mContextTab, \'allowImages\');',
				'type', 'checkbox',
				'tabid', 'tab-item-allowImages'
			]
		);


		this.insertNewItemBefore(mpopup, 'menuseparator', null, ref, ['tabid', 'tab-sep-advanced']);


		// SẴ^uւ̑
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_toggleTabLockedAll', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.toggleAllTabsLocked();',
				'type', 'checkbox',
				'tabid', 'tab-item-lockTabAll'
			]
		);
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_toggleReferrerBlockedAll', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.toggleReferrerBlockedForAllTabs();',
				'type', 'checkbox',
				'tabid', 'tab-item-blockReferrerAll'
			]
		);
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_toggleTabAutoReloadAll', ref,
			[
				'oncommand', 'this.parentNode.hidePopup(); var b = this.parentNode.mTabBrowser; b.toggleAllTabsAutoReload();',
				'type', 'checkbox',
				'tabid', 'tab-item-autoreloadAll'
			]
		);
		this.insertNewItemBefore(mpopup, 'menuseparator', null, ref, ['tabid', 'tab-sep-forAll']);


		// O[v
		// close group of tabs
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_removeTabGroup', mpopup.getElementsByAttribute('tabid', 'tab-item-removeTab')[0].nextSibling,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.removeTabGroup(b.mContextTab);',
				'tbattr', 'tabbrowser-group',
				'tabid', 'tab-item-removeTabGroup'
			]
		);

//		ref = mpopup.lastChild;
		ref = mpopup.getElementsByAttribute('tabid', 'tab-item-removeOther')[0];

		// /E
		// close left/right tabs
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_removeLeft', ref,
			[
				'label-for-horizontal-tabbar', this.strbundle.GetStringFromName('label_removeLeftHorizontal'),
				'label-for-vertical-tabbar', this.strbundle.GetStringFromName('label_removeLeftVertical'),
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.removeLeftTabsFrom(b.mContextTab);',
				'tabid', 'tab-item-removeLeft'
			]
		);
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_removeRight', ref,
			[
				'label-for-horizontal-tabbar', this.strbundle.GetStringFromName('label_removeRightHorizontal'),
				'label-for-vertical-tabbar', this.strbundle.GetStringFromName('label_removeRightVertical'),
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.removeRightTabsFrom(b.mContextTab);',
				'tabid', 'tab-item-removeRight'
			]
		);

		this.insertNewItemBefore(mpopup, 'menuseparator', null, ref, ['tabid', 'tab-sep-removeLR']);

		// close all tabs
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_removeAll', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.removeAllTabs();',
//				'tbattr', 'tabbrowser-multiple',
				'tabid', 'tab-item-removeAll'
			]
		);
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_removeVisited', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.removeVisitedTabs();',
				'tbattr', 'tabbrowser-multiple',
				'tabid', 'tab-item-removeVisited'
			]
		);

		this.insertNewItemBefore(mpopup, 'menuseparator', null, ref, ['tabid', 'tab-sep-removeAll']);


		ref = ref.nextSibling; // ReLXgj[łnull

		this.insertNewItemBefore(mpopup, 'menuseparator', null, ref, ['tabid', 'tab-sep-undo']);

		// u^uv蒼
		// undo close tab
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_undoRemoveTab', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.undoRemoveTab();',
				'tabid', 'tab-item-undoRemoveTab'
			]
		);


		this.insertNewItemBefore(mpopup, 'menuseparator', null, null, ['tabid', 'tab-sep-group']);

		// ^uׂ̕
		// sort tabs
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_sortTabsByGroup', null,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.sortTabsByGroup();',
				'tabid', 'tab-item-sortTabsByGroup',
				'tbattr', 'tabbrowser-group'
			]
		);

		// O[ṽnCCg\
		// highlight group of tabs
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_highlightGroup', null,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.highlightGroupFromTab(b.mContextTab);',
				'tabid', 'tab-item-highlightGroup',
				'tbattr', 'tabbrowser-group'
			]
		);

		// O[v̐Fݒ
		// set group color
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_setTabColorFor', null,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.setTabColorFor(b.mContextTab);',
				'tabid', 'tab-item-setTabColorFor'
			]
		);


		// ubN}[N̕ҏW
		// edit bookmark from tab
		var editRef = bookmarkGroup && bookmarkGroup.nextSibling ? bookmarkGroup.nextSibling : null ;
		this.insertNewItemBefore(mpopup, 'menuseparator', null, editRef, ['tabid', 'tab-sep-bookmark']);
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_editBookmark', editRef,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.editBookmarkFromTab(b.mContextTab);',
				'tabid', 'tab-item-editBookmark'
			]
		);


		this.insertNewItemBefore(mpopup, 'menuseparator', null, null, ['tabid', 'tab-sep-editmenu']);
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_editMenu', null,
			[
				'oncommand', 'this.parentNode.hidePopup(); window.openDialog(\'chrome://tabextensions/content/contextMenuEdit.xul\', \'\', \'chrome,modal,resizable=no\');',
				'tabid', 'tab-item-editMenu'
			]
		);
	}
	catch(ex){
		alert(ex);
	}
	},
	
	// ڂ̒ǉ 
	insertNewItemBefore : function(aMPopup, aLocalName, aLabelID, aRefNode, aAttrArray)
	{
		var newItem = document.createElementNS(this.XULNS, aLocalName);
		if (aRefNode)
			aMPopup.insertBefore(newItem, aRefNode)
		else
			aMPopup.appendChild(newItem);

		if (aLabelID)
			newItem.setAttribute('label', this.strbundle.GetStringFromName(aLabelID));
		if (aAttrArray)
			for (var i = 0; i < aAttrArray.length; i += 2)
				newItem.setAttribute(aAttrArray[i], aAttrArray[i+1]);

		return newItem;
	},
  
	// ^üړ 
	supportMovableTabs : function(aTabBrowser)
	{
		// initialize the order of tabs, "new tab" and "close tab" button.
		/* Content of tabs:
			Mozilla 1.1+
				<xul:stack/>
				<xul:hbox flex="1" style="min-width: 1px;">
					<children/> (<xul:tab/>)
					<xul:spacer class="tabs-right" flex="1"/>
				</xul:hbox>
				<xul:stack/>
			Netscape 7.0
				<xul:stack/>
				<children/>
				<xul:stack flex="1"/>
			Mozilla 1.0
				<xul:spacer class="tabs-left"/>
				<children/>
				<xul:stack flex="1"/>
			Phoenix/Firebird/Firefox
				<xul:hbox flex="1" style="min-width: 1px;">
					<children/> (<xul:tab/>)
					<xul:spacer class="tabs-right" flex="1"/>
				</xul:hbox>
				<xul:stack/>

			Mozilla on Mac OS X
				defined in:
				- http://lxr.mozilla.org/mozilla/source/themes/classic/global/mac/globalBindings.xml (Mozilla Suite)
				- http://lxr.mozilla.org/mozilla/source/toolkit/skin/mac/globalBindings.xml (Firefox, old)
				- http://lxr.mozilla.org/mozilla/source/toolkit/themes/pinstripe/global/globalBindings.xml (Firefox)
		*/
try{
		var closeBox = document.getAnonymousElementByAttribute(aTabBrowser.mTabContainer, 'class', 'tabs-closebutton-box');
		var prev;
		while (true)
		{
			anonyElem = document.getAnonymousNodes(closeBox.parentNode);
			if (!anonyElem)
				anonyElem = closeBox.parentNode.childNodes;

			for (i = anonyElem.length-1; i > -1 ; i--)
				if (i != 0 && anonyElem[i] == closeBox) {
					prev = anonyElem[i-1];
					break;
				}
			if (!prev || prev.localName == 'spacer') {
				closeBox = closeBox.parentNode;
				if (closeBox.parentNode == aTabBrowser.mStrip) break;
			}
			else
				break;
		}
		aTabBrowser.mTabContainerInnerBox = prev;
		if (aTabBrowser.mTabContainerInnerBox.localName == 'tab') { // for Mozilla 1.0.x
			aTabBrowser.mTabContainerInnerBox = aTabBrowser.mTabContainer;
			closeBox.setAttribute('buttonpack', 'end');
		}

		var tabContents = aTabBrowser.mTabContainerInnerBox.childNodes;
		var isAfter = false;
		for (i = 0; i < tabContents.length; i++)
		{
			if (tabContents[i].localName == 'tab') {
				isAfter = true;
				continue;
			}

			if (isAfter)
				tabContents[i].setAttribute('tabs-scrollbox-spacer', 'after');
			else
				tabContents[i].setAttribute('tabs-scrollbox-spacer', 'before');
		}
		var tabsRight = document.getAnonymousElementByAttribute(aTabBrowser.mTabContainer, 'class', 'tabs-right');
		if (tabsRight)
			tabsRight.setAttribute('tabs-scrollbox-spacer', 'after');

		aTabBrowser.mTabContainerInnerBox.setAttribute('tabs-scrollbox', true);
		closeBox.setAttribute('tabs-scrollbox-right', true);
}
catch(e) {
	alert('Launching Error:\nTabbrowser Extensions failed to find out mTabContainerInnerBox.\n\n'+e);
//	window.close();
}

		// for Firefox
		// hbvʒu}[J[̏
		// initialize the marker for indicating dropped position of tabs
		if (!aTabBrowser.mMarker &&
			aTabBrowser.mTabContainerInnerBox != aTabBrowser.mTabContainer) {
			document.addBinding(aTabBrowser.mTabContainerInnerBox, 'chrome://tabextensions/content/tabextensions.xml#dummy'); // first binding is ignored...why? This is a dummy to avoid this problem.
			window.setTimeout(
				function(aTabBrowser)
				{
					document.addBinding(aTabBrowser.mTabContainerInnerBox, 'chrome://tabextensions/content/tabextensions.xml#tabs-extra');
				},
				0,
				aTabBrowser
			);
		}


		var container    = aTabBrowser.mTabContainer;
		var tabs         = container.childNodes;
//		var rearrangable = this.getPref('browser.tabs.extensions.tab_scroller') != 3;
		for (var i = 0; i < tabs.length; i++)
		{
			if (tabs[i].localName != 'tab') continue;

			aTabBrowser.mTabs.push(tabs[i]);
			tabs[i].tabIndex = aTabBrowser.mTabs.length-1;
//			if (rearrangable)
				tabs[i].ordinal = tabs[i].tabIndex;
		}
		// add properties and methods without XBL
		container.mTabBrowser        = aTabBrowser;
		container.advanceSelectedTab = this.advanceSelectedTab;


		// Add methods
		aTabBrowser.getDropPosition = this.getTabDropPosition;

		container.setAttribute('ondraggesture', 'nsDragAndDrop.startDrag(event, this.parentNode.parentNode.parentNode); event.stopPropagation();');
		aTabBrowser.onDragStart = this.onTabDragStart;

		container.setAttribute('ondragexit', 'nsDragAndDrop.dragExit(event, this.parentNode.parentNode.parentNode); event.stopPropagation();');
		aTabBrowser.onDragExit = this.onTabDragExit;

		aTabBrowser.__tabextensions__onDrop = aTabBrowser.onDrop;
		aTabBrowser.onDrop = this.onTabDrop;

		aTabBrowser.__tabextensions__onDragOver = aTabBrowser.onDragOver;
		aTabBrowser.onDragOver = this.onTabDragOver;

		aTabBrowser.__tabextensions__getSupportedFlavours = aTabBrowser.getSupportedFlavours;
		aTabBrowser.getSupportedFlavours = this.getTabsSupportedFlavours;
	},
 
	// tabs̃Abvf[g 
	updateTabContainer : function(aTabBrowser)
	{
		if (!('mTabBrowser' in aTabBrowser.mTabContainer.mTabBrowser) ||
			!aTabBrowser.mTabContainer.mTabBrowser)
			aTabBrowser.mTabContainer.mTabBrowser = aTabBrowser;

		// Behavior of tabs with middle-click or double click
		aTabBrowser.onTabClick = this.onTabClick;
		aTabBrowser.mTabContainer.setAttribute('onclick', 'this.parentNode.parentNode.parentNode.onTabClick(event);');
		aTabBrowser.mTabContainer.setAttribute('ondblclick', 'this.parentNode.parentNode.parentNode.onTabClick(event);');

		// when there is no tab bar and the current is blank (after close all of tabs), actions on content area are regarded as onthe tab bar.
		aTabBrowser.addEventListener('click', this.emulateTabbarClick, true);
		aTabBrowser.addEventListener('dblclick', this.emulateTabbarClick, true);
	},
	emulateTabbarClick : function(aEvent)
	{
		if (aEvent.originalTarget.ownerDocument == aEvent.target.ownerDocument ||
			!aEvent.target.isBlank)
			return;

		aEvent.target.onTabClick(aEvent);

/*
		aEvent.stopPropagation();
		aEvent.preventCapture();
		aEvent.preventBubble();
		aEvent.preventDefault();
*/
	},
  
	// ƎCxg̕ߑ 
	
	onTabbrowserWindowClose : function(aEvent) 
	{
		var t = aEvent.originalTarget || aEvent.target;
		if (t) {
			var doc = t.ownerDocument || t;
			doc.tabbrowserReadyState = 'loading';
		}
	},
	
	onTabbrowserWindowUnload : function(aEvent) 
	{
		var t = aEvent.originalTarget || aEvent.target;
		if (t) {
			var doc = t.ownerDocument || t;
			doc.tabbrowserReadyState = 'loading';
		}
	},
  
	onXULTabbrowserTabLoading : function(aEvent) 
	{
		TabbrowserService.onTabLoading(aEvent.target.getTabByTabId(aEvent.tabId), aEvent.loadingView, !aEvent.followFrames);
	},
 
	onXULTabbrowserTabLoad : function(aEvent) 
	{
		var tab = aEvent.target.getTabByTabId(aEvent.tabId);
		TabbrowserService.onTabLoadFinish(aEvent.loadedView, tab);
		if ('TabbrowserSessionManager' in window)
			TabbrowserSessionManager.onTabLoad(tab.tabIndex);

		if (TabbrowserService.getPref('browser.tabs.extensions.tabs_width_type') == 1)
			TabbrowserService.browser.onTabsModified();
	},
 
	onXULTabbrowserTabAdded : function(aEvent) 
	{
		if ('TabbrowserSessionManager' in window)
			TabbrowserSessionManager.onTabLoad(aEvent.target.getTabByTabId(aEvent.tabId).tabIndex);
	},
 
	onXULTabbrowserTabRemoved : function(aEvent) 
	{
		if ('TabbrowserSessionManager' in window)
			TabbrowserSessionManager.onTabRemoved(aEvent.tabId);
	},
 
	onXULTabbrowserTabMoved : function(aEvent) 
	{
		if ('TabbrowserSessionManager' in window)
			TabbrowserSessionManager.onTabMoved(aEvent.tabId, aEvent.target.getTabByTabId(aEvent.tabId).tabIndex);
	},
 
	onXULTabbrowserTabGroupModified : function(aEvent) 
	{
		if ('TabbrowserSessionManager' in window)
			TabbrowserSessionManager.onTabLoad(aEvent.target.getTabByTabId(aEvent.tabId).tabIndex);
	},
 
	onXULTabbrowserTabStatusChange : function(aEvent) 
	{
		if (
			aEvent.targetURI != 'ANY' &&
			(
				TabbrowserService.shouldSaveBookmarksStatus ||
				aEvent.targetStatus == 'fixedLabel' ||
				(
					TabbrowserService.getPref('browser.tabs.extensions.bookmarks.save_textZoom') &&
					aEvent.targetStatus == 'textZoom'
				)
			)
			)
			TabbrowserService.saveBookmarkStatus(aEvent.target, aEvent.target.getTabByTabId(aEvent.tabId), aEvent.targetStatus);
	},
 
	onXULTabbrowserTabDrop : function(aEvent) 
	{
		TabbrowserService.onTabDropInternal(aEvent);
	},
 
	onXULTabbrowserURIDrop : function(aEvent) 
	{
		// Make dragged links visited
		var links = TabbrowserService.getSelectionLinks();
		if (links.length == 1 &&
			links[0].uri == aEvent.droppedURI)
			TabbrowserService.markLinkVisited(links[0].uri, links[0].node);
	},
 
	onXULTabbrowserAddTabCanceled : function(aEvent) 
	{
		var TS = TabbrowserService;
		var chromehidden;
		var useOverflow = (
				( // if the tab bar is hidden
					(chromehidden = Components.lookupMethod(window, 'top').call(window).document.documentElement.getAttribute('chromehidden')) &&
					chromehidden.indexOf('location') > -1 &&
					chromehidden.indexOf('toolbar') > -1
				) ||
				(
					TS.getPref('browser.tabs.extensions.limit.overflow') &&
					TS.winHookMode != 2
				)
			);


		if (!useOverflow) {
			TS.popupAlert(TS.strbundle.GetStringFromName('status_tabs_rejected'));
			return;
		}


		// If another browser exists, open tab there.

		var referrer = aEvent.referrerURI ? TS.makeURIFromSpec(aEvent.referrerURI) : null ;
		var max      = TS.getPref('browser.tabs.extensions.limit.number');
		var info,
			b        = TS.browserWindows;
		for (var i = 0; i < b.length; i++)
		{
			if (
				b[i] == window ||
				!b[i].TabbrowserService.browser ||
				!b[i].TabbrowserService.browser.mTabs ||
				(max && b[i].TabbrowserService.browser.mTabs.length >= max)
				)
				continue;

			b[i].focus();
			b[i].TabbrowserService.browser.addTabInternal(
				aEvent.loadingURI,
				referrer,
				aEvent.tabInfo
			);
			return;
		}

		// ɃuEUEBhEȂA邢́ÃEBhESĐς܂Ń^uJĂꍇAVKɃEBhEJ
		// If other navigators have fully tabs, then open new navigator window.
//dump('over:'+aURI+'\n');
		TS.overflowingTabsManager.addTab(
			aEvent.loadingURI,
			referrer,
			aEvent.tabInfo
		);
	},
  
	addPrefListener : function(aObserver) 
	{
		var domains = ('domains' in aObserver) ? aObserver.domains : [aObserver.domain] ;
		try {
			var pbi = this.Prefs.QueryInterface(Components.interfaces.nsIPrefBranchInternal);
			for (var i = 0; i < domains.length; i++)
				pbi.addObserver(domains[i], aObserver, false);
		}
		catch(e) {
		}
	},
 
	removePrefListener : function(aObserver) 
	{
		var domains = ('domains' in aObserver) ? aObserver.domains : [aObserver.domain] ;
		try {
			var pbi = this.Prefs.QueryInterface(Components.interfaces.nsIPrefBranchInternal);
			for (var i = 0; i < domains.length; i++)
				pbi.removeObserver(domains[i], aObserver, false);
		}
		catch(e) {
		}
	},
 
	// replace "window.open" and other functions to custom versions. 
	onTabLoading : function(aRelatedTab, aWindow, aShouldNotFollowFrames)
	{
		if (aWindow == Components.lookupMethod(aWindow, 'top').call(aWindow) &&
			!('__tabextensions__initialized' in aWindow)) {
			// ACRw肳ĂꍇÃACRD悷B
			// URIACRw肳ꂽubN}[NURI艺ʂ̃fBNgłȂꍇAACRZbgB
			var icon = this.getIconForBookmark(aRelatedTab.mTabInfo.loadingURI, true);
			if (icon) {
				window.setTimeout(
					function(aTab, aURI)
					{
						aTab.setAttribute('image', aURI);
						// y[WJ_ŃACȐ񂪏㏑Ă܂Ă̂ŁAēx㏑
					},
					0,
					aRelatedTab, icon
				);
				this.setIconForBookmark(aRelatedTab.mTabInfo.loadingURI);
			}
		}

		if ('frames' in aWindow && !aShouldNotFollowFrames) {
			for (var i = 0; i < aWindow.frames.length; i++)
				this.onTabLoading(aRelatedTab, aWindow.frames[i]);
		}

		if ('__tabextensions__initialized' in aWindow || !aWindow.open || !aWindow.Window) return;


		// set focus
		if (
			aRelatedTab == this.browser.selectedTab &&
			!document.commandDispatcher.focusedElement // if a node has been focued, do nothing
			)
			this.browser.setFocusInternal();


		// override "window.open"
		if (!('__tabextensions__open' in aWindow.Window.prototype)) {
			aWindow.Window.prototype.__tabextensions__open = aWindow.Window.prototype.open;
		}
		aWindow.eval('Window.prototype.open = '+this.newWindowOpen.toSource());
		aWindow.open = aWindow.Window.prototype.open;


		// override timer functions
		if (!('__tabextensions__setTimeout' in aWindow.Window.prototype)) {
			aWindow.Window.prototype.__tabextensions__setTimeout = aWindow.Window.prototype.setTimeout;
			aWindow.Window.prototype.__tabextensions__setInterval = aWindow.Window.prototype.setInterval;
		}
		aWindow.eval('Window.prototype.setTimeout = '+this.newWindowSetTimeout.toSource());
		aWindow.eval('Window.prototype.setInterval = '+this.newWindowSetInterval.toSource());

		aWindow.__tabextensions__popupControlState   = this.openAbused;
		aWindow.__tabextensions__runningTimeoutDepth = 0;


		// Norton Internet Securityt overrides window.open so we have to kill the feature...
		aWindow.SymRealWinOpen = aWindow.Window.prototype.open;


		aWindow.openBrowserTab       = this.openBrowserTab;
		aWindow.shouldOpenBrowserTab = this.shouldOpenBrowserTab;

/*
		if (aRelatedTab.mTabInfo.openedAutomatically) {
			aWindow.resizeTo = function() {};
			aWindow.resizeBy = function() {};
			aWindow.moveBy   = function() {};
			aWindow.moveTo   = function() {};
		}
*/

		aWindow.__tabextensions__LastEvent = (new Date()).getTime();

		aWindow.__tabextensions__initialized = true;
	},
	
	onTabLoadFinish : function(aWindow, aRelatedTab) 
	{
		if ('frames' in aWindow) {
			for (var i = 0; i < aWindow.frames.length; i++)
				this.onTabLoadFinish(aWindow.frames[i], aRelatedTab);
		}

		if (!('__tabextensions__initialized' in aWindow))
			this.onTabLoading(aRelatedTab, aWindow, true);
	},
  
	loadPrefs : function() 
	{
		if (this.getPref('browser.tabs.extensions.default.type') === null)
			window.openDialog('chrome://tabextensions/content/initializeDefaultPref.xul', '_blank', 'chrome,modal,resizable=no,titlebar=no,centerscreen');

		if (this.getPref('browser.tabs.extensions.default'))
			return;


		var defPref = [];
		var i;

		const dir = 'chrome://tabextensions/content/default/';
		var prop;
		switch (this.getPref('browser.tabs.extensions.default.type'))
		{
			default:
			case 0:
				defPref.push(this.readFromURI(dir+'default.js'));
				prop = 'defaultPref';
				break;

			case 1:
				defPref.push(this.readFromURI(dir+'default.light.js'));
				prop = 'defaultPrefLight';
				break;
		}

		var overlays = this.readFromURI(dir+'overlays.txt');
		var selected = this.getPref('browser.tabs.extensions.default.overlay');
		if (selected && overlays.match((new RegExp('^'+selected+'=(.+)$', 'm'))))
			defPref.push(this.readFromURI(dir+RegExp.$1));


		var modules = TabbrowserServiceModules;
		for (i = 0; i < modules.length; i++)
			if (prop in modules[i] && typeof modules[i][prop] == 'string')
				defPref.push(this.readFromURI(modules[i][prop]));


		var prefs = [];
		var pref = function(aPrefstring, aValue) {
			prefs[prefs.length] = { name : aPrefstring, value : aValue };
		}
		eval(defPref.join('\n'));


		// Sometimes user prefs are broken by Mozilla default prefs...
		// So we have to save TBE's user prefs to the another file.
		// This section loads the escaped prefs.
		var userPrefs = {};
		pref = function(aPrefstring, aValue) {
			userPrefs[aPrefstring] = aValue;
		}
		eval(this.readFromURI(this.profileURL+'tabextensions.js') || '');


		const DEFPrefs = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefService).getDefaultBranch(null);
		var nullPointer;
		for (i = prefs.length-1; i > -1; i--)
		{
			if (prefs[i].name in this.prefs) continue;

			this.setPref(prefs[i].name, prefs[i].value, DEFPrefs);
			if (prefs[i].name in userPrefs)
				this.setPref(prefs[i].name, userPrefs[prefs[i].name]);

			nullPointer = this.getPref(prefs[i]);
			this.prefs[prefs[i].name] = true;
		}
	},
  
	destruct : function() 
	{
		if (!this.activated) return;
		this.activated = false;

		this.onEventForModules('onBeforeDestruct');

		var i;

		if (this.isBrowserWindow) {
			this.removePrefListener(gTSTabMenuPrefListener);
			this.removePrefListener(gTSPlatformNativeBehaviorPrefListener);
			this.removePrefListener(gTWindowModePrefListener);
			this.removePrefListener(gTSOpenTabForWindowOpenPrefListener);

			try {
				var w = this.browserWindows;
				if (!w.length || (w.length == 1 && w[0] == window))
					this.ObserverService.removeObserver(window.gTSDOMWindowOpenObserver, 'domwindowopened', false);
			}
			catch(e) {
			}
			delete window.gTSDOMWindowOpenObserver;
		}
		if (this.browser) {
			window.removeEventListener('focus', this.onWindowFocus, true);
			window.removeEventListener('blur', this.onWindowBlur, true);

			this.removePrefListener(gTSTabbarBlankSpacePrefListener);
			this.removePrefListener(gTSCloseBoxPrefListener);
			this.removePrefListener(gTSLastTabClosingPrefListener);
			this.removePrefListener(gTSTabsAutoHidePrefListener);
			this.removePrefListener(gTSIconOverlayInTabsPrefListener);
			this.removePrefListener(gTSTabbarPlacePrefListener);
			this.removePrefListener(gTSGroupModePrefListener);
			this.removePrefListener(gTSTabsWidthPrefListener);
			this.removePrefListener(gTSTabScrollerPrefListener);
			this.removePrefListener(gTSAnotherBindingPrefListener);

			window.removeEventListener('resize', this.onWindowResize, false);
		}


		window.removeEventListener('close', this.onWindowClose, false);


		this.destroyTabBrowser();


		this.onEventForModules('onAfterDestruct');


		// Save TBE user prefs to the another file, because Mozilla overwrites some entries.
		var prefs = [];
		var value;
		for (var name in this.prefs)
		{
			value = this.getPref(name);

 			if (value !== null)
				prefs.push('pref("'+name+'", '+(typeof value == 'string' ? value.toSource()+'.valueOf()' : value )+');');
		}
		prefs.push('');
		this.writeToURI(prefs.join('\n'), this.profileURL+'tabextensions.js');
	},
	
	destroyTabBrowser : function() 
	{
		var b = this.browsers;
		for (i = 0; i < b.length; i++)
		{
			// remove event listeners
			b[i].endHookingContentAreaEvents();

			b[i].removeEventListener('DOMWindowClose', b[i].onWindowCloseInLastTabEventListener, true);

			b[i].removeEventListener('close', this.onTabbrowserWindowClose, true);
			b[i].removeEventListener('unload', this.onTabbrowserWindowUnload, true);

			b[i].removeEventListener('XULTabbrowserTabLoading', this.onXULTabbrowserTabLoading, false);
			b[i].removeEventListener('XULTabbrowserTabLoad', this.onXULTabbrowserTabLoad, false);
			b[i].removeEventListener('XULTabbrowserTabAdded', this.onXULTabbrowserTabAdded, false);
			b[i].removeEventListener('XULTabbrowserTabRemoved', this.onXULTabbrowserTabRemoved, false);
			b[i].removeEventListener('XULTabbrowserTabMoved', this.onXULTabbrowserTabMoved, false);
//			b[i].removeEventListener('XULTabbrowserTabGroupModified', this.onXULTabbrowserTabGroupModified, false);
			b[i].removeEventListener('XULTabbrowserTabStatusChange', this.onXULTabbrowserTabStatusChange, false);
			b[i].removeEventListener('XULTabbrowserTabDrop', this.onXULTabbrowserTabDrop, false);
			b[i].removeEventListener('XULTabbrowserURIDrop', this.onXULTabbrowserURIDrop, false);
			b[i].removeEventListener('XULTabbrowserAddTabCanceled', this.onXULTabbrowserAddTabCanceled, false);

			b[i].removeEventListener('click', this.emulateTabbarClick, true);
			b[i].removeEventListener('dblclick', this.emulateTabbarClick, true);


			b[i].bookmarksManager = null;


			var browser;
			for (j in b[i].mTabs)
			{
				try {
					browser = b[i].mTabs[j].mBrowser;

					browser.stop();
					b[i].mTabProgressListenerCreatorInternal.removeListenerFrom(b[i].mTabs[j]);
					browser.contentDocument.defaultView.close = function() {};

					// do destroying steps which aren't done by the destructor of "tabbrowser.xml"
					browser.setAttribute('type', 'content');
					if ('destroy' in browser) browser.destroy();
				}
				catch(e) {
					if (this.debug) dump('Error: Tabbrowser Extensions fails to destroy tabbrowser\n'+e+'\n');
				}
			}

			b[i].mTabs               = null;
			b[i].mIdentifiedTabs     = null;
			b[i].mRemovedTabInfoList = null;
		}
	},
  
	onEventForModules : function(aEventName, aInfo) 
	{
		var modules = TabbrowserServiceModules;
		for (var i = 0; i < modules.length; i++)
			if (aEventName in modules[i] && typeof modules[i][aEventName] == 'function')
				modules[i][aEventName](aInfo);
	},
 
	// replace <tabbrowser> methods 
	
	getBrowserForTab : function(aTab) 
	{
		if (!aTab) return this.browsers[0];

		if (aTab._mBrowser) return aTab._mBrowser;


		if (!aTab || aTab.localName == 'tabs') aTab = this.selectedTab;

		if (aTab == this.selectedTab)
			return this.mCurrentBrowser;

		var t = this.mTabContainer.childNodes;
		var b = this.mPanelContainer.childNodes;
		for (var i = 0; i < t.length; i++)
			if (aTab == t[i]) {
				return (b[i].localName == 'browser') ? b[i] : // trunk
					b[i].getElementsByTagNameNS('http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul', 'browser')[0] ; // Firefox 0.9.2 branch
			}

		return null;
	},
 
	// |bvAbvj[̍XV 
	updatePopupMenu : function(aPopup, aEvent)
	{
		// if the popup is a submenu, return
		if (aEvent.originalTarget != aPopup) return;

		var tab = document.popupNode || this.selectedTab;
		if (tab.localName != 'tab') tab = this.selectedTab;

		this.updateMenuItems(aPopup, this, tab, true);
	},
 
	updateTabsMenu : function(aPopup, aEvent) 
	{
		// if the popup is a submenu, return
		if (aEvent.originalTarget != aPopup) return;

		var nodes = aPopup.getElementsByAttribute('tbattr', 'tabbrowser-multiple');
		var single = gBrowser.mTabs.length == 1 ;
		for (var i = 0;i < nodes.length; i++)
			if (single)
				nodes[i].setAttribute('disabled', true);
			else
				nodes[i].removeAttribute('disabled');

		gBrowser.updateMenuItems(aPopup);
	},
 
	updateTabsListMenu : function(aPopup, aShouldSort) 
	{
		while (aPopup.hasChildNodes() &&
			!aPopup.lastChild.getAttribute('sorted'))
			aPopup.removeChild(aPopup.lastChild);

		var i,
			tabs;
		if (aShouldSort) {
			var root = { childTabs : [] };
			for (i in gBrowser.mTabs)
				if (!gBrowser.mTabs[i].parentTab)
					root.childTabs.push(gBrowser.mTabs[i]);
			root.childTabs.sort(gBrowser.conpareHasChildTabs);

			tabs = gBrowser.gatherChildTabsOf(root);
		}
		else
			tabs = gBrowser.mTabs;

		var label,
			tab;
		for (i = 0; i < tabs.length; i++)
		{
			aPopup.appendChild(document.createElement('menuitem'));
			aPopup.lastChild.setAttribute('value', tabs[i].tabIndex);

			label = [];
			tab   = tabs[i];
			while (tab.parentTab)
			{
				tab = tab.parentTab;
				label.push('  ');
			}
			label.push(tabs[i].label);
			aPopup.lastChild.setAttribute('label', label.join(''));

			if (tabs[i].mLabelContainer.hasAttribute('style'))
				aPopup.lastChild.setAttribute('style', tabs[i].mLabelContainer.getAttribute('style'));

			if (tabs[i] == gBrowser.selectedTab) {
				aPopup.lastChild.setAttribute('type', 'radio');
				aPopup.lastChild.setAttribute('checked', true);
			}
		}
	},
 
	// ACR̎擾 
	buildFavIconString : function(aURI)
	{
		var icon = this.bookmarksManager ? this.bookmarksManager.getIcon(aURI.spec, true) : null ;
		return icon || this.__tabextensions__buildFavIconString(aURI) ;
	},

	loadFavIcon : function(aURI, aAttr, aNode)
	{
		this.__tabextensions__loadFavIcon(aURI, aAttr, aNode);

		var icon = this.bookmarksManager ? this.bookmarksManager.getIcon(aURI.spec, true) : null ;

		if (icon) {
			window.setTimeout(
				function(aNode, aAttr, aURI)
				{
					aNode.setAttribute(aAttr, aURI);
				},
				0,
				aNode, aAttr, icon
			);
			this.bookmarksManager.setIcon(aURI.spec);
		}
	},
 
	addTab : function(aURI, aReferrerURI, aCharset, aPostData) 
	{
		var info = {
				charset  : (aCharset ? aCharset : null ),
				postData : (aPostData ? b.readPostStream(aPostData) : null )
			};
		return this.addTabInternal(aURI, aReferrerURI, info);
	},
	
	/*
		𒴂̃^uVEBhEŊJ߂̃IuWFNgB
		nꂽURIۑĂAVEBhEŃy[Wǂݍޏł̂҂ĂACɃ^uœǂݍށB

		If too many URIs are handled to "addTab", then it handle them to this object.
		This object stores those URIs/referrers, opens a new browser window, and, starts to load each URI after getting ready the browser.
	*/
	overflowingTabsManager : 
	{
		shouldOpenedInfo : [],
		timer            : null,
		active           : false,
		shouldLoadURI    : false,

		addTab : function(aURI, aReferrerURI, aInfo)
		{
			aInfo.uri      = aURI;
			aInfo.referrer = aReferrerURI || null ;
			this.shouldOpenedInfo.push(aInfo);
//dump('add:'+this.shouldOpenedInfo[this.shouldOpenedInfo.length-1].uri+'\n');

			if (this.active) return;

			var w = window.openDialog(TabbrowserService.browserURI, '_blank', 'chrome,all,dialog=no', 'about:blank');
			this.souldLoadURI = true;
			this.timer = window.setInterval(this.pourTabsTo, 200, w);
			this.active = true;
		},

		pourTabsTo : function(aWindow)
		{
			var manager = TabbrowserService.overflowingTabsManager;

			// 1: If all of overflowed tabs are opened, timer is cleared.
			// 2: If the window for overflowed tabs is closed, we have to clear timer.
			if (!manager.shouldOpenedInfo.length ||
				(aWindow && ('closed' in aWindow && aWindow.closed))) {
				manager.stop();
				return;
			}

			if (!('TabbrowserService' in aWindow) ||
				!aWindow.TabbrowserService.activated ||
				!aWindow.TabbrowserService.isBrowserWindow) return;

			var info = manager.shouldOpenedInfo[0];
			manager.shouldOpenedInfo.splice(0, 1);

			if (!info || !info.uri || !info.uri.toString()) return;


			// first tab is loaded with "loadURI"
			aWindow.TabbrowserService.browser.loadURI(info.uri, info.referrer);
			var t = aWindow.TabbrowserService.browser.selectedTab;
			aWindow.TabbrowserService.browser.initTabWithTabInfo(t, info);
			t.mTabInfo.loadingURI = info.uri;
			manager.shouldLoadURI = false;

			var handedInfo;
			while (manager.shouldOpenedInfo.length)
			{
				info = manager.shouldOpenedInfo[0];
				manager.shouldOpenedInfo.splice(0, 1);
				if (!info || !info.uri || !info.uri.toString()) continue;

				info.parentTab = ('parentTab' in info && info.parentTab) ? t.tabId : null ;

				aWindow.TabbrowserService.browser.addTabInternal(
					info.uri,
					info.referrer,
					info
				);
			}

			manager.stop();
		},

		stop : function()
		{
			window.clearInterval(this.timer);
			this.shouldOpenedInfo = [];
			this.active           = false;
			this.souldLoadURI     = false;
		}
	},
  
	removeTab : function(aTab) 
	{
		this.removeTabInternal(aTab);
	},
 
	// ^uD&D 
	// drag and drop of tabs
	
	// onDragStart 
	onTabDragStart : function(aEvent, aTransferData, aDragAction)
	{
		this.updateScrollbarFromEvent(aEvent);

		var tab = this.getTabFromChild(aEvent.originalTarget);

		// dragging tabbar
		if (!tab) {
			return;
		}

		this.mDraggedTab = tab;

		var uri   = tab.mBrowser.currentURI.spec;
		var label = tab.mTabInfo.fixedLabelOnLoad || tab.mTabInfo.fixedLabel || tab.label || uri ;

		aTransferData.data = new TransferData();
		aTransferData.data.addDataForFlavour('tabbrowser/tab',
			'order='+tab.tabIndex+'\n'+ // current order of the tab.
			'dragId='+tab.tabId+'\n'+ // browser ID. If tab is dropped to other window, the browser opens new tab.
			'uri='+uri);

		aTransferData.data.addDataForFlavour('text/x-moz-url', uri+'\n'+label);
		aTransferData.data.addDataForFlavour('text/html', '<a href="'+uri+'">'+label+'</a>');
		aTransferData.data.addDataForFlavour('text/unicode', uri);
	},
	
	onTabListDragStart : function(aEvent, aTransferData, aDragAction) 
	{
		var tab = gBrowser.mTabs[aEvent.target.value];
		gBrowser.mDraggedTab = tab;

		var uri = tab.mBrowser.currentURI.spec;

		aTransferData.data = new TransferData();
		aTransferData.data.addDataForFlavour('tabbrowser/tab',
			'order='+tab.tabIndex+'\n'+ // current order of the tab.
			'dragId='+tab.tabId+'\n'+ // browser ID. If tab is dropped to other window, the browser opens new tab.
			'uri='+uri);

		aTransferData.data.addDataForFlavour('text/x-moz-url', uri+'\n'+(tab.mTabInfo.fixedLabelOnLoad || tab.mTabInfo.fixedLabel || tab.label));
		aTransferData.data.addDataForFlavour('text/html', '<a href="'+uri+'">'+tab.label+'</a>');
		aTransferData.data.addDataForFlavour('text/unicode', uri);
	},
  
	// onDrop 
	onTabDrop : function(aEvent, aTransferData, aSession)
	{
		var event;
		if (aTransferData.flavour.contentType == 'text/x-moz-url') {
			event = document.createEvent('Events');
			event.initEvent('XULTabbrowserURIDrop', false, true);
			event.droppedURI = aTransferData.data.split('\n')[0];
			this.dispatchEvent(event);
		}

		if (aTransferData.flavour.contentType != 'tabbrowser/tab') {
			this.__tabextensions__onDrop(aEvent, aTransferData, aSession);
			return;
		}

		if (this.mMarker) {
			this.mMarker.setAttribute('hidden', true);
			this.mMarker.mTarget = null;
		}

		var toTab   = aEvent.target,
			fromTab = this.mDraggedTab,
			data    = aTransferData.data.split('\n'),
//			order   = data[0].match(/\d+$/)[0],
			dragId  = data[1].match(/[^=]+$/)[0],
			uri     = data[2].replace(/^uri=/, '');

		// ^ũhbvʒu𒲂ׂ
		// get the dropped position of the tab
		var pos = this.getDropPosition(aEvent);
		if (pos == this.DROP_ON_MARKER) {
			toTab = this.mMarker.mTarget;
			if (toTab.tabIndex == this.mMarker.getAttribute('ordinal'))
				pos = this.DROP_BEFORE;
			else
				pos = this.DROP_AFTER;
		}

		var toIndex;
		if (toTab.localName == 'tab') {
			toIndex = toTab.tabIndex;
		}
		else {
			var box = this.mTabs[this.mTabs.length-1].boxObject;
			if (aEvent.screenX >= box.screenX+box.width) {
				toIndex = this.mTabs.length-1;
				pos = this.DROP_AFTER;
			}
			else {
				toIndex = 0;
				pos = this.DROP_BEFORE;
			}
			toTab = this.mTabs[toIndex];
		}


		event = document.createEvent('Events');
		event.initEvent('XULTabbrowserTabDrop', false, true);

		event.tabURI           = uri;
		event.droppedTabId     = dragId;
		event.targetTabId      = toTab.tabId;
		event.droppedPosition  = pos;

		event.dragdropShiftKey = aEvent.shiftKey;
		event.dragdropAltKey   = aEvent.altKey;
		event.dragdropMetaKey  = aEvent.metaKey;
		event.dragdropCtrlKey  = aEvent.ctrlKey;

		event.dragdropTarget         = aEvent.target;
		event.dragdropOriginalTarget = 'originalTtarget' in aEvent ? aEvent.originalTtarget : null ;

		this.dispatchEvent(event);


		this.mDraggedTab = null;
	},
	
	onTabDropInternal : function(aEvent) 
	{
		var b = aEvent.target; // tabbrowser

		var fromId  = aEvent.droppedTabId,
			fromTab = b.getTabByTabId(fromId),
			toTab   = b.getTabByTabId(aEvent.targetTabId),
			toIndex = toTab.tabIndex,
			uri     = aEvent.tabURI,
			pos     = aEvent.droppedPosition,
			i;

		if (
			b.getAttribute('tabs-rearrange') == 'true' ||
			pos == b.DROP_ON ||
			!fromTab ||
			aEvent.dragdropTarget.localName != 'tab'
			) {
		}
		else {
			return;
		}


		// When the tab is dragged from another window...
		if (!fromTab) {

			// when dropped to an existing tab
			if (pos == b.DROP_ON &&
				toTab.mTabInfo.loadingURI &&
				toTab.mTabInfo.loadingURI != 'about:blank' &&
				aEvent.dragdropTarget.localName == 'tab' &&
				(!b.tabGroupsAvailable || aEvent.dragdropShiftKey)) {
				toTab.mBrowser.loadURI(uri);
				return;
			}

			if (this.getPref('browser.tabs.extensions.dragdrop.only_load_uri')) { // old implementation
				fromTab = b.addTab(uri);
			}
			else {
				var w = this.browserWindows;
				var browser, tab;
				for (i in w) // find the window the tab is dragged from
				{
					browser = w[i].TabbrowserService.browser;
					tab     = browser.getTabByTabId(fromId);
					if (tab) break;
				}
				if (tab) {
					var info   = browser.getTabInfo(tab);
					var isLast = (browser.mTabs.length == 1);
					browser.removeTabInternal(tab, { preventUndo : true });
					if (isLast) {
						window.setTimeout(function() {
							Components.lookupMethod(browser.ownerDocument.defaultView, 'top').call(browser.ownerDocument.defaultView).close();
						}, 0);
					}
					fromTab = b.addTabWithTabInfo(info);
				}
				else
					fromTab = b.addTab(uri);
			}

			// if the tab is dropped to the blank tab, remove it
			if (
				pos == b.DROP_ON ||
				b.mTabs.length < 3 // if there was only one tab since the tab was dropped
				) {
				var targetTab = (b.mTabs.length < 3) ? b.mTabs[0] : toTab ;
				if (targetTab.isReallyBlank) {
					b.removeTabInternal(targetTab, { preventUndo : yes });
					if (toTab == targetTab) toTab = null;
				}
			}
		}

		// O[vւ̒ǉ insert to the group
		var isSimpleEdit = this.getPref('browser.tabs.extensions.group.edit_simple_dragdrop');
		if (toTab &&
			pos == b.DROP_ON &&
			(
				b.tabGroupsAvailable &&
				(
					aEvent.dragdropCtrlKey ||
					aEvent.dragdropMetaKey ||
					(
						!aEvent.dragdropCtrlKey &&
						!aEvent.dragdropMetaKey &&
						isSimpleEdit
					)
				)
			)) {
// If there is 3 tabs A, B(child of A) and C(child of A), and you open new tab D from A, tabextensions appends D to it's group. Then it has three children B, C, and D.
// But, D is not accessible when there is too many tabs. In bookmark groups or links opened from the context menu, D shouldn't be the brother of B and C. For example, if new tabs are shown at the right edge of groups, expected result is following: A, D(child of A), B and C(child of B).
			if (toTab.hasChildTabs() &&
				toTab.shouldPurgeChildren) {
				var children  = toTab.childTabs;
				var newParent = toTab.parentTab || children[0] ;
				for (i = 0; i < children.length; i++)
					b.attachTabTo(children[i], children[i] == newParent ? toTab.parentTab : newParent );

				toTab.shouldPurgeChildren     = false;
				newParent.shouldPurgeChildren = true;
			}

			b.moveTabToGroupEdge(fromTab, toTab);
			fromTab.parentTab = toTab;
		}
		else {
			if (toIndex > fromTab.tabIndex)
				toIndex += (pos < 0 ? -1 : 0 );
			else if (!isSimpleEdit || toIndex < fromTab.tabIndex)
				toIndex += (pos > 0 ? 1 : 0 );

			if (toIndex >= 0 && toIndex < b.mTabs.length)
				b.moveTabTo(fromTab, toIndex);


			// ^uȊȌꏊɃhbvꍇAO[v𔲂
			// if the tab is dropped from groups, detach it from the group.
			if (aEvent.dragdropTarget.localName != 'tab' &&
				fromTab.parentTab &&
				(
					!aEvent.dragdropOriginalTarget ||
					aEvent.dragdropOriginalTarget != b.mMarker
				)
				) {
				fromTab.parentTab = null;

				// q̃^u^ủEɍĔzu
				// move child tabs to right of the tab
				var tabs = fromTab.allChildTabs;
				for (i in tabs)
					b.moveTabTo(tabs[i], fromTab.tabIndex+1);
			}
		}
	},
  
	// onDragOver 
	onTabDragOver : function(aEvent, aFlavour, aSession)
	{
		this.updateScrollbarFromEvent(aEvent);

		this.__tabextensions__onDragOver(aEvent, aFlavour, aSession);

		var XferDataSet = nsTransferable.get(
				this.getSupportedFlavours(),
				nsDragAndDrop.getDragData,
				true
			);
		var XferData = XferDataSet.first.first;
		if (XferData.flavour.contentType == 'tabbrowser/tabbar') {
			var current = aEvent.originalTarget;
			while (current.parentNode &&
					current != this.mTabContainer &&
					current != this)
				current = current.parentNode;

			if (current == this.mTabContainer)
				this.setAttribute('tabbar-moving', true);
			return;
		}
		else if (XferData.flavour.contentType != 'tabbrowser/tab') return;


		// auto scroll
		if (this.mScrollbar) {
			var wait = 80,
				clientPos,
				maxPos;
			if (this.mTabBox.orient == 'horizontal') { // left or right
				clientPos = aEvent.clientY;
				maxPos    = this.mTabContainerInnerBox.boxObject.height;
			}
			else { // top or bottom
				clientPos = aEvent.clientX;
				maxPos    = this.mTabContainerInnerBox.boxObject.width;
			}
			if (clientPos > 0 && clientPos < 40) {
				if (clientPos < 10)
					wait = 10;
				else if (clientPos < 25)
					wait = 40;
				this.scrollTabbarBy(-10, wait);
			}
			else if (clientPos > maxPos-40 && clientPos < maxPos) {
				if (clientPos > maxPos-10)
					wait = 10;
				else if (clientPos > maxPos-25)
					wait = 40;
				this.scrollTabbarBy(10, wait);
			}
		}


		// if dragged on the marker, do nothing
		if (aEvent.originalTarget &&
			aEvent.originalTarget == this.mMarker) return;

		this.mCurrentDragOverTab = (aEvent.target.localName == 'tab') ? aEvent.target : null ;
		if (!this.mCurrentDragOverTab) return;

		var tab = this.mCurrentDragOverTab;


		var preventToRearrange = (
				this.getAttribute('tabs-rearrange') != 'true' ||
				!this.mDraggedTab ||
				this.mDraggedTab.tabId != XferData.data.split('\n')[1].match(/[^=]+$/)[0]
			);


		// hbOJn^ȕł͕\ςȂ
		// Ignore the tab dragged from.
		if (this.mDraggedTab == aEvent.target) {
			if (this.mMarker) {
				this.mMarker.setAttribute('hidden', true);
				this.mMarker.mTarget = null;
			}
			tab.removeAttribute('dragover-at');
			return;
		}


		// rightleft̔
		// Which is the position the tab dropped, left or right?
		var pos = this.getDropPosition(aEvent);
//		dump('drop position: '+pos+'\n');
		if (pos == this.DROP_BEFORE) {
			if (preventToRearrange) {
				aSession.canDrop = false;
				tab.removeAttribute('dragover-at');
			}
			else if (this.mMarker) {
				this.mMarker.setAttribute('ordinal', tab.tabIndex);
				this.mMarker.removeAttribute('hidden');
				this.mMarker.mTarget = tab;
				tab.removeAttribute('dragover-at');
			}
			else {
				tab.setAttribute('dragover-at', 'before');
			}
		}
		else if (pos == this.DROP_AFTER) {
			if (preventToRearrange) {
				aSession.canDrop = false;
				tab.removeAttribute('dragover-at');
			}
			else if (this.mMarker) {
				this.mMarker.setAttribute('ordinal', tab.tabIndex+1);
				this.mMarker.removeAttribute('hidden');
				this.mMarker.mTarget = this.mTabs[tab.tabIndex+1];
				tab.removeAttribute('dragover-at');
			}
			else {
				tab.setAttribute('dragover-at', 'after');
			}
		}
		else {
			if (this.mDraggedTab &&
				!this.canAttachTabTo(this.mDraggedTab, tab)) {
				aSession.canDrop = false;
			}
			if (this.mMarker) {
				this.mMarker.setAttribute('hidden', true);
				this.mMarker.mTarget = null;
			}

			tab.setAttribute('dragover-at', 'this');
		}
	},

	getTabDropPosition : function(aEvent)
	{
		var isSimpleEdit = false;
		try {
			isSimpleEdit = this.mPrefs.getBoolPref('browser.tabs.extensions.group.edit_simple_dragdrop');
		}
		catch(e) {
		}

		var box = aEvent.target.boxObject.QueryInterface(Components.interfaces.nsIBoxObject);
		var regionCount = (
					this.tabGroupsAvailable &&
					(
						aEvent.ctrlKey ||
						aEvent.metaKey ||
						(
							!aEvent.ctrlKey &&
							!aEvent.metaKey &&
							isSimpleEdit
						)
					)
				) ? 3 : 2 ;
		// This is a number of position. "2" is "Left/Right", "3" is "Left/Middle/Right".

		var side = this.mTabBox.orient == 'horizontal'; // left or right
		var measure          = ((side ? box.height : box.width) / regionCount),
			coordValue       = (side ? box.y : box.x ),
			clientCoordValue = (side ? aEvent.clientY : aEvent.clientX );

		if (this.mScrollbar) // see "updateScrollbarFromEvent" in tabextensions.xml
			coordValue -= Number(this.mScrollbar.getAttribute('curpos'));

		// if dragged on the marker...
		if (aEvent.originalTarget &&
			aEvent.originalTarget == this.mMarker)
			return this.DROP_ON_MARKER;
		else if (clientCoordValue < (coordValue + measure))
			return this.DROP_BEFORE;
		else if (!this.tabGroupsAvailable ||
				clientCoordValue >= (coordValue + (regionCount-1)*measure))
			return this.DROP_AFTER;
		else
			return this.DROP_ON;
	},
 
	// onDragExit 
	onTabDragExit : function(aEvent, aSession)
	{
		this.removeAttribute('tabbar-moving');

		if (this.mMarker) {
			this.mMarker.setAttribute('hidden', true);
			this.mMarker.mTarget = null;
		}

		if (this.mCurrentDragOverTab)
			this.mCurrentDragOverTab.removeAttribute('dragover-at');
	},
 
	// Supported Flavours 
	getTabsSupportedFlavours : function()
	{
		var flavours = this.__tabextensions__getSupportedFlavours();

		var flavour;

		flavour = new Flavour('tabbrowser/tabbar');
		flavours.flavours.unshift(flavour);
		flavours.flavourTable[flavour.contentType] = flavour;

		flavour = new Flavour('tabbrowser/tab');
		flavours.flavours.unshift(flavour);
		flavours.flavourTable[flavour.contentType] = flavour;

		return flavours;
	},
  
	// ^uE^uo[_uNbNENbN̓ 
	// behavior of clicking on the the tabbar or tabs
	onTabClick : function(aEvent)
	{
		this.updateScrollbarFromEvent(aEvent);

		var type = (aEvent.type == 'dblclick') ? (aEvent.button == 0 ? 'double' : null ) :
					(aEvent.button == 1 || (aEvent.button == 0 && (aEvent.ctrlKey || aEvent.metaKey))) ? 'middle' :
					null ;

		if (!type) return;

		var ignoreMiddleClick = false;
		try {
			ignoreMiddleClick = this.mPrefs.getBoolPref('middlemouse.contentLoadURL');
		}
		catch(e) {
		}
		if (type == 'middle' && ignoreMiddleClick) return;

		// in scrollbars
		if (aEvent.originalTarget.localName &&
			aEvent.originalTarget.localName.match(/^(scrollbar(button)?|slider|thumb)$/)) return;

		var tab    = aEvent.target,
			action = 0,
			pref   = '';

		switch (tab.localName)
		{
			case 'tab':
				switch (type)
				{
					case 'double':
						pref = 'ondblclick';
						break;

					case 'middle':
						pref = 'onmiddleclick';
						break;

					default:
						break;
				}
				break;

			default: // tab bar
				tab = this.selectedTab;
				switch (type)
				{
					case 'double':
						pref = 'tabbar_ondblclick';
						break;

					case 'middle':
						pref = 'tabbar_onmiddleclick';
						break;

					default:
						break;
				}
				break;
		}

		if (pref) {
			try {
				action = this.mPrefs.getIntPref('browser.tabs.extensions.'+pref);
			}
			catch(e) {
			}
		}

		switch (action)
		{
			case 0:
			default:
				break;

			case 1:
				BrowserOpenTab();
				break;
			case 2:
				this.reloadTab(tab);
				break;
			case 3:
				this.reloadAllTabs();
				break;
			case 4:
				this.removeTabInternal(tab);
				break;
			case 5:
				this.removeAllTabsButInternal(tab);
				break;
			case 6:
				if (this.tabGroupsAvailable)
					this.bookmarksManager.bookmarkTabGroup(tab);
				else if ('addGroupmarkAs' in window)
					addGroupmarkAs();
				else
					this.bookmarksManager.bookmarkTabGroup(tab, true);
				break;

			case 101:
				this.duplicateTab(tab);
				break;
			case 102:
				this.toggleTabLocked(tab);
				break;
			case 103:
				this.toggleTabAutoReload(tab);
				break;
			case 104:
				this.removeLeftTabsFrom(tab);
				break;
			case 105:
				this.removeRightTabsFrom(tab);
				break;
			case 106:
				this.duplicateTabInWindow(tab);
				break;
			case 107:
				this.moveTabBy(tab, -1);
				break;
			case 108:
				this.moveTabBy(tab, 1);
				break;
			case 109:
				this.removeTabGroup(tab);
				break;
			case 110:
				this.sortTabsByGroup();
				break;
			case 111:
				this.highlightGroupFromTab(tab);
				break;
			case 112:
				this.setTabColorFor(tab);
				break;
			case 113:
				this.undoRemoveTab();
				break;
			case 114:
				this.editBookmarkFromTab(tab);
				break;
			case 115:
				this.toggleReferrerBlocked(tab);
				break;
			case 116:
				window.openDialog('chrome://tabextensions/content/contextMenuEdit.xul', '', 'chrome,modal,resizable=no');
				break;
			case 117:
				this.removeAllTabs();
				break;
			case 118:
				this.setFixedLabelFor(tab);
				break;
			case 119:
				this.removeVisitedTabs();
				break;

			case 200:
				this.toggleDocShellPropertyFor(tab, 'allowPlugins');
				break;
			case 201:
				this.toggleDocShellPropertyFor(tab, 'allowJavascript');
				break;
			case 202:
				this.toggleDocShellPropertyFor(tab, 'allowMetaRedirects');
				break;
			case 203:
				this.toggleDocShellPropertyFor(tab, 'allowSubframes');
				break;
			case 204:
				this.toggleDocShellPropertyFor(tab, 'allowImages');
				break;

			case 300:
				this.toggleAllTabsLocked();
				break;
			case 301:
				this.toggleReferrerBlockedForAllTabs();
				break;
			case 302:
				this.toggleAllTabsAutoReload();
				break;
		}

		aEvent.preventDefault();
		aEvent.preventBubble();
		aEvent.preventCapture();
		aEvent.stopPropagation();
	},
 
	// for "tabs" 
	advanceSelectedTab : function(aDir)
	{
		var fromContent = (document.commandDispatcher.focusedWindow != window);

		var b        = this.mTabBrowser;
		var startTab = this.selectedItem;
		var tabs     = b.mTabs;

		var next = tabs[startTab.tabIndex+aDir];
		while (next != startTab && (!next || next.getAttribute('hidden')))
		{
			if (next && next.getAttribute('hidden'))
				next = tabs[next.tabIndex+aDir];
			if (!next)
				next = (aDir > 0) ? tabs[0] : tabs[tabs.length-1];
		}

		if (next && next != startTab) {
			this.selectedItem = next;
			if (this.getAttribute('setfocus') != 'false') {
				next.focus();
				document.commandDispatcher.advanceFocusIntoSubtree(next);
				b.setFocusInternal();
			}
		}

		b.scrollTabbarTo(next);

		// failsafe
		if (fromContent) _content.focus();
	},
 
	replaceGroup : function(aGroupInfo) 
	{
		var oldTabsInfo = [];
		var i;

		for (i in this.mTabs)
			oldTabsInfo.push(this.getTabInfo(this.mTabs[i]));

		var t = this.removeAllTabsButInternal(this.addTab('about:blank'), { preventUndo : true });

		for (i = 0; i < aGroupInfo.length; i++)
		{
			if ('SHEntries' in aGroupInfo[i])
				this.addTabWithTabInfo(aGroupInfo[i]);
			else {
				var referrerURI = 'referrerURI' in aGroupInfo[i] ? data.referrerURI : null ;
				this.addTab(aGroupInfo[i].URI, aGroupInfo[i]);
			}
		}

		if (aGroupInfo.length)
			this.removeTabInternal(t, { preventUndo : true });

		return oldTabsInfo;
	},
 
	setTabTitle : function(aTab) 
	{
		if (!aTab) aTab = this.selectedTab;
		this.__tabextensions__setTabTitle(aTab);
		aTab.setAttribute('crop', aTab.mTabInfo.titleCrop);
	},
  
	// window.open() management 
	
	newWindowOpen : function(aURI, aName, aFlags) 
	{
		var now = (new Date()).getTime();
		aName = String(aName) || '' ;

		var TS = TabbrowserService;
if (TS.debug) dump('newWindowOpen ('+aURI+')\n');

		var contextWindow = this.document.defaultView;
		if (!contextWindow) contextWindow = this;
		var sourceURI = ('Components' in window && 'lookupMethod' in Components) ? Components.lookupMethod(contextWindow, 'location').call(contextWindow).href : contextWindow.location.href ;

		aURI = aURI ? String(aURI) : 'about:blank' ;
		if (!aURI.match(/^\w+:/))
			aURI = TS.makeURLAbsolute(sourceURI, aURI);

		var abuseLevel = TS.checkForAbusePoint({
				window    : contextWindow,
				XULwindow : window,
				now       : now,
				uri       : aURI,
				source    : sourceURI
			});


if (TS.debug) dump('   abuse level: '+abuseLevel+'\n');
		if (!TS.checkOpenAllow(abuseLevel, aName, contextWindow)) {
if (TS.debug) dump('   blocked\n');
			TS.fireAbuseEvents(
				true,
				false,
				{
					window    : contextWindow,
					uri       : aURI,
					flags     : aFlags
				}
			);
			return {};
		}

try {
if (TS.debug) dump('   POP UP NOW!!\n');
		var w;
		if (window.shouldOpenBrowserTab(aURI, aName, aFlags)) {
if (TS.debug) dump('    => New Tab\n');
			w = TS.openBrowserTabInternal(contextWindow, aURI, aName, aFlags, sourceURI);
		}
		else {
if (TS.debug) dump('    => New Window\n');
			var topWin = Components.lookupMethod(contextWindow, 'top').call(contextWindow);
			if (
				topWin.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
					.getInterface(Components.interfaces.nsIWebNavigation)
					.QueryInterface(Components.interfaces.nsIDocShell)
					.QueryInterface(Components.interfaces.nsIDocShellTreeItem)
					.itemType != Components.interfaces.nsIDocShellTreeItem.typeChrome &&
				aName &&
				!(
					aName.match(/^_(top|self|content|parent)$/i) ||
					aName == '_main'
				) &&
				TS.getPref('browser.tabs.extensions.ignore_target') &&
				!this.service.getFrameByName(topWin, aName)
				)
				aName = '_blank';

			var flags = TS.applyFlagsPermission(aFlags);

			// we have to allow delayed popups becaus TBE makes delay for allowed popups too...
			var originalVal = TS.getPref('dom.disable_open_during_load');
			if (originalVal)
				TS.setPref('dom.disable_open_during_load', false);

			try {
			w = (aFlags !== void(0)) ? this.__tabextensions__open(aURI, aName, (Components.lookupMethod(this.document.defaultView, 'top').call(this.document.defaultView) == Components.lookupMethod(window, 'top').call(window) ? flags.replace(/(alwaysLowered|alwaysRaised|titlebar|z-lock)(=(0|1|true|false|yes|no))?,?/g, '') || void(0) : flags )) :
					this.__tabextensions__open(aURI, aName) ;
			}
			catch(e) {
				if (originalVal)
					TS.setPref('dom.disable_open_during_load', true);

				throw e;
			}

			if (originalVal)
				TS.setPref('dom.disable_open_during_load', true);

			// set real opener to prevent to reopen the new window in a tab
			if (TS.browserWindow &&
				TS.browserWindow != window)
				TS.browserWindow.__tabextensions__opener = this;
			if (w)
				w.__tabextensions__opener = this;
		}
if (TS.debug) dump('       successfully opened\n');
}
catch(e) {
if (TS.debug) alert(e+'\n');
}


		if (abuseLevel >= TS.openControlled)
			if ('openPopupSpamCount' in this)
				this.openPopupSpamCount++;
			else
				this.openPopupSpamCount = 1;

		if (abuseLevel >= TS.openAbused)
			TS.fireAbuseEvents(
				false,
				true,
				{
					window    : contextWindow,
					uri       : aURI,
					flags     : aFlags
				}
			);

if (TS.debug) dump('   allowed\n');
		return w;
	},
	
	// methods like "GlobalWindowImpl", transplanted from nsGlobalWindow.cpp 
	// see http://lxr.mozilla.org/mozilla/source/dom/src/base/nsGlobalWindow.cpp
	openAllowed    : 0, // open that window without worries
	openControlled : 1, // it's a popup, but allow it
	openAbused     : 2, // it's a popup. disallow it, but allow domain override.
	openOverridden : 3, // disallow window open
	
	checkForAbusePoint : function(aInfo) 
	{
		if (!aInfo)
			return this.openOverridden;

		const CI = Components.interfaces;
		if (aInfo.window.QueryInterface(CI.nsIInterfaceRequestor).getInterface(CI.nsIWebNavigation).QueryInterface(CI.nsIDocShellTreeItem).itemType != CI.nsIDocShellTreeItem.typeContent)
			return this.openAllowed;


		var w     = aInfo.window;
		var abuse = '__tabextensions__popupState' in w ? w.__tabextensions__popupState : this.openAllowed ;


		// delayed popups, requested before being initialized
		if (
			!('__tabextensions__popupState' in w) &&
			!('__tabextensions__triggerByUser' in w) // except bookmarklets
			) {
			var rejectDelay = Math.max(Number(this.getPref('dom.disable_open_click_delay')), 0);
			function findRootCaller(aFunc)
			{
				dump('====CALLER('+aFunc.__parent__+')====\n'+aFunc+'\n');
				return (!aFunc || !aFunc.arguments.callee.caller) ? aFunc : findRootCaller(aFunc.arguments.callee.caller) ;
			}
			var foundCaller = findRootCaller(arguments.callee.caller);
			if (
				rejectDelay &&
				'__tabextensions__LastEvent' in w &&
				(aInfo.now - w.__tabextensions__LastEvent) > rejectDelay
				) {
				if (this.debug) dump('TBE blocks popup: '+(aInfo.now - w.__tabextensions__LastEvent)+'msec DELAYED\n');
				abuse = this.openOverridden;
			}
		}

		// is the document being loaded or unloaded?
		if (
			abuse == this.openAllowed &&
			w.document.tabbrowserReadyState != 'complete'
			) {
			if (this.debug) dump('TBE blocks popup: LOADING\n');
			abuse = this.openAbused;
		}

		// fetch pref string detailing which events are allowed
		// see http://lxr.mozilla.org/mozilla/source/dom/src/base/nsGlobalWindow.cpp#3045 (definition of GlobalWindowImpl::CheckForAbusePoint())
		var type   = '__tabextensions__activeEventType' in w ? w.__tabextensions__activeEventType : null ;
		var events = w.__tabextensions__activeEvents;
		if (
			type &&
			type in events &&
			events[type].length &&
			events[type][events[type].length-1].eventPhase > 0 &&
			events[type][events[type].length-1].eventPhase < 4
			) {
			abuse = this.openAbused;
			var allowed_events = this.getPref('dom.popup_allowed_events');
			if (allowed_events === null)
				allowed_events = 'change click dblclick reset submit';
			if ((' '+allowed_events.toLowerCase()+' ').indexOf(' '+type.toLowerCase()+' ') > -1) {
				switch (type)
				{
					case 'select':
					case 'resize':
					case 'input':
					case 'change':
					case 'keypress':
					case 'keyup':
					case 'keydown':
					case 'error':
					case 'submit':
					case 'reset':
						abuse = this.openControlled;
						break;
					case 'mouseup':
					case 'mousedown':
					case 'dblclick':
						if (w.__tabextensions__activeEventButton == 0)
							abuse = this.openControlled;
						break;
					case 'click':
						if (w.__tabextensions__activeEventButton == 0)
							abuse = this.openAllowed;
						break;
					default:
						break;
				}
			}
			if (this.debug && abuse == this.openAbused)
				dump('TBE blocks popup: DENIED EVENT ('+type+')\n');
		}

		// limit the number of simultaneously open popups
		if (abuse == this.openAbused || abuse == this.openControlled) {
			var max = this.getPref('dom.popup_maximum');
			if (max === null) max = 20; // for Mozilla 1.6 or older (default at Mozilla 1.7a)
			max = Math.max(Number(max), 0);
			if (
				max >= 0 &&
				('openPopupSpamCount' in w ? w.openPopupSpamCount : 0 ) >= max
				) {
				if (this.debug) dump('TBE blocks popup: TOO MANY SPAM WINDOWS\n');
				abuse = this.openOverridden;
			}
		}

		return abuse;
	},
 
	checkOpenAllow : function(aAbuseLevel, aName, aCurrentWindow) 
	{
		var allowWindow = true;

		if (
			aAbuseLevel == this.openOverridden ||
			(
				aAbuseLevel == this.openAbused &&
				this.isPopupBlocked(aCurrentWindow)
			)
			) {
			allowWindow = false;

			if (
				aName &&
				(
					aName.match(/^_(top|self|content)$/i) ||
					aName == '_main' ||
					this.WindowWatcher.getWindowByName(aName, aCurrentWindow)
				)
				)
				allowWindow = true;
		}

		return allowWindow;
	},
 
	isPopupBlocked : function(aWindow) 
	{
		var blockedPref = this.getPref('dom.disable_open_during_load'); // for Mozilla 1.6 or older
		var blocked = (blockedPref === null) ? true : blockedPref ;

		try { // for Mozilla 1.2 or later
			const nsIPopupWindowManager = Components.interfaces.nsIPopupWindowManager;
			const PopupManager = Components.classes['@mozilla.org/PopupWindowManager;1'].getService(nsIPopupWindowManager);
			var permission = PopupManager.testPermission(
					this.makeURIFromSpec(
						('Components' in window && 'lookupMethod' in Components) ? Components.lookupMethod(aWindow, 'location').call(aWindow).href : aWindow.location.href
					)
				);
			if (blockedPref === null) // for Mozilla 1.7a or later
				blocked = (permission == nsIPopupWindowManager.DENY_POPUP);
			else if (permission != nsIPopupWindowManager.DENY_POPUP)
				blocked = false;
		}
		catch(e) {
		}

		return blocked;
	},
 
	fireAbuseEvents : function(aBlocked, aOpenWindow, aInfo) 
	{
		if (aBlocked)
			this.firePopupBlockedEvent(aInfo.window, aInfo.uri, aInfo.flags);
		if (aOpenWindow)
			this.firePopupWindowEvent(aInfo.window);
	},
	
	firePopupBlockedEvent : function(aWindow, aURI, aFlags) 
	{
		try {
			var event = document.createEvent('PopupBlockedEvents');
			event.initPopupBlockedEvent(
				'DOMPopupBlocked',
				true,
				true,
				this.makeURIFromSpec('Components' in window && 'lookupMethod' in Components ? Components.lookupMethod(aWindow, 'location').call(aWindow).href : aWindow.location.href ),
				this.makeURIFromSpec(aURI),
				aFlags
			);
			Components.lookupMethod(aWindow, 'top').call(aWindow).document.dispatchEvent(event);
		}
		catch(e) {
		}
	},
 
	firePopupWindowEvent : function(aWindow) 
	{
		try {
			var event = document.createEvent('Events');
			event.initEvent('PopupWindow', true, true);
			Components.lookupMethod(aWindow, 'top').call(aWindow).document.dispatchEvent(event);
		}
		catch(e) {
		}
	},
   
	applyFlagsPermission : function(aFlags) 
	{
		// ignore disabled flags
		var flags = aFlags || '';
		var features = [
				'titlebar',
				'close',
				'toolbar',
				'location',
				'directories',
				'personalbar',
				'menubar',
				'scrollbars',
				'resizable',
				'minimizable',
				'status'
			],
			regexp = new RegExp();
		for (var i in features)
			if (this.getPref('dom.disable_window_open_feature.'+features[i])) {
				flags = flags.replace(regexp.compile(features[i]+'=(0|false|no)?,?', 'gi'), '');
				if (flags.indexOf(features[i]) < 0)
					flags = flags ? flags + ',' + features[i] : features[i] ;
			}

		return flags;
	},
 
	newWindowSetTimeout : function() 
	{
		var w     = this,
			exp   = arguments[0],
			delay = arguments[1],
			args  = [],
			TS    = TabbrowserService;
		if (arguments.length > 2)
			for (var i = 2; i < arguments.length; i++)
				args.push(arguments[i] ? arguments[i].toSource() : arguments[i] );

		args = args.length ? args.join(',') : '' ;

		var popupState = TS.openAbused;
		if (
			!w.__tabextensions__runningTimeoutDepth &&
			w.__tabextensions__popupControlState < TS.openAbused &&
			delay <= Math.max(Number(TS.getPref('dom.disable_open_click_delay')), 0)
			) {
			popupState = w.__tabextensions__popupControlState;
		}
		if (TS.debug) dump('TBE blocks delayed popup: '+delay+'msec DELAYED\n');

		var runTimeout = function() {
			++w.__tabextensions__runningTimeoutDepth;
			w.__tabextensions__popupState = popupState;
			try {
				if (typeof exp == 'function')
					eval('exp('+args+')');
				else
					eval(exp);
			}
			catch(e) {
			}
			--w.__tabextensions__runningTimeoutDepth;
			delete w.__tabextensions__popupState;
		};

		return eval('this.__tabextensions__setTimeout(runTimeout, delay)');
	},
 
	newWindowSetInterval : function() 
	{
		var w     = this,
			exp   = arguments[0],
			delay = arguments[1],
			args  = [],
			TS    = TabbrowserService;
		if (arguments.length > 2)
			for (var i = 2; i < arguments.length; i++)
				args.push(arguments[i] ? arguments[i].toSource() : arguments[i] );

		args = args.length ? args.join(',') : '' ;

		var popupState = TS.openAbused;
		if (
			!w.__tabextensions__runningTimeoutDepth &&
			w.__tabextensions__popupControlState < TS.openAbused &&
			delay <= Math.max(Number(TS.getPref('dom.disable_open_click_delay')), 0)
			) {
			popupState = w.__tabextensions__popupControlState;
		}
		if (TS.debug) dump('TBE blocks delayed popup: '+delay+'msec DELAYED\n');

		var runTimeout = function() {
			++w.__tabextensions__runningTimeoutDepth;
			w.__tabextensions__popupState = popupState;
			try {
				if (typeof exp == 'function')
					eval('exp('+args+')');
				else
					eval(exp);
			}
			catch(e) {
			}
			--w.__tabextensions__runningTimeoutDepth;
			delete w.__tabextensions__popupState;
		};

		return eval('this.__tabextensions__setInterval(runTimeout, delay)');
	},
  
	openBrowserTab : function(aURI, aName, aFlags, aSourceURI) 
	{
		var contextWindow = this.document.defaultView;
		if (!contextWindow) contextWindow = this;

		var TS  = window.TabbrowserService;
if (TS.debug) dump('newWindowOpen/openBrowserTab ('+aURI+')\n');

		var abuseLevel = TS.checkForAbusePoint({
				window    : contextWindow,
				XULwindow : window,
				now       : (new Date()).getTime(),
				uri       : aURI,
				source    : sourceURI
			});

if (TS.debug) dump('   abuse level: '+abuseLevel+'\n');
		if (!TS.checkOpenAllow(abuseLevel, aName, contextWindow)) {
if (TS.debug) dump('   blocked\n');
			TS.fireAbuseEvents(
				true,
				false,
				{
					window    : contextWindow,
					uri       : aURI,
					flags     : aFlags
				}
			);
			return {};
		}

		var retVal = TS.openBrowserTabInternal(contextWindow, aURI, aName, aFlags, aSourceURI);

		if (abuseLevel >= TS.openAbused)
			TS.fireAbuseEvents(
				false,
				true,
				{
					window : contextWindow
				}
			);

if (TS.debug) dump('   allowed\n');

		return retVal;
	},
	openBrowserTabInternal : function(aContextWindow, aURI, aName, aFlags, aSourceURI)
	{
		var uri = aURI || 'about:blank' ;
		var event;
		var i;

		if  ( // when should not open tab
			'shouldOpenBrowserTab' in aContextWindow &&
			!aContextWindow.shouldOpenBrowserTab(uri, aName, aFlags)
			) {
//			dump('tabextensions:window.open is rejected\n');
			return null;
		}

		this.uriSecurityCheck(uri, aSourceURI);

		var name = !aName ? '_blank' : String(aName) ;
		aFlags = this.applyFlagsPermission(aFlags);

		var w = null;


		var b = this.browser,
			browser,
			parentTab;
		var loadInBackground = this.getPref('browser.tabs.extensions.loadInBackgroundJS');

		// prevent to open same URI
		if (this.preventSameURLTab) {
			if (b.selectedTab.mTabInfo.loadingURI == uri)
				return b.selectedTab.mBrowser.contentDocument.defaultView;

			for (i in b.mTabs)
			{
				if (b.mTabs[i].mTabInfo.loadingURI != uri) continue;

				this.popupAlert(this.strbundle.GetStringFromName('status_same_uri_tab_exists'));

				if (!loadInBackground) {
					b.selectedTab = b.mTabs[i];
					b.scrollTabbarTo(b.selectedTab);
					b.setFocusInternal();
				}
				return b.mTabs[i].mBrowser.contentDocument.defaultView;
			}
		}

		var topWin = Components.lookupMethod(aContextWindow, 'top').call(aContextWindow);
		for (i in b.mTabs)
			if (b.mTabs[i].mBrowser.contentDocument.defaultView == topWin)
				parentTab = b.mTabs[i];

		var referrer = !parentTab || parentTab.referrerBlocked ? null : this.makeURIFromSpec(aSourceURI) ;

		// When a tab with the name exists, open in the tab.
		if (
			!this.getPref('browser.tabs.extensions.ignore_target') &&
			name.toLowerCase() != '_blank'
			) {
			for (i in b.mTabs)
			{
				browser = b.mTabs[i].mBrowser;

				if (b.mTabs[i].browserName != name &&
					browser.contentDocument.defaultView.name != name) continue;

				var realURI = this.getRealURI(uri);
				var bypassReferrerBlocker = realURI ? true : false ;
				if (realURI) uri = realURI;

				if (b.mTabs[i].mTabInfo.referrerBlocked || bypassReferrerBlocker)
					referrer = null;

	/*
				var postData = {};
				uri = getShortcutOrURI(uri, postData);
				browser.webNavigation.loadURI(
					uri,
					Components.interfaces.nsIWebNavigation.LOAD_FLAGS_NONE,
					referrer,
					('value' in postData ? postData.value : null ),
					null
				);
	*/
				browser.loadURI(uri, referrer);

				if (b.tabGroupsAvailable) b.attachTabTo(b.mTabs[i], parentTab, true);

				browser.contentDocument.defaultView.opener = aContextWindow;
				if (
					name &&
					!String(name).match(/^_(self|top|parent|content|blank)$/i) &&
					name != '_main'
					)
					browser.contentDocument.defaultView.name = name;

	//			dump('tabextensions:window.open is redirected to existing tab:'+uri+'\n');

				return browser.contentDocument.defaultView;
			}
		}


		var info = {
				browserName   : name,
				openedFromTab : true
			};

		// inherit status
		if (
			parentTab &&
			(
				!this.getPref('browser.tabs.extensions.inherit.onlySameSite') ||
				this.isSameHost(uri, aSourceURI)
			)
			) {
			var props = [];
			if(this.getPref('browser.tabs.extensions.inherit.textZoom'))
				props.push('textZoom');
			if (this.getPref('browser.tabs.extensions.inherit.locked'))
				props.push('locked');
			if (this.getPref('browser.tabs.extensions.inherit.referrerBlocked'))
				props.push('referrerBlocked');
			if (this.getPref('browser.tabs.extensions.inherit.allow'))
				props = props.concat([
						'allowPlugins',
						'allowJavascript',
						'allowMetaRedirects',
						'allowSubframes',
						'allowImages'
					]);
			if (props.length) {
				for (i in props)
					info[props[i]] = parentTab[props[i]];
				info.uri = uri;
			}
		}

		var t = b.addTabInternal(uri, referrer, info);
		if (!t) return null;


		if (parentTab)
			b.attachTabTo(t, parentTab, true);


		if (!loadInBackground) {
			b.selectedTab = t;
			b.scrollTabbarTo(b.selectedTab);
			b.setFocusInternal();
		}

		w = t.mBrowser.contentDocument.defaultView;

		w.opener = aContextWindow;
		if (
			name &&
			!String(name).match(/^_(self|top|parent|content|blank)$/i) &&
			name != '_main'
			)
			w.name = name;

		return w;
	},
 
	shouldOpenBrowserTab : function(aURI, aName, aFlags) 
	{
		var topWin = ('Components' in window && 'lookupMethod' in Components) ? Components.lookupMethod(this, 'top').call(this) : this.top ;

		var inContent = this && topWin != Components.lookupMethod(window, 'top').call(window);


		/*
			The original mean of this pref is, to parse the link pref
			"browser.link.open_newwindow" for "window.open()" or not.
			Default value "2" means "parse only for popups with no option".
			"0" means "parse for any popup".
			"1" means "don't parse for any popup".

			TBE uses this pref like as a boolean pref (2 or not) because
			links and popups are controlled separately by default in TBE.
		*/
		var restrictionPref = window.TabbrowserService.getPref('browser.link.open_newwindow.restriction');
		if (restrictionPref === null) restrictionPref = 2;
		switch(restrictionPref)
		{
			case 0: // same to link
				break;

			case 1: // ignore link pref
				break;

			default: // ignore only for popups with options
			case 2:
				if (
					aFlags &&
		//			String(aFlags).match(/(^|,)(width|height)=[0-9]*/i) &&
					window.TabbrowserService.winHookMode != 2
					)
					return false;
				break;
		}


		return (
			(
				!inContent &&
				(!aURI || !aURI.match(/^chrome:/)) && // not-registered resources
				(
					// unrequested open in single window mode
					window.TabbrowserService.winHookMode == 2 ||
					( // unrequested open in XUL windows
						window.TabbrowserService.winHookMode == 1 &&
						window.document.documentElement.namespaceURI != window.TabbrowserService.XULNS
					)
				)
			) ||
			// window.open of content windows
			(
				inContent &&
				(
					TabbrowserService.getPref('browser.tabs.extensions.ignore_target') ||
					!TabbrowserService.getFrameByName(topWin, aName, this)
				) &&
				(
					(window.TabbrowserService.winHookMode == 1 && this.document.tabbrowserReadyState != 'complete') ||
					window.TabbrowserService.winHookMode == 2 ||
					!window.TabbrowserService.shouldPopupWindowForURI(aURI, this)
				)
			)
			);

/*
		alert(
			['(',
			'    (!inContent [['+!inContent+']] &&',
			'    (!aURI || !aURI.match(/^chrome:/)) [['+(!aURI || !aURI.match(/^chrome:/))+' &&',
			'    (',
			'       window.TabbrowserService.winHookMode == 2 [['+(window.TabbrowserService.winHookMode == 2)+']] ||',
			'        (',
			'           window.TabbrowserService.winHookMode == 1 [['+(window.TabbrowserService.winHookMode == 1)+']] &&',
			'           window.document.documentElement.namespaceURI != window.TabbrowserService.XULNS [['+(window.document.documentElement.namespaceURI != window.TabbrowserService.XULNS)+']]',
			'       )',
			'    )',
			') ||',
			'(',
			'inContent [['+inContent+']] &&',
			'!TabbrowserService.getFrameByName(topWin, aName, this) [['+!TabbrowserService.getFrameByName(topWin, aName, this)+']] &&',
			'   (',
			'       (window.TabbrowserService.winHookMode == 1 && this.document.tabbrowserReadyState != \'complete\') [['+(window.TabbrowserService.winHookMode == 1 && this.document.tabbrowserReadyState != 'complete')+']] ||',
			'       window.TabbrowserService.winHookMode == 2 [['+(window.TabbrowserService.winHookMode == 2)+']] ||',
			'       !window.TabbrowserService.shouldPopupWindowForURI(aURI) [['+!window.TabbrowserService.shouldPopupWindowForURI(aURI)+']]',
			'   )',
			')'
		].join('\n'));
*/
	},
 
	shouldPopupWindowForURI : function(aURI, aWindow) 
	{
		var defaultAllowed = !(
				this.opentabforJS ||
				this.winHookMode == 2 ||
				(
					this.winHookMode == 1 &&
					aWindow &&
					aWindow.document.tabbrowserReadyState != 'complete'
				)
			);

		if (aURI) {
			var ex = defaultAllowed ? this.JSWindowOpenExceptionsBlack : this.JSWindowOpenExceptionsWhite ;
			for (var i = 0; i < ex.length; i++)
				if (aURI.indexOf(ex.getData(ex.item(i), 'Rule')) > -1)
					return !defaultAllowed;
		}

		return defaultAllowed;
	},
 
	newOpenDialog : function() 
	{
		var uri = arguments.length ? arguments[0] : null ;
		var TS  = TabbrowserService;

		if (uri == TS.browserURI &&
			TS.winHookMode == 2 &&
			TS.isBrowserWindow) {
			var documentURI = arguments.length > 2 ? arguments[3] : null ;
			var referrer = arguments.length > 4 ? arguments[5] : null ;
			TS.browserWindow.TabbrowserService.browser.addTab(documentURI, referrer);
			return window;
		}

		var args = [];
		for (var i = 0; i < arguments.length; i++)
			args.push('arguments['+i+']');

/*
		window.childWindows.push(eval('__tabextensions__openDialog('+args.join(', ')+')'));
		return window.childWindows[window.childWindows.length-1];
*/
		return eval('__tabextensions__openDialog('+args.join(', ')+')');
	},
  
	// TBE features 
	
	// Bookmarks 
	
	openBookmark : function(aID, aEvent, aOpenType) 
	{
try{
		if (// Ignored bookmark uris:
			!aID || // no URI, or functions
			aID.match(/bookmarks-button|BookmarksMenu|NC:PersonalToolbarFolder|innermostBox|(PT_)?bookmarks_groupmark|exBookmarks|bookmarks-menu|bookmarks-ptf|bookmarks-chevron|PersonalToolbar/i) || // Not a bookmark *item*
			// innermostBox is in NS7/Moz1.0. NC:Personal... is in 1.1.
			(aEvent && aEvent.type == 'click' && aEvent.button > 1) // right click or others
			) {
			return false;
		}

		var uri      = aID;
		var resource = null;
		try {
			resource = this.RDF.GetResource(uri);
		}
		catch(e) {
			return false;
		}

		var isLivemark       = this.isLivemark(resource);
		var livemarkBehavior = this.getPref('browser.tabs.extensions.livemark.behavior.onMiddleClick');

		// for bookmark groups
		var isFolder   = this.isBookmarkFolder(resource);
		var isGroup    = (aOpenType == 'folder-as-group' && isFolder) || (isLivemark && livemarkBehavior == 3) || this.isBookmarkGroup(resource);
		var shouldOpenAsGroup = (aOpenType == 'folder-as-group') || (isLivemark && isGroup) || this.shouldOpenBookmarkGroup(resource);
//dump('GROUP: '+isGroup+', Folder: '+isFolder+'\n');
		if (!isGroup && !isFolder) {
			try { // for IE favorites, etc.
				var target = this.BookmarksDS.GetTarget(
						resource,
						this.kNC_URL,
						true
					);
				if (!target) return false;
				target = target.QueryInterface(this.knsIRDFLiteral).Value;
				if (target) uri = target;
			}
			catch (e) {
				return false;
			}
		}


		var usetab       = this.opentabforBookmarks,
			usetab_force = this.getPref('browser.tabs.opentabfor.anybookmark');

		if (isLivemark)
			usetab = usetab_force = (livemarkBehavior == 1) || (livemarkBehavior == 2);


		var w = this.browserWindow;
		var b = w ? w.TabbrowserService.browser : null ;

		var middleClick = aEvent &&
					(
						(aEvent.type == 'click' && aEvent.button == 1) ||
						(
							(
								(aEvent.type == 'click' && aEvent.button == 0) ||
								aEvent.type == 'command'
							) &&
							(
								aEvent.ctrlKey || aEvent.metaKey
							)
						)
					);


		var openIn = 'current';
		if (aOpenType && aOpenType != 'folder-as-group')
			openIn = aOpenType;
		else {
			if (
				/*!uri.match(/^NC:/) &&*/ !uri.match(/^javascript:/i) &&
				(usetab_force || (usetab && middleClick))
				) {
				// VK^uJŁAubN}[NJĂ悢ꍇ
				// Open the bookmark in new tabs
				// O
				// Exception
				if (
					usetab_force &&
					(
						(middleClick && !isLivemark) || // ɐVK^uŊJݒ̎́At]
						(
							b &&
							b.mCurrentBrowser.currentURI.spec == 'about:blank'
						) ||
						(
							b &&
							b.selectedTab.isReallyBlank &&
							this.reuseCurrentBlankTab
						)
					)
					)
					openIn = 'current';
				else
					openIn = 'tab';
			}
			else if (!aEvent || aEvent.type == 'command' || aEvent.button == 0)
				// VK^uJȂŁAubN}[NJĂ悢ꍇ
				// Open the bookmark in the current tab
				openIn = 'current';
/*
if (aEvent)
	alert([
		'type  : '+aEvent.type,
		'key   : '+aEvent.keyCode,
		'ctrl  : '+aEvent.ctrlKey,
		'shift : '+aEvent.shiftKey,
		'alt   : '+aEvent.altKey,
		'meta  : '+aEvent.metaKey
	].join('\n'));
*/
			if (openIn == 'tab' && aEvent && aEvent.shiftKey)
				openIn = 'window';

			if (openIn == 'current' && aEvent && aEvent.altKey)
				openIn = 'properties';

			if (openIn == 'window' && this.winHookMode == 2)
				openIn = 'tab';
		}

		if (!w && openIn != 'properties')
			openIn = 'window';


		// load stored data for the bookmark
		var referrer   = this.getReferrerForBookmark(aID) || null ;
		var info       = {
				uri        : uri,
				fixedLabel : this.getFixedLabelForBookmark(aID),
				textZoom   : this.getTextZoomForBookmark(aID),
				bookmarkID : aID
			};

		if (!info.fixedLabel && this.getPref('browser.tabs.extensions.show_link_text_as_label')) {
			var name = this.getNameForBookmark(aID) || '';
			info.fixedLabelAutoDestroy = true;
			info.fixedLabel = this.strbundle.GetStringFromName('loading_temp_label').replace(/%s/gi, name).replace(/\s+/g, ' ');
			if (this.getPref('browser.tabs.extensions.show_link_text_as_label_permanently'))
				info.fixedLabelOnLoad = name;
		}

		if (this.shouldSaveBookmarksStatus)
			info = this.loadBookmarkStatus(aID, info);

		var reloadTab = null;
		if (this.preventSameURLTab) {
			var tabs = b.mTabs;
			for (var i in tabs)
				if (tabs[i].mTabInfo.loadingURI == uri) {
					this.popupAlert(this.strbundle.GetStringFromName('status_same_uri_tab_exists'));
					reloadTab = tabs[i];
					break;
				}
		}

}
catch(e) {
		if (this.debug) alert('FAILED TO OPEN A BOOKMARK:\n\n'+e);
		return false;
}

		// to avoid popup blocking...
		if (uri.match(/javascript:/))
			uri = 'javascript:void(window.__tabextensions__triggerByUser = true);'+uri.replace(/^javascript:/i, '')+';void(delete window.__tabextensions__triggerByUser)';


		var loadInBackground = isLivemark ? (livemarkBehavior == 2) : this.getPref('browser.tabs.extensions.loadInBackgroundBookmarks') ;

		switch (openIn)
		{
			case 'current':
			default:
				// web panels (Firefox)
				if (
					'BookmarksCommand' in window &&
					this.BookmarksDS.GetTarget(
						resource,
						this.kNC_WebPanel,
						true
					) &&
					'openWebPanel' in BookmarksCommand
					) {
					BookmarksCommand.openWebPanel(resource, this.BookmarksDS);
					return true;
				}

				if (shouldOpenAsGroup)
					if (isGroup || (usetab_force && middleClick)) {
						this.openBookmarkGroup(resource, this.BookmarksDatabase);
						return true;
					}
					else
						return false;
				else if (isFolder)
					return false;

				if (reloadTab) {
					reloadTab.mBrowser.reload();
					if (!loadInBackground) {
						b.selectedTab = reloadTab;
						b.scrollTabbarTo(b.selectedTab);
						reloadTab.mBrowser.contentDocument.defaultView.focus();
					}
					break;
				}

				b.mCurrentBrowser.loadURI(uri, referrer);
				b.initTabWithTabInfo(b.selectedTab, info, uri);

				if (w == window || !this.loadInBackgroundWindow) {
					w.focus();
					w.setTimeout('_content.focus();', 0);
				}

				break;

			case 'tab':
			case 'newactivetab':
				if (shouldOpenAsGroup) {
					this.openBookmarkGroup(resource, this.BookmarksDatabase);
					return true;
				}
				else if (isFolder)
					return false;

				var newTab;
				if (reloadTab) {
					reloadTab.mBrowser.reload();
					newTab = reloadTab;
				}
				else {
					newTab = b.addTabInternal(
							uri,
							referrer,
							info
						);
				}
				if (!loadInBackground || openIn == 'newactivetab') {
					b.selectedTab = newTab;
					b.scrollTabbarTo(b.selectedTab);
				}

				if (w == window || !this.loadInBackgroundWindow) {
					w.focus();
					w.setTimeout('_content.focus();', 0);
				}

				break;

			case 'window':
				if (shouldOpenAsGroup)
					return false;
				else if (isFolder)
					return false;
				else
					window.openDialog(
						this.browserURI,
						'_blank',
						'chrome,all,dialog=no',
						uri,
						null,
						referrer,
						info
					).addEventListener(
						'load',
						function()
						{
							var b = TabbrowserService.browser;
							b.initTabWithTabInfo(b.selectedTab, window.arguments[3]);
						},
						false
					);
				break;

			case 'properties':
				if (this.isNewTypeBrowser) // Firefox
					window.openDialog('chrome://browser/content/bookmarks/bookmarksProperties.xul', '', 'centerscreen,chrome,resizable=no', aID, {});
				else
					window.openDialog('chrome://communicator/content/bookmarks/bm-props.xul', '', 'centerscreen,chrome,dialog=no,resizable=no,dependent', aID, {});
				break;
		}

		return true;
	},
	
	// ubN}[NtH_ǂׂ 
	// is the bookmark item only a folder?
	isBookmarkFolder : function(aResource)
	{
		try {
			var type = this.BookmarksDatabase.GetTarget(
					aResource,
					this.RDF.GetResource('http://www.w3.org/1999/02/22-rdf-syntax-ns#type'),
					true
				);
			if (type) {
				type = type.QueryInterface(this.knsIRDFResource).Value;
				return (type == 'http://home.netscape.com/NC-rdf#Folder');
			}
		}
		catch(e) {
		}

		return false;
	},
 
	// ubN}[NO[vǂׂ 
	// is the bookmark item a group?
	isBookmarkGroup : function(aResource)
	{
		try {
			var isGroupLiteral = this.BookmarksDatabase.GetTarget(
					aResource,
					this.RDF.GetResource('http://home.netscape.com/NC-rdf#FolderGroup'),
					true
				);
			if (isGroupLiteral) {
				isGroupLiteral = isGroupLiteral.QueryInterface(this.knsIRDFLiteral).Value;
				return (isGroupLiteral == 'true');
			}
		}
		catch(e) {
		}

		return false;
	},
 
	shouldOpenBookmarkGroup : function(aResource) 
	{
		var folderAsGroup = this.getPref('browser.tabs.opentabfor.bookmarks_folder_as_group');
		return (folderAsGroup) ? this.isBookmarkFolder(aResource) : this.isBookmarkGroup(aResource) ;
	},
 
	// Cu}[Nǂׂ 
	// is the bookmark item a livemark?
	isLivemark : function(aResource)
	{
		try {
			var type = this.BookmarksDatabase.GetTarget(
					aResource,
					this.RDF.GetResource('http://www.w3.org/1999/02/22-rdf-syntax-ns#type'),
					true
				);
			if (type) {
				type = type.QueryInterface(this.knsIRDFResource).Value;
				return (type == 'http://home.netscape.com/NC-rdf#Livemark');
			}
		}
		catch(e) {
		}

		return false;
	},
  
	openBookmarkGroup : function(aResourceOrID, aDataSource, aRDF, aCalled) // aRDF is ignored 
	{
try {
		var TS = TabbrowserService;
		var w  = TS.browserWindow;
		var i;

		var containerRes;
		try {
			containerRes = aResourceOrID.QueryInterface(TS.knsIRDFResource);
		}
		catch(e) {
			if (typeof aResourceOrID == 'string')
				containerRes = TS.RDF.GetResource(aResourceOrID);
			else
				return;
		}

		if (!aDataSource) aDataSource = TS.BookmarksDS;


		var RDFC   = Components.classes['@mozilla.org/rdf/container;1'].getService(Components.interfaces.nsIRDFContainer);
		RDFC.Init(aDataSource, containerRes);

		var items = RDFC.GetElements(),
			item,
			uri,
			referrer;
		var b = w ? w.TabbrowserService.browser : null ;
		var nextIndex = b ? b.mTabs.length : 0 ; // ɃANeBuɂ^u̔ԍ
		var rootTab = b ? b.mTabs[0] : null ;

		var isGroupMode = TS.isGroupMode;
		var shouldOpenAsGroup = isGroupMode && TS.getPref('browser.tabs.extensions.group.open_bookmarkgroup_as_group');

		var shouldResutoreStatus = TS.shouldSaveBookmarksStatus;
		var loadInBackground = TS.getPref('browser.tabs.extensions.loadInBackgroundBookmarks');
		var groupBehavior = TS.bookmarkGroupBehavior;
		var preventSame = TS.preventSameURLTab;

		if (isGroupMode)
			rootTab = b.selectedTab.parentTab || b.selectedTab;

		// SẴ^uNAꍇ
		// Clear all tabs before opening a bookmark-group
		if ((groupBehavior == 10 || groupBehavior == 11) && !aCalled) {
			if (b) {
				var shouldMakeBackLog = false,
					removedTabsInfo   = [];
				if ('replaceGroup' in b)
					for (i in b.mTabs)
						removedTabsInfo.push(b.getTabInfo(b.mTabs[i]));

				if (isGroupMode && groupBehavior == 11) {
					var children = rootTab.allChildTabs;
					if (children.length) {
						for (i = children.length-1; i > -1; i--)
							b.removeTabInternal(children[i]);
					}
					else {
						rootTab = b.removeAllTabsButInternal(b.addTab('about:blank'), { preventUndo : true });
						shouldMakeBackLog = true;
					}
				}
				else {
					rootTab = b.removeAllTabsButInternal(b.addTab('about:blank'), { preventUndo : true });
					shouldMakeBackLog = true;
				}

				if (shouldMakeBackLog && 'replaceGroup' in b) {
					b.backBrowserGroup    = removedTabsInfo;
					b.forwardBrowserGroup = [];
				}
			}

			loadInBackground = false;
		}


		var t,
			info,
			parentTab,
			firstTab,
			reloaded,
			index = 0;

		var shouldShowTempLabel = TS.getPref('browser.tabs.extensions.show_link_text_as_label');
		var openIn = this.getPref('browser.tabs.extensions.open_tab_in_link');

//if (TS.debug) dump('Open livemark as group ('+containerRes.Value+')\n');

		while (items.hasMoreElements())
		{
			item = items.getNext().QueryInterface(TS.knsIRDFResource);

			// ċAőSẴubN}[NJ
			// open all bookmarks in the folder reflexively
			if (TS.shouldOpenBookmarkGroup(item) &&
				TS.getPref('browser.tabs.extensions.bookmarks.open_child_folders')) {
				TS.openBookmarkGroup(item, aDataSource, null, true);
				continue;
			}

			uri = aDataSource.GetTarget(item, TS.kNC_URL, true);
			if (!uri) continue;
			uri = uri.QueryInterface(TS.knsIRDFLiteral).Value;
//if (TS.debug) dump('  livemark: '+uri+'\n');
//			dump('Open Bookmark Group: '+uri+'\n');


			if (isGroupMode) {
				if (!index) { // first item
					if (groupBehavior || shouldOpenAsGroup)
						parentTab = (groupBehavior == 1 || (groupBehavior == 21 && rootTab.hasChildTabs())) ? rootTab : null ;
					else
						parentTab = null;
				}
				else if ( // exception
						(
						groupBehavior == 10 || groupBehavior == 11 ||
						((groupBehavior == 20 || groupBehavior == 21) && !rootTab.hasChildTabs())
						) &&
						!shouldOpenAsGroup
					) {
					parentTab = null;
				}
				else if (groupBehavior || shouldOpenAsGroup)
					parentTab = rootTab;
			}

			info = {
				uri        : uri,
				parentTab  : (parentTab ? parentTab.tabId : null ),
				bookmarkID : item.Value,
				inGroup    : true,
				fixedLabel : TS.getFixedLabelForBookmark(item.Value),
				textZoom   : TS.getTextZoomForBookmark(item.Value),
				openIn     : openIn
			};
			if (shouldShowTempLabel && !info.fixedLabel) {
				info.fixedLabel = TS.strbundle.GetStringFromName('loading_temp_label').replace(/%s/gi, TS.getNameForBookmark(item.Value) || '').replace(/\s+/g, ' ');
				info.fixedLabelAutoDestroy = shouldShowTempLabel;
			}

			if (shouldResutoreStatus)
				info = TS.loadBookmarkStatus(item.Value, info);

			referrer = TS.getReferrerForBookmark(item.Value);


			reloaded = false;
			if (preventSame) {
				for (i = 0; i < b.mTabs.length; i++)
					if (b.mTabs[i].mTabInfo.loadingURI == uri) {
						TS.popupAlert(TS.strbundle.GetStringFromName('status_same_uri_tab_exists'));
						b.mTabs[i].mBrowser.reload();
						t = b.mTabs[i];
						reloaded = true;
					}
			}

			if (!reloaded) {
				if (!w || !b) {
					info.parentTab = info.parentTab ? true : false ;
					TS.overflowingTabsManager.addTab(uri, referrer, info);
					t = null;
				}
				else if (
						!index &&
						!aCalled &&
						(
							groupBehavior == 10 || // when the group replaces existing tabs
							groupBehavior == 11 ||
							( // if the tab is "about:blank", load the first bookmark in the tab
								(
									b.selectedTab.isReallyBlank ||
									(
										b.mCurrentBrowser.currentURI.spec == 'about:blank' &&
										b.mCurrentBrowser.contentDocument.tabbrowserReadyState == 'complete'
									)
								) &&
								TS.reuseCurrentBlankTab
							) ||
							( // when the group replaces existing tab when only one tab is open
								(
									groupBehavior == 20 ||
									groupBehavior == 21
								) &&
								(
									b.mTabs.length == 1 ||
									(
										TS.isGroupMode &&
										!rootTab.hasChildTabs()
									)
								)
							)
						)
					) {
					nextIndex = rootTab.tabIndex;

					rootTab.mBrowser.loadURI(uri, referrer);
					b.initTabWithTabInfo(rootTab, info, uri);
					if (parentTab || shouldOpenAsGroup)
						rootTab.parentTab = parentTab;

					t = rootTab;
				}
				else {
					t = b.addTabInternal(
						uri,
						referrer,
						info
					);
				}
			}

			if (!index) {
				firstTab = t;

				switch (this.getPref('browser.tabs.extensions.open_tab_in_link'))
				{
					case 1:
						openIn = 0;
						break;
					case 2:
					default:
						openIn = 3;
						break;
				}

				if (isGroupMode) {
					// ŏ̃^uV[g^uɂ
					// set new root tab
					if (shouldOpenAsGroup)
						rootTab = t || true ; // "true" is for overflowed tabs

					if (t &&
						(groupBehavior || shouldOpenAsGroup) &&
						!t.parentTab)
						t.removeAttribute('tab-color');
				}
			}

			index++;
		}

		// ubN}[NO[vsȏꍇAȂB
		// Invalid bookmark-group is ignored.
		if (!index) return;

		// ubN}[NO[v̍ŏ̃^uI
		// Select the first tab of group.
		if (b && !loadInBackground && !aCalled) {
			b.selectedTab = b.mTabs[nextIndex];
			b.scrollTabbarTo(b.selectedTab);
			b.setFocusInternal();
		}

		if (
			b && !aCalled &&
			(!groupBehavior || groupBehavior == 10 || groupBehavior == 11)
			)
			firstTab.shouldPurgeChildren = true;

		if (w == window || !TS.loadInBackgroundWindow) {
//			w.focus();
//			w.setTimeout('_content.focus();', 0);
			b.focus();
		}

		return;
}
catch(e) {
		if (this.debug) alert('FAILED TO OPEN A BOOKMARK GROUP:\n\n'+e);
		return;
}
	},
 
	// make bookmark-group from tab-group 
	bookmarkTabGroup : function(aTab, aShouldBookmarkAllTabs)
	{
		if (!aTab || aTab.localName != 'tab')
			aTab = this.browser.selectedTab;

		var tabs;
		var highlightWithTabTree = true;
		if (aShouldBookmarkAllTabs) {
			tabs = this.browser.mTabs;
		}
		else {
			tabs = aTab.sameColorGroup;
			if (tabs.length == 1) {
				if (!aTab.hasChildTabs() && aTab.parentTab)
					aTab = aTab.parentTab;
				tabs = aTab.allChildTabs;
				tabs.unshift(aTab);
			}
			else
				highlightWithTabTree = false;
		}
		if (!tabs.length) return;

		tabs = tabs.sort(this.browser.conpareTabOrder);

		var info = [],
			b;
		for (var i in tabs)
		{
			b = tabs[i].mBrowser;
			try {
				doc = b.contentDocument;
			}
			catch(e) {
				doc = null;
			}
			info[i] = {
				name    : (doc ? doc.title : '' ) || b.currentURI.spec,
				url     : b.currentURI.spec,
				charset : (doc ? doc.characterSet : null )
			};
		}

		var currentInfo = info[0];
		currentInfo.forceToGroup = true;

		if (highlightWithTabTree)
			this.browser.highlightGroupFromTab(aTab, true, true);
		else
			this.browser.highlightTabs({ brothers: tabs }, true);

		// show modal dialog because we have to highligh the group of tabs while dialog is open
		if (!this.isNewTypeBrowser)
			window.openDialog(
				'chrome://communicator/content/bookmarks/addBookmark.xul',
				'',
				'modal,centerscreen,chrome,dialog,resizable,dependent',
				currentInfo.name,
				currentInfo.url,
				null,
				currentInfo.charset,
				'addGroup,group',
				info
			);
		else
			window.openDialog(
				'chrome://browser/content/bookmarks/addBookmark2.xul',
				'',
				'modal,centerscreen,chrome,dialog,resizable,dependent',
				currentInfo.name,
				currentInfo.url,
				null,
				currentInfo.charset,
				'addGroup,group',
				info
			);

		this.browser.cancelHighlight();
	},
 
	saveBookmarkStatus : function(aTabBrowser, aTab, aEntry) 
	{
		if (!aTabBrowser || !aTab || !aEntry ||
			!aTab.mTabInfo.bookmarkID ||
			aTab.mTabInfo.bookmarkURI != aTab.mTabInfo.loadingURI ||
			!this.isBookmarked(aTab.mTabInfo.bookmarkID))
			return;

		var id  = this.RDF.GetResource(aTab.mTabInfo.bookmarkID).Value;

		var desc = this.loadBookmarkStatusInternal(id) || '' ;
		desc = desc.split('\n');
		if (!desc.length) desc = desc[0].split('\r');
		var info = {};
		for (var i in desc)
		{
			desc[i] = desc[i].split('=');
			if (!desc[i][0]) continue;
			info[desc[i][0]] = desc[i][1];
		}


		if (aEntry == 'fixedLabel') {
			if (!aTab.mTabInfo.fixedLabel) {
				if ('useFixedLabel' in info) delete info.useFixedLabel;
			}
			else
				info.useFixedLabel = true;
		}
		else if (aEntry == 'textZoom') {
			if (!this.getPref('browser.tabs.extensions.bookmarks.save_textZoom')) return;

			var zoom = parseInt(aTab.mBrowser.markupDocumentViewer.textZoom*100);
			if (zoom == 100)
				delete info.textZoom;
			else
				info.textZoom = zoom;
		}
		else if (this.shouldSaveBookmarksStatus) {
			var enabledByDefault;

			if (aEntry == 'locked') {
				enabledByDefault = this.getPref('browser.tabs.extensions.locked.enabled');
				if (
					(
						enabledByDefault &&
						aTab.getAttribute('tab-locked')
					) ||
					(
						!enabledByDefault &&
						!aTab.getAttribute('tab-locked')
					)
					) {
					if ('locked' in info) delete info.locked;
				}
				else if (enabledByDefault &&
						!aTab.getAttribute('tab-locked'))
					info.locked = false;
				else if (!enabledByDefault &&
						aTab.getAttribute('tab-locked'))
					info.locked = true;
			}
			else if (aEntry == 'referrerblocked') {
				enabledByDefault = this.getPref('browser.tabs.extensions.referrerBlocked.enabled');
				if (
					(
						enabledByDefault &&
						aTab.getAttribute('tab-referrerblocked')
					) ||
					(
						!enabledByDefault &&
						!aTab.getAttribute('tab-referrerblocked')
					)
					) {
					if ('referrerBlocked' in info) delete info.referrerBlocked;
				}
				else if (enabledByDefault &&
						!aTab.getAttribute('tab-referrerblocked'))
					info.referrerBlocked = false;
				else if (!enabledByDefault &&
						aTab.getAttribute('tab-referrerblocked'))
					info.referrerBlocked = true;
			}
			else if (aEntry == 'autoreload') {
				if (!aTab.getAttribute('tab-autoreload') ||
					!aTab.mTabInfo.autoReloadInterval) {
					if ('autoreloadInterval' in info)
						delete info.autoreloadInterval;
					if ('autoreloadPostType' in info)
						delete info.autoreloadPostType;
					if ('autoreloadPostData' in info)
						delete info.autoreloadPostData;
				}
				else {
					info.autoreloadInterval = aTab.mTabInfo.autoReloadInterval;
					if (aTab.mTabInfo.autoReloadPostData) {
						info.autoreloadPostType = aTab.mTabInfo.autoReloadPostData.contentType;
						info.autoreloadPostData = this.escape(aTab.mTabInfo.autoReloadPostData.content || '' );
					}
				}
			}
			else if (
					aEntry.match(/^allow/) &&
					this.shouldSaveBookmarksPermissions
					) {
				var allowProps = {
						// <property>      : <enabled by default>
						allowPlugins       : this.getPref('browser.tabs.extensions.allowPlugins.enabled'),
						allowJavascript    : this.getPref('browser.tabs.extensions.allowJavascript.enabled'),
						allowMetaRedirects : this.getPref('browser.tabs.extensions.allowMetaRedirects.enabled'),
						allowSubframes     : this.getPref('browser.tabs.extensions.allowSubframes.enabled'),
						allowImages        : this.getPref('browser.tabs.extensions.allowImages.enabled')
					};

				if (
					(
						allowProps[aEntry] &&
						aTab.mBrowser.docShell[aEntry]
					) ||
					(
						!allowProps[aEntry] &&
						!aTab.mBrowser.docShell[aEntry]
					)
					) {
					if (aEntry in info) delete info[aEntry];
				}
				else if (allowProps[aEntry] &&
						!aTab.mBrowser.docShell[aEntry])
					info[aEntry] = false;
				else if (!allowProps[aEntry] &&
						aTab.mBrowser.docShell[aEntry])
					info[aEntry] = true;
			}

		}

		this.saveBookmarkStatusInternal(id, info);
	},

	saveBookmarkStatusInternal : function(aBookmarkID, aInfo)
	{
		if (!this.isBookmarked(aBookmarkID)) return;
		var res  = this.RDF.GetResource(aBookmarkID);
		var desc = this.createNewBookmarkDescription(aBookmarkID, aInfo);
		var old  = this.BookmarksDS.GetTarget(res, this.kNC_DESC, true);
		if (old) {
			old = old.QueryInterface(this.knsIRDFLiteral);
			this.BookmarksDS.Change(
				res,
				this.kNC_DESC,
				old,
				this.RDF.GetLiteral(desc),
				true
			);
		}
		else
			this.BookmarksDS.Assert(
				res,
				this.kNC_DESC,
				this.RDF.GetLiteral(desc),
				true
			);
	},

	createNewBookmarkDescription : function(aBookmarkID, aInfo, aOldDescription)
	{
		if (!this.isBookmarked(aBookmarkID)) return '';
		var res = this.RDF.GetResource(aBookmarkID);

		var newStatus = [];
		for (var i in aInfo) newStatus.push(i+'='+aInfo[i]);

		var desc = aOldDescription;
		if (aOldDescription === void(0)) {
			desc = this.BookmarksDS.GetTarget(res, this.kNC_DESC, true);
			desc = desc ? desc.QueryInterface(this.knsIRDFLiteral).Value : '' ;
		}

		newStatus = newStatus.length ? [
			this.kBookmarksCommentSep,
			this.kBookmarksInfoSepStart,
			newStatus.join('\n'),
			this.kBookmarksInfoSepEnd
		].join('\n') : '' ;


		if (!desc || desc.indexOf(this.kBookmarksInfoSepStart) < 0) {
			desc = [desc, newStatus].join('');
		}
		else {
			var before = desc.substring(
					0,
					desc.indexOf(
						desc.indexOf(this.kBookmarksCommentSep) < 0 ? this.kBookmarksInfoSepStart : this.kBookmarksCommentSep
					)
				);
			var after = desc.substring(
					desc.indexOf(
						this.kBookmarksInfoSepEnd
					)+this.kBookmarksInfoSepEnd.length+1
				);
			desc = [
				before,
				(before.length && newStatus ? '\n' : '' ),
				newStatus,
				(after.length && newStatus ? '\n' : '' ),
				after
			].join('');
		}

		return desc;
	},
  
	// Context Menu 
	
	// open selection links in tabs 
	openAllLinksInTabs : function(aShouldGrouping)
	{
		var links = this.getSelectionLinks();
		if (!links.length) return;

		var targetWindow = document.commandDispatcher.focusedWindow;
		if (!targetWindow || Components.lookupMethod(targetWindow, 'top').call(targetWindow) == window)
			targetWindow = window._content;

		var w = this.browserWindow;
		var b = w ? w.TabbrowserService.browser : null ;

		var isGroupMode = this.isGroupMode;
		var rootTab = (isGroupMode && b && w == window) ? (b.selectedTab.rootTab || b.selectedTab) : null ;

		var uri;
		var realURI;
		var referrer = (Components.lookupMethod(targetWindow, 'top').call(targetWindow) == b.contentDocument.defaultView && b.selectedTab.referrerBlocked) ? null : this.makeURIFromSpec(targetWindow.location.href) ;

		var i;

		if (b) {
			var t,
				info = {
					parentTab : (aShouldGrouping || !rootTab ? null : rootTab.tabId )
				},
				openIn = this.getPref('browser.tabs.extensions.open_tab_in_link');

			if (openIn > -1) info.openIn = openIn;

			var firstTab;
			for (i in links)
			{
				uri     = links[i].uri;
				realURI = this.getRealURI(uri);
				if (realURI) uri = realURI;

				if (
					i == 0 &&
					b.selectedTab.isReallyBlank &&
					this.reuseCurrentBlankTab
					) {
					t = b.selectedTab;
					t.mBrowser.loadURI(uri, realURI ? null : referrer );
					if (info.parentTab)
						t.parentTab = (typeof info.parentTab == 'string') ? b.getTabByTabId(info.parentTab) : info.parentTab ;
				}
				else {
					t = b.addTabInternal(uri, (realURI ? null : referrer ), info);
				}
				if (!t) continue; // if there is too many tabs, it can be canceled.

				if (i == 0) {
					firstTab = t;
					if (aShouldGrouping) info.parentTab = t.tabId;
					if ('openIn' in info) {
						switch (info.openIn)
						{
							case 1:
								info.openIn = 0;
								break;
							case 2:
								info.openIn = 3;
								break;
							default:
								break;
						}
					}
				}

				this.markLinkVisited(links[i].uri, links[i].node);
			}
			var loadInBackground = TabbrowserService.getPref('browser.tabs.extensions.loadInBackgroundLinks');
			if (firstTab) { // if there is too many tabs, it can be canceled.
				if (!loadInBackground) {
					b.selectedTab = firstTab;
					b.scrollTabbarTo(b.selectedTab);
					b.setFocusInternal();
				}
				if (aShouldGrouping)
					firstTab.shouldPurgeChildren = true;
			}
		}
		else {
			for (i in links)
			{
				uri     = links[i].uri;
				realURI = this.getRealURI(uri);
				if (realURI) uri = realURI;

				this.overflowingTabsManager.addTab(uri, (realURI ? null : referrer ), { parentTab : aShouldGrouping });
				this.markLinkVisited(links[i].uri, links[i].node);
			}
		}
	},
	
	// I͈͂̃NW 
	getSelectionLinks : function(aShouldRejectMailto)
	{
		var links = [];

		var targetWindow = document.commandDispatcher.focusedWindow;
		if (!targetWindow || targetWindow.top == window)
			targetWindow = window._content;

		var selection = targetWindow.getSelection();
		var selectionSource = selection ? this.getSelectionSource(targetWindow, null, selection) : null ;
		if (!selection ||
			!selection.rangeCount ||
			!selectionSource)
			return links;

		// if there seems to be no link, skip operations after this line.
		selectionSource = selectionSource.toLowerCase();
		if (selectionSource.search(/<([^:]+:)?a /) < 0 &&
			selectionSource.search(/<[^>]+href *= *['"]/) < 0)
			return links;

/*
// old implementation
		var range = targetWindow.document.createRange();
		if (selection.anchorNode == selection.focusNode ||
			selection.anchorNode.compareDocumentPosition(selection.focusNode) & Node.DOCUMENT_POSITION_FOLLOWING) {
			range.setStart(selection.anchorNode, selection.anchorOffset);
			range.setEnd(selection.focusNode, selection.focusOffset);
		}
		else {
			range.setStart(selection.focusNode, selection.focusOffset);
			range.setEnd(selection.anchorNode, selection.anchorOffset);
		}
*/

// getRangeAt() cancels the selection, so I cannot use this simple statement...
// NOTE: The problem in the comment above doesn't appear on lately Mozilla.
		const count = selection.rangeCount;
		var node,
			uri,
			isInRange;
		for (var i = 0; i < count; i++)
		{
			range = selection.getRangeAt(0);


			/*var*/ node = this.getParentLink(range.startContainer) || range.startContainer;
			/*var*/ uri;

			/*var*/ isInRange = (range.startContainer == range.endContainer) ?
								function(aNode) {
									return aNode != range.endContainer;
								} :
								function(aNode) {
									return range.endContainer.compareDocumentPosition(aNode) & Node.DOCUMENT_POSITION_PRECEDING
								} ;

			traceTree:
			do
			{
				if (this.isLinkNode(node)) {
					try { // sometimes fails when we click a string like URI in the end edge of block level elements. why?
						uri = this.makeURLAbsolute(node.baseURI, (node.getAttributeNS(this.XLinkNS, 'href') || node.getAttribute('href') || node.href || node));
						if ((!aShouldRejectMailto || !uri.match(/^mailto:/)) && uri)
							links.push({ node : node, uri : uri });
					}
					catch(e) {
					}
				}

				if (node.hasChildNodes()) {
					node = node.firstChild;
				}
				else {
					while (!node.nextSibling)
					{
						node = node.parentNode;
						if (!node) break traceTree;
					}
					node = node.nextSibling;
				}
	//			dump(node+' / '+node.localName+'\n');
			}
			while (isInRange(node));

//			range.detach();

		}


		return links;
	},
	getParentLink : function(aNode)
	{
		var node = aNode;
		while (!this.isLinkNode(node) && node.parentNode)
			node = node.parentNode;

		return this.isLinkNode(node) ? node : null ;
	},
	isLinkNode : function(aNode)
	{
		return (
				aNode.nodeType == Node.ELEMENT_NODE &&
				(
					aNode.getAttributeNS(this.XLinkNS, 'href') ||
					(
						aNode.localName.toLowerCase().match(/^(a|area|link)$/) &&
						(!aNode.namespaceURI || aNode.namespaceURI == this.XHTMLNS)
					)
				)
				);
	},
	makeURLAbsolute : function(aBase, aURI)
	{
		var baseURI = this.IOService.newURI(aBase, null, null);
		return this.IOService.newURI(baseURI.resolve(aURI), null, null).spec;
	},
  
	// bookmark selection links as a bookmark group 
	bookmarkAllLinksAsGroup : function()
	{
		var links = this.getSelectionLinks(true);
		if (!links.length) return;

		var info = [];
		for (var i in links)
			info[i] = {
				name    : this.getInnerTextOf(links[i].node),
				url     : links[i].uri,
				charset : null
			};

		var currentInfo = info[0];
		currentInfo.forceToGroup = true;

		if (!this.isNewTypeBrowser)
			window.openDialog(
				'chrome://communicator/content/bookmarks/addBookmark.xul',
				'',
				'centerscreen,chrome,dialog=yes,resizable,dependent',
				currentInfo.name, currentInfo.url, null,
				currentInfo.charset, 'addGroup,group',
				info
			);
		else
			window.openDialog(
				'chrome://browser/content/bookmarks/addBookmark2.xul',
				'',
				'centerscreen,chrome,dialog=yes,resizable=no,dependent',
				currentInfo.name, currentInfo.url, null,
				currentInfo.charset, 'addGroup',
				info
			);
	},
  
	openLinkInNewTab : function(aURI, aLinkNode, aShouldActivateTab) 
	{
		if (!this.browserWindow) {
			window.openDialog(this.browserURI, '_blank', 'chrome,all,dialog=no', aURI);
			return;
		}

		var browser  = this.browserWindow.TabbrowserService.browser;

		var info = {};
		var openIn = this.getPref('browser.tabs.extensions.open_tab_in_link');
		if (openIn > -1)
			info.openIn = openIn;
		if (aLinkNode)
			info.parentTab = browser.selectedTab.tabId;

		var referrer = this.shouldSendReferrerWithLinkClick() ? getReferrer(document) : null ;
		var tab      = browser.addTabInternal(aURI, referrer, info);

		if (aShouldActivateTab) {
			browser.selectedTab = tab;
			browser.scrollTabbarTo(browser.selectedTab);
			browser.setFocusInternal();
		}

		this.markLinkVisited(aURI, aLinkNode);
	},
 
	// reopen window as a tab 
	openTabInsteadSelf : function(aWindow)
	{
		this.openTabInsteadSelfInternal(aWindow || window, this);
	},
	openTabInsteadSelfInternal : function(aWindow, aService)
	{
		var i, j, k;
		var b, t;

		var TS  = aService;
		var win = aWindow;
		var browser = win.document.getElementById('content');

		if (
			win.gTSWindowOpenerType == 'ContentWindow' &&
			(
				!browser ||
				!('selectedTab' in browser) ||
				!browser.selectedTab ||
				!('mTabInfo' in browser.selectedTab) ||
				!browser.selectedTab.mTabInfo ||
				!browser.selectedTab.mTabInfo.currentMethod
			)
			) {
			win.setTimeout(TS.openTabInsteadSelfInternal, 100, aWindow, aService);
			return;
		}
		if (
			win.gTSWindowOpenerType == 'ContentWindow' &&
			(
				(TS.winHookMode == 1 && '__tabextensions__opener' in win) ||
				TS.shouldPopupWindowForURI(browser.selectedTab.mTabInfo.loadingURI)
			)
			) {
			// uŊJꍇ̓uEU𕡐Jvݒ̎ŁAwindow.open()Weby[WJavaScriptJꂽEBhÉÄӎuŊĴƌȂA^uł͊JȂB
			delete win.__tabextensions__opener;
			win.clearInterval(win.gTSOpenTabTimer);
			win.gTSOpenTabTimer = null;
			win.gTSWindowOpenerType = 'PlatformNative';

			win.gTSWindowShouldBeDestructed = false;

			// re-post if this window isn't closed
			for (i in browser.mTabs)
			{
				t = browser.mTabs[i];
				if (t.mTabInfo.currentMethod == 'GET' ||
					!t.mTabInfo.lastPostData) continue;

				b = t.mBrowser;
				b.webNavigation.loadURI(
					t.mTabInfo.loadingURI,
					Components.interfaces.nsIWebNavigation.LOAD_FLAGS_REPLACE_HISTORY,
					TS.makeURIFromSpec(t.mTabInfo.loadingReferrerURI),
					browser.createPostStream(t.mTabInfo.lastPostData, true),
					null
				);
			}

			TS.checkWindowShouldBeOpenedForSameURI();

			TS.showWindow();

			return;
		}
		delete win.__tabextensions__opener;

		var uris      = [];
		var names     = [];
		var referrers = [];
		var postData  = [];
		var openers   = [];
		var name, data;
		if (win.gTSWindowOpenerType != 'ContentWindow' &&
			'arguments' in win &&
			win.arguments.length) {
			uris = win.arguments[0].split('\n');
			if (win.arguments.length > 3)
				for (i in uris)
					referrers.push(TS.makeURIFromSpec(win.arguments[2]));
		}
		else {
			if (win.gTSOpenTabTimer) {
				win.clearInterval(win.gTSOpenTabTimer);
				win.gTSOpenTabTimer = null;
			}

			for (i in browser.mTabs)
			{
				uris.push(browser.mTabs[i].mTabInfo.loadingURI);
				referrers.push(TS.makeURIFromSpec(browser.mTabs[i].mTabInfo.loadingReferrerURI));

				name = browser.mTabs[i].mTabInfo.loadingName;
				names.push(name && name != '_blank' ? name : '' );

				if (browser.mTabs[i].mTabInfo.currentMethod != 'GET')
					postData[i] = browser.mTabs[i].mTabInfo.lastPostData;
				else
					postData[i] = null;

				if (!postData[i])
					postData[i] = {
						contentType : '',
						content     : '',
						method      : ''
					};

				try {
					openers[i] = browser.mTabs[i].mBrowser.docShell
							.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
							.getInterface(Components.interfaces.nsIDOMWindow);
					openers[i] = Components.lookupMethod(openers[i], 'opener').call(openers[i]) || null ;
				}
				catch(e) {
					openers[i] = null;
				}
			}
		}

		// convert file pathes to URIs
		var testURI;
		for (i = 0; i < uris.length; i++)
		{
			testURI = TS.fixupURI(uris[i]);
			if (testURI) uris[i] = testURI;
		}

		var nav = TS.browserWindows;
		if (!uris.length || !nav.length) return;

		var lastTab,
			charset,
			shouldRemoveFirst = false;
		for (i = 0; i < nav.length; i++)
		{
			if (
				nav[i] == win ||
				!('TabbrowserService' in nav[i]) ||
				!nav[i].TabbrowserService.activated ||
				nav[i].gTSWindowOpenerType == 'ContentWindow' // if the window is opened from webpages, it seems to be a window opened by same opener.
				)
				continue;

			b = nav[i].TabbrowserService.browser;

			charset = b.contentDocument.characterSet;

			lastTab           = b.selectedTab;
			shouldRemoveFirst = (b.mTabs.length == 1);

			var done,
				openerTab;

			urisRoop:
			for (j = 0; j < uris.length; j++)
			{
				if (names[j]) {
					for (k = 0; k < b.mTabs.length; k++)
					{
						if (b.mTabs[k] != names[j]) continue;

						t = b.mTabs[k];
						t.browserName = names[j];
						if (postData[j]) {
							try {
								b.documentCharsetInfo.parentCharset = b.mAtomService.getAtom(charset);
							}
							catch(e) {
							}
						}
						t.mBrowser.webNavigation.loadURI(
							uris[j],
							Components.interfaces.nsIWebNavigation.LOAD_FLAGS_NONE,
							referrers[j],
							b.createPostStream(postData[j], true),
							null
						);

						if (b.tabGroupsAvailable)
							b.attachTabTo(t, null, true);

						continue urisRoop;
					}
				}

				done      = false;
				openerTab = null;
				if (TS.preventSameURLTab) {
					for (k = 0; k < b.mTabs.length; k++)
					{
						if (b.mTabs[k].mTabInfo.loadingURI != uris[j]) continue;

						TS.popupAlert(TS.strbundle.GetStringFromName('status_same_uri_tab_exists'));

						b.mTabs[k].mBrowser.reload();
						t = b.mTabs[k];
						done = true;
						break;
					}
				}
				if (!done) {
					if (
						b.selectedTab.isReallyBlank ||
						(
							win.gTSWindowOpenerType == 'PlatformNative' &&
							TS.platformNativeBehavior == 1
						)
						) {
						t = b.selectedTab;
						if (names[j]) t.browserName = names[j];
						if (postData[j]) {
							try {
								b.documentCharsetInfo.parentCharset = b.mAtomService.getAtom(charset);
							}
							catch(e) {
							}
						}
						t.mBrowser.webNavigation.loadURI(
							uris[j],
							Components.interfaces.nsIWebNavigation.LOAD_FLAGS_NONE,
							referrers[j],
							b.createPostStream(postData[j], true),
							null
						);
					}
					else {
						if (b.tabGroupsAvailable && openers[j]) {
							for (k = 0; k < b.mTabs.length; k++)
							{
								if (b.mTabs[k].mBrowser.contentDocument != openers[j].document) continue;

								openerTab = b.mTabs[k];
								break;
							}
						}

						t = b.addTabInternal(
							uris[j],
							referrers[j],
							{
								browserName : (names[j] ? names[j] : null),
								postData    : postData[j],
								charset     : (postData[j] ? charset : null),
								parentTab   : openerTab
							}
						);
					}
					try {
						if (b.tabGroupsAvailable && !openers[j])
							b.attachTabTo(t, null, true);
					}
					catch(e) {
					}
					if (TS.debug) dump('tabextensions: '+uris[j]+' reopened\n');
				}
			}

			if (
				t &&
				(
				(win.gTSWindowOpenerType == 'ContentWindow' &&
				!TS.getPref('browser.tabs.extensions.loadInBackgroundJS')) ||
				(win.gTSWindowOpenerType == 'PlatformNative' &&
				!TS.getPref('browser.tabs.extensions.loadInBackgroundPlatformNative')) ||
				(win.gTSWindowOpenerType == 'XULWindow' &&
				!TS.loadInBackground)
				)
				) {
				b.selectedTab = t;
				b.scrollTabbarTo(b.selectedTab);
				b.setFocusInternal();
			}

			if (win.gTSWindowOpenerType == 'PlatformNative' &&
				!TS.getPref('browser.tabs.extensions.loadInBackgroundWindow.platformNative.inherit')) {
				if (!TS.getPref('browser.tabs.extensions.loadInBackgroundWindow.platformNative'))
					nav[i].focus();
			}
			else if (!TS.loadInBackgroundWindow)
				nav[i].focus();

			if (shouldRemoveFirst && lastTab.isReallyBlank)
				b.removeTabInternal(lastTab, { preventUndo : true });

			TS.closeWindow(win, nav[i]);

			break;
		}
	},
 
	checkWindowShouldBeOpenedForSameURI : function(aWindow) 
	{
		var win = aWindow || window ;

		if (!this.preventSameURLTab) {
			this.showWindow(win);
			return;
		}

		var uris = win.arguments[0].split('\n');
		var i;

		// convert file pathes to URIs
		var testURI;
		for (i = 0; i < uris.length; i++)
		{
			testURI = this.fixupURI(uris[i]);
			if (testURI) uris[i] = testURI;
		}

		var done = false;
		var w = this.browserWindows;
		var b;
		var parentWindow;
		for (i = 0; i < uris.length; i++)
		{
			for (j = 0; j < w.length; j++)
			{
				if (w[j] == win) continue;
				b = w[j].TabbrowserService.browser;
				for (k = 0; k < b.mTabs.length; k++)
				{
					if (b.mTabs[k].mTabInfo.loadingURI != uris[i]) continue;

					w[j].TabbrowserService.popupAlert(w[j].TabbrowserService.strbundle.GetStringFromName('status_same_uri_tab_exists'));

					b.mTabs[k].mBrowser.reload();
					if (
						(win.gTSWindowOpenerType == 'ContentWindow' &&
						!this.getPref('browser.tabs.extensions.loadInBackgroundJS')) ||
						(win.gTSWindowOpenerType == 'PlatformNative' &&
						!this.getPref('browser.tabs.extensions.loadInBackgroundPlatformNative')) ||
						(win.gTSWindowOpenerType == 'XULWindow' &&
						!this.loadInBackground)
						) {
						b.selectedTab = t;
						b.scrollTabbarTo(b.selectedTab);
						b.setFocusInternal();
					}
					done = true;
					parentWindow = w[j];
					break;
				}
			}
		}

		if (done)
			this.closeWindow(win, parentWindow);
		else
			this.showWindow(win);
	},
 
	copyTabsFrom : function(aWindow) 
	{
		var sourceBrowser = aWindow.TabbrowserService.browser,
			firstTab      = this.browser.selectedTab,
			b             = this.browser,
			info,
			lastTab;

		b.removeAllTabsButInternal(firstTab); // close other tabs

		for (var i in sourceBrowser.mTabs)
		{
			info    = sourceBrowser.getTabInfo(sourceBrowser.mTabs[i]);
			lastTab = b.addTabWithTabInfo(info);
			if (info.selected) {
				b.selectedTab = lastTab;
				b.scrollTabbarTo(b.selectedTab);
				b.setFocusInternal();
			}
		}

		b.removeTabInternal(firstTab, { preventUndo : true });
	},
 
	// confirm to close, when the window contains tabs 
	onWindowClose : function(aEvent)
	{
		var TS  = TabbrowserService;
		var TSM = 'TabbrowserSessionManager' in window ? TabbrowserSessionManager : null ;

		if (TS.windowClosing) return false;
		TS.windowClosing = true;

		var b  = TS.browsers;
		var check, result;

		if (TS.activated && b.length > 0) {
			for (var i = 0; i < b.length; i++)
			{
				if (b[i].mTabs.length < 2) continue;

				check = { value: TS.getPref('browser.tabs.extensions.cancel_windowclose') != -1 };
				if (check.value) {
					result = TS.getPref('browser.tabs.extensions.cancel_windowclose');
					if (result == 1) {
						var statusText = TS.strbundle.GetStringFromName('message_cancel_windowclose').replace(/%s/gi, b[i].mTabs.length-1);
						var status = document.getElementById('statusbar-display');
						if (status)
							status.label = statusText;
						else
							window.status = statusText;

						try {
							var sound = Components.classes['@mozilla.org/sound;1'].createInstance(Components.interfaces.nsISound);
							sound.beep();
						}
						catch(e) {
						}
					}
				}
				else if (TSM && TS.getPref('browser.tabs.extensions.startup_action_overlay') == 0) {
					if (TS.getPref('browser.tabs.extensions.cancel_windowclose') != 0)
						TS.setPref('browser.tabs.extensions.cancel_windowclose', 0);
					return true;
				}
				else {
					var buttonLabels = (TS.PromptService.BUTTON_TITLE_IS_STRING * TS.PromptService.BUTTON_POS_0) +
							(TS.PromptService.BUTTON_TITLE_CANCEL * TS.PromptService.BUTTON_POS_1);
					result = TS.PromptService.confirmEx(
							window,
							TS.strbundle.GetStringFromName('message_confirm_windowclose_title'),
							TS.strbundle.GetStringFromName('message_confirm_windowclose_text').replace(/%s/gi, b[i].mTabs.length),
							(!TSM || TSM.shouldResutoreLastVisitedTabs ? buttonLabels : buttonLabels + (TS.PromptService.BUTTON_TITLE_IS_STRING * TS.PromptService.BUTTON_POS_2)),
							(TSM && TSM.shouldResutoreLastVisitedTabs ? TSM.strbundle.GetStringFromName('message_confirm_windowclose_save') : TS.strbundle.GetStringFromName('message_confirm_windowclose_ok') ),
							null,
							(!TSM || TSM.shouldResutoreLastVisitedTabs ? null : TSM.strbundle.GetStringFromName('message_confirm_windowclose_save') ),
							TS.strbundle.GetStringFromName('message_never_show_dialog'),
							check
						);
					if (check.value && result != -1) {
						TS.setPref('browser.tabs.extensions.cancel_windowclose', (result == 2 ? 0 : result ));

						if (result == 2) {
							TS.setPref('browser.tabs.extensions.startup_action_overlay', 0);

							check = { value : TS.getPref('browser.tabs.extensions.startup_action_overlay.one_time.hide_changemode_alert') };
							if (TSM && !check.value) {
								TS.PromptService.alertCheck(
									window,
									TSM.strbundle.GetStringFromName('message_confirm_windowclose_save_note_title'),
									TSM.strbundle.GetStringFromName('message_confirm_windowclose_save_note'),
									TS.strbundle.GetStringFromName('message_never_show_dialog'),
									check
								);
								if (check.value) TS.setPref('browser.tabs.extensions.startup_action_overlay.one_time.hide_changemode_alert', true);
							}
							return false;
						}
					}
				}

				switch (result)
				{
					default:
					case 0: // close all tabs
						break;

					case 1: // cancel to close
						if (aEvent) {
							aEvent.preventDefault();
							aEvent.preventBubble();
							aEvent.preventCapture();
							aEvent.stopPropagation();
						}

						window.setTimeout(function() { TabbrowserService.windowClosing = false; }, 100);
						return false;

					case 2: // save all tabs and close
						if (!TSM) break;

						var prefString,
							label = '';
						if (TS.browserWindows.length == 1) {
							TS.setPref('browser.tabs.extensions.startup_action_overlay.one_time', true);
							prefString = 'browser.tabs.extensions.startup_action_overlay.one_time.hide_alert';
						}
						else {
							label = TSM.saveTabSession();
							prefString = 'browser.tabs.extensions.autosave_tabset.hide_alert';
						}
						check = { value : TS.getPref(prefString) };
						if (!check.value) {
							TS.PromptService.alertCheck(
								window,
								TSM.strbundle.GetStringFromName('message_confirm_windowclose_alert_title'),
								TSM.strbundle.GetStringFromName(prefString == 'browser.tabs.extensions.startup_action_overlay.one_time.hide_alert' ? 'message_confirm_windowclose_alert_one_time' : 'message_confirm_windowclose_alert_autosave_tabset' ).replace(/%s/gi, label),
								TSM.strbundle.GetStringFromName('message_never_show_dialog'),
								check
							);
							if (check.value) TS.setPref(prefString, true);
						}
						break;
				}
			}
		}

		// failsafe
		if (TS.activated)
			TS.destruct();

		return true;
	},
	windowClosing : false,
 
	onWindowResize : function(aEvent) 
	{
		if (aEvent.target == window ||
			aEvent.target == document ||
			aEvent.target.ownerDocument == document)
			TabbrowserService.browser.onTabsModified();
	},
 
	// set the flag "is this window focused?" 
	// see the definition of "setFocusInternal" in the tabextensions.xml
	onWindowFocus : function(aEvent)
	{
		window.setTimeout('window.__tabextensions__isWindowFocused = true;', 0);
	},
	
	onWindowBlur : function(aEvent) 
	{
		window.__tabextensions__isWindowFocused = false;
	},
  
	goPreferences : function() 
	{
		var targets = this.WindowManager.getEnumerator('mozilla:preferences', true),
			target;
		while (targets.hasMoreElements())
		{
			target = targets.getNext().QueryInterface(Components.interfaces.nsIDOMWindowInternal);
			if (target.location.href == 'chrome://tabextensions/content/pref/prefDialog.xul') {
				target.focus();
				return;
			}
		}

		window.openDialog(
			'chrome://tabextensions/content/pref/prefDialog.xul',
			'',
			'chrome,all,dependent'
		);
	},
 
	viewSourceOf : function() 
	{
		if (!arguments || !arguments.length) return false;

		var w,
			uri,
			args,
			onload,
			target,
			targetURI,
			parentTab;

		var root = this.isNewTypeBrowser ? 'chrome://global/content/' : 'chrome://navigator/content/' ;

		switch (arguments[0])
		{
			case 'document':
				var doc = arguments[1];
				var nav;
				try {
					w = doc.defaultView;
					if(w == window) w = _content;
					nav = w.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
							.getInterface(Components.interfaces.nsIWebNavigation);
				}
				catch(e) {
					nav = this.browser.webNavigation;
				}

				var cookie = null;
				try{
					var pageLoader = nav.QueryInterface(Components.interfaces.nsIWebPageDescriptor);
					cookie = pageLoader.currentDescriptor;
				}
				catch(e) {
				}

				uri  = root+'viewSource.xul?url='+escape(nav.currentURI.spec);
				args = [
					nav.currentURI.spec,
					'charset='+doc.characterSet,
					cookie
				];
				onload    = 'onLoadViewSource();'
				target    = targetURI = nav.currentURI.spec;
				parentTab = this.browser.selectedTab;
				break;

			case 'uri':
				uri  = root+'viewSource.xul?url='+escape(arguments[1]);
				args = [
					arguments[1],
					arguments[2],
					arguments[3]
				];
				onload    = 'onLoadViewSource();'
				target    = targetURI = arguments[1];
				parentTab = null;
				break;

			case 'partial':
				var context = arguments[1];
				w = document.commandDispatcher.focusedWindow || _content ;

				var reference;
				switch (context)
				{
					case 'selection':
						reference = w.__proto__.getSelection.call(w);
						targetURI = [
							'data:text/html;charset=utf-8,',
							encodeURIComponent(this.getSelectionSource(w))
						].join('');
						break;
					case 'mathml':
						reference = document.popupNode;
						targetURI = [
							'data:text/html;charset=utf-8,',
							encodeURIComponent(this.getPartialSourceOf(reference, context))
						].join('');
						break;
					default:
						throw 'not reached';
				}

				uri  = root+'viewPartialSource.xul?url='+escape(w.location.href);
				args = [
					null,
					'charset='+w.document.characterSet,
					reference,
					context
				];
				onload    = 'onLoadViewPartialSource();'
				target    = w.location.href;
				parentTab = this.browser.selectedTab;
				break;

			default:
				return false;
		}

		var label = this.strbundle.GetStringFromName('view_source_label').replace(/%s/gi, target);

		var b        = this.browser;
		var t        = b.addTab(uri);
		var listener = function()
			{
				t.mBrowser.removeEventListener('load', listener, true);
				t.mBrowser.contentDocument.documentElement.removeAttribute('onload');
				t.mBrowser.contentWindow.onload = function() {};

				t.mBrowser.contentWindow.arguments = args;
				t.mBrowser.contentWindow.setTimeout(onload, 0);

				t.mBrowser.sessionHistory.QueryInterface(Components.interfaces.nsISHistoryInternal).replaceEntry(
					0,
					b.createSHEntryFromInfo({
						uri              : 'view-source:'+targetURI,
						title            : label,
						isSubFrame       : false,
						saveLayoutState  : true,
						expirationStatus : true,
						loadType         : 2,
						x                : 0,
						y                : 0
					})
				);
			};
		t.mBrowser.addEventListener('load', listener, true);

		t.mBrowser.userTypedValue = 'view-source:'+target;

		if (!this.getPref('browser.tabs.extensions.loadInBackgroundViewSource'))
			b.selectedTab = t;

		b.setFixedLabelFor(t, label, 'ANY');
		if (parentTab)
			t.parentTab = parentTab;

		return true;
	},
	
	getPartialSourceOf : function(aNode, aContext) // see viewPartialSource.js 
	{
		var node = aNode;
		if (aNode && aNode.nodeType == Node.TEXT_NODE)
			node = node.parentNode;

		var topTag;
		switch (aContext)
		{
			case 'mathml':
				topTag = 'math';
				break;
			default:
				throw 'not reached';
		}
		while (node && node.localName != topTag)
			node = node.parentNode;

		if (!node) return '';

		var w   = node.ownerDocument.defaultView;
		var sel = w.__proto__.getSelection.call(w);

		sel.removeAllRanges();

		var range = w.document.createRange();
		range.setStart(node, 0);
		range.setEnd(node, node.childNodes.length);

		sel.addRange(range);

		return this.getSelectionSource(w, null, sel);
	}
   
}; 
  
// Listeners and Observers 
	
// Pref Listeners 
	
	/* for browser windows */ 
	
var gTSTabMenuPrefListener = 
{
	domain  : 'browser.tabs.extensions.tab_menu.show',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var menu = document.getElementById('tabMenu');
		if (menu) {
			if (!TabbrowserService.getPref(this.domain))
				menu.setAttribute('hidden', true);
			else
				menu.removeAttribute('hidden');
		}
	}
};
 
var gTSPlatformNativeBehaviorPrefListener = 
{
	domains : [
		'browser.tabs.extensions.platform_native.behavior',
		'advanced.system.supportDDEExec'
	],
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var TS = TabbrowserService;

		var value = TS.getPref('browser.tabs.extensions.platform_native.behavior');
		if (aPrefName == 'browser.tabs.extensions.platform_native.behavior') {
			gTWindowModePrefListener.observe(null, 'nsPref:changed', 'browser.tabs.extensions.platform_native.behavior');

			var nsIBrowserDOMWindow = 'nsIBrowserDOMWindow' in Components.interfaces ? Components.interfaces.nsIBrowserDOMWindow : 'nsIBrowserWindow' in Components.interfaces ? Components.interfaces.nsIBrowserWindow : null ;
			if (nsIBrowserDOMWindow) {
				switch (value)
				{
					case 1:
						TS.setPref('browser.link.open_external', nsIBrowserDOMWindow.OPEN_CURRENTWINDOW);
						break;
					case 2:
						TS.setPref('browser.link.open_external', nsIBrowserDOMWindow.OPEN_NEWTAB);
						break;
					case 3:
						TS.setPref('browser.link.open_external', nsIBrowserDOMWindow.OPEN_NEWWINDOW);
						break;
					default:
						break;
				}
			}
		}

		if (navigator.platform == 'Win32') {
			if (value > 1) {
				var DDE = TS.getPref('advanced.system.supportDDEExec');
				if (DDE !== null && DDE)
					TS.setPref('advanced.system.supportDDEExec', false);
			}
			else {
				// if I wish to disable DDE but don't wish to load pages in a tab...
				if (
					aPrefName == 'advanced.system.supportDDEExec' &&
					TS.getPref('advanced.system.supportDDEExec')
					)
					return;

				if (value == 1)
					TS.setPref('advanced.system.supportDDEExec', true);
			}
			return;
		}
		else if ('@mozilla.org/browser/xremoteservice;1' in Components.classes &&
				Components.classes['@mozilla.org/browser/xremoteservice;1']) { // Linux or others
			this.registerRemoteService(value < 2);
			return;
		}
	},
	remoteServiceRegistered : true,
	registerRemoteService : function(aRegister)
	{
		try {
			const remoteService = Components.classes['@mozilla.org/browser/xremoteservice;1'].getService(Components.interfaces.nsIXRemoteService);
			if (aRegister) {
				if (!this.remoteServiceRegistered)
					remoteService.addBrowserInstance(window);
				this.remoteServiceRegistered = true;
			}
			else {
				if (this.remoteServiceRegistered)
					remoteService.removeBrowserInstance(window);
				this.remoteServiceRegistered = false;
			}
		}
		catch(e) {
		}
	}
};
 
var gTWindowModePrefListener = 
{
	domain  : 'browser.tabs.extensions.window_hook_mode',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var TS = TabbrowserService;
		var nsIBrowserDOMWindow = 'nsIBrowserDOMWindow' in Components.interfaces ? Components.interfaces.nsIBrowserDOMWindow : 'nsIBrowserWindow' in Components.interfaces ? Components.interfaces.nsIBrowserWindow : null ;

		// override prefs of native tabbed browsing
		var openExternal = TS.getPref('browser.link.open_external');
		var openWindow   = TS.getPref('browser.link.open_window');
		if (nsIBrowserDOMWindow && TS.winHookMode == 2) {
			if (openExternal != null && nsIBrowserDOMWindow &&
				openExternal != nsIBrowserDOMWindow.OPEN_CURRENTWINDOW &&
				openExternal != nsIBrowserDOMWindow.OPEN_NEWTAB)
				TS.setPref('browser.link.open_external', nsIBrowserDOMWindow.OPEN_NEWTAB);

			if (openWindow != null && nsIBrowserDOMWindow &&
				openWindow != nsIBrowserDOMWindow.OPEN_CURRENTWINDOW &&
				openWindow != nsIBrowserDOMWindow.OPEN_NEWTAB) {
				TS.setPref('browser.link.open_window', nsIBrowserDOMWindow.OPEN_NEWTAB);
				TS.setPref('browser.link.open_window.ui', nsIBrowserDOMWindow.OPEN_NEWTAB);
			}
		}
		else if (nsIBrowserDOMWindow) {
			var behavior = TS.getPref('browser.tabs.extensions.platform_native.behavior');
			if (openExternal != null && nsIBrowserDOMWindow &&
				openExternal != nsIBrowserDOMWindow.OPEN_DEFAULTWINDOW &&
				openExternal != nsIBrowserDOMWindow.OPEN_NEWWINDOW)
				TS.setPref('browser.link.open_external', behavior == 3 ? nsIBrowserDOMWindow.OPEN_NEWWINDOW : behavior == 2 ? nsIBrowserDOMWindow.OPEN_NEWTAB : nsIBrowserDOMWindow.OPEN_CURRENTWINDOW );

			if (openWindow != null && nsIBrowserDOMWindow &&
				openExternal != nsIBrowserDOMWindow.OPEN_DEFAULTWINDOW &&
				openExternal != nsIBrowserDOMWindow.OPEN_NEWWINDOW) {
				TS.setPref('browser.link.open_window', TS.getPref('browser.tabs.opentabfor.windowopen') && (TS.getPref('browser.tabs.opentabfor.anylink') || TS.getPref('browser.tabs.opentabfor.linkclick')) ? nsIBrowserDOMWindow.OPEN_NEWTAB : nsIBrowserDOMWindow.OPEN_NEWWINDOW );
				TS.setPref('browser.link.open_window.ui', nsIBrowserDOMWindow.OPEN_NEWTAB);
			}
		}

		if (!TS.winHookMode &&
			!TS.opentabforJS &&
			gTSWindowOpenerType == 'ContentWindow')
			gTSWindowOpenerType = 'PlatformNative'; // reset opener type to use this window for reopen new windows opened from webpages in this window.

		if (window.location.href != TS.browserURI) return;

		var i;
		var isSingleWindow = TS.winHookMode == 2 ? true : false ;

		var items = [
				document.getElementById('menu_newNavigator'),
				document.getElementsByAttribute('oncommand', 'gContextMenu.openFrame();')[0],
				document.getElementById('cmd_newNavigator')
			];

		// Firefox
		if (TS.isNewTypeBrowser) {
			var nodes = document.getElementsByAttribute('command', 'cmd_newNavigator');
			for (i = 0; i < nodes.length; i++)
				if (nodes[i].localName == 'menuitem')
					items.push(nodes[i]);
		}

		for (i in items)
			if (items[i]) {
				if (isSingleWindow) {
					items[i].setAttribute('hidden', true);
					items[i].setAttribute('disabled', true);
				}
				else {
					items[i].removeAttribute('hidden');
					items[i].removeAttribute('disabled');
				}
			}
	}
};
 
var gTSOpenTabForWindowOpenPrefListener = 
{
	domains : [
		'browser.tabs.opentabfor.windowopen',
		'browser.tabs.opentabfor.linkclick',
		'browser.tabs.opentabfor.anylink'
	],
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var TS = TabbrowserService;
		var nsIBrowserDOMWindow = 'nsIBrowserDOMWindow' in Components.interfaces ? Components.interfaces.nsIBrowserDOMWindow : 'nsIBrowserWindow' in Components.interfaces ? Components.interfaces.nsIBrowserWindow : null ;

		if (!aPrefName || aPrefName == 'browser.tabs.opentabfor.windowopen') {
			if (!TS.winHookMode &&
				!TS.opentabforJS &&
				gTSWindowOpenerType == 'ContentWindow')
				gTSWindowOpenerType = 'PlatformNative'; // reset opener type to use this window for reopen new windows opened from webpages in this window.
		}

		// override prefs of native tabbed browsing
		var openWindow = TS.getPref('browser.link.open_window');
		if (!aPrefName && openWindow != null && nsIBrowserDOMWindow) {
			if (TS.getPref('browser.tabs.opentabfor.windowopen') &&
				(TS.getPref('browser.tabs.opentabfor.anylink') || TS.getPref('browser.tabs.opentabfor.linkclick'))) {
				TS.setPref('browser.link.open_window', nsIBrowserDOMWindow.OPEN_NEWTAB);
				TS.setPref('browser.link.open_window.ui', nsIBrowserDOMWindow.OPEN_NEWTAB);
			}
			else if (!TS.getPref('browser.tabs.opentabfor.windowopen') &&
				!TS.getPref('browser.tabs.opentabfor.anylink') &&
				!TS.getPref('browser.tabs.opentabfor.linkclick')) {
				TS.setPref('browser.link.open_window', nsIBrowserDOMWindow.OPEN_NEWWINDOW);
				TS.setPref('browser.link.open_window.ui', nsIBrowserDOMWindow.OPEN_NEWTAB);
			}
		}
	}
};
  
	/* for tabbrowser widget */ 
	
var gTSCloseBoxPrefListener = 
{
	domain  : 'browser.tabs.extensions.show_closebox',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed' ||
			!('TabbrowserService' in window)) return;

		var value = TabbrowserService.getPref(aPrefName);
		var b = document.getElementsByTagNameNS(TabbrowserService.XULNS, 'tabbrowser');
		var i;

		switch (aPrefName)
		{
			case 'browser.tabs.extensions.show_closebox.tabbar':
				for (i = 0; i < b.length; i++)
					b[i].setAttribute('tabbrowser-tabbar-closebox-hidden', !value);
				break;

			case 'browser.tabs.extensions.show_closebox.tab':
				switch (value)
				{
					case -1:
					default:
						value = 'never';
						break;
					case 0:
						value = 'any';
						break;
					case 1:
						value = 'current';
						break;
					case 2:
						value = 'pointed';
						break;
				}
				for (i = 0; i < b.length; i++)
					b[i].setAttribute('tabbrowser-tab-closebox', value);
				break;

			default:
				break;
		}
	}
};
 
var gTSIconOverlayInTabsPrefListener = 
{
	domain  : 'browser.tabs.extensions.overlay_icon',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var shouldOverlay = TabbrowserService.getPref(this.domain);
		var b = document.getElementsByTagNameNS(TabbrowserService.XULNS, 'tabbrowser'),
			i, j;
		for (i = 0; i < b.length; i++)
			for (j = 0; j < b[i].mTabs.length; j++)
				b[i].mTabs[j].setAttribute('overlay-icon', shouldOverlay);
	}
};
 
var gTSTabsWidthPrefListener = 
{
	domains : [
		'browser.tabs.extensions.tabs_width_type',
		'browser.tabs.extensions.tabs_width',
		'browser.tabs.extensions.tabs_min_width',
		'browser.tabs.extensions.tabs_max_width',
		'browser.tabs.extensions.tabs_title_crop'
	],
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var b = document.getElementsByTagNameNS(TabbrowserService.XULNS, 'tabbrowser'),
			i, j;
		for (i = 0; i < b.length; i++)
		{
			for (j = 0; j < b[i].mTabs.length; j++)
				b[i].mTabs[j].initTab();

			b[i].onTabsModified();
		}
	}
};
 
var gTSTabbarBlankSpacePrefListener = 
{
	domain  : 'browser.tabs.extensions.show_blankspaces',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var shouldMakeSpace = TabbrowserService.getPref(this.domain);
		var b = document.getElementsByTagNameNS(TabbrowserService.XULNS, 'tabbrowser');
		for (var i = 0; i < b.length; i++)
			b[i].setAttribute('makeblankspace', shouldMakeSpace);
	}
};
 
var gTSLastTabClosingPrefListener = 
{
	domain  : 'browser.tabs.extensions.last_tab_closing',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		if (TabbrowserService.getPref(this.domain) != 2) {
			TabbrowserService.setPref('browser.tabs.autoHide', false);
			TabbrowserService.setPref('browser.tabs.forceHide', false);
		}

		var b = document.getElementsByTagNameNS(TabbrowserService.XULNS, 'tabbrowser'),
			i;
		if (TabbrowserService.getPref('browser.tabs.autoHide')) {
			for (i = 0; i < b.length; i++)
				b[i].setStripVisibilityTo(false);
		}
		else {
			for (i = 0; i < b.length; i++)
				b[i].setStripVisibilityTo(true);
		}
	}
};
 
var gTSTabsAutoHidePrefListener = 
{
	domain  : 'browser.tabs.autoHide',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (
			aTopic != 'nsPref:changed' ||
			!TabbrowserService.getPref(this.domain) ||
			TabbrowserService.getPref('browser.tabs.autoHide.temporaryChanged') // when this is temporary change, ignore.
			)
			return;

		// disable the feature automatically
		TabbrowserService.setPref('browser.tabs.extensions.last_tab_closing', 2);

		var b = document.getElementsByTagNameNS(TabbrowserService.XULNS, 'tabbrowser');
		for (var i = 0; i < b.length; i++)
			b[i].setStripVisibilityTo(b[i].mTabs.length > 1);
	}
};
 
var gTSTabbarPlacePrefListener = 
{
	domain  : 'browser.tabs.extensions.tabbar_place',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		this.update(TabbrowserService.getPref(this.domain) > -1);
	},
	update : function(aPreventToUpdateNow)
	{
		var TS = TabbrowserService;

		var place = TS.getPref(this.domain);
		var b     = document.getElementsByTagNameNS(TS.XULNS, 'tabbrowser');

		if (place > -1 && b[0].hasAttribute('tabbrowser-tabbar-hidden'))
			b[i].removeAttribute('tabbrowser-tabbar-hidden');

		if (
			(place == 0 && b[0].mStrip.getAttribute('class').match(/tabbrowser-strip-top/)) ||
			(place == 1 && b[0].mStrip.getAttribute('class').match(/tabbrowser-strip-bottom/)) ||
			(place == 2 && b[0].mStrip.getAttribute('class').match(/tabbrowser-strip-left/)) ||
			(place == 3 && b[0].mStrip.getAttribute('class').match(/tabbrowser-strip-right/))
			)
			return;

		if (aPreventToUpdateNow) {
			TS.PromptService.alert(
				window,
				TS.strbundle.GetStringFromName('message_alert_tabbar_place_title'),
				TS.strbundle.GetStringFromName('message_alert_tabbar_place')
			);
			return;
		}

		if (place > 1) {
			if(TS.getPref('browser.tabs.extensions.tabs_width_type') != 2)
				TS.setPref('browser.tabs.extensions.tabs_width_type', 2);

			if(TS.getPref('browser.tabs.extensions.tab_scroller') == 3)
				TS.setPref('browser.tabs.extensions.tab_scroller', 0);
		}

		var i;
		for (i = 0; i < b.length; i++)
			b[i].updateTabbarPlace();

		var attr = place < 2 ? 'label-for-horizontal-tabbar' : 'label-for-vertical-tabbar' ;
		var nodes = document.getElementsByAttribute(attr, '*');
		for (i = 0; i < nodes.length; i++)
			nodes[i].setAttribute('label', nodes[i].getAttribute(attr));
	}
};
 
// ^u̐eq֌W𖕏 
// clear the relation of tabs when the TabGroup Mode is disabled
var gTSGroupModePrefListener =
{
	domain  : 'browser.tabs.extensions.group.enabled',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed' ||
			TabbrowserService.getPref(this.domain)) return;

		var b = document.getElementsByTagNameNS(TabbrowserService.XULNS, 'tabbrowser'),
			i, j;
		for (i = 0; i < b.length; i++)
			for (j = 0; j < b[i].mTabs.length; j++)
			{
				b[i].mTabs[j].parentTab = null;
				b[i].mTabs[j]._childTabs = [];
				b[i].mTabs[j].mTabInfo.openedAutomatically = false;
				b[i].mTabs[j].mTabInfo.groupHost = null;
			}
	}
};
 
var gTSTabScrollerPrefListener = 
{
	domain  : 'browser.tabs.extensions.tab_scroller',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var TS = TabbrowserService;

		var value = TS.getPref(this.domain);
		var rearrangable = true;
		switch (value)
		{
			default:
			case 0:
				value = 'button';
				break;

			case 4:
				value = 'buttonalways';
				break;

			case 1:
				value = 'scrollbar';
				break;

			case 2:
				value = 'scrollbaralways';
				break;

			case 3:
				value = 'multirow';
				if (!TS.getPref('browser.tabs.extensions.use_multirow_rearrangable_tabs'))
					rearrangable = false;

				if (TS.getPref('browser.tabs.extensions.tabbar_place') > 1)
					TS.setPref('browser.tabs.extensions.tabbar_place', 0);
//				if (TS.getPref('browser.tabs.extensions.tabs_width_type') == 0)
//					TS.setPref('browser.tabs.extensions.tabs_width_type', 2);
				break;

			case -1:
				value = 'never';
				break;
		}

		var b = document.getElementsByTagNameNS(TS.XULNS, 'tabbrowser');
		var i, j;
		var tabContents;
		if (rearrangable) {
			for (i = 0; i < b.length; i++)
			{
				b[i].setAttribute('tab-scrollbar', value);
				b[i].setAttribute('tabs-rearrange', true);

				if (b[i].getAttribute('tabs-rearrange') != 'true')
					for (j in b[i].mTabs)
						b[i].mTabs[j].ordinal = j;
			}
		}
		else {
			for (i = 0; i < b.length; i++)
			{
				for (j in b[i].mTabs)
					b[i].mTabs[j].removeAttribute('ordinal');

				b[i].removeAttribute('tabs-rearrange');
				b[i].setAttribute('tab-scrollbar', value);
			}
		}
	}
};
 
var gTSAnotherBindingPrefListener = 
{
	domain  : 'browser.tabs.extensions.use_another_binding',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		if (TabbrowserService.getPref(this.domain))
			document.documentElement.setAttribute('tabextensions-another-binding', 'true');
		else
			document.documentElement.removeAttribute('tabextensions-another-binding');
	}
};
     
// end of definition 
}
 
// initialize 

// failsafe
if (
	window == Components.lookupMethod(window, 'top').call(window) &&
	!gTSWindowOpenerType &&
	TabbrowserService.isBrowserWindow
	)
	TabbrowserService.DOMWindowOpenObserver.observe(window, 'domwindowopened', null);

if (TabbrowserService.isNewTypeBrowser) {
	// Firefox cannot add event listener in "TabbrowserService.init()", so do it in this point.
	window.addEventListener('close', function(aEvent)
	{
		TabbrowserService.onWindowClose(aEvent);
	},
	false);
}

// initialize and shotdown
if ('Shutdown' in window && !('__tabextensions__Shutdown' in window)) {
	window.__tabextensions__Shutdown = window.Shutdown;
	window.Shutdown = function()
	{
		TabbrowserService.destruct();

		// to resolve "there is no observer for '***'" error
		var sv = TabbrowserService.ObserverService;
		if (TabbrowserService.isBrowserWindow) {
			if ('dlObserver' in window &&
				!sv.enumerateObservers('dl-start').hasMoreElements())
				sv.addObserver(dlObserver, 'dl-start', false);
		}

		// register again the window before do the original Shutdown() (for Linux or others)
		if (!gTSPlatformNativeBehaviorPrefListener.remoteServiceRegistered)
			gTSPlatformNativeBehaviorPrefListener.registerRemoteService(true);

		window.__tabextensions__Shutdown();
	};
}
else {
	window.addEventListener('unload', function()
	{
		if (!TabbrowserService.activated) return;

		TabbrowserService.destruct();
	},
	false);
	window.addEventListener('unload', function()
	{
		if (!TabbrowserService.activated) return;

		TabbrowserService.destruct();
	},
	false);
}

window.addEventListener('load', function()
{
	if (TabbrowserService.activated) return;

	TabbrowserService.init();
},
false);
window.addEventListener('load', function()
{
	if (TabbrowserService.activated) return;

	TabbrowserService.init();
},
false);
 
