/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2004 Tomaz Solc                                           */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* $Id: subject_preferred.c,v 1.4 2004/11/26 13:07:19 avian Exp $ */

/* 
 * AUTHOR:
 *
 *  Jaume Obrador <obrador@espaiweb.net>
 *
 *  Code for preferred room added by Tomaz Solc <tomaz.solc@siol.net>
 *
 * DESCRIPTION:
 *
 *  Adds a weight whenever a subject-teacher pair is not scheduled at the 
 *  specified preferred day and/or period and/or room.
 *
 * DEFINED SUBJECT RESTRICTIONS:
 *
 *  <restriction type="preferred-period">period</restriction>
 *
 *  <restriction type="preferred-day">day</restriction>
 *
 *  <restriction type="preferred-room">room</restriction>
 *
 *  These three restrictions specify the preferred period, day and room id
 *  for a subject-teacher pair, and must be declared in subject tag.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "modsup.h"
#include "data.h"
#include "gettext.h"

int *pperiod;
int *pday;
int *proom;

int getday(char *type, char *cont, int sid)
{
	int p,c;
	
	c=sscanf(cont, "%d", &p);

	if(c<1||p<0||p>days) {
		strcpy(moderror, _("invalid preferred day"));
		return(1);
	}

	pday[sid]=p;

	return 0;
}

int getperiod(char *type, char *cont, int sid)
{
	int p,c;
	
	c=sscanf(cont, "%d", &p);

	if(c<1||p<0||p>periods) {
		strcpy(moderror, _("invalid preferred period"));
		return(1);
	}

	pperiod[sid]=p;

	return 0;
}

int getroom(char *type, char *cont, int sid)
{
	int c;
	
	c=find_room(cont);

	if(c<0) {
		strcpy(moderror, _("invalid preferred room"));
		return(1);
	}

	proom[sid]=c;

	return 0;
}

parop subject_restrictions[] = { 
	{ type : "preferred-period", parfunc: getperiod },
	{ type : "preferred-day", parfunc: getday },
	{ type : "preferred-room", parfunc: getroom },
	{ type : 0, parfunc: 0 }
};

int init_mod()
{
	int c;

	pperiod=malloc(sizeof(*pperiod)*smapnum);
	pday=malloc(sizeof(*pday)*smapnum);
	proom=malloc(sizeof(*proom)*smapnum);

	for(c=0;c<smapnum;c++) {
		pperiod[c]=-1;
		pday[c]=-1;
		proom[c]=-1;
	}
	
	return 0;
}

int grade_function(chromo *t, int *cpnt, int *tpnt, int **start, int **lead)
{
	int c;
	int sum;
	int d,p;

	sum=0;

        for(c=0;c<tuplenum;c++) {
		if(pday[tuplemap[c].sid]>-1) {
			d=t->inf[c].time/periods;
			if(d!=pday[tuplemap[c].sid]) sum++;
		}
		if(pperiod[tuplemap[c].sid]>-1) {
			p=t->inf[c].time%periods;
			if(p!=pperiod[tuplemap[c].sid]) sum++;
		}
		if(proom[tuplemap[c].sid]>-1) {
			p=t->inf[c].room;
			if(p!=proom[tuplemap[c].sid]) sum++;
		}
	}

	return(sum);
}

