/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2002 Tomaz Solc                                           */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* $Id: errorl.c,v 1.9 2004/06/02 11:54:17 avian Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "main.h"
#include "gettext.h"
#include "error.h"

int verbosity;
char *curmodule;

void vtell(char *module, int msgtag, const char *fmt, va_list ap)
{
	char msg[BUFFSIZE];

	if(msgtag>verbosity) {
		if(msgtag==MSG_FATAL) {
			exit(1);
		} else {
			return;
		}
	}

	vsnprintf(msg, BUFFSIZE, fmt, ap);
	msg[BUFFSIZE-1]=0;

	if(msgtag==MSG_FATAL) {
	        fprintf(stderr, _("[%s] fatal: %s\n"), module, msg);
		exit(1);
	} else {
	        fprintf(stderr, "[%s] %s\n", module, msg);
	}

}

void tell(char *module, int msgtag, const char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);

	vtell(module, msgtag, fmt, ap);

	va_end(ap);
}

void fatalxml(const char *fmt, int no, ...)
{
	va_list ap;
        char fmt2[BUFFSIZE];

	va_start(ap, no);

	snprintf(fmt2, 256, _("%s (line %d)"), fmt, no);
	fmt2[BUFFSIZE-1]=0;

        vtell("xmlsup", MSG_FATAL, fmt2, ap);

	va_end(ap);
}

void fatal(const char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);

	vtell(curmodule, MSG_FATAL, fmt, ap);
	
	va_end(ap);
}

void error(const char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);

	vtell(curmodule, MSG_ERROR, fmt, ap);
	
	va_end(ap);
}

void notify(const char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);

	vtell(curmodule, MSG_INFO, fmt, ap);

	va_end(ap);
}


void info(const char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);

	vtell(curmodule, MSG_INFO, fmt, ap);

	va_end(ap);
}

void debug(const char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);

	vtell(curmodule, MSG_DEBUG, fmt, ap);

	va_end(ap);
}
