/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2002 Tomaz Solc                                           */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* $Id: export_htmlcss.c,v 1.11 2005/01/17 16:45:34 avian Exp $ */

#include <stdio.h>
#include <time.h>
#include <string.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_ICONV
#include <iconv.h>
#include <langinfo.h>
#endif

#include "error.h"
#include "data.h"
#include "xmlsup.h"
#include "gettext.h"

#define BUFFSIZE	256
#define TRESHOLD	3	/* More tuples will be put in the footnote */
#define COLUMNS_INDEX	4
#define COLUMNS_FOOTNOTE 3

char buff[BUFFSIZE];
int bookmark;

#ifdef HAVE_ICONV
char buff2[BUFFSIZE];

char *get_dayname(int n) {
	struct tm t;
	char *a,*b;
	size_t c, d;
	iconv_t cd;

	cd=iconv_open("UTF-8", nl_langinfo(CODESET));

	t.tm_wday=n%5+1;
	strftime(buff, BUFFSIZE, "%a", &t);

	if(((int) cd)==-1) {
		return(buff);
	}

	a=buff;
	b=buff2;
	c=BUFFSIZE;
	d=BUFFSIZE;

	iconv(cd, &a, &c, &b, &d);
	
	iconv_close(cd);

	return(buff2);
}
#else
char *get_dayname(int n) {
	struct tm t;

	t.tm_wday=n+1;
	strftime(buff, BUFFSIZE, "%a", &t);

	return(buff);
}
#endif

void make_index(chromo *t, FILE *out)
{
	int cid,tid,rid; 

	fprintf(out, "<h2>");
	fprintf(out, _("Classes"));
	fprintf(out, "</h2>\n");

	fprintf(out, "<table>\n\t<tr>\n");
	for(cid=0;cid<cmapnum;cid++) {
		if(cid%COLUMNS_INDEX==0&&cid!=0) fprintf(out, "\t</tr>\n\t<tr>\n");
		fprintf(out, "\t\t<td><a href=\"#class%d\">%d - %s</a></td>\n", cid, cmap[cid].year, cmap[cid].name);
	}
	while(cid%COLUMNS_INDEX!=0) {
		fprintf(out, "\t\t<td class=\"empty\">&nbsp;</td>\n");
		cid++;
	}

	fprintf(out, "\t</tr>\n</table>\n");

	fprintf(out, "<h2>");
	fprintf(out, _("Teachers"));
	fprintf(out, "</h2>\n");

	fprintf(out, "<table>\n\t<tr>\n");
	for(tid=0;tid<tmapnum;tid++) {
		if(tid%4==0&&tid!=0) fprintf(out, "\t</tr>\n\t<tr>\n");
		fprintf(out, "\t\t<td><a href=\"#teach%d\">%s</a></td>\n", tid, tmap[tid].name);
	}
	while(tid%4!=0) {
		fprintf(out, "\t\t<td class=\"empty\">&nbsp;</td>\n");
		tid++;
	}
	fprintf(out, "\t</tr>\n\t</table>\n");

	fprintf(out, "<h2>");
	fprintf(out, _("Classrooms"));
	fprintf(out, "</h2>\n");

	fprintf(out, "<table>\n\t<tr>\n");
	for(rid=0;rid<rmapnum;rid++) {
		if(rid%4==0&&rid!=0) fprintf(out, "\t</tr>\n\t<tr>\n");
		fprintf(out, "\t\t<td><a href=\"#room%d\">%s</a></td>\n", rid, rmap[rid].id);
	}
	while(rid%4!=0) {
		fprintf(out, "\t\t<td class=\"empty\">&nbsp;</td>\n");
		rid++;
	}
	fprintf(out, "\t</tr>\n\t</table>\n");
}

void make_period(chromo *t, outputext *pnt, FILE *out, int mycid) {
	int sid,tid,rid,cid,n;

	if(pnt->status==2) {
		sid=tuplemap[pnt->tuples[0]].sid;
	        tid=tuplemap[pnt->tuples[0]].tid;
	        rid=t->inf[pnt->tuples[0]].room;

                fprintf(out, "\t\t<td>\n");
		fprintf(out, "\t\t\t<p class=\"subject\">%s</p>\n", smap[sid].title);
		fprintf(out, "\t\t\t<p class=\"teacher\">%s</p>\n", tmap[tid].name);
		fprintf(out, "\t\t\t<p class=\"room\">%s</p>\n", rmap[rid].id);
		fprintf(out, "\t\t</td>\n");
       	} else if(pnt->status==1) { 
		fprintf(out, "\t\t<td class=\"conf\">\n");
		for(n=0;n<((pnt->num>TRESHOLD)?TRESHOLD:pnt->num);n++) {
			sid=tuplemap[pnt->tuples[n]].sid;
		        tid=tuplemap[pnt->tuples[n]].tid;
		        rid=t->inf[pnt->tuples[n]].room;
			cid=tuplemap[pnt->tuples[n]].cid;

		        fprintf(out, "\t\t\t<p class=\"conf\"><a href=\"#class%d\">", cid);
			fprintf(out, "%s, ", smap[sid].title);
			fprintf(out, "%s, ", tmap[tid].name);
			fprintf(out, "%s", rmap[rid].id);
			fprintf(out, "</a></p>\n");
		}
		if(pnt->num>TRESHOLD) {
			fprintf(out, "\t\t\t<p class=\"conf\"><a href=\"#class%d-%d\">... %d)</a></p>\n", mycid, bookmark, bookmark);
			bookmark++;
		}
		fprintf(out, "\t\t</td>\n");
	} else {
		fprintf(out, "\t\t<td class=\"empty\">&nbsp;</td>\n");
	}
}

void make_footnote(chromo *t, outputext *pnt, FILE *out,int mycid) {
	int sid,tid,rid,cid,n;

       	if(pnt->status==1&&pnt->num>TRESHOLD) {
		if((bookmark-1)%COLUMNS_FOOTNOTE==0&&(bookmark-1)!=0) fprintf(out, "\t</tr>\n\t<tr>\n");
		fprintf(out, "\t\t<td class=\"footnote\">\n");
	       	fprintf(out, "\t\t\t<div id=\"class%d-%d\">\n", mycid, bookmark);
		fprintf(out, "\t\t\t<h3 class=\"footnote\">%d)</h3>\n", bookmark++);
		for(n=0;n<pnt->num;n++) {
			sid=tuplemap[pnt->tuples[n]].sid;
		        tid=tuplemap[pnt->tuples[n]].tid;
		        rid=t->inf[pnt->tuples[n]].room;
			cid=tuplemap[pnt->tuples[n]].cid;

		        fprintf(out, "\t\t\t<p><a href=\"#class%d\">", cid);

			fprintf(out, "<b class=\"footnote\">%d - %s:</b> ", cmap[cid].year, cmap[cid].name);
			fprintf(out, "%s, ", smap[sid].title);
			fprintf(out, "%s, ", tmap[tid].name);
			fprintf(out, "%s", rmap[rid].id);
			fprintf(out, "</a></p>\n");
		}
		fprintf(out, "\t\t\t</div>\n");
		fprintf(out, "\t\t</td>\n");
	}
}

void make_class(int cid, chromo *t, outputext *pnt, FILE *out)
{
	int c,b,a;

	bookmark=1;

        pnt+=cid*TIMES;

        fprintf(out, "<h2 id=\"class%d\">%d - %s</h2>\n", cid, cmap[cid].year, cmap[cid].name);
        fprintf(out, "<table>\n");

        for(c=-1;c<PERIODS;c++) {
        	a=c;
                if (c==-1) {
			fprintf(out, "\t<tr>\n\t\t<th></th>\n"); 
			for(b=0;b<DAYS;b++) {
				fprintf(out, "\t\t<th>%s</th>\n", 
					get_dayname(b)); 
			}
                	fprintf(out, "\t</tr>\n");
			continue;
		}

		fprintf(out, "\t<tr>\n\t\t<th>%d</th>\n", c+1);
                for(b=0;b<DAYS;b++) {
			make_period(t, &pnt[a], out, cid);
                        a+=PERIODS;
                }
                fprintf(out, "\t</tr>\n");
        }
        fprintf(out, "</table>\n");
	if(bookmark>1) {
		bookmark=1;

		fprintf(out, "<table>\n\t<tr>\n");
	        for(c=0;c<PERIODS;c++) {
	        	a=c;
	                for(b=0;b<DAYS;b++) {
				make_footnote(t, &pnt[a], out, cid);
	                        a+=PERIODS;
	                }
	        }
		while((bookmark-1)%COLUMNS_FOOTNOTE!=0&&(bookmark>COLUMNS_FOOTNOTE)) {
			fprintf(out, "\t\t<td class=\"footnote-empty\">&nbsp;</td>\n");
			bookmark++;
		}
		fprintf(out, "\t</tr>\n</table>\n");
	}

	fprintf(out, "<p><a href=\"#header\">%s</a></p>", _("Back to top"));
        fprintf(out, "<hr/>\n");
}

void make_teacher(int tid, chromo *t, int *pnt, FILE *out) 
{
	int a,b,c,cid,rid,sid;

        pnt+=tid*TIMES;

        fprintf(out, "<h2 id=\"teach%d\">%s</h2>\n", tid, tmap[tid].name);
        fprintf(out, "<table>\n");

        for(c=-1;c<PERIODS;c++) {
        	a=c;
                if (c==-1) {
			fprintf(out, "\t<tr>\n\t\t<th></th>\n"); 
			for(b=0;b<DAYS;b++) {
				fprintf(out, "\t\t<th>%s</th>\n", 
					get_dayname(b)); 
			}
	               	fprintf(out, "\t</tr>\n");
			continue;
		}

		fprintf(out, "\t<tr>\n\t\t<th>%d</th>\n", c+1);

		for(b=0;b<DAYS;b++) {
			if (pnt[a]!=-1) {
				cid=tuplemap[pnt[a]].cid;
				rid=t->inf[pnt[a]].room;
				sid=tuplemap[pnt[a]].sid;
				fprintf(out, "\t\t<td>\n\t\t\t<p class=\"subject\">%s</p>\n\t\t\t<p class=\"class\">%d - %s</p>\n\t\t\t<p class=\"room\">%s</p>\n\t\t</td>\n", smap[sid].title, cmap[cid].year, cmap[cid].name, rmap[rid].id);
			} else {
				fprintf(out, "\t\t<td class=\"empty\">&nbsp;</td>\n");
			}

			a+=PERIODS;
		}
                fprintf(out, "\t</tr>\n");
        }
        fprintf(out, "</table>\n");
	fprintf(out, "<p><a href=\"#header\">%s</a></p>", _("Back to top"));
	fprintf(out, "<hr/>\n");
}

/* Function contributed by Nicholas Robinson */
void make_room(int rid, chromo *t, outputext *opnt, FILE *out) {

	int per;
	fprintf(out, "<h2 id=\"room%d\">%s</h2>\n", rid, rmap[rid].id);
	fprintf(out, "<table>\n");

	for(per=-1;per<PERIODS;per++) {
		int day, cid;

                if(per==-1) {
			fprintf(out, "\t<tr>\n\t\t<th></th>\n");
			for(day=0;day<DAYS;day++) {
				fprintf(out, "\t\t<th>%s</th>\n", 
					get_dayname(day));
			}
                	fprintf(out, "\t</tr>\n");
			continue;
		}

		fprintf(out, "\t<tr>\n\t\t<th>%d</th>\n", per+1);

		for(day=0;day<DAYS;day++)
		{
			int in_use = 0;
			outputext *pnt2;
			int time;

			/* Check every class's timetable to see if it uses 
			 * this room at this time. */

			for(cid=0;cid<cmapnum;cid++) {
				pnt2=opnt+cid*TIMES;
				time=day*PERIODS+per;

				if(pnt2[time].status==2&&
				   rid==t->inf[pnt2[time].tuples[0]].room) {
					in_use=1;
					break;
				}
			}

			if(in_use) {
				fprintf(out, "\t\t<td>\n");
				for(cid=0;cid<cmapnum;cid++) {
					int tid, sid;

					pnt2=opnt+cid*TIMES;
					time=day*PERIODS+per;


					/* Only want the main class 
					 * i.e. ignore the ones arising from 
					 * 'conflicts-with' */

					if(pnt2[time].status==2&&
					   rid == t->inf[pnt2[time].tuples[0]].room) {

						tid=tuplemap[pnt2[time].tuples[0]].tid;
						sid=tuplemap[pnt2[time].tuples[0]].sid;
						fprintf(out, "\t\t\t<p class=\"subject\">%s</p>\n\t\t\t<p class=\"teacher\">%s</p><p class=\"class\">%d - %s</p>\n", smap[sid].title, tmap[tid].name, cmap[cid].year, cmap[cid].name );
					}
				}
				fprintf(out, "\t\t</td>\n");
			} else {
				fprintf(out, "\t\t<td class=\"empty\">&nbsp;</td>\n");
			}
		}
		fprintf(out, "\t</tr>\n");
	}

        fprintf(out, "</table>\n");
	fprintf(out, "<p><a href=\"#header\">%s</a></p>", _("Back to top"));
	fprintf(out, "<hr>\n");
}

void output_function(chromo *t, int *cpnt, int *tpnt, char *options, FILE* out, outputext *opnt)
{
        int cid, tid, rid;

	bind_textdomain_codeset(PACKAGE, "UTF-8");

	fprintf(out, "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n");
        fprintf(out, "<html>\n<head>\n");
	fprintf(out, "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>\n");
	fprintf(out, "<title>\n");
	fprintf(out, _("Tablix output"));
	fprintf(out, "</title>\n");
	if(strlen(options)>0) {
		fprintf(out, "<link rel=\"stylesheet\" href=\"%s\" type=\"text/css\"/>", options);
	} else {
		bind_textdomain_codeset(PACKAGE, "");
		info(_("no stylesheet specified"));
		bind_textdomain_codeset(PACKAGE, "UTF-8");
	}
	fprintf(out, "</head>\n<body>\n");
	
	fprintf(out, "<div id=\"header\">");
        fprintf(out, "<h1>%s</h1>\n", school_name);
        fprintf(out, "<h2>%s</h2>\n", school_address);
        fprintf(out, "<h3>%s</h3>\n", author);
	fprintf(out, "</div>");

	fprintf(out, "<hr/>\n");

	fprintf(out, "<div id=\"index\">\n");
	make_index(t, out);
	fprintf(out, "</div>\n");

	fprintf(out, "<hr/>\n");

	for(cid=0;cid<cmapnum;cid++) make_class(cid, t, opnt, out);

	for(tid=0;tid<tmapnum;tid++) make_teacher(tid, t, tpnt, out);

	for(rid=0;rid<rmapnum;rid++) make_room(rid, t, opnt, out);

        fprintf(out, "<p>");
	fprintf(out, _("Grade of this timetable: %d"), t->grade);
	fprintf(out, "</p>\n");
        fprintf(out, "<p>");
	fprintf(out, _("Tablix, version %s"), VERSION);
	fprintf(out, "</p>\n");

        fprintf(out, "</body>\n</html>\n");
	bind_textdomain_codeset(PACKAGE, "");
}
