/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2002 Tomaz Solc                                           */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* $Id: main.h,v 1.30 2004/04/12 17:53:53 avian Exp $ */

/* PVM message tags */

#ifndef _MAIN_H
#define _MAIN_H

#define MSG_SIBLING     1
#define MSG_MIGRATION   3
#define MSG_XMLDATA     4
#define MSG_MASTERKILL  7
#define MSG_RESULTDATA  8
#define MSG_SENDPOP     9
#define MSG_POPDATA     10
#define MSG_RESTOREPOP  11
#define MSG_MODINFO	12
#define MSG_LOCALSYN	13
#define MSG_LOCALACK	14
#define MSG_PARAMS	15

#define MSG_FATAL   100
#define MSG_ERROR   101
#define MSG_REPORT  102
#define MSG_INFO    103
#define MSG_DEBUG   104

/* DEBUGING AND PROFILING */

/* Sizes of various arrays */

#define GRADEMAX        90000
/* for temporary files */
#define LINEBUFFSIZE    1000

/* Evolutionary parameters */

#define POPSIZE_DEF     500
#define TOURSIZE_DEF    3
#define MUTATEPART_DEF  4
#define RANDPART_DEF    6
#define MAXEQUAL_DEF    20
/* demand this many equaly graded generations before finishing */
#define FINISH_DEF      300

/* Migration of MIGRPART every MIGRTIME generations */

#define MIGRTIME_DEF	40
#define MIGRPART_DEF	10

/* How many equaly graded generations before doing local search */
#define	LOCALTRESH_DEF	100

#ifdef TUNABLE_PARAMS
#define POPSIZE         par_popsize
#define TOURSIZE        par_toursize
#define MUTATEPART      par_mutatepart
#define RANDPART        par_randpart
#define MAXEQUAL        par_maxequal
#define FINISH          par_finish
#define MIGRTIME        par_migrtime
#define MIGRPART        par_migrpart
#define	LOCALTRESH	par_localtresh

extern int par_popsize;
extern int par_toursize;
extern int par_mutatepart;
extern int par_randpart;
extern int par_maxequal;
extern int par_finish;
extern int par_migrtime;
extern int par_migrpart;
extern int par_localtresh;

extern int get_params(char *i);
extern void print_params();
#else
#define POPSIZE         POPSIZE_DEF
#define TOURSIZE        TOURSIZE_DEF
#define MUTATEPART      MUTATEPART_DEF
#define RANDPART        RANDPART_DEF
#define MAXEQUAL        MAXEQUAL_DEF
#define FINISH          FINISH_DEF
#define MIGRTIME        MIGRTIME_DEF
#define MIGRPART        MIGRPART_DEF
#define	LOCALTRESH	LOCALTRESH_DEF
#endif

#endif
