/*
 * Tag menu
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#pragma implementation

#include "TagMenu.h"

#include "Environment.h"

#include <map>
#include <vector>
#include <string>

using namespace std;

void TagMenu::do_selected(string tag)
{
	_signal_selected.emit(tag);
}

static void splitTag(const std::string& fulltag, std::string& facet, std::string& tag)
{
	unsigned int p = fulltag.find("::");
	if (p == string::npos)
	{
		facet = "";
		tag = fulltag;
	} else {
		facet = fulltag.substr(0, p);
		tag = fulltag.substr(p + 2);
	}
}

void TagMenu::populateWith(const OpSet<string>& tags) throw ()
{
	std::map<std::string, std::vector<std::string> > contents;
    for (OpSet<std::string>::const_iterator i = tags.begin(); i != tags.end(); i++)
	{
		string facet;
		string tag;
		splitTag(*i, facet, tag);
		std::map<string, vector<string> >::iterator j = contents.find(facet);
		if (j != contents.end())
			j->second.push_back(tag);
		else
		{
			std::vector<std::string> v;
			v.push_back(tag);
			contents.insert(pair<string, vector<string> >(facet, v));
		}
	}

	for (std::map<string, std::vector<string> >::const_iterator i = contents.begin(); i != contents.end(); i++)
	{
		Gtk::Menu* submenu = manage(new Gtk::Menu);
		if (i->first.size())
		{
			for (vector<string>::const_iterator j = i->second.begin(); j != i->second.end(); j++)
			{
				submenu->items().push_back(Gtk::Menu_Helpers::MenuElem(
							*j,
							SigC::bind<string>(
								SigC::slot(*this, &TagMenu::do_selected), i->first + "::" + *j)));
				//printf("Adding %.*s::%.*s\n", PFSTR(i->first), PFSTR(*j));
			}
			//printf("Adding %.*s\n", PFSTR(i->first));
			items().push_back(Gtk::Menu_Helpers::MenuElem(i->first, *submenu));
		} else {
			for (vector<string>::const_iterator j = i->second.begin(); j != i->second.end(); j++)
			{
				submenu->items().push_back(Gtk::Menu_Helpers::MenuElem(
							*j,
							SigC::bind<string>(
								SigC::slot(*this, &TagMenu::do_selected), *j)));
				//printf("Adding %.*s\n", PFSTR(*j));
			}
			items().push_back(Gtk::Menu_Helpers::MenuElem("(legacy)", *submenu));
			//printf("Adding (legacy)\n");
		}
	}
}

void TagMenu::populateWith(const OpSet<string>& tags, const string& facet) throw ()
{
	if (facet.size())
	{
		for (OpSet<string>::const_iterator i = tags.begin(); i != tags.end(); i++)
		{
			string f, t;
			splitTag(*i, f, t);
			//printf("Facet: %.*s, tag: %.*s\n", PFSTR(f), PFSTR(t));
			if (f == facet)
			{
				//printf("Adding %.*s\n", PFSTR(*i));
				items().push_back(Gtk::Menu_Helpers::MenuElem(
							t,
							SigC::bind<string>(
								SigC::slot(*this, &TagMenu::do_selected), *i)));
			}
		}
	} else {
		for (OpSet<string>::const_iterator i = tags.begin(); i != tags.end(); i++)
			if (i->find("::") == string::npos)
			{
				//printf("Adding %.*s\n", PFSTR(*i));
				items().push_back(Gtk::Menu_Helpers::MenuElem(
							*i,
							SigC::bind<string>(
								SigC::slot(*this, &TagMenu::do_selected), *i)));
			}
	}
}

void TagMenu::populateAll(const TagcollDocument<std::string>& doc) throw ()
{
	OpSet<string> allTags = doc.collection().getAllTags();
	populateWith(allTags);
}

void TagMenu::populateAvailable(const TagcollDocument<std::string>& doc, const OpSet<std::string>& selectedTags) throw ()
{
	OpSet<string> tags = doc.collection().getCompanionTags(selectedTags);
	populateWith(tags);
}

void TagMenu::populateAvailable(const TagcollDocument<std::string>& doc, const OpSet<std::string>& selectedTags, const std::string& facet) throw ()
{
	OpSet<string> tags = doc.collection().getCompanionTags(selectedTags);
	populateWith(tags, facet);
}

void TagMenu::populateUnselected(const TagcollDocument<std::string>& doc, const OpSet<std::string>& selectedTags) throw ()
{
	OpSet<string> tags = doc.collection().getAllTags() - selectedTags;
	//for (OpSet<string>::const_iterator i = tags.begin(); i != tags.end(); i++)
		//printf("Sel: %.*s\n", PFSTR(*i));
	populateWith(tags);
}

// vim:set ts=4 sw=4:
