#ifndef TAG_PANEL_H
#define TAG_PANEL_H

/*
 * A single view on a TagcollDocument
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#pragma interface

#include "TagcollDocument.h"
#include "TagSelector.h"
#include "ItemList.h"

#include <sigc++/sigc++.h>
#include <gtkmm/paned.h>

using namespace std;

class TagPanel : public Gtk::HPaned
{
public:
	//typedef SigC::Signal0<bool, Gtk::DirectionType> type_signal_list_focus;

protected:
	TagcollDocument<std::string>& doc;
	TagSelector tagSelector;
	ItemList itemList;

	/*
	type_signal_list_focus _signal_list_focus_in;
	type_signal_list_focus _signal_list_focus_out;
	*/

	void on_signal_add_tag(std::string tag);
	void on_signal_remove_tag(std::string tag);
	
public:
	enum Position { LEFT, RIGHT };
	
	TagPanel(TagcollDocument<std::string>& doc, Position pos);
	virtual ~TagPanel() {}

	const OpSet<std::string>& selectedTags() const { return tagSelector.selected(); }
	const OpSet<std::string>& selectedTags(const OpSet<string>& tagset)
		{ return tagSelector.selected(tagset); }

	std::map< std::string, OpSet<std::string> > getAllItems() { return itemList.getAllItems(); }
	std::map< std::string, OpSet<std::string> > getSelection() { return itemList.getSelection(); }
	int getSelectionSize() { return itemList.getSelectionSize(); }

	//bool isActive() { return itemList.is_focus(); }

	// Signals
	ItemList::type_signal_selection_changed signal_selection_changed() throw ()
		{ return itemList.signal_selection_changed(); }
	ItemList::type_signal_focus_in signal_focus_in() throw ()
		{ return itemList.signal_focus_in(); }
	ItemList::type_signal_request_tagcoll_change signal_request_tagcoll_change() throw ()
		{ return itemList.signal_request_tagcoll_change(); }
	ItemList::type_signal_request_tagset_merge signal_request_tagset_merge() throw ()
		{ return itemList.signal_request_tagset_merge(); }
	ItemList::type_signal_request_tagset_intersect signal_request_tagset_intersect() throw ()
		{ return itemList.signal_request_tagset_intersect(); }
	ItemList::type_signal_request_item_copy signal_request_item_copy() throw ()
		{ return itemList.signal_request_item_copy(); }
	ItemList::type_signal_request_item_copy signal_request_item_move() throw ()
		{ return itemList.signal_request_item_move(); }
	ItemList::type_signal_select_tagset signal_select_tagset() throw ()
		{ return itemList.signal_select_tagset(); }
	ItemList::type_signal_select_tagset signal_select_tagset_other_panel() throw ()
		{ return itemList.signal_select_tagset_other_panel(); }

	void on_tagSelector_changed()
	{
		itemList.setTagset(tagSelector.selected());
	}

	/*
	type_signal_list_focus signal_list_focus_in() throw () { return _signal_list_focus; }
	type_signal_list_focus signal_list_focus_out() throw () { return _signal_list_focus; }
	*/
	//virtual bool do_list_focus_in_event(GdkEventFocus*);
};

// vim:set ts=4 sw=4:
#endif
