/*
 * A single view on a TagcollDocument
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#pragma implementation

#include "TagPanel.h"

#include <tagcoll/stringf.h>
#include "Environment.h"

#include <map>

#include <gtkmm/frame.h>

using namespace std;
using namespace Tagcoll;


TagPanel::TagPanel(TagcollDocument<std::string>& doc, Position pos)
	: doc(doc), tagSelector(doc), itemList(doc)
{
	Gtk::Frame* frame = manage(new Gtk::Frame("Tag filter"));
	frame->add(tagSelector);
	//frame->set_shadow_type(Gtk::SHADOW_OUT);
	if (pos == LEFT)
	{
		add1(*frame);
		add2(itemList);
	} else {
		add1(itemList);
		add2(*frame);
	}

	tagSelector.signal_changed().connect(sigc::mem_fun(*this, &TagPanel::on_tagSelector_changed));
	tagSelector.signal_add_tag().connect(sigc::mem_fun(*this, &TagPanel::on_signal_add_tag));
	tagSelector.signal_remove_tag().connect(sigc::mem_fun(*this, &TagPanel::on_signal_remove_tag));
	//itemList.signal_focus_in_event().connect(sigc::mem_fun(*this, &TagPanel::do_list_focus_in_event));
}

void TagPanel::on_signal_add_tag(Tag tag)
{
	// Get the contents of the selection 
	std::map< string, TagSet > data = getSelection();
	if (data.empty())
		data = getAllItems();
	if (data.empty())
		return;

	// Prepare the change
	TagcollChange<string, Tag> change;
	for (std::map< string, TagSet >::const_iterator i = data.begin();
			i != data.end(); i++)
		change.insert(make_pair(i->first, i->second + tag));

	// Make the change
	doc.applyChange(change);

	signal_request_tagcoll_change().emit(change);
}

void TagPanel::on_signal_remove_tag(Tag tag)
{
	// Get the contents of the selection 
	std::map< string, TagSet > data = getSelection();
	if (data.empty())
		data = getAllItems();
	if (data.empty())
		return;
	
	// Prepare the change
	TagcollChange<string, Tag> change;
	for (std::map< string, TagSet >::const_iterator i = data.begin();
			i != data.end(); i++)
		change.insert(make_pair(i->first, i->second - tag));

	// Make the change
	doc.applyChange(change);

	signal_request_tagcoll_change().emit(change);
}




/*
bool TagPanel::do_list_focus_in_event(GdkEventFocus*)
{
	warning("LFIE\n");
	return false;
}
*/

// vim:set ts=4 sw=4:
