/*
 * Set of tags and set of facets
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#pragma implementation

#include "TagSet.h"

// Only for debugging
#include <tagcoll/stringf.h>

using namespace std;
using namespace Tagcoll;


TagSet::TagSet() throw ()
{
}

TagSet::TagSet(const OpSet<Tag>& p) throw ()
	: OpSet<Tag>(p)
{
}

TagSet::~TagSet() throw ()
{
}

Tag TagSet::find(const std::string& name) const throw ()
{
	Tag sample(0, name);
	const_iterator found = find(sample);
	if (found != end())
		return *found;
	else
		return Tag();
}

FacetSet TagSet::getFacets() const throw ()
{
	FacetSet res;
	for (const_iterator i = begin(); i != end(); i++)
		res += i->facet();
	return res;
}

bool TagSet::has(const std::string& tag) const throw ()
{
	return find(tag);
}


FacetSet::FacetSet() throw ()
{
}

FacetSet::FacetSet(const OpSet<Facet>& p) throw ()
	: OpSet<Facet>(p)
{
}

FacetSet::~FacetSet() throw ()
{
}

Facet FacetSet::obtainFacet(const std::string& name) throw ()
{
	Facet sample(name);
	iterator i = find(sample);
	if (i == end())
	{
		(*this) += sample;
		return sample;
	} else {
		return *i;
	}
}

Tag FacetSet::obtainTag(const std::string& fullname) throw ()
{
	unsigned int p = fullname.find("::");
	if (p == string::npos)
	{
		Facet facet = obtainFacet("");
		Tag tag = facet.obtainTag(fullname);
		if (!tag)
			fprintf(stderr, "FacetSet::obtainTag: Bug! Obtained tag is false\n");
		if (tag.fullname() != fullname)
			fprintf(stderr, "FacetSet::obtainTag: Bug! [%.*s] became [%.*s]\n", PFSTR(fullname), PFSTR(tag.fullname()));
		return tag;
	} else {
		Facet facet = obtainFacet(fullname.substr(0, p));
		Tag tag = facet.obtainTag(fullname.substr(p + 2));
		if (!tag)
			fprintf(stderr, "FacetSet::obtainTag: Bug! Obtained tag is false\n");
		if (tag.fullname() != fullname)
			fprintf(stderr, "FacetSet::obtainTag: Bug! [%.*s] became [%.*s]\n", PFSTR(fullname), PFSTR(tag.fullname()));
		return tag;
	}
}

TagSet FacetSet::getTags() const throw ()
{
	TagSet res;
	for (const_iterator i = begin(); i != end(); i++)
		res += i->tags();
	return res;
}

bool FacetSet::has(const std::string& facet) const throw ()
{
	return find(facet);
}

bool FacetSet::hasTag(const std::string& tag) const throw ()
{
	unsigned int p = tag.find("::");
	if (p == string::npos)
	{
		Facet f = find("");
		if (!f)
			return false;
		return f.hasTag(tag);
	} else {
		Facet f = find(tag.substr(0, p));
		if (!f)
			return false;
		return f.hasTag(tag.substr(p + 2));
	}
}

Facet FacetSet::find(const std::string& name) const throw ()
{
	Facet sample(name);
	const_iterator found = find(sample);
	if (found != end())
		return *found;
	else
		return Facet();
}

Tag FacetSet::findTag(const std::string& tag) const throw ()
{
	//fprintf(stderr, "FT [%.*s]\n", PFSTR(tag));
	unsigned int p = tag.find("::");
	if (p == string::npos)
	{
		//fprintf(stderr, "FT unf [%.*s]\n", PFSTR(tag));
		Facet facet = find("");
		if (!facet)
			return Tag();
		return facet.getTag(tag);
	} else {
		//fprintf(stderr, "FT fac [%.*s -- %.*s]\n", PFSTR(tag.substr(0, p)), PFSTR(tag.substr(p + 2)));
		Facet facet = find(tag.substr(0, p));
		if (!facet)
			return Tag();
		Tag res = facet.getTag(tag.substr(p + 2));
		//fprintf(stderr, "FT res [%.*s]\n", PFSTR(res.fullname()));
		//if (res.fullname() != tag)
			//fprintf(stderr, "FT ERROR\n");
		return res;
	}
}

// vim:set ts=4 sw=4:
