#ifndef TAGCOLL_EDITOR_H
#define TAGCOLL_EDITOR_H

/*
 * Main application class
 *
 * Copyright (C) 2003  Enrico Zini
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "TagcollDocument.h"
#include "TagPanel.h"

#include <gtkmm/window.h>
//#include <gtkmm/table.h>
#include <gtkmm/paned.h>
#include <gtkmm/menu.h>
#include <gtkmm/menubar.h>
#include <gtkmm/label.h>
#include <gtkmm/combo.h>
#include <gtkmm/button.h>

using namespace std;

class TagcollEditor : public Gtk::Window
{
protected:
	TagcollDocument<std::string>& doc;
	TagPanel* panels[2];
	//TagPanel leftTagPanel;
	//TagPanel rightTagPanel;
	Gtk::VBox mainVBox;
	Gtk::HBox entryHBox;
	Gtk::Label addLabel;
	Gtk::Combo addCombo;
	Gtk::Button addButton;
	//Gtk::Table panelTable;
	Gtk::HPaned mainHPaned;
	bool changed;
	int currentPanel;

	Gtk::MenuBar menuBar;
	Gtk::Menu fileMenu;
	Gtk::Menu editMenu;
	Gtk::Menu helpMenu;

	Gtk::Widget* saveMenuItem;
	Gtk::Widget* saveasMenuItem;
	Gtk::Widget* undoMenuItem;
	Gtk::Widget* redoMenuItem;
	Gtk::Widget* mergeMenuItem;
	Gtk::Widget* intersectMenuItem;
	Gtk::Widget* copyToOtherMenuItem;
	Gtk::Widget* moveToOtherMenuItem;
	Gtk::Widget* deleteUnselectedMenuItem;

	void checkUndo();
	void setChanged(bool val);

	TagPanel& activePanel() { return *panels[currentPanel]; }
	TagPanel& otherPanel() { return *panels[1 - currentPanel]; }

public:
	TagcollEditor(TagcollDocument<std::string>& doc);
	virtual ~TagcollEditor() {}

	void on_open();
	void on_open_debtags();
	void on_save();
	void on_save_as();
	void on_quit();
	void on_undo();
	void on_redo();
	void on_merge();
	void on_intersect();
	void on_copy_to_other();
	void on_move_to_other();
	void on_delete_unselected();

	void on_doc_change();
	void on_filename_change();
	void on_selection_change();

	void on_leftpanel_focus();
	void on_rightpanel_focus();

	void on_request_tagcoll_change(Tagcoll::PatchList<std::string, Tag> change);

	void on_select_tagset_panel1(TagSet tagset);
	void on_select_tagset_panel2(TagSet tagset);

	void on_addButton_clicked();
};

// vim:set ts=4 sw=4:
#endif
