#!/bin/sh
# Run this to generate all the initial makefiles, etc.


srcdir=`dirname $0`
test -z "$srcdir" && srcdir=.

(test -f $srcdir/configure.ac) || {
    echo -n "*** Error: Directory "\`$srcdir\'" does not look like the"
    echo " project top-level directory"
    exit 1
}


OSTYPE=`uname -s`

echo "=== Running aclocal"
aclocal || {
    echo "*** Error: aclocal failed."
    exit 1
}

echo "=== Running automake"
if test "$OSTYPE" = "IRIX" -o "$OSTYPE" = "IRIX64"; then
   AMFLAGS=" --include-deps";
fi
automake --add-missing $AMFLAGS || {
    echo "*** Error: automake failed."
    exit 1
}

echo "=== Running autoconf"
autoconf || {
    echo "*** Error: autoconf failed."
    exit 1
}


echo
echo "Now you are ready to run './configure'"
echo
