/******************************************************************************
*                                                                             *
*  TakTuk, a middleware for adaptive large scale parallel remote executions   *
*  deployment. Perl implementation, copyright(C) 2006 Guillaume Huard.        *
*                                                                             *
*  This program is free software; you can redistribute it and/or modify       *
*  it under the terms of the GNU General Public License as published by       *
*  the Free Software Foundation; either version 2 of the License, or          *
*  (at your option) any later version.                                        *
*                                                                             *
*  This program is distributed in the hope that it will be useful,            *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
*  GNU General Public License for more details.                               *
*                                                                             *
*  You should have received a copy of the GNU General Public License          *
*  along with this program; if not, write to the Free Software                *
*  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA *
*                                                                             *
*  Contact: Guillaume.Huard@imag.fr                                           *
*           ENSIMAG - Laboratoire ID                                          *
*           51 avenue Jean Kuntzmann                                          *
*           38330 Montbonnot Saint Martin                                     *
*                                                                             *
******************************************************************************/

#ifndef __TAKTUK__
#define __TAKTUK__
#include <sys/types.h>
#include <sys/uio.h>

#define TAKTUK_ESWRIT 0
#define TAKTUK_EFCLSD 1
#define TAKTUK_ESREAD 2
#define TAKTUK_EARGTO 3
#define TAKTUK_EARGBD 4
#define TAKTUK_ETMOUT 5
#define TAKTUK_EINVST 6
#define TAKTUK_EALLOC 7
#define TAKTUK_EIBUFF 8
#define TAKTUK_EINTRN 9
#define TAKTUK_ENOCON 10

#define TAKTUK_READ_SIZE 8192
#define TAKTUK_WRITE_SIZE 8192

#define TAKTUK_TIMEOUT 'O'
#define TAKTUK_WAIT_MESSAGE 'W'
#define TAKTUK_MESSAGE 'm'
#define TAKTUK_SEND_TO 't'

extern int taktuk_error;

const char *taktuk_error_msg(int msg_code);
/* Similar to the routine send available in taktuk_perl but do not check the
 * correctness of the set specification (will just fail to send quietly within
 * taktuk engine in this case). */
int taktuk_send(const char *dest, const void *buffer, size_t length);
int taktuk_recv(char *from, void *buffer, size_t length, int timeout);
int taktuk_sendv(const char *dest, const struct iovec *iov, int iovcnt);
int taktuk_recvv(char *from, const struct iovec *iov, int iovcnt, int timeout);

#endif
