/*----- PROTECTED REGION ID(TangoAccessControlClass.cpp) ENABLED START -----*/
static const char *RcsId      = "$Id: TangoAccessControlClass.cpp 16161 2011-03-21 13:18:14Z taurel $";
static const char *TagName    = "$Name$";
static const char *CvsPath    = "$Source$";
static const char *SvnPath    = "$HeadURL:  $";
static const char *HttpServer = "http://www.esrf.eu/computing/cs/tango/tango_doc/ds_doc/";
//=============================================================================
//
// file :        TangoAccessControlClass.cpp
//
// description : C++ source for the TangoAccessControlClass. A singleton
//               class derived from DeviceClass. It implements the
//               command list and all properties and methods required
//               by the �name� once per process.
//
// project :     Tango Access Control Management.
//
//
// Copyright (C) :      2004,2005,2006,2007,2008,2009,2010,2011
//						European Synchrotron Radiation Facility
//                      BP 220, Grenoble 38043
//                      FRANCE
//
// This file is part of Tango.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
//
// $Author: taurel $
//
// $Revision: 16161 $
// $Date: 2011-03-21 14:18:14 +0100 (Mon, 21 Mar 2011) $
//
// SVN only:
// $HeadURL:  $
//
// CVS only:
// $Source$
// $Log$
// Revision 1.7  2011/02/11 14:21:42  pascal_verdier
// GetAccessForMutiIP  command added.
//
// Revision 1.6  2011/02/11 13:28:43  pascal_verdier
// Pogo-7 compatibility.
//
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================


#include <tango.h>
#include <TangoAccessControl.h>
#include <TangoAccessControlClass.h>

/*----- PROTECTED REGION END -----*/

//-------------------------------------------------------------------
/**
 *	Create TangoAccessControlClass singleton and
 *	return it in a C function for Python usage
 */
//-------------------------------------------------------------------
extern "C" {
#ifdef _TG_WINDOWS_

__declspec(dllexport)

#endif

	Tango::DeviceClass *_create_TangoAccessControl_class(const char *name) {
		return TangoAccessControl_ns::TangoAccessControlClass::init(name);
	}
}


namespace TangoAccessControl_ns
{


//===================================================================
//	Initialize pointer for singleton pattern
//===================================================================
TangoAccessControlClass *TangoAccessControlClass::_instance = NULL;

//--------------------------------------------------------
/**
 * method : 		TangoAccessControlClass::TangoAccessControlClass(string &s)
 * description : 	constructor for the TangoAccessControlClass
 *
 * @param s	The class name
 */
//--------------------------------------------------------
TangoAccessControlClass::TangoAccessControlClass(string &s):AccessControl_ns::AccessControlClass(s)
{
	cout2 << "Entering TangoAccessControlClass constructor" << endl;
	set_default_property();
	get_class_property();
	write_class_property();

	/*----- PROTECTED REGION ID(TangoAccessControl::Class::constructor) ENABLED START -----*/
	

	/*----- PROTECTED REGION END -----*/	//	TangoAccessControl::Class::constructor

	cout2 << "Leaving TangoAccessControlClass constructor" << endl;
}


//--------------------------------------------------------
/**
 * method : 		TangoAccessControlClass::~TangoAccessControlClass()
 * description : 	destructor for the TangoAccessControlClass
 */
//--------------------------------------------------------
TangoAccessControlClass::~TangoAccessControlClass()
{
	/*----- PROTECTED REGION ID(TangoAccessControl::Class::destructor) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	TangoAccessControl::Class::destructor

	_instance = NULL;
}


//--------------------------------------------------------
/**
 * method : 		TangoAccessControlClass::init
 * description : 	Create the object if not already done.
 *                  Otherwise, just return a pointer to the object
 *
 * @param	name	The class name
 */
//--------------------------------------------------------
TangoAccessControlClass *TangoAccessControlClass::init(const char *name)
{
	if (_instance == NULL)
	{
		try
		{
			string s(name);
			_instance = new TangoAccessControlClass(s);
		}
		catch (bad_alloc)
		{
			throw;
		}		
	}		
	return _instance;
}

//--------------------------------------------------------
/**
 * method : 		TangoAccessControlClass::instance
 * description : 	Check if object already created,
 *                  and return a pointer to the object
 */
//--------------------------------------------------------
TangoAccessControlClass *TangoAccessControlClass::instance()
{
	if (_instance == NULL)
	{
		cerr << "Class is not initialised !!" << endl;
		exit(-1);
	}
	return _instance;
}




//===================================================================
//	Command execution method calls
//===================================================================
//--------------------------------------------------------
/**
 * method : 		AddAddressForUserClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *AddAddressForUserClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "AddAddressForUserClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<TangoAccessControl *>(device))->add_address_for_user(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		AddDeviceForUserClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *AddDeviceForUserClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "AddDeviceForUserClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<TangoAccessControl *>(device))->add_device_for_user(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		CloneUserClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *CloneUserClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "CloneUserClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<TangoAccessControl *>(device))->clone_user(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		GetAccessClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *GetAccessClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "GetAccessClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	return insert((static_cast<TangoAccessControl *>(device))->get_access(argin));
}
//--------------------------------------------------------
/**
 * method : 		GetAccessForMultiIPClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *GetAccessForMultiIPClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "GetAccessForMultiIPClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	return insert((static_cast<TangoAccessControl *>(device))->get_access_for_multi_ip(argin));
}
//--------------------------------------------------------
/**
 * method : 		GetAddressByUserClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *GetAddressByUserClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "GetAddressByUserClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<TangoAccessControl *>(device))->get_address_by_user(argin));
}
//--------------------------------------------------------
/**
 * method : 		GetAllowedCommandClassListClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *GetAllowedCommandClassListClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "GetAllowedCommandClassListClass::execute(): arrived" << endl;

	
	return insert((static_cast<TangoAccessControl *>(device))->get_allowed_command_class_list());
}
//--------------------------------------------------------
/**
 * method : 		GetAllowedCommandsClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *GetAllowedCommandsClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "GetAllowedCommandsClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<TangoAccessControl *>(device))->get_allowed_commands(argin));
}
//--------------------------------------------------------
/**
 * method : 		GetDeviceByUserClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *GetDeviceByUserClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "GetDeviceByUserClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<TangoAccessControl *>(device))->get_device_by_user(argin));
}
//--------------------------------------------------------
/**
 * method : 		GetDeviceClassClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *GetDeviceClassClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "GetDeviceClassClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	return insert((static_cast<TangoAccessControl *>(device))->get_device_class(argin));
}
//--------------------------------------------------------
/**
 * method : 		GetUsersClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *GetUsersClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "GetUsersClass::execute(): arrived" << endl;

	
	return insert((static_cast<TangoAccessControl *>(device))->get_users());
}
//--------------------------------------------------------
/**
 * method : 		RegisterServiceClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *RegisterServiceClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "RegisterServiceClass::execute(): arrived" << endl;

	
	((static_cast<TangoAccessControl *>(device))->register_service());
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		RemoveAddressForUserClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *RemoveAddressForUserClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "RemoveAddressForUserClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<TangoAccessControl *>(device))->remove_address_for_user(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		RemoveDeviceForUserClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *RemoveDeviceForUserClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "RemoveDeviceForUserClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);
	((static_cast<TangoAccessControl *>(device))->remove_device_for_user(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		RemoveUserClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *RemoveUserClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "RemoveUserClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);
	((static_cast<TangoAccessControl *>(device))->remove_user(argin));
	return new CORBA::Any();
}
//--------------------------------------------------------
/**
 * method : 		UnregisterServiceClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *UnregisterServiceClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	cout2 << "UnregisterServiceClass::execute(): arrived" << endl;

	
	((static_cast<TangoAccessControl *>(device))->unregister_service());
	return new CORBA::Any();
}




//===================================================================
//	Properties management
//===================================================================

//--------------------------------------------------------
/**
 * method : 		TangoAccessControlClass::get_class_property
 * description : 	Get the class property for specified name.
 *
 * @param	name  The property name
 */
//--------------------------------------------------------
Tango::DbDatum TangoAccessControlClass::get_class_property(string &prop_name)
{
	for (unsigned int i=0 ; i<cl_prop.size() ; i++)
		if (cl_prop[i].name == prop_name)
			return cl_prop[i];
	//	if not found, returns  an empty DbDatum
	return Tango::DbDatum(prop_name);
}


//--------------------------------------------------------
/**
 *	Method      : TangoAccessControl::TangoAccessControlClass::get_default_device_property()()
 *	Description : Return the default value for device property.
 */
//--------------------------------------------------------
Tango::DbDatum TangoAccessControlClass::get_default_device_property(string &prop_name)
{
	for (unsigned int i=0 ; i<dev_def_prop.size() ; i++)
		if (dev_def_prop[i].name == prop_name)
			return dev_def_prop[i];
	//	if not found, return  an empty DbDatum
	return Tango::DbDatum(prop_name);
}


//--------------------------------------------------------
/**
 *	Method      : TangoAccessControl::TangoAccessControlClass::get_default_class_property()()
 *	Description : Return the default value for class property.
 */
//--------------------------------------------------------
Tango::DbDatum TangoAccessControlClass::get_default_class_property(string &prop_name)
{
	for (unsigned int i=0 ; i<cl_def_prop.size() ; i++)
		if (cl_def_prop[i].name == prop_name)
			return cl_def_prop[i];
	//	if not found, return  an empty DbDatum
	return Tango::DbDatum(prop_name);
}


//--------------------------------------------------------
/**
 *	Method      : TangoAccessControl::TangoAccessControlClass::get_class_property()
 *	Description : //	Add your own code to initialize
 */
//--------------------------------------------------------
void TangoAccessControlClass::get_class_property()
{
}


//--------------------------------------------------------
/**
 *	Method      : TangoAccessControl::TangoAccessControlClass::set_default_property()
 *	Description : Set default property (class and device) for wizard.
 *	              For each property, add to wizard property name and description.
 *	              If default value has been set, add it to wizard property and.
 *	              store it in a DbDatum.
 */
//--------------------------------------------------------
void TangoAccessControlClass::set_default_property()
{
	string	prop_name;
	string	prop_desc;
	string	prop_def;
	vector<string>	vect_data;
	
	//	Set Default Class Properties

	//	Set Default Device Properties
}


//--------------------------------------------------------
/**
 *	Method      : TangoAccessControl::TangoAccessControlClass::write_class_property()
 *	Description : Set class description fields as property in database
 */
//--------------------------------------------------------
void TangoAccessControlClass::write_class_property()
{
	//	First time, check if database used
	if (Tango::Util::_UseDb == false)
		return;

	Tango::DbData	data;
	string	classname = get_name();
	string	header;
	string::size_type	start, end;

	//	Put title
	Tango::DbDatum	title("ProjectTitle");
	string	str_title("Tango Access Control Management");
	title << str_title;
	data.push_back(title);

	//	Put Description
	Tango::DbDatum	description("Description");
	vector<string>	str_desc;
	str_desc.push_back("This class is a conceate class inherited from AccessControl abstract class.<Br>");
	str_desc.push_back("<Br>");
	str_desc.push_back("This class defines how to manage the TANGO access control.<Br>");
	str_desc.push_back("It implements commands for tool to defines access for users, devices and IP addresses.<Br>");
	str_desc.push_back("It implements also commands used by client API to check access for specified user, device and address.<Br>");
	str_desc.push_back("And it implements register and unregister it as TANGO service.");
	description << str_desc;
	data.push_back(description);
		
	//	put cvs or svn location
	string	filename("TangoAccessControl");
	filename += "Class.cpp";
	
	// check for cvs information
	string	src_path(CvsPath);
	start = src_path.find("/");
	if (start!=string::npos)
	{
		end   = src_path.find(filename);
		if (end>start)
		{
			string	strloc = src_path.substr(start, end-start);
			//	Check if specific repository
			start = strloc.find("/cvsroot/");
			if (start!=string::npos && start>0)
			{
				string	repository = strloc.substr(0, start);
				if (repository.find("/segfs/")!=string::npos)
					strloc = "ESRF:" + strloc.substr(start, strloc.length()-start);
			}
			Tango::DbDatum	cvs_loc("cvs_location");
			cvs_loc << strloc;
			data.push_back(cvs_loc);
		}
	}
	// check for svn information
	else
	{
		string	src_path(SvnPath);
		start = src_path.find("://");
		if (start!=string::npos)
		{
			end = src_path.find(filename);
			if (end>start)
			{
				header = "$HeadURL: ";
				start = header.length();
				string	strloc = src_path.substr(start, (end-start));
				
				Tango::DbDatum	svn_loc("svn_location");
				svn_loc << strloc;
				data.push_back(svn_loc);
			}
		}
	}

	//	Get CVS or SVN revision tag
	
	// CVS tag
	string	tagname(TagName);
	header = "$Name: ";
	start = header.length();
	string	endstr(" $");
	
	end   = tagname.find(endstr);
	if (end!=string::npos && end>start)
	{
		string	strtag = tagname.substr(start, end-start);
		Tango::DbDatum	cvs_tag("cvs_tag");
		cvs_tag << strtag;
		data.push_back(cvs_tag);
	}
	
	// SVN tag
	string	svnpath(SvnPath);
	header = "$HeadURL: ";
	start = header.length();
	
	end   = svnpath.find(endstr);
	if (end!=string::npos && end>start)
	{
		string	strloc = svnpath.substr(start, end-start);
		
		string tagstr ("/tags/");
		start = strloc.find(tagstr);
		if ( start!=string::npos )
		{
			start = start + tagstr.length();
			end   = strloc.find(filename);
			string	strtag = strloc.substr(start, end-start-1);
			
			Tango::DbDatum	svn_tag("svn_tag");
			svn_tag << strtag;
			data.push_back(svn_tag);
		}
	}

	//	Get URL location
	string	httpServ(HttpServer);
	if (httpServ.length()>0)
	{
		Tango::DbDatum	db_doc_url("doc_url");
		db_doc_url << httpServ;
		data.push_back(db_doc_url);
	}

	//  Put inheritance
	Tango::DbDatum	inher_datum("InheritedFrom");
	vector<string> inheritance;
	inheritance.push_back("AccessControl");
	inher_datum << inheritance;
	data.push_back(inher_datum);

	//	Call database and and values
	get_db_class()->put_property(data);
}




//===================================================================
//	Factory methods
//===================================================================


//--------------------------------------------------------
/**
 * method : 		TangoAccessControlClass::device_factory
 * description : 	Create the device object(s)
 *                  and store them in the device list
 *
 * @param	*devlist_ptr	The device name list
 */
//--------------------------------------------------------
void TangoAccessControlClass::device_factory(const Tango::DevVarStringArray *devlist_ptr)
{

	/*----- PROTECTED REGION ID(TangoAccessControl::Class::device_factory_before) ENABLED START -----*/

	//	Add your own code
	

	/*----- PROTECTED REGION END -----*/	//	TangoAccessControl::Class::device_factory_before

	//	Create devices and add it into the device list
	for (unsigned long i=0 ; i<devlist_ptr->length() ; i++)
	{
		cout4 << "Device name : " << (*devlist_ptr)[i].in() << endl;
		device_list.push_back(new TangoAccessControl(this, (*devlist_ptr)[i]));							 
	}

	//	Manage dynamic attributes if any
	erase_dynamic_attributes(devlist_ptr, get_class_attr()->get_attr_list());

	//	Export devices to the outside world
	for (unsigned long i=1 ; i<=devlist_ptr->length() ; i++)
	{
		//	Add dynamic attributes if any
		TangoAccessControl *dev = static_cast<TangoAccessControl *>(device_list[device_list.size()-i]);
		dev->add_dynamic_attributes();

		//	Check before if database used.
		if ((Tango::Util::_UseDb == true) && (Tango::Util::_FileDb == false))
			export_device(dev);
		else
			export_device(dev, dev->get_name().c_str());
	}

	/*----- PROTECTED REGION ID(TangoAccessControl::Class::device_factory_after) ENABLED START -----*/

	//	Add your own code
	

	/*----- PROTECTED REGION END -----*/	//	TangoAccessControl::Class::device_factory_after

	
}


//--------------------------------------------------------
/**
 *	Method      : TangoAccessControl::TangoAccessControlClass::attribute_factory()
 *	Description : Create the attribute object(s)
 *	              and store them in the attribute list
 */
//--------------------------------------------------------
void TangoAccessControlClass::attribute_factory(vector<Tango::Attr *> &att_list)
{
	/*----- PROTECTED REGION ID(TangoAccessControl::Class::attribute_factory_before) ENABLED START -----*/

	//	Add your own code

	/*----- PROTECTED REGION END -----*/	//	TangoAccessControl::Class::attribute_factory_before

	AccessControl_ns::AccessControlClass::attribute_factory(att_list);


	//	Create a list of static attributes
	create_static_attribute_list(get_class_attr()->get_attr_list());

	/*----- PROTECTED REGION ID(TangoAccessControl::Class::attribute_factory_after) ENABLED START -----*/

	//	Add your own code

	/*----- PROTECTED REGION END -----*/	//	TangoAccessControl::Class::attribute_factory_after

}


//--------------------------------------------------------
/**
 *	Method      : TangoAccessControl::TangoAccessControlClass::command_factory()
 *	Description : Create the command object(s)
 *	              and store them in the command list
 */
//--------------------------------------------------------
void TangoAccessControlClass::command_factory()
{
	/*----- PROTECTED REGION ID(TangoAccessControl::Class::command_factory_before) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	TangoAccessControl::Class::command_factory_before

	AccessControl_ns::AccessControlClass::command_factory();
	AddAddressForUserClass	*pAddAddressForUserCmd =
		new AddAddressForUserClass("AddAddressForUser",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"user name, address",
			"",
			Tango::OPERATOR);
	command_list.push_back(pAddAddressForUserCmd);
	AddDeviceForUserClass	*pAddDeviceForUserCmd =
		new AddDeviceForUserClass("AddDeviceForUser",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"user name, device adn value",
			"",
			Tango::OPERATOR);
	command_list.push_back(pAddDeviceForUserCmd);
	CloneUserClass	*pCloneUserCmd =
		new CloneUserClass("CloneUser",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"[0] - source user name.\n[1] - target user name.",
			"",
			Tango::OPERATOR);
	command_list.push_back(pCloneUserCmd);
	GetAccessClass	*pGetAccessCmd =
		new GetAccessClass("GetAccess",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_STRING,
			"[0] - User name\n[1] - IP Address\n[2] - Device",
			"access for specified inputs  read/write.",
			Tango::OPERATOR);
	command_list.push_back(pGetAccessCmd);
	GetAccessForMultiIPClass	*pGetAccessForMultiIPCmd =
		new GetAccessForMultiIPClass("GetAccessForMultiIP",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_STRING,
			"[0] - User name\n[1] - Device\n[2] - IP Address #1\n[3] - IP Address #2\n[4] - IP Address #3\n[5] - IP Address #4\n......",
			"access for specified inputs  read/write.",
			Tango::OPERATOR);
	command_list.push_back(pGetAccessForMultiIPCmd);
	GetAddressByUserClass	*pGetAddressByUserCmd =
		new GetAddressByUserClass("GetAddressByUser",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"user name.",
			"Addresses found for the specified user.",
			Tango::OPERATOR);
	command_list.push_back(pGetAddressByUserCmd);
	GetAllowedCommandClassListClass	*pGetAllowedCommandClassListCmd =
		new GetAllowedCommandClassListClass("GetAllowedCommandClassList",
			Tango::DEV_VOID, Tango::DEVVAR_STRINGARRAY,
			"",
			"Class names which have AllowedAccessCmd property defined.",
			Tango::OPERATOR);
	command_list.push_back(pGetAllowedCommandClassListCmd);
	GetAllowedCommandsClass	*pGetAllowedCommandsCmd =
		new GetAllowedCommandsClass("GetAllowedCommands",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"Device name OR Device Class name",
			"Allowed commands found in database for specified device",
			Tango::OPERATOR);
	command_list.push_back(pGetAllowedCommandsCmd);
	GetDeviceByUserClass	*pGetDeviceByUserCmd =
		new GetDeviceByUserClass("GetDeviceByUser",
			Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
			"user name.",
			"devices and rights found for the specified user.",
			Tango::OPERATOR);
	command_list.push_back(pGetDeviceByUserCmd);
	GetDeviceClassClass	*pGetDeviceClassCmd =
		new GetDeviceClassClass("GetDeviceClass",
			Tango::DEV_STRING, Tango::DEV_STRING,
			"Device name",
			"Class found in database for specified device",
			Tango::OPERATOR);
	command_list.push_back(pGetDeviceClassCmd);
	GetUsersClass	*pGetUsersCmd =
		new GetUsersClass("GetUsers",
			Tango::DEV_VOID, Tango::DEVVAR_STRINGARRAY,
			"",
			"Users find in table access_address.",
			Tango::OPERATOR);
	command_list.push_back(pGetUsersCmd);
	RegisterServiceClass	*pRegisterServiceCmd =
		new RegisterServiceClass("RegisterService",
			Tango::DEV_VOID, Tango::DEV_VOID,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pRegisterServiceCmd);
	RemoveAddressForUserClass	*pRemoveAddressForUserCmd =
		new RemoveAddressForUserClass("RemoveAddressForUser",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"user name, address",
			"",
			Tango::OPERATOR);
	command_list.push_back(pRemoveAddressForUserCmd);
	RemoveDeviceForUserClass	*pRemoveDeviceForUserCmd =
		new RemoveDeviceForUserClass("RemoveDeviceForUser",
			Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
			"user name, device and value",
			"",
			Tango::OPERATOR);
	command_list.push_back(pRemoveDeviceForUserCmd);
	RemoveUserClass	*pRemoveUserCmd =
		new RemoveUserClass("RemoveUser",
			Tango::DEV_STRING, Tango::DEV_VOID,
			"user name",
			"",
			Tango::OPERATOR);
	command_list.push_back(pRemoveUserCmd);
	UnregisterServiceClass	*pUnregisterServiceCmd =
		new UnregisterServiceClass("UnregisterService",
			Tango::DEV_VOID, Tango::DEV_VOID,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pUnregisterServiceCmd);

	/*----- PROTECTED REGION ID(TangoAccessControl::Class::command_factory_after) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	TangoAccessControl::Class::command_factory_after

}




//===================================================================
//	Dynamic attributes related methods
//===================================================================


//--------------------------------------------------------
/**
 * method : 		TangoAccessControlClass::create_static_attribute_list
 * description : 	Create the a list of static attributes
 *
 * @param	att_list	the ceated attribute list 
 */
//--------------------------------------------------------
void TangoAccessControlClass::create_static_attribute_list(vector<Tango::Attr *> &att_list)
{
	for (unsigned long i=0 ; i<att_list.size() ; i++)
	{
		string att_name(att_list[i]->get_name());
		transform(att_name.begin(), att_name.end(), att_name.begin(), ::tolower);
		defaultAttList.push_back(att_name);
	}

	cout2 << defaultAttList.size() << " attributes in default list" << endl;


	/*----- PROTECTED REGION ID(TangoAccessControl::Class::create_static_att_list) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	TangoAccessControl::Class::create_static_att_list

}


//--------------------------------------------------------
/**
 * method : 		TangoAccessControlClass::erase_dynamic_attributes
 * description : 	delete the dynamic attributes if any.
 *
 * @param	devlist_ptr	the device list pointer
 * @param	list of all attributes
 */
//--------------------------------------------------------
void TangoAccessControlClass::erase_dynamic_attributes(const Tango::DevVarStringArray *devlist_ptr, vector<Tango::Attr *> &att_list)
{
	Tango::Util *tg = Tango::Util::instance();

	for (unsigned long i=0 ; i<devlist_ptr->length() ; i++)
	{	
		Tango::DeviceImpl *dev_impl = tg->get_device_by_name(((string)(*devlist_ptr)[i]).c_str());
		TangoAccessControl *dev = static_cast<TangoAccessControl *> (dev_impl);
		
		vector<Tango::Attribute *> &dev_att_list = dev->get_device_attr()->get_attribute_list();
		vector<Tango::Attribute *>::iterator ite_att;
		for (ite_att=dev_att_list.begin() ; ite_att != dev_att_list.end() ; ++ite_att)
		{
			string att_name((*ite_att)->get_name_lower());
			if ((att_name == "state") || (att_name == "status"))
				continue;
			vector<string>::iterator ite_str = find(defaultAttList.begin(), defaultAttList.end(), att_name);
			if (ite_str == defaultAttList.end())
			{
				cout2 << att_name << " is a UNWANTED dynamic attribute for device " << (*devlist_ptr)[i] << endl;
				Tango::Attribute &att = dev->get_device_attr()->get_attr_by_name(att_name.c_str());
				dev->remove_attribute(att_list[att.get_attr_idx()],true);
				--ite_att;
			}
		}
	}
	/*----- PROTECTED REGION ID(TangoAccessControl::Class::erase_dynamic_attributes) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	TangoAccessControl::Class::erase_dynamic_attributes

}



	/*----- PROTECTED REGION ID(TangoAccessControl::Class::Additional Methods) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	TangoAccessControl::Class::Additional Methods

} //	namespace
