/*----- PROTECTED REGION ID(TangoAccessControlClass.h) ENABLED START -----*/
//=============================================================================
//
// file :        TangoAccessControlClass.h
//
// description : Include for the TangoAccessControlClass root class.
//               This class is the singleton class for.
//               the TangoAccessControl device class..
//               It contains all properties and methods which the .
//               TangoAccessControl requires only once e.g. the commands.
//
// project :     Tango Access Control Management.
//
//
// Copyright (C) :      2004,2005,2006,2007,2008,2009,2010,2011,2012,2013,2014
//						European Synchrotron Radiation Facility
//                      BP 220, Grenoble 38043
//                      FRANCE
//
// This file is part of Tango.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
// $Author: pascal_verdier $
//
// $Revision: 25304 $
// $Date: 2014-03-25 13:48:26 +0100 (Tue, 25 Mar 2014) $
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================


#ifndef TANGOACCESSCONTROLCLASS_H
#define TANGOACCESSCONTROLCLASS_H

#include <tango.h>
#include <TangoAccessControl.h>
#include <AccessControlClass.h>

/*----- PROTECTED REGION END -----*/	//	TangoAccessControlClass.h


namespace TangoAccessControl_ns
{
/*----- PROTECTED REGION ID(TangoAccessControlClass::classes for dynamic creation) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	TangoAccessControlClass::classes for dynamic creation

//=========================================
//	Define classes for commands
//=========================================
//	Command AddAddressForUser class definition
class AddAddressForUserClass : public Tango::Command
{
public:
	AddAddressForUserClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	AddAddressForUserClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~AddAddressForUserClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoAccessControl *>(dev))->is_AddAddressForUser_allowed(any);}
};

//	Command AddDeviceForUser class definition
class AddDeviceForUserClass : public Tango::Command
{
public:
	AddDeviceForUserClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	AddDeviceForUserClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~AddDeviceForUserClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoAccessControl *>(dev))->is_AddDeviceForUser_allowed(any);}
};

//	Command CloneUser class definition
class CloneUserClass : public Tango::Command
{
public:
	CloneUserClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	CloneUserClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~CloneUserClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoAccessControl *>(dev))->is_CloneUser_allowed(any);}
};

//	Command GetAccess class definition
class GetAccessClass : public Tango::Command
{
public:
	GetAccessClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	GetAccessClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~GetAccessClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoAccessControl *>(dev))->is_GetAccess_allowed(any);}
};

//	Command GetAccessForMultiIP class definition
class GetAccessForMultiIPClass : public Tango::Command
{
public:
	GetAccessForMultiIPClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	GetAccessForMultiIPClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~GetAccessForMultiIPClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoAccessControl *>(dev))->is_GetAccessForMultiIP_allowed(any);}
};

//	Command GetAddressByUser class definition
class GetAddressByUserClass : public Tango::Command
{
public:
	GetAddressByUserClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	GetAddressByUserClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~GetAddressByUserClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoAccessControl *>(dev))->is_GetAddressByUser_allowed(any);}
};

//	Command GetAllowedCommandClassList class definition
class GetAllowedCommandClassListClass : public Tango::Command
{
public:
	GetAllowedCommandClassListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	GetAllowedCommandClassListClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~GetAllowedCommandClassListClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoAccessControl *>(dev))->is_GetAllowedCommandClassList_allowed(any);}
};

//	Command GetAllowedCommands class definition
class GetAllowedCommandsClass : public Tango::Command
{
public:
	GetAllowedCommandsClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	GetAllowedCommandsClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~GetAllowedCommandsClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoAccessControl *>(dev))->is_GetAllowedCommands_allowed(any);}
};

//	Command GetDeviceByUser class definition
class GetDeviceByUserClass : public Tango::Command
{
public:
	GetDeviceByUserClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	GetDeviceByUserClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~GetDeviceByUserClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoAccessControl *>(dev))->is_GetDeviceByUser_allowed(any);}
};

//	Command GetDeviceClass class definition
class GetDeviceClassClass : public Tango::Command
{
public:
	GetDeviceClassClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	GetDeviceClassClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~GetDeviceClassClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoAccessControl *>(dev))->is_GetDeviceClass_allowed(any);}
};

//	Command GetUsers class definition
class GetUsersClass : public Tango::Command
{
public:
	GetUsersClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	GetUsersClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~GetUsersClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoAccessControl *>(dev))->is_GetUsers_allowed(any);}
};

//	Command RegisterService class definition
class RegisterServiceClass : public Tango::Command
{
public:
	RegisterServiceClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	RegisterServiceClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~RegisterServiceClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoAccessControl *>(dev))->is_RegisterService_allowed(any);}
};

//	Command RemoveAddressForUser class definition
class RemoveAddressForUserClass : public Tango::Command
{
public:
	RemoveAddressForUserClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	RemoveAddressForUserClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~RemoveAddressForUserClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoAccessControl *>(dev))->is_RemoveAddressForUser_allowed(any);}
};

//	Command RemoveDeviceForUser class definition
class RemoveDeviceForUserClass : public Tango::Command
{
public:
	RemoveDeviceForUserClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	RemoveDeviceForUserClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~RemoveDeviceForUserClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoAccessControl *>(dev))->is_RemoveDeviceForUser_allowed(any);}
};

//	Command RemoveUser class definition
class RemoveUserClass : public Tango::Command
{
public:
	RemoveUserClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	RemoveUserClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~RemoveUserClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoAccessControl *>(dev))->is_RemoveUser_allowed(any);}
};

//	Command UnregisterService class definition
class UnregisterServiceClass : public Tango::Command
{
public:
	UnregisterServiceClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	UnregisterServiceClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~UnregisterServiceClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoAccessControl *>(dev))->is_UnregisterService_allowed(any);}
};


/**
 *	The TangoAccessControlClass singleton definition
 */

#ifdef _TG_WINDOWS_
class __declspec(dllexport)  TangoAccessControlClass : public AccessControl_ns::AccessControlClass
#else
class TangoAccessControlClass : public AccessControl_ns::AccessControlClass
#endif
{
	/*----- PROTECTED REGION ID(TangoAccessControlClass::Additionnal DServer data members) ENABLED START -----*/
public:
	

	/*----- PROTECTED REGION END -----*/	//	TangoAccessControlClass::Additionnal DServer data members

	public:
		//	write class properties data members
		Tango::DbData	cl_prop;
		Tango::DbData	cl_def_prop;
		Tango::DbData	dev_def_prop;
	
		//	Method prototypes
		static TangoAccessControlClass *init(const char *);
		static TangoAccessControlClass *instance();
		~TangoAccessControlClass();
		Tango::DbDatum	get_class_property(string &);
		Tango::DbDatum	get_default_device_property(string &);
		Tango::DbDatum	get_default_class_property(string &);
	
	protected:
		TangoAccessControlClass(string &);
		static TangoAccessControlClass *_instance;
		void command_factory();
		void attribute_factory(vector<Tango::Attr *> &);
		void write_class_property();
		void set_default_property();
		void get_class_property();
		string get_cvstag();
		string get_cvsroot();
	
	private:
		void device_factory(const Tango::DevVarStringArray *);
		void create_static_attribute_list(vector<Tango::Attr *> &);
		void erase_dynamic_attributes(const Tango::DevVarStringArray *,vector<Tango::Attr *> &);
		vector<string>	defaultAttList;
		Tango::Attr *get_attr_object_by_name(vector<Tango::Attr *> &att_list, string attname);
};

}	//	End of namespace

#endif   //	TangoAccessControl_H
