/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_AVATAR_H__
#define __TPA_AVATAR_H__

#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS

/* TYPE MACROS */
#define TPA_TYPE_AVATAR \
    (tpa_avatar_get_type())
#define TPA_AVATAR(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_AVATAR, TpaAvatar))
#define TPA_AVATAR_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_AVATAR, TpaAvatarClass))
#define TPA_IS_AVATAR(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_AVATAR))
#define TPA_IS_AVATAR_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_AVATAR))
#define TPA_AVATAR_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_AVATAR, TpaAvatarClass))
#define TPA_AVATAR_GET_PRIVATE(obj) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((obj), TPA_TYPE_AVATAR, TpaAvatarPrivate))

typedef struct _TpaAvatar TpaAvatar;
typedef struct _TpaAvatarClass TpaAvatarClass;
typedef struct _TpaAvatarPrivate TpaAvatarPrivate;

struct _TpaAvatarClass {
    GObjectClass parent_class;
};

struct _TpaAvatar {
    GObject parent;
    TpaAvatarPrivate *priv;
};

GType               tpa_avatar_get_type               (void);
TpaAvatar *         tpa_avatar_new_from_file          (const gchar *file,
                                                       const gchar *mimetype);
TpaAvatar *         tpa_avatar_new                    (GArray *image,
                                                       const gchar *mimetype,
                                                       const gchar *token);
const GArray *      tpa_avatar_get_image              (TpaAvatar *self);
const gchar *       tpa_avatar_get_mime_type          (TpaAvatar *self);
const gchar *       tpa_avatar_get_token              (TpaAvatar *self);

G_END_DECLS

#endif /* #ifndef __TPA_AVATAR_H__*/
