/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_CONTACT_LIST_H__
#define __TPA_CONTACT_LIST_H__

#include <glib.h>
#include <glib-object.h>

#include <tapioca/client/tpa-object.h>
#include <tapioca/client/tpa-contact.h>

G_BEGIN_DECLS

/* TYPE MACROS */
#define TPA_TYPE_CONTACT_LIST \
    (tpa_contact_list_get_type())
#define TPA_CONTACT_LIST(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_CONTACT_LIST, TpaContactList))
#define TPA_CONTACT_LIST_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_CONTACT_LIST, TpaContactListClass))
#define TPA_IS_CONTACT_LIST(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_CONTACT_LIST))
#define TPA_IS_CONTACT_LIST_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_CONTACT_LIST))
#define TPA_CONTACT_LIST_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_CONTACT_LIST, TpaContactListClass))
#define TPA_CONTACT_LIST_GET_PRIVATE(obj) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((obj), TPA_TYPE_CONTACT_LIST, TpaContactListPrivate))

typedef struct _TpaContactList TpaContactList;
typedef struct _TpaContactListClass TpaContactListClass;
typedef struct _TpaContactListPrivate TpaContactListPrivate;

struct _TpaContactListClass {
    TpaObjectClass parent_class;
};

struct _TpaContactList {
    TpaObject parent;
    TpaContactListPrivate *priv;
};

GType               tpa_contact_list_get_type           (void);
const TpaContact *  tpa_contact_list_add                (TpaContactList *self,
                                                         const gchar *uri);
void                tpa_contact_list_remove             (TpaContactList *self,
                                                         TpaContact *contact);
GPtrArray *         tpa_contact_list_get_known          (TpaContactList *self);
GPtrArray *         tpa_contact_list_get_subscribed     (TpaContactList *self);
GPtrArray *         tpa_contact_list_get_authorized     (TpaContactList *self);
GPtrArray *         tpa_contact_list_get_hidden         (TpaContactList *self);
GPtrArray *         tpa_contact_list_get_blocked        (TpaContactList *self);
TpaContact *        tpa_contact_list_get_contact        (TpaContactList *self,
                                                         const gchar *uri);
gboolean            tpa_contact_list_is_local           (TpaContactList *self);

G_END_DECLS

#endif /* #ifndef __TPA_CONTACT_LIST_H__*/
