/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_MEDIA_STREAM_H__
#define __TPA_MEDIA_STREAM_H__

#include <glib.h>
#include <glib-object.h>

#include <tapioca/client/tpa-channel.h>

G_BEGIN_DECLS

/* TYPE MACROS */
#define TPA_TYPE_MEDIA_STREAM \
    (tpa_media_stream_get_type())
#define TPA_MEDIA_STREAM(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_MEDIA_STREAM, TpaMediaStream))
#define TPA_MEDIA_STREAM_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_MEDIA_STREAM, TpaMediaStreamClass))
#define TPA_IS_MEDIA_STREAM(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_MEDIA_STREAM))
#define TPA_IS_MEDIA_STREAM_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_MEDIA_STREAM))
#define TPA_MEDIA_STREAM_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_MEDIA_STREAM, TpaMediaStreamClass))
#define TPA_MEDIA_STREAM_GET_PRIVATE(obj) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((obj), TPA_TYPE_MEDIA_STREAM, TpaMediaStreamPrivate))


typedef struct _TpaMediaStream TpaMediaStream;
typedef struct _TpaMediaStreamClass TpaMediaStreamClass;
typedef struct _TpaMediaStreamPrivate TpaMediaStreamPrivate;

struct _TpaMediaStreamClass {
    TpaObjectClass parent_class;
};

struct _TpaMediaStream {
    TpaObject parent;
    TpaMediaStreamPrivate *priv;
};

GType               tpa_media_stream_get_type         (void);
TpaMediaStream *    tpa_media_stream_new              (TpaObject *object);
gboolean            tpa_media_stream_handle_channel   (TpaMediaStream *self,
                                                       TpaChannel *channel);
void                tpa_media_stream_set_audio_volume (TpaMediaStream *self,
                                                       guint stream,
                                                       guint volume);
void                tpa_media_stream_mute_input       (TpaMediaStream *self,
                                                       guint stream,
                                                       gboolean mute);
void                tpa_media_stream_mute_output      (TpaMediaStream *self,
                                                       guint stream,
                                                       gboolean mute);
void                tpa_media_stream_add_video_output (TpaMediaStream *self,
                                                       guint stream,
                                                       guint window);
void                tpa_media_stream_remove_video_output
                                                      (TpaMediaStream *self,
                                                       guint window);
void                tpa_media_stream_add_video_input  (TpaMediaStream *self,
                                                       guint window);
void                tpa_media_stream_remove_video_input
                                                      (TpaMediaStream *self,
                                                       guint window);

G_END_DECLS

#endif /* #ifndef __TPA_MEDIA_STREAM_H__*/

