/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_FORWARDING_H__
#define __TPA_FORWARDING_H__

#include <tapioca/base/tpa-errors.h>

G_BEGIN_DECLS

typedef struct _TpaIForwarding TpaIForwarding;
typedef struct _TpaIForwardingPrivate TpaIForwardingPrivate;

struct _TpaIForwarding {
    GTypeInterface parent;

    TpaError    (* get_forwarding_handle)   (GObject *obj,
                                             guint *handle);
    TpaError    (* set_forwarding_handle)   (GObject *obj,
                                             guint handle);
    TpaIForwardingPrivate *priv;
};

/* TYPE MACROS */
#define TPA_TYPE_IFORWARDING \
    (tpa_forwarding_get_type ())
#define TPA_IS_IFORWARDING(obj) \
    (g_type_is_a (G_OBJECT_TYPE(obj), TPA_TYPE_IFORWARDING))
#define TPA_IFORWARDING(obj) \
    (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TPA_TYPE_IFORWARDING, TpaIForwarding))

GType       tpa_forwarding_get_type             (void);
void        tpa_forwarding_init                 (TpaIForwarding *iface,
                                                 gpointer data);
void        tpa_forwarding_finalize             (GObject *obj);
void        tpa_forwarding_signal_forwarding_changed
                                                (GObject *obj,
                                                 guint forward_to);

G_END_DECLS

#endif /* #ifndef __TPA_FORWARDING_H__*/
