/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_ICE_H__
#define __TPA_ICE_H__

#include <tapioca/base/tpa-errors.h>

G_BEGIN_DECLS

typedef struct _TpaIIce TpaIIce;
typedef struct _TpaIcePrivate TpaIIcePrivate;

struct _TpaIIce {
    GTypeInterface parent;

    TpaError    (* get_session_handler)     (GObject *obj,
                                             GPtrArray *ret);
    TpaIIcePrivate *priv;
};

/* TYPE MACROS */
#define TPA_TYPE_IICE \
    (tpa_ice_get_type ())
#define TPA_IS_IICE(obj) \
    (g_type_is_a (G_OBJECT_TYPE(obj), TPA_TYPE_IICE))
#define TPA_IICE(obj) \
    (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TPA_TYPE_IICE, TpaIIce))

GType       tpa_ice_get_type                    (void);
void        tpa_ice_init                        (TpaIIce *iface,
                                                 gpointer data);
void        tpa_ice_finalize                    (GObject *obj);
void        tpa_ice_signal_new_ice_session_handler
                                                (GObject *obj,
                                                 const gchar *session_handler,
                                                 const gchar *type);
G_END_DECLS

#endif /* #ifndef __TPA_ICE_H__*/
