/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate file output normals
 */

#include <ac/fcntl.h>
#include <ac/unistd.h>
#include <file/output/normal.h>


file_output_normal::~file_output_normal()
{
	if (::close(fd))
		nfatal("close");
}


file_output_normal::file_output_normal()
	: fn(__FILE__), fd(-1)
{
	fatal("default constructor not public (bug)");
}


file_output_normal::file_output_normal(char *arg)
	: fn(arg), fd(-1)
{
	fd = ::creat(arg, 0666);
	if (fd < 0)
		nfatal("open");
}


file_output_normal::file_output_normal(const file_output_normal &arg)
	: fn(arg.fn), fd(-1)
{
	fd = dup(arg.fd);
	if (fd < 0)
		arg.nfatal("dup");
}


file_output_normal &
file_output_normal::operator = (const file_output_normal &arg)
{
	fn = arg.fn;
	fd = dup(arg.fd);
	if (fd < 0)
		arg.nfatal("dup");
	return *this;
}


void
file_output_normal::write(const void *buffer, int nbytes)
	const
{
	int count = ::write(fd, buffer, nbytes);
	if (count < 0)
		nfatal("write");
	if (count != nbytes)
		fatal("short write (gave %d, got %d)", nbytes, count);
}

const char *
file_output_normal::filename()
	const
{
	return fn;
}
