/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: interface definition for common/tar/input/filter_base.cc
 */

#ifndef COMMON_TAR_INPUT_FILTER_BASE_H
#define COMMON_TAR_INPUT_FILTER_BASE_H

#include <tar/input.h>

class tar_input_filter_base: public tar_input
{
	 public:
	 virtual ~tar_input_filter_base();
	 tar_input_filter_base(tar_input *);
	 virtual int read_data(void *, int);
	 virtual void read_data_padding();
	 virtual int read_header(tar_header &);
	 virtual void read_header_padding();
	 virtual const char *filename() const;

	 private:
	 tar_input *fp;

	 protected:
	 tar_input_filter_base();
	 tar_input_filter_base(const tar_input_filter_base &);
	 tar_input_filter_base &operator = (const tar_input_filter_base &);
};

#endif /* COMMON_TAR_INPUT_FILTER_BASE_H */
