/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate tar input group_numbers
 */

#include <tar/input/group_numbr.h>


tar_input_group_number::~tar_input_group_number()
{
}


tar_input_group_number::tar_input_group_number(tar_input *arg_fp, long arg_gid)
	: tar_input_filter_base(arg_fp), gid(arg_gid)
{
}


int
tar_input_group_number::read_header(tar_header &h)
{
	int ok = tar_input_filter_base::read_header(h);
	if (ok)
		h.group_id = gid;
	return ok;
}


tar_input_group_number::tar_input_group_number()
{
	fatal("bug %s %d", __FILE__, __LINE__);
}


tar_input_group_number::tar_input_group_number(const tar_input_group_number &)
{
	fatal("bug %s %d", __FILE__, __LINE__);
}


tar_input_group_number &
tar_input_group_number::operator = (const tar_input_group_number &)
{
	fatal("bug %s %d", __FILE__, __LINE__);
	return *this;
}
