/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate tar input user numbers
 */

#include <ac/time.h>

#include <tar/input/filter/now.h>


tar_input_filter_now::~tar_input_filter_now()
{
}


tar_input_filter_now::tar_input_filter_now(tar_input *arg) :
    tar_input_filter(arg),
    mtime(0)
{
    time_t tmp;
    time(&tmp);
    mtime = tmp;
}


int
tar_input_filter_now::read_header(tar_header &h)
{
    int ok = tar_input_filter::read_header(h);
    if (ok)
	h.mtime = mtime;
    return ok;
}
