//
//	srecord - manipulate eprom load files
//	Copyright (C) 2003 Peter Miller;
//	All rights reserved.
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
//
// MANIFEST: interface definition for common/tar/output/filter.cc
//

#ifndef COMMON_TAR_OUTPUT_FILTER_H
#define COMMON_TAR_OUTPUT_FILTER_H

#pragma interface "tar_output_filter"

#include <tar/output.h>

/**
  * The tar_output_filter class is used to represent a generic filter
  * class which modifies the file headers or data in some way.
  * The default operation of the methods of this class is to forward the
  * operation to the deepr instance; derived classes will override those
  * methods which need a different behaviour.
  */
class tar_output_filter:
    public tar_output
{
public:
    /**
      * The destructor.
      */
    virtual ~tar_output_filter();

    /**
      * The constructor.
      */
    tar_output_filter(tar_output *);

    // See base class for documentation.
    void write_header(const tar_header &);

    // See base class for documentation.
    void write_header_padding();

    // See base class for documentation.
    void write_data(const void *, int);

    // See base class for documentation.
    void write_data_padding();

    // See base class for documentation.
    const char *filename() const;

    // See base class for documentation.
    void write_archive_begin();

    // See base class for documentation.
    void write_archive_end();

private:
    /**
      * The deeper instance variable is used to remember where the
      * filtered output is to be sent.
      */
    tar_output *deeper;

    /**
      * The default constructor.  Do not use.
      */
    tar_output_filter();

    /**
      * The copy constructor.  Do not use.
      */
    tar_output_filter(const tar_output_filter &);

    /**
      * The assignment operator.  Do not use.
      */
    tar_output_filter &operator=(const tar_output_filter &);
};

#endif // COMMON_TAR_OUTPUT_FILTER_H
