//
//      srecord - manipulate eprom load files
//      Copyright (C) 2002, 2008, 2009 Peter Miller
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 3 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program. If not, see
//      <http://www.gnu.org/licenses/>.
//

#ifndef COMMON_FILENAMELIST_FILE_H
#define COMMON_FILENAMELIST_FILE_H

#include <libtardy/filenamelist.h>
#include <libtardy/file/input.h>

/**
  * The filenamelist_file class is used to represent a file name list
  * sourced from a file, one file name per line.
  */
class filenamelist_file:
        public filenamelist
{
public:
        /**
          * The destructor.
          */
        virtual ~filenamelist_file();

        /**
          * The constructor.
          */
        filenamelist_file(file_input *);

        // see base class for documentation
        bool read_one_line(rcstring &result);

        // see base class for documentation
        const char *filename() const;

private:
        /**
          * The `source' instance variable is used to remember where to
          * get the input from.
          */
        file_input *source;

        /**
          * The `position' instance variable is used to remember the
          * current position within the buffer.
          */
        int position;

        /**
          * The `length' instance variable is used to remember the number
          * of valid characters within the buffer.
          */
        int length;

        /**
          * The `buffer' instance variable is used to remember data read
          * from the source.  The source is buffered for better eficiency.
          */
        char buffer[512];

        /**
          * The read_one_char method is used to read one character
          * from the input source, buffered using the the `buffer',
          * `position' and `length' instance variables.
          */
        inline int read_one_char();

        /**
          * The default constructor.  Do not use.
          */
        filenamelist_file();

        /**
          * The copy constructor.  Do not use.
          */
        filenamelist_file(const filenamelist_file &);

        /**
          * The assignment operator.  Do not use.
          */
        filenamelist_file &operator=(const filenamelist_file &);
};

#endif // COMMON_FILENAMELIST_FILE_H
