/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.compile;

import org.jatha.Jatha;
import org.jatha.compile.CompilerException;
import org.jatha.compile.EvalPrimitive;
import org.jatha.compile.LispCompiler;
import org.jatha.compile.LispPrimitive;
import org.jatha.compile.WrongArgumentTypeException;
import org.jatha.dynatype.LispValue;
import org.jatha.machine.SECDMachine;

public class ApplyPrimitive
extends LispPrimitive {
    public ApplyPrimitive(Jatha lisp) {
        super(lisp, "APPLY", 2L, Long.MAX_VALUE);
    }

    public void Execute(SECDMachine machine) throws CompilerException {
        LispValue args = machine.S.pop();
        LispValue fn = args.car();
        LispValue fnArgs = args.cdr();
        if (!this.validArgumentList(args)) {
            throw new WrongArgumentTypeException("APPLY", "a CONS in the last argument", "a " + fnArgs.last().car().type_of().toString());
        }
        machine.S.push(this.f_lisp.makeCons(fn, this.f_lisp.COMPILER.quoteList(this.constructArgList(fnArgs))));
        machine.C.pop();
        machine.C.push(new EvalPrimitive(this.f_lisp));
    }

    public LispValue CompileArgs(LispCompiler compiler, SECDMachine machine, LispValue args, LispValue valueList, LispValue code) throws CompilerException {
        return compiler.compileArgsLeftToRight(args, valueList, this.f_lisp.makeCons(machine.LIS, this.f_lisp.makeCons(args.length(), code)));
    }

    LispValue constructArgList(LispValue args) {
        if (args.cdr() == this.f_lisp.NIL) {
            return args.car();
        }
        return this.f_lisp.makeCons(args.car(), this.constructArgList(args.cdr()));
    }

    public boolean validArgumentList(LispValue args) {
        if (args.last().car().basic_consp()) {
            return super.validArgumentList(args);
        }
        System.err.println(";; *ERROR*: Last argument to APPLY must be a CONS.");
        return false;
    }
}

