/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.compile;

import java.io.PrintStream;
import org.jatha.Jatha;
import org.jatha.compile.CompilerException;
import org.jatha.compile.LispCompiler;
import org.jatha.dynatype.LispInteger;
import org.jatha.dynatype.LispValue;
import org.jatha.dynatype.StandardLispSymbol;
import org.jatha.dynatype.StandardLispValue;
import org.jatha.machine.SECDMachine;

public abstract class LispPrimitive
extends StandardLispValue {
    protected long minNumberOfArgs;
    protected long maxNumberOfArgs;
    public boolean inlineP = false;
    protected String functionName;
    protected LispValue functionNameSymbol;

    public String toString() {
        return "#<function " + this.functionName + " " + this.parameterCountString() + ">";
    }

    public boolean basic_functionp() {
        return true;
    }

    public void printCode(LispValue code) {
        this.printCode(code, 2);
    }

    public void printCode(LispValue code, int indentAmount) {
        while (code != this.f_lisp.NIL) {
            code = ((LispPrimitive)code.car()).grindef(code, indentAmount);
        }
    }

    public LispValue grindef(LispValue code, int indentAmount) {
        this.indent(indentAmount);
        System.out.print(this.functionName);
        this.f_lisp.NEWLINE.internal_princ(System.out);
        return code.cdr();
    }

    public void indent(int amount) {
        int i = 0;
        while (i < amount) {
            this.f_lisp.SPACE.internal_princ(System.out);
            ++i;
        }
    }

    public LispPrimitive(Jatha lisp, String fnName, long minArgs, long maxArgs) {
        super(lisp);
        this.minNumberOfArgs = minArgs;
        this.maxNumberOfArgs = maxArgs;
        this.functionName = fnName;
        this.functionNameSymbol = new StandardLispSymbol(this.f_lisp, fnName);
    }

    public LispPrimitive(Jatha lisp, String fnName, long minArgs) {
        super(lisp);
        this.minNumberOfArgs = minArgs;
        this.maxNumberOfArgs = minArgs;
        this.functionName = fnName;
        this.functionNameSymbol = new StandardLispSymbol(this.f_lisp, fnName);
    }

    public LispPrimitive(Jatha lisp, String fnName) {
        super(lisp);
        this.minNumberOfArgs = 0L;
        this.maxNumberOfArgs = 0L;
        this.functionName = fnName;
        this.functionNameSymbol = new StandardLispSymbol(this.f_lisp, fnName);
    }

    public String LispFunctionNameString() {
        return this.functionName;
    }

    public LispValue LispFunctionNameSymbol() {
        return this.functionNameSymbol;
    }

    public void internal_princ(PrintStream os) {
        os.print(this.toString());
    }

    public void internal_prin1(PrintStream os) {
        os.print(this.toString());
    }

    public void internal_print(PrintStream os) {
        os.print(this.toString());
    }

    boolean validArgumentLength(LispValue numberOfArguments) {
        long numArgs = ((LispInteger)numberOfArguments).getLongValue();
        return this.minNumberOfArgs <= numArgs && numArgs <= this.maxNumberOfArgs;
    }

    public boolean validArgumentList(LispValue args) {
        return this.validArgumentLength(args.length());
    }

    public String parameterCountString() {
        String result = Long.toString(this.minNumberOfArgs);
        if (this.maxNumberOfArgs == Long.MAX_VALUE) {
            result = result + "...";
        } else if (this.maxNumberOfArgs != this.minNumberOfArgs) {
            result = result + " " + this.maxNumberOfArgs;
        }
        return result;
    }

    public abstract void Execute(SECDMachine var1) throws CompilerException;

    LispValue BuiltinFunctionCode(LispValue fn) {
        return fn.symbol_function().second();
    }

    public LispValue CompileArgs(LispCompiler compiler, SECDMachine machine, LispValue args, LispValue valueList, LispValue code) throws CompilerException {
        return compiler.compileArgsLeftToRight(args, valueList, code);
    }

    public LispValue CompileArgs(LispCompiler compiler, SECDMachine machine, LispValue function, LispValue args, LispValue valueList, LispValue code) throws CompilerException {
        if (this.inlineP) {
            return this.CompileArgs(compiler, machine, args, valueList, code);
        }
        LispValue fncode = function.symbol_function().second();
        return this.CompileArgs(compiler, machine, args, valueList, this.f_lisp.makeCons(fncode, code));
    }
}

