/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.dynatype;

import java.io.PrintStream;
import org.jatha.Jatha;
import org.jatha.dynatype.LispCharacter;
import org.jatha.dynatype.LispValue;
import org.jatha.dynatype.StandardLispAtom;

public class StandardLispCharacter
extends StandardLispAtom
implements LispCharacter {
    private char value;

    public StandardLispCharacter() {
    }

    public StandardLispCharacter(Jatha lisp, char theChar) {
        super(lisp);
        this.value = theChar;
    }

    public StandardLispCharacter(Jatha lisp) {
        super(lisp);
        this.value = (char)109;
    }

    public void internal_princ(PrintStream os) {
        os.print(this.value);
    }

    public void internal_prin1(PrintStream os) {
        os.print("#\\" + this.value);
    }

    public void internal_print(PrintStream os) {
        os.print("#\\" + this.value);
    }

    char getValue() {
        return this.value;
    }

    public Object toJava() {
        return new Character(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public boolean basic_constantp() {
        return true;
    }

    public LispValue characterp() {
        return this.f_lisp.T;
    }

    public LispValue eql(LispValue val) {
        if (val instanceof LispCharacter) {
            if (this.value == ((LispCharacter)val).getCharacterValue()) {
                return this.f_lisp.T;
            }
            return this.f_lisp.NIL;
        }
        return super.eql(val);
    }

    public LispValue equal(LispValue val) {
        return this.eql(val);
    }

    public LispValue type_of() {
        return this.f_lisp.CHARACTER_TYPE;
    }

    public LispValue typep(LispValue type) {
        LispValue result = super.typep(type);
        if (result == this.f_lisp.T || type == this.f_lisp.CHARACTER_TYPE) {
            return this.f_lisp.T;
        }
        return this.f_lisp.NIL;
    }

    public char getCharacterValue() {
        return this.value;
    }
}

