/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.test.junit;

import java.io.EOFException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jatha.Jatha;
import org.jatha.dynatype.LispCons;
import org.jatha.dynatype.LispValue;
import org.jatha.dynatype.LispValueNotAListException;
import org.jatha.dynatype.StandardLispBignum;
import org.jatha.dynatype.StandardLispCons;
import org.jatha.dynatype.StandardLispConstant;
import org.jatha.dynatype.StandardLispHashTable;
import org.jatha.dynatype.StandardLispInteger;
import org.jatha.dynatype.StandardLispPackage;
import org.jatha.dynatype.StandardLispReal;
import org.jatha.dynatype.StandardLispString;
import org.jatha.dynatype.StandardLispSymbol;

public class CoreTest
extends TestCase {
    protected static Jatha f_lisp;
    protected LispValue f_NIL;
    protected LispValue f_T;
    protected LispValue f_Bignum;
    protected LispValue f_Cons;
    protected LispValue f_Constant;
    protected LispValue f_Function;
    protected LispValue f_HashTable;
    protected LispValue f_Integer;
    protected LispValue f_Keyword;
    protected LispValue f_List;
    protected LispValue f_Number;
    protected LispValue f_QuotedList;
    protected LispValue f_Package;
    protected LispValue f_Real;
    protected LispValue f_String;
    protected LispValue f_Symbol;
    protected LispValue A;
    protected LispValue B;
    protected LispValue C;
    protected LispValue D;
    protected LispValue E;
    protected LispValue ONE;
    protected LispValue TWO;
    protected LispValue THREE;
    protected LispValue FOUR;
    protected LispValue FIVE;
    static /* synthetic */ Class class$org$jatha$test$junit$CoreTest;

    public static void main(String[] args) {
        boolean useGui = false;
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                if (args[i].equalsIgnoreCase("-gui")) {
                    useGui = true;
                }
                ++i;
            }
        }
        if (useGui) {
            junit.swingui.TestRunner.run((Class)(class$org$jatha$test$junit$CoreTest == null ? (class$org$jatha$test$junit$CoreTest = CoreTest.class$("org.jatha.test.junit.CoreTest")) : class$org$jatha$test$junit$CoreTest));
        } else {
            TestRunner.run((Test)CoreTest.suite());
        }
    }

    protected void setUp() throws Exception {
        f_lisp = new Jatha(false, false);
        f_lisp.init();
        f_lisp.start();
        try {
            this.A = f_lisp.parse("A");
            this.B = f_lisp.parse("B");
            this.C = f_lisp.parse("C");
            this.D = f_lisp.parse("D");
            this.E = f_lisp.parse("E");
        }
        catch (EOFException eof) {
            throw new Exception("Can't parse symbols.");
        }
        this.ONE = new StandardLispInteger(f_lisp, 1L);
        this.TWO = new StandardLispInteger(f_lisp, 2L);
        this.THREE = new StandardLispInteger(f_lisp, 3L);
        this.FOUR = new StandardLispInteger(f_lisp, 4L);
        this.FIVE = new StandardLispInteger(f_lisp, 5L);
        this.f_NIL = CoreTest.f_lisp.NIL;
        this.f_T = CoreTest.f_lisp.T;
        this.f_Bignum = new StandardLispBignum(f_lisp, -2L);
        this.f_Cons = new StandardLispCons(f_lisp, this.A, this.B);
        this.f_Constant = new StandardLispConstant(f_lisp, "CONSTANT");
        this.f_Function = f_lisp.parse("CAR").symbol_function();
        this.f_HashTable = new StandardLispHashTable(f_lisp);
        this.f_Integer = new StandardLispInteger(f_lisp, 614L);
        this.f_Keyword = f_lisp.parse(":HELLO");
        this.f_List = f_lisp.makeList(this.A, this.B, this.C);
        this.f_Package = new StandardLispPackage(f_lisp, "TEST-PACKAGE");
        this.f_QuotedList = f_lisp.makeList(CoreTest.f_lisp.QUOTE, f_lisp.makeList(this.A, this.B, this.C));
        this.f_Real = new StandardLispReal(f_lisp, 6.14);
        this.f_String = new StandardLispString(f_lisp, "a test string");
        this.f_Symbol = new StandardLispSymbol(f_lisp, "TEST-SYMBOL");
    }

    public static Test suite() {
        return new TestSuite(class$org$jatha$test$junit$CoreTest == null ? (class$org$jatha$test$junit$CoreTest = CoreTest.class$("org.jatha.test.junit.CoreTest")) : class$org$jatha$test$junit$CoreTest);
    }

    public void testBasicAtom() {
        Assert.assertTrue((boolean)this.A.basic_atom());
        Assert.assertTrue((boolean)this.ONE.basic_atom());
        Assert.assertTrue((boolean)this.f_NIL.basic_atom());
        Assert.assertTrue((boolean)this.f_T.basic_atom());
        Assert.assertTrue((boolean)this.f_Bignum.basic_atom());
        Assert.assertFalse((boolean)this.f_Cons.basic_atom());
        Assert.assertTrue((boolean)this.f_Constant.basic_atom());
        Assert.assertFalse((boolean)this.f_Function.basic_atom());
        Assert.assertFalse((boolean)this.f_HashTable.basic_atom());
        Assert.assertTrue((boolean)this.f_Integer.basic_atom());
        Assert.assertTrue((boolean)this.f_Keyword.basic_atom());
        Assert.assertFalse((boolean)this.f_List.basic_atom());
        Assert.assertFalse((boolean)this.f_Package.basic_atom());
        Assert.assertTrue((boolean)this.f_Real.basic_atom());
        Assert.assertTrue((boolean)this.f_String.basic_atom());
        Assert.assertTrue((boolean)this.f_Symbol.basic_atom());
    }

    public void testBasicBignump() {
        Assert.assertFalse((boolean)this.A.basic_bignump());
        Assert.assertFalse((boolean)this.ONE.basic_bignump());
        Assert.assertFalse((boolean)this.f_NIL.basic_bignump());
        Assert.assertFalse((boolean)this.f_T.basic_bignump());
        Assert.assertTrue((boolean)this.f_Bignum.basic_bignump());
        Assert.assertFalse((boolean)this.f_Cons.basic_bignump());
        Assert.assertFalse((boolean)this.f_Constant.basic_bignump());
        Assert.assertFalse((boolean)this.f_Function.basic_bignump());
        Assert.assertFalse((boolean)this.f_HashTable.basic_bignump());
        Assert.assertFalse((boolean)this.f_Integer.basic_bignump());
        Assert.assertFalse((boolean)this.f_Keyword.basic_bignump());
        Assert.assertFalse((boolean)this.f_List.basic_bignump());
        Assert.assertFalse((boolean)this.f_Package.basic_bignump());
        Assert.assertFalse((boolean)this.f_Real.basic_bignump());
        Assert.assertFalse((boolean)this.f_String.basic_bignump());
        Assert.assertFalse((boolean)this.f_Symbol.basic_bignump());
    }

    public void testBasicConsp() {
        Assert.assertFalse((boolean)this.A.basic_consp());
        Assert.assertFalse((boolean)this.ONE.basic_consp());
        Assert.assertFalse((boolean)this.f_NIL.basic_consp());
        Assert.assertFalse((boolean)this.f_T.basic_consp());
        Assert.assertFalse((boolean)this.f_Bignum.basic_consp());
        Assert.assertTrue((boolean)this.f_Cons.basic_consp());
        Assert.assertFalse((boolean)this.f_Constant.basic_consp());
        Assert.assertTrue((boolean)this.f_Function.basic_consp());
        Assert.assertFalse((boolean)this.f_HashTable.basic_consp());
        Assert.assertFalse((boolean)this.f_Integer.basic_consp());
        Assert.assertFalse((boolean)this.f_Keyword.basic_consp());
        Assert.assertTrue((boolean)this.f_List.basic_consp());
        Assert.assertFalse((boolean)this.f_Package.basic_consp());
        Assert.assertTrue((boolean)this.f_QuotedList.basic_consp());
        Assert.assertFalse((boolean)this.f_Real.basic_consp());
        Assert.assertFalse((boolean)this.f_String.basic_consp());
        Assert.assertFalse((boolean)this.f_Symbol.basic_consp());
    }

    public void testBasicConstantp() {
        Assert.assertFalse((boolean)this.A.basic_constantp());
        Assert.assertTrue((boolean)this.ONE.basic_constantp());
        Assert.assertTrue((boolean)this.f_NIL.basic_constantp());
        Assert.assertTrue((boolean)this.f_T.basic_constantp());
        Assert.assertTrue((boolean)this.f_Bignum.basic_constantp());
        Assert.assertFalse((boolean)this.f_Cons.basic_constantp());
        Assert.assertTrue((boolean)this.f_Constant.basic_constantp());
        Assert.assertFalse((boolean)this.f_Function.basic_constantp());
        Assert.assertFalse((boolean)this.f_HashTable.basic_constantp());
        Assert.assertTrue((boolean)this.f_Integer.basic_constantp());
        Assert.assertTrue((boolean)this.f_Keyword.basic_constantp());
        Assert.assertFalse((boolean)this.f_List.basic_constantp());
        Assert.assertFalse((boolean)this.f_Package.basic_constantp());
        Assert.assertTrue((boolean)this.f_QuotedList.basic_constantp());
        Assert.assertTrue((boolean)this.f_Real.basic_constantp());
        Assert.assertTrue((boolean)this.f_String.basic_constantp());
        Assert.assertFalse((boolean)this.f_Symbol.basic_constantp());
    }

    public void testBasicForeignp() {
        Assert.assertFalse((boolean)this.A.basic_foreignp());
        Assert.assertFalse((boolean)this.ONE.basic_foreignp());
        Assert.assertFalse((boolean)this.f_NIL.basic_foreignp());
        Assert.assertFalse((boolean)this.f_T.basic_foreignp());
        Assert.assertFalse((boolean)this.f_Bignum.basic_foreignp());
        Assert.assertFalse((boolean)this.f_Cons.basic_foreignp());
        Assert.assertFalse((boolean)this.f_Constant.basic_foreignp());
        Assert.assertFalse((boolean)this.f_Function.basic_foreignp());
        Assert.assertFalse((boolean)this.f_HashTable.basic_foreignp());
        Assert.assertFalse((boolean)this.f_Integer.basic_foreignp());
        Assert.assertFalse((boolean)this.f_Keyword.basic_foreignp());
        Assert.assertFalse((boolean)this.f_List.basic_foreignp());
        Assert.assertFalse((boolean)this.f_Package.basic_foreignp());
        Assert.assertFalse((boolean)this.f_Real.basic_foreignp());
        Assert.assertFalse((boolean)this.f_String.basic_foreignp());
        Assert.assertFalse((boolean)this.f_Symbol.basic_foreignp());
    }

    public void testBasicIntegerp() {
        Assert.assertFalse((boolean)this.A.basic_integerp());
        Assert.assertTrue((boolean)this.ONE.basic_integerp());
        Assert.assertFalse((boolean)this.f_NIL.basic_integerp());
        Assert.assertFalse((boolean)this.f_T.basic_integerp());
        Assert.assertTrue((boolean)this.f_Bignum.basic_integerp());
        Assert.assertFalse((boolean)this.f_Cons.basic_integerp());
        Assert.assertFalse((boolean)this.f_Constant.basic_integerp());
        Assert.assertFalse((boolean)this.f_Function.basic_integerp());
        Assert.assertFalse((boolean)this.f_HashTable.basic_integerp());
        Assert.assertTrue((boolean)this.f_Integer.basic_integerp());
        Assert.assertFalse((boolean)this.f_Keyword.basic_integerp());
        Assert.assertFalse((boolean)this.f_List.basic_integerp());
        Assert.assertFalse((boolean)this.f_Package.basic_integerp());
        Assert.assertFalse((boolean)this.f_Real.basic_integerp());
        Assert.assertFalse((boolean)this.f_String.basic_integerp());
        Assert.assertFalse((boolean)this.f_Symbol.basic_integerp());
    }

    public void testBasicFunctionp() {
        Assert.assertFalse((boolean)this.A.basic_functionp());
        Assert.assertFalse((boolean)this.ONE.basic_functionp());
        Assert.assertFalse((boolean)this.f_NIL.basic_functionp());
        Assert.assertFalse((boolean)this.f_T.basic_functionp());
        Assert.assertFalse((boolean)this.f_Bignum.basic_functionp());
        Assert.assertFalse((boolean)this.f_Cons.basic_functionp());
        Assert.assertFalse((boolean)this.f_Constant.basic_functionp());
        Assert.assertFalse((boolean)this.f_Function.basic_functionp());
        Assert.assertFalse((boolean)this.f_HashTable.basic_functionp());
        Assert.assertFalse((boolean)this.f_Integer.basic_functionp());
        Assert.assertFalse((boolean)this.f_Keyword.basic_functionp());
        Assert.assertFalse((boolean)this.f_List.basic_functionp());
        Assert.assertFalse((boolean)this.f_Package.basic_functionp());
        Assert.assertFalse((boolean)this.f_Real.basic_functionp());
        Assert.assertFalse((boolean)this.f_String.basic_functionp());
        Assert.assertFalse((boolean)this.f_Symbol.basic_functionp());
    }

    public void testBasicKeywordp() {
        Assert.assertFalse((boolean)this.A.basic_keywordp());
        Assert.assertFalse((boolean)this.ONE.basic_keywordp());
        Assert.assertFalse((boolean)this.f_NIL.basic_keywordp());
        Assert.assertFalse((boolean)this.f_T.basic_keywordp());
        Assert.assertFalse((boolean)this.f_Bignum.basic_keywordp());
        Assert.assertFalse((boolean)this.f_Cons.basic_keywordp());
        Assert.assertFalse((boolean)this.f_Constant.basic_keywordp());
        Assert.assertFalse((boolean)this.f_Function.basic_keywordp());
        Assert.assertFalse((boolean)this.f_HashTable.basic_keywordp());
        Assert.assertFalse((boolean)this.f_Integer.basic_keywordp());
        Assert.assertTrue((boolean)this.f_Keyword.basic_keywordp());
        Assert.assertFalse((boolean)this.f_List.basic_keywordp());
        Assert.assertFalse((boolean)this.f_Package.basic_keywordp());
        Assert.assertFalse((boolean)this.f_Real.basic_keywordp());
        Assert.assertFalse((boolean)this.f_String.basic_keywordp());
        Assert.assertFalse((boolean)this.f_Symbol.basic_keywordp());
    }

    public void testBasicLength() {
        int l = 0;
        try {
            l = this.A.basic_length();
            Assert.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException e) {
            // empty catch block
        }
        try {
            l = this.ONE.basic_length();
            Assert.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException e) {
            // empty catch block
        }
        Assert.assertTrue((0 == this.f_NIL.basic_length() ? 1 : 0) != 0);
        try {
            l = this.f_T.basic_length();
            Assert.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException e) {
            // empty catch block
        }
        try {
            l = this.f_Bignum.basic_length();
            Assert.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException e) {
            // empty catch block
        }
        try {
            l = this.f_Cons.basic_length();
            Assert.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException e) {
            // empty catch block
        }
        try {
            l = this.f_Constant.basic_length();
            Assert.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException e) {
            // empty catch block
        }
        Assert.assertTrue((1 < this.f_Function.basic_length() ? 1 : 0) != 0);
        try {
            l = this.f_HashTable.basic_length();
            Assert.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException e) {
            // empty catch block
        }
        try {
            l = this.f_Integer.basic_length();
            Assert.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException e) {
            // empty catch block
        }
        try {
            l = this.f_Keyword.basic_length();
            Assert.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException e) {
            // empty catch block
        }
        Assert.assertTrue((3 == this.f_List.basic_length() ? 1 : 0) != 0);
        try {
            l = this.f_Package.basic_length();
            Assert.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException e) {
            // empty catch block
        }
        Assert.assertTrue((2 == this.f_QuotedList.basic_length() ? 1 : 0) != 0);
        try {
            l = this.f_Real.basic_length();
            Assert.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException e) {
            // empty catch block
        }
        try {
            l = this.f_String.basic_length();
            Assert.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException e) {
            // empty catch block
        }
        try {
            l = this.f_Symbol.basic_length();
            Assert.fail((String)"Should have thrown a LispValueNotAListException.");
        }
        catch (LispValueNotAListException e) {}
    }

    public void testBasicListp() {
        Assert.assertFalse((boolean)this.A.basic_listp());
        Assert.assertFalse((boolean)this.ONE.basic_listp());
        Assert.assertTrue((boolean)this.f_NIL.basic_listp());
        Assert.assertFalse((boolean)this.f_T.basic_listp());
        Assert.assertFalse((boolean)this.f_Bignum.basic_listp());
        Assert.assertTrue((boolean)this.f_Cons.basic_listp());
        Assert.assertFalse((boolean)this.f_Constant.basic_listp());
        Assert.assertTrue((boolean)this.f_Function.basic_listp());
        Assert.assertFalse((boolean)this.f_HashTable.basic_listp());
        Assert.assertFalse((boolean)this.f_Integer.basic_listp());
        Assert.assertFalse((boolean)this.f_Keyword.basic_listp());
        Assert.assertTrue((boolean)this.f_List.basic_listp());
        Assert.assertFalse((boolean)this.f_Package.basic_listp());
        Assert.assertFalse((boolean)this.f_Real.basic_listp());
        Assert.assertFalse((boolean)this.f_String.basic_listp());
        Assert.assertFalse((boolean)this.f_Symbol.basic_listp());
    }

    public void testBasicMacrop() {
        Assert.assertFalse((boolean)this.A.basic_macrop());
        Assert.assertFalse((boolean)this.ONE.basic_macrop());
        Assert.assertFalse((boolean)this.f_NIL.basic_macrop());
        Assert.assertFalse((boolean)this.f_T.basic_macrop());
        Assert.assertFalse((boolean)this.f_Bignum.basic_macrop());
        Assert.assertFalse((boolean)this.f_Cons.basic_macrop());
        Assert.assertFalse((boolean)this.f_Constant.basic_macrop());
        Assert.assertFalse((boolean)this.f_Function.basic_macrop());
        Assert.assertFalse((boolean)this.f_HashTable.basic_macrop());
        Assert.assertFalse((boolean)this.f_Integer.basic_macrop());
        Assert.assertFalse((boolean)this.f_Keyword.basic_macrop());
        Assert.assertFalse((boolean)this.f_List.basic_macrop());
        Assert.assertFalse((boolean)this.f_Package.basic_macrop());
        Assert.assertFalse((boolean)this.f_Real.basic_macrop());
        Assert.assertFalse((boolean)this.f_String.basic_macrop());
        Assert.assertFalse((boolean)this.f_Symbol.basic_macrop());
    }

    public void testBasicNull() {
        Assert.assertFalse((boolean)this.A.basic_null());
        Assert.assertFalse((boolean)this.ONE.basic_null());
        Assert.assertTrue((boolean)this.f_NIL.basic_null());
        Assert.assertFalse((boolean)this.f_T.basic_null());
        Assert.assertFalse((boolean)this.f_Bignum.basic_null());
        Assert.assertFalse((boolean)this.f_Cons.basic_null());
        Assert.assertFalse((boolean)this.f_Constant.basic_null());
        Assert.assertFalse((boolean)this.f_Function.basic_null());
        Assert.assertFalse((boolean)this.f_HashTable.basic_null());
        Assert.assertFalse((boolean)this.f_Integer.basic_null());
        Assert.assertFalse((boolean)this.f_Keyword.basic_null());
        Assert.assertFalse((boolean)this.f_List.basic_null());
        Assert.assertFalse((boolean)this.f_Package.basic_null());
        Assert.assertFalse((boolean)this.f_Real.basic_null());
        Assert.assertFalse((boolean)this.f_String.basic_null());
        Assert.assertFalse((boolean)this.f_Symbol.basic_null());
    }

    public void testBasicNumberp() {
        Assert.assertFalse((boolean)this.A.basic_numberp());
        Assert.assertTrue((boolean)this.ONE.basic_numberp());
        Assert.assertFalse((boolean)this.f_NIL.basic_numberp());
        Assert.assertFalse((boolean)this.f_T.basic_numberp());
        Assert.assertTrue((boolean)this.f_Bignum.basic_numberp());
        Assert.assertFalse((boolean)this.f_Cons.basic_numberp());
        Assert.assertFalse((boolean)this.f_Constant.basic_numberp());
        Assert.assertFalse((boolean)this.f_Function.basic_numberp());
        Assert.assertFalse((boolean)this.f_HashTable.basic_numberp());
        Assert.assertTrue((boolean)this.f_Integer.basic_numberp());
        Assert.assertFalse((boolean)this.f_Keyword.basic_numberp());
        Assert.assertFalse((boolean)this.f_List.basic_numberp());
        Assert.assertFalse((boolean)this.f_Package.basic_numberp());
        Assert.assertTrue((boolean)this.f_Real.basic_numberp());
        Assert.assertFalse((boolean)this.f_String.basic_numberp());
        Assert.assertFalse((boolean)this.f_Symbol.basic_numberp());
    }

    public void testBasicStringp() {
        Assert.assertFalse((boolean)this.A.basic_stringp());
        Assert.assertFalse((boolean)this.ONE.basic_stringp());
        Assert.assertFalse((boolean)this.f_NIL.basic_stringp());
        Assert.assertFalse((boolean)this.f_T.basic_stringp());
        Assert.assertFalse((boolean)this.f_Bignum.basic_stringp());
        Assert.assertFalse((boolean)this.f_Cons.basic_stringp());
        Assert.assertFalse((boolean)this.f_Constant.basic_stringp());
        Assert.assertFalse((boolean)this.f_Function.basic_stringp());
        Assert.assertFalse((boolean)this.f_HashTable.basic_stringp());
        Assert.assertFalse((boolean)this.f_Integer.basic_stringp());
        Assert.assertFalse((boolean)this.f_Keyword.basic_stringp());
        Assert.assertFalse((boolean)this.f_List.basic_stringp());
        Assert.assertFalse((boolean)this.f_Package.basic_stringp());
        Assert.assertFalse((boolean)this.f_Real.basic_stringp());
        Assert.assertTrue((boolean)this.f_String.basic_stringp());
        Assert.assertFalse((boolean)this.f_Symbol.basic_stringp());
    }

    public void testBasicSymbolp() {
        Assert.assertTrue((boolean)this.A.basic_symbolp());
        Assert.assertFalse((boolean)this.ONE.basic_symbolp());
        Assert.assertTrue((boolean)this.f_NIL.basic_symbolp());
        Assert.assertTrue((boolean)this.f_T.basic_symbolp());
        Assert.assertFalse((boolean)this.f_Bignum.basic_symbolp());
        Assert.assertFalse((boolean)this.f_Cons.basic_symbolp());
        Assert.assertTrue((boolean)this.f_Constant.basic_symbolp());
        Assert.assertFalse((boolean)this.f_Function.basic_symbolp());
        Assert.assertFalse((boolean)this.f_HashTable.basic_symbolp());
        Assert.assertFalse((boolean)this.f_Integer.basic_symbolp());
        Assert.assertTrue((boolean)this.f_Keyword.basic_symbolp());
        Assert.assertFalse((boolean)this.f_List.basic_symbolp());
        Assert.assertFalse((boolean)this.f_Package.basic_symbolp());
        Assert.assertFalse((boolean)this.f_Real.basic_symbolp());
        Assert.assertFalse((boolean)this.f_String.basic_symbolp());
        Assert.assertTrue((boolean)this.f_Symbol.basic_symbolp());
    }

    public void testAppend() {
        LispCons l2;
        LispCons l1 = f_lisp.makeList(this.A, this.B, this.C, this.D);
        LispValue l3 = l1.append(l2 = f_lisp.makeList(this.D, this.C, this.B, this.A));
        Assert.assertTrue((8 == l3.basic_length() ? 1 : 0) != 0);
        Assert.assertTrue((this.C.equal(l3.sixth()) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        Assert.assertTrue((l3.first().equal(l3.last().car()) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        Assert.assertTrue((boolean)l3.eq(l1).basic_null());
        Assert.assertTrue((l2.eq(l3.cdr().cdr().cdr().cdr()) == CoreTest.f_lisp.T ? 1 : 0) != 0);
        Assert.assertTrue((l3.reverse().equal(l3) != CoreTest.f_lisp.NIL ? 1 : 0) != 0);
    }

    public void testapply() {
    }

    public void testassoc() {
    }

    public void testatom() {
    }

    public void testbignump() {
    }

    public void testboundp() {
    }

    public void testbutlast() {
    }

    public void testcar() {
    }

    public void testcdr() {
    }

    public void testcharacterp() {
    }

    public void testclrhash() {
    }

    public void testconsp() {
    }

    public void testcopy_list() {
    }

    public void testeighth() {
    }

    public void testelt() {
    }

    public void testeq() {
    }

    public void testeql() {
    }

    public void testequal() {
    }

    public void testfboundp() {
    }

    public void testfloatp() {
    }

    public void testfifth() {
    }

    public void testfirst() {
    }

    public void testfourth() {
    }

    public void testfuncall() {
    }

    public void testgethash() {
    }

    public void testsetf_gethash() {
    }

    public void testhashtablep() {
    }

    public void testhash_table_count() {
    }

    public void testhash_table_size() {
    }

    public void testhash_table_rehash_size() {
    }

    public void testhash_table_rehash_threshold() {
    }

    public void testhash_table_test() {
    }

    public void testintegerp() {
    }

    public void testkeywordp() {
    }

    public void testlast() {
    }

    public void testlength() {
    }

    public void testlisp_null() {
    }

    public void testlist() {
    }

    public void testlistp() {
    }

    public void testmax(LispValue args) {
        Assert.assertTrue((boolean)this.ONE.max(f_lisp.makeList(this.ONE, this.TWO, this.THREE, this.FOUR)).equals(this.FOUR));
        Assert.assertFalse((boolean)this.ONE.max(this.TWO).equals(this.ONE));
        Assert.assertTrue((boolean)this.ONE.max(this.TWO).equals(this.TWO));
        Assert.assertTrue((boolean)this.TWO.max(this.ONE).equals(this.TWO));
        Assert.assertFalse((boolean)this.TWO.max(this.ONE).equals(this.ONE));
    }

    public void testmin(LispValue args) {
        Assert.assertTrue((boolean)this.THREE.min(f_lisp.makeList(this.TWO, this.THREE, this.FOUR)).equals(this.TWO));
        Assert.assertFalse((boolean)this.ONE.min(this.TWO).equals(this.TWO));
        Assert.assertTrue((boolean)this.ONE.min(this.TWO).equals(this.ONE));
        Assert.assertTrue((boolean)this.TWO.min(this.ONE).equals(this.ONE));
        Assert.assertFalse((boolean)this.TWO.min(this.ONE).equals(this.TWO));
    }

    public void testmember(LispValue elt) {
    }

    public void testnconc(LispValue arg) {
    }

    public void testninth() {
    }

    public void testnreverse() {
    }

    public void testnumberp() {
    }

    public void testpop() {
        LispValue l1 = f_lisp.makeList(this.A, this.B, this.C);
        LispCons l2 = f_lisp.makeList(this.A, this.B, this.C);
        Assert.assertTrue((CoreTest.f_lisp.T == this.A.eq(l1.pop()) ? 1 : 0) != 0);
        Assert.assertTrue((2 == l1.basic_length() ? 1 : 0) != 0);
        Assert.assertTrue((3 == l1.push(this.D).basic_length() ? 1 : 0) != 0);
        Assert.assertTrue((this.D == l1.pop() ? 1 : 0) != 0);
        Assert.assertTrue((2 == l1.basic_length() ? 1 : 0) != 0);
        Assert.assertTrue((this.B == l1.pop() ? 1 : 0) != 0);
        Assert.assertTrue((1 == l1.basic_length() ? 1 : 0) != 0);
        Assert.assertTrue((this.C == l1.pop() ? 1 : 0) != 0);
        Assert.assertTrue((CoreTest.f_lisp.T == l1.equal(new StandardLispCons(f_lisp, CoreTest.f_lisp.NIL, CoreTest.f_lisp.NIL)) ? 1 : 0) != 0);
        l1 = new StandardLispSymbol(f_lisp, "L1");
        l1.setq(f_lisp.makeList(this.A, this.B, this.C));
        Assert.assertTrue((CoreTest.f_lisp.T == this.A.eq(l1.pop()) ? 1 : 0) != 0);
        Assert.assertTrue((2 == l1.symbol_value().basic_length() ? 1 : 0) != 0);
        Assert.assertTrue((CoreTest.f_lisp.T == this.B.eq(l1.pop()) ? 1 : 0) != 0);
        Assert.assertTrue((1 == l1.symbol_value().basic_length() ? 1 : 0) != 0);
        Assert.assertTrue((CoreTest.f_lisp.T == this.C.eq(l1.pop()) ? 1 : 0) != 0);
        Assert.assertTrue((0 == l1.symbol_value().basic_length() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)l1.symbol_value().basic_null());
        l1.push(this.C);
        Assert.assertTrue((1 == l1.symbol_value().basic_length() ? 1 : 0) != 0);
        l1.push(this.B);
        Assert.assertTrue((2 == l1.symbol_value().basic_length() ? 1 : 0) != 0);
        l1.push(this.A);
        Assert.assertTrue((3 == l1.symbol_value().basic_length() ? 1 : 0) != 0);
        Assert.assertTrue((CoreTest.f_lisp.T == l1.symbol_value().equal(f_lisp.makeList(this.A, this.B, this.C)) ? 1 : 0) != 0);
        Assert.assertTrue((CoreTest.f_lisp.T == l1.symbol_value().equal(l2) ? 1 : 0) != 0);
    }

    public void testprin1() {
    }

    public void testprinc() {
    }

    public void testprint() {
    }

    public void testpush() {
        StandardLispSymbol l1 = new StandardLispSymbol(f_lisp, "L1");
        LispCons l2 = f_lisp.makeList(this.A, this.B);
        l1.setq(CoreTest.f_lisp.NIL);
        l1.push(this.B);
        l1.push(this.A);
        Assert.assertTrue((l1.symbol_value().equal(l2) == CoreTest.f_lisp.T ? 1 : 0) != 0);
    }

    public void testrassoc() {
    }

    public void testremhash() {
    }

    public void testremove() {
    }

    public void testreverse() {
    }

    public void testrplaca() {
    }

    public void testrplacd() {
    }

    public void testsecond() {
    }

    public void testsetf_symbol_function() {
    }

    public void testsetf_symbol_plist() {
    }

    public void testsetf_symbol_value() {
    }

    public void testseventh() {
    }

    public void teststringp() {
    }

    public void testsubst() {
    }

    public void testsubstring() {
    }

    public void testsymbolp() {
    }

    public void testsymbol_function() {
    }

    public void testsymbol_name() {
    }

    public void testsymbol_package() {
    }

    public void testsymbol_plist() {
    }

    public void testsymbol_value() {
    }

    public void testtenth() {
    }

    public void testthird() {
    }

    public void testtype_of() {
    }

    public void testtypep(LispValue type) {
    }

    public void testzerop() {
    }

    public void testAdd(LispValue args) {
    }

    public void testDivide(LispValue args) {
    }

    public void testMultiply(LispValue args) {
    }

    public void testSubtract(LispValue args) {
    }

    public void testToString() {
        Assert.assertTrue((boolean)"A".equals(this.A.toString()));
        Assert.assertTrue((boolean)"B".equals(this.B.toString()));
        Assert.assertTrue((boolean)"C".equals(this.C.toString()));
        Assert.assertTrue((boolean)"\"a test string\"".equals(this.f_String.toString()));
        Assert.assertTrue((boolean)"a test string".equals(this.f_String.toStringSimple()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

