/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.database.DB;
import edu.uoregon.tau.dms.dss.DataSession;
import edu.uoregon.tau.dms.dss.IntervalLocationProfile;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

public class IntervalEvent {
    private int intervalEventID;
    private String name;
    private String group;
    private int trialID;
    private IntervalLocationProfile meanSummary = null;
    private IntervalLocationProfile totalSummary = null;
    private DataSession dataSession = null;

    public IntervalEvent(DataSession dataSession) {
        this.dataSession = dataSession;
    }

    public int getID() {
        return this.intervalEventID;
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    public int getTrialID() {
        return this.trialID;
    }

    public IntervalLocationProfile getMeanSummary() {
        if (this.meanSummary == null) {
            this.dataSession.getIntervalEventDetail(this);
        }
        return this.meanSummary;
    }

    public IntervalLocationProfile getTotalSummary() {
        if (this.totalSummary == null) {
            this.dataSession.getIntervalEventDetail(this);
        }
        return this.totalSummary;
    }

    public void setID(int n) {
        this.intervalEventID = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public void setTrialID(int n) {
        this.trialID = n;
    }

    public void setMeanSummary(IntervalLocationProfile intervalLocationProfile) {
        this.meanSummary = intervalLocationProfile;
    }

    public void setTotalSummary(IntervalLocationProfile intervalLocationProfile) {
        this.totalSummary = intervalLocationProfile;
    }

    public static Vector getIntervalEvents(DataSession dataSession, DB dB, String string) {
        Vector<IntervalEvent> vector = new Vector<IntervalEvent>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select id, name, group_name, trial ");
        stringBuffer.append("from interval_event ");
        stringBuffer.append(string);
        stringBuffer.append(" order by name asc ");
        try {
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            Object var6_7 = null;
            while (resultSet.next()) {
                IntervalEvent intervalEvent = new IntervalEvent(dataSession);
                intervalEvent.setID(resultSet.getInt(1));
                intervalEvent.setName(resultSet.getString(2));
                intervalEvent.setGroup(resultSet.getString(3));
                intervalEvent.setTrialID(resultSet.getInt(4));
                vector.addElement(intervalEvent);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return vector;
    }

    public int saveIntervalEvent(DB dB, int n, Hashtable hashtable, int n2) {
        int n3 = 0;
        try {
            PreparedStatement preparedStatement = null;
            if (n2 < 0) {
                preparedStatement = dB.prepareStatement("INSERT INTO interval_event (trial, name, group_name) VALUES (?, ?, ?)");
                preparedStatement.setInt(1, n);
                preparedStatement.setString(2, this.name);
                preparedStatement.setString(3, this.group);
                preparedStatement.executeUpdate();
                String string = new String();
                if (dB.getDBType().compareTo("mysql") == 0) {
                    string = "select LAST_INSERT_ID();";
                }
                string = dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM interval_event" : "select currval('interval_event_id_seq');";
                n3 = Integer.parseInt(dB.getDataItem(string));
            } else {
                preparedStatement = dB.prepareStatement("SELECT id FROM interval_event where name = ?");
                preparedStatement.setString(1, this.name);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    n3 = resultSet.getInt(1);
                }
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while saving the interval_event.");
            sQLException.printStackTrace();
            System.exit(0);
        }
        if (this.meanSummary != null) {
            this.meanSummary.saveMeanSummary(dB, n3, hashtable, n2);
        }
        if (this.totalSummary != null) {
            this.totalSummary.saveTotalSummary(dB, n3, hashtable, n2);
        }
        return n3;
    }
}

