/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.Group;
import edu.uoregon.tau.paraprof.FullDataWindow;
import edu.uoregon.tau.paraprof.FunctionDataWindow;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.PPThread;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfErrorDialog;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.ThreadDataWindow;
import edu.uoregon.tau.paraprof.interfaces.ImageExport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class FullDataWindowPanel
extends JPanel
implements MouseListener,
Printable,
ImageExport {
    private ParaProfTrial ppTrial = null;
    private FullDataWindow window = null;
    private List list = new Vector();
    private int barHeight = -1;
    private int barSpacing = -1;
    private int baseBarLength = 500;
    private int barLength = 0;
    private int textOffset = 60;
    private int barXCoord = 100;
    private int lastHeaderEndPosition = 0;
    private int xPanelSize = 0;
    private int yPanelSize = 0;

    public FullDataWindowPanel(ParaProfTrial paraProfTrial, FullDataWindow fullDataWindow) {
        this.setToolTipText("ParaProf Full Data Window");
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.ppTrial = paraProfTrial;
        this.window = fullDataWindow;
        this.barLength = this.baseBarLength;
    }

    private PPFunctionProfile getPPFunctionProfile(PPThread pPThread, int n) {
        ListIterator listIterator = pPThread.getFunctionListIterator();
        while (listIterator.hasNext()) {
            PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)listIterator.next();
            if (n > pPFunctionProfile.getXEnd() || n < pPFunctionProfile.getXBeg()) continue;
            return pPFunctionProfile;
        }
        return null;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            PPThread pPThread = null;
            int n3 = 0;
            if (this.ppTrial.getPreferencesWindow().getBarSpacing() != 0) {
                n3 = n2 / this.ppTrial.getPreferencesWindow().getBarSpacing();
            }
            if (n3 >= this.list.size()) {
                return "";
            }
            if (n < this.barXCoord) {
                if (ParaProf.helpWindow.isShowing()) {
                    ParaProf.helpWindow.clearText();
                    if (n3 == 1 && this.list.size() > 1) {
                        ParaProf.helpWindow.writeText("This line represents the mean statistics (over all threads).\n");
                    }
                    if (n3 == 0 && this.list.size() > 1) {
                        ParaProf.helpWindow.writeText("This line represents the standard deviation of each function (over threads).\n");
                    } else {
                        ParaProf.helpWindow.writeText("n,c,t stands for: Node, Context and Thread.\n");
                    }
                    ParaProf.helpWindow.writeText("Right click to display options for viewing the data.");
                    ParaProf.helpWindow.writeText("Left click to go directly to the Thread Data Window");
                }
                return "Right click for options";
            }
            pPThread = (PPThread)this.list.get(n3);
            PPFunctionProfile pPFunctionProfile = this.getPPFunctionProfile(pPThread, n);
            if (pPFunctionProfile != null) {
                if (ParaProf.helpWindow.isShowing()) {
                    ParaProf.helpWindow.clearText();
                    ParaProf.helpWindow.writeText("Current function name is: " + pPFunctionProfile.getFunctionName() + "\n");
                    if (n3 == 1 && this.list.size() > 1) {
                        ParaProf.helpWindow.writeText("The mean draw bars give a visual representation of the mean values for the functions.\n");
                    } else if (n3 == 0 && this.list.size() > 1) {
                        ParaProf.helpWindow.writeText("The standard deviation draw bars give a visual representation of the relative deviations from mean for the functions.\n");
                    } else {
                        ParaProf.helpWindow.writeText("The thread draw bars give a visual representation functions which have run on this thread and what their relative values are.\n");
                    }
                    ParaProf.helpWindow.writeText("Functions are assigned a color from the default color set unless specifically assigned a color.  The colors are cycled through when the number of functions exceeds the number of available colors.\n");
                    ParaProf.helpWindow.writeText("Right click to display options for this function.");
                    ParaProf.helpWindow.writeText("Left click to go directly to the Function Data Window.");
                }
                return pPFunctionProfile.getFunctionName();
            }
            if (n <= pPThread.getMiscXEnd() && n >= pPThread.getMiscXBeg()) {
                if (ParaProf.helpWindow.isShowing()) {
                    ParaProf.helpWindow.clearText();
                    ParaProf.helpWindow.writeText("Your mouse is over the misc. function section!\n");
                    ParaProf.helpWindow.writeText("These are functions which have a non zero value, but whose screen representation is less than a pixel.\n");
                    ParaProf.helpWindow.writeText("To view these function, right or left click to the left of this bar to bring up windows which will show more detailed information.");
                }
                return "Misc function section ... see help window for details";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.export((Graphics2D)graphics, true, false, false);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            this.window.closeThisWindow();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        try {
            if (n >= 1) {
                return 1;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, this.xPanelSize, this.yPanelSize);
            this.export((Graphics2D)graphics, false, true, false);
            return 0;
        }
        catch (Exception exception) {
            new ParaProfErrorDialog(exception);
            return 1;
        }
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        String string;
        this.list = this.window.getData();
        int n = 0;
        PPThread pPThread = null;
        this.ppTrial.getPreferencesWindow().setBarDetails(graphics2D);
        this.barSpacing = this.ppTrial.getPreferencesWindow().getBarSpacing();
        this.barHeight = this.ppTrial.getPreferencesWindow().getBarHeight();
        Font font = new Font(this.ppTrial.getPreferencesWindow().getParaProfFont(), this.ppTrial.getPreferencesWindow().getFontStyle(), this.barHeight);
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        int[] nArray = this.ppTrial.getMaxNCTNumbers();
        this.barXCoord = fontMetrics.stringWidth("n,c,t " + nArray[0] + "," + nArray[1] + "," + nArray[2]) + 15;
        int[] nArray2 = ParaProfUtils.computeClipping(graphics2D.getClipBounds(), this.window.getViewRect(), bl, bl2, this.list.size(), this.barSpacing, n);
        int n2 = nArray2[0];
        int n3 = nArray2[1];
        n = nArray2[2];
        if (bl3) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Insets insets = this.getInsets();
            n += this.barSpacing;
            string = this.window.getHeaderString();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "'\n'");
            while (stringTokenizer.hasMoreTokens()) {
                AttributedString attributedString = new AttributedString(stringTokenizer.nextToken());
                attributedString.addAttribute(TextAttribute.FONT, font);
                AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
                float f = this.getSize().width - insets.left - insets.right;
                float f2 = insets.left;
                float f3 = insets.right;
                while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
                    TextLayout textLayout = lineBreakMeasurer.nextLayout(f);
                    textLayout.draw(graphics2D, f2, n += this.barSpacing);
                    f2 = insets.left;
                }
            }
            this.lastHeaderEndPosition = n;
        }
        int n4 = 0;
        if (this.list != null) {
            for (int i = n2; i <= n3; ++i) {
                pPThread = (PPThread)this.list.get(i);
                string = pPThread.getName();
                int n5 = this.drawBar(graphics2D, fontMetrics, string, pPThread, this.barXCoord, n += this.barSpacing, this.barHeight, bl);
                if (n5 <= n4) continue;
                n4 = n5;
            }
        }
        if (this.resizePanel(fontMetrics, n4 + 5) && bl) {
            this.revalidate();
            return;
        }
    }

    private int drawStackedBar(Graphics2D graphics2D, FontMetrics fontMetrics, String string, PPThread pPThread, int n, int n2, int n3, boolean bl) {
        ListIterator listIterator = null;
        Group group = this.ppTrial.getHighlightedGroup();
        boolean bl2 = false;
        int n4 = (int)((double)n + (double)this.barLength);
        graphics2D.setColor(Color.black);
        graphics2D.drawString(string, n - fontMetrics.stringWidth(string) - 5, n2);
        double d = 0.0;
        listIterator = pPThread.getFunctionListIterator();
        while (listIterator.hasNext()) {
            PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)listIterator.next();
            if (!(pPFunctionProfile.getExclusiveValue() > 0.0)) continue;
            d += pPFunctionProfile.getExclusiveValue();
        }
        listIterator = pPThread.getFunctionListIterator();
        double d2 = 0.0;
        int n5 = 0;
        while (listIterator.hasNext()) {
            PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)listIterator.next();
            double d3 = 0.0;
            d3 = pPFunctionProfile.getExclusiveValue();
            int n6 = 0;
            n6 = this.window.getNormalizeBars() ? (int)(d3 / d * (double)this.barLength) : (int)((d3 + d2) / this.window.getDataSorter().getMaxExclusiveSum() * (double)this.barLength) - n5;
            if (n6 > 2) {
                d2 += d3;
                n5 += n6;
                if (n3 > 2) {
                    graphics2D.setColor(pPFunctionProfile.getColor());
                    graphics2D.fillRect(n + 1, n2 - n3 + 1, n6 - 1, n3 - 1);
                    if (pPFunctionProfile.getFunction() == this.ppTrial.getHighlightedFunction()) {
                        bl2 = true;
                        graphics2D.setColor(this.ppTrial.getColorChooser().getHighlightColor());
                        graphics2D.drawRect(n, n2 - n3, n6, n3);
                        graphics2D.drawRect(n + 1, n2 - n3 + 1, n6 - 2, n3 - 2);
                    } else if (pPFunctionProfile.isGroupMember(this.ppTrial.getHighlightedGroup())) {
                        bl2 = true;
                        graphics2D.setColor(this.ppTrial.getColorChooser().getGroupHighlightColor());
                        graphics2D.drawRect(n, n2 - n3, n6, n3);
                        graphics2D.drawRect(n + 1, n2 - n3 + 1, n6 - 2, n3 - 2);
                    } else {
                        graphics2D.setColor(Color.black);
                        if (bl2) {
                            graphics2D.drawLine(n + 1, n2 - n3, n + 1 + n6, n2 - n3);
                            graphics2D.drawLine(n + 1, n2, n + 1 + n6, n2);
                            graphics2D.drawLine(n + 1 + n6, n2 - n3, n + 1 + n6, n2);
                            bl2 = false;
                        } else {
                            graphics2D.drawRect(n, n2 - n3, n6, n3);
                        }
                    }
                    if (bl) {
                        pPFunctionProfile.setDrawCoords(n, n + n6, n2 - n3, n2);
                    }
                    n += n6;
                    continue;
                }
                if (pPFunctionProfile.getFunction() == this.ppTrial.getHighlightedFunction()) {
                    graphics2D.setColor(this.ppTrial.getColorChooser().getHighlightColor());
                } else if (pPFunctionProfile.isGroupMember(this.ppTrial.getHighlightedGroup())) {
                    graphics2D.setColor(this.ppTrial.getColorChooser().getGroupHighlightColor());
                } else {
                    graphics2D.setColor(pPFunctionProfile.getColor());
                }
                graphics2D.fillRect(n, n2 - n3, n6, n3);
                if (bl) {
                    pPFunctionProfile.setDrawCoords(n, n + n6, n2 - n3, n2);
                }
                n += n6;
                continue;
            }
            if (!bl) continue;
            pPFunctionProfile.setDrawCoords(n, n, n2 - n3, n2);
        }
        if (this.window.getNormalizeBars()) {
            if (n < n4) {
                graphics2D.setColor(this.ppTrial.getColorChooser().getMiscFunctionColor());
                graphics2D.fillRect(n, n2 - n3, n4 - n, n3);
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(n, n2 - n3, n4 - n, n3);
                pPThread.setMiscCoords(n, n4, n2 - n3, n2);
                n = n4;
            }
        } else {
            double d4 = d - d2;
            int n7 = (int)((d4 + d2) / this.window.getDataSorter().getMaxExclusiveSum() * (double)this.barLength) - n5;
            graphics2D.setColor(this.ppTrial.getColorChooser().getMiscFunctionColor());
            graphics2D.fillRect(n, n2 - n3, n7, n3);
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(n, n2 - n3, n7, n3);
            pPThread.setMiscCoords(n, n + n7, n2 - n3, n2);
            n += n7;
        }
        return n;
    }

    private int drawBar(Graphics2D graphics2D, FontMetrics fontMetrics, String string, PPThread pPThread, int n, int n2, int n3, boolean bl) {
        if (this.window.getStackBars()) {
            return this.drawStackedBar(graphics2D, fontMetrics, string, pPThread, n, n2, n3, bl);
        }
        ListIterator listIterator = null;
        Group group = this.ppTrial.getHighlightedGroup();
        boolean bl2 = false;
        int n4 = (int)((double)n + (double)this.barLength);
        graphics2D.setColor(Color.black);
        graphics2D.drawString(string, n - fontMetrics.stringWidth(string) - 5, n2);
        double d = 0.0;
        listIterator = pPThread.getFunctionListIterator();
        ListIterator listIterator2 = ((PPThread)this.list.get(0)).getFunctionListIterator();
        while (listIterator.hasNext()) {
            PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)listIterator.next();
            d += pPFunctionProfile.getExclusiveValue();
        }
        listIterator = pPThread.getFunctionListIterator();
        double d2 = 0.0;
        int n5 = 0;
        if (!listIterator.hasNext()) {
            return 0;
        }
        PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)listIterator.next();
        while (listIterator2.hasNext()) {
            PPFunctionProfile pPFunctionProfile2 = (PPFunctionProfile)listIterator2.next();
            Function function = pPFunctionProfile2.getFunction();
            double d3 = this.window.getDataSorter().getMaxExclusives()[function.getID()];
            int n6 = (int)(d3 / this.window.getDataSorter().getMaxExclusiveSum() * (double)this.barLength);
            if (function != pPFunctionProfile.getFunction()) {
                if (n6 <= 2) continue;
                n += n6 + 5;
                continue;
            }
            double d4 = 0.0;
            d4 = pPFunctionProfile.getExclusiveValue();
            int n7 = 0;
            if (this.window.getNormalizeBars()) {
                n7 = (int)(d4 / d * (double)this.barLength);
            } else {
                n7 = (int)(d4 / this.window.getDataSorter().getMaxExclusiveSum() * (double)this.barLength);
                if (n7 < 1) {
                    n7 = 1;
                }
            }
            if (n7 > 2 || n6 > 2) {
                d2 += d4;
                n5 += n7;
                if (n3 > 2) {
                    graphics2D.setColor(pPFunctionProfile.getColor());
                    graphics2D.fillRect(n + 1, n2 - n3 + 1, n7 - 1, n3 - 1);
                    if (pPFunctionProfile.getFunction() == this.ppTrial.getHighlightedFunction()) {
                        bl2 = true;
                        graphics2D.setColor(this.ppTrial.getColorChooser().getHighlightColor());
                        graphics2D.drawRect(n, n2 - n3, n7, n3);
                        graphics2D.drawRect(n + 1, n2 - n3 + 1, n7 - 2, n3 - 2);
                    } else if (pPFunctionProfile.isGroupMember(this.ppTrial.getHighlightedGroup())) {
                        bl2 = true;
                        graphics2D.setColor(this.ppTrial.getColorChooser().getGroupHighlightColor());
                        graphics2D.drawRect(n, n2 - n3, n7, n3);
                        graphics2D.drawRect(n + 1, n2 - n3 + 1, n7 - 2, n3 - 2);
                    } else {
                        graphics2D.setColor(Color.black);
                        graphics2D.drawRect(n, n2 - n3, n7, n3);
                    }
                    if (bl) {
                        pPFunctionProfile.setDrawCoords(n, n + n7, n2 - n3, n2);
                    }
                    n += n7;
                } else {
                    if (pPFunctionProfile.getFunction() == this.ppTrial.getHighlightedFunction()) {
                        graphics2D.setColor(this.ppTrial.getColorChooser().getHighlightColor());
                    } else if (pPFunctionProfile.isGroupMember(this.ppTrial.getHighlightedGroup())) {
                        graphics2D.setColor(this.ppTrial.getColorChooser().getGroupHighlightColor());
                    } else {
                        graphics2D.setColor(pPFunctionProfile.getColor());
                    }
                    graphics2D.fillRect(n, n2 - n3, n7, n3);
                    graphics2D.setColor(Color.black);
                    graphics2D.drawRect(n, n2 - n3, n7, n3);
                    if (bl) {
                        pPFunctionProfile.setDrawCoords(n, n + n7, n2 - n3, n2);
                    }
                    n += n7;
                }
            } else if (bl) {
                pPFunctionProfile.setDrawCoords(n, n, n2 - n3, n2);
            }
            if (n6 > 2) {
                n += n6 - n7 + 5;
            }
            if (!listIterator.hasNext()) continue;
            pPFunctionProfile = (PPFunctionProfile)listIterator.next();
        }
        double d5 = d - d2;
        if (d5 > 0.0) {
            int n8 = (int)((d5 + d2) / this.window.getDataSorter().getMaxExclusiveSum() * (double)this.barLength) - n5;
            graphics2D.setColor(this.ppTrial.getColorChooser().getMiscFunctionColor());
            graphics2D.fillRect(n, n2 - n3, n8, n3);
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(n, n2 - n3, n8, n3);
            pPThread.setMiscCoords(n, n + n8, n2 - n3, n2);
            n += n8;
        }
        return n;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            PPThread pPThread = null;
            int n4 = n2 / this.ppTrial.getPreferencesWindow().getBarSpacing();
            if (n4 >= this.list.size()) {
                this.ppTrial.setHighlightedFunction(null);
                return;
            }
            pPThread = (PPThread)this.list.get(n4);
            if (ParaProfUtils.rightClick(mouseEvent)) {
                if (n < this.barXCoord) {
                    ParaProfUtils.handleThreadClick(this.ppTrial, pPThread.getThread(), this, mouseEvent);
                } else {
                    ListIterator listIterator = pPThread.getFunctionListIterator();
                    while (listIterator.hasNext()) {
                        PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)listIterator.next();
                        if (n > pPFunctionProfile.getXEnd() || n < pPFunctionProfile.getXBeg()) continue;
                        JPopupMenu jPopupMenu = ParaProfUtils.createFunctionClickPopUp(this.ppTrial, pPFunctionProfile.getFunction(), this);
                        jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            } else if (n < this.barXCoord) {
                ThreadDataWindow threadDataWindow = new ThreadDataWindow(this.ppTrial, pPThread.getThread());
                threadDataWindow.show();
            } else {
                ListIterator listIterator = pPThread.getFunctionListIterator();
                while (listIterator.hasNext()) {
                    PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)listIterator.next();
                    if (n > pPFunctionProfile.getXEnd() || n < pPFunctionProfile.getXBeg()) continue;
                    this.ppTrial.setHighlightedFunction(pPFunctionProfile.getFunction());
                    FunctionDataWindow functionDataWindow = new FunctionDataWindow(this.ppTrial, pPFunctionProfile.getFunction());
                    functionDataWindow.show();
                    return;
                }
                this.ppTrial.setHighlightedFunction(null);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        Dimension dimension = null;
        dimension = bl ? this.getSize() : this.window.getSize();
        dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)this.lastHeaderEndPosition);
        return dimension;
    }

    public void setBarLength(int n) {
        this.barLength = Math.max(1, n);
        this.repaint();
    }

    private boolean resizePanel(FontMetrics fontMetrics, int n) {
        boolean bl = false;
        int n2 = (this.window.getData().size() + 1) * this.barSpacing + 10;
        int n3 = n;
        if (n2 != this.yPanelSize || n3 != this.xPanelSize) {
            this.yPanelSize = n2;
            this.xPanelSize = n3;
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            bl = false;
        }
        return bl;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize);
    }
}

