/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UserEvent;
import edu.uoregon.tau.dms.dss.UserEventProfile;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.paraprof.enums.UserEventValueType;
import java.awt.Color;

public class PPUserEventProfile
implements Comparable {
    private UserEventProfile userEventProfile;
    private DataSorter dataSorter;
    private UserEvent userEvent = null;
    private int xBeg = 0;
    private int xEnd = 0;
    private int yBeg = 0;
    private int yEnd = 0;
    private boolean statDrawnTo;
    private boolean highlighted = false;
    private int sortType;
    private Thread thread;

    public PPUserEventProfile(DataSorter dataSorter, Thread thread, UserEventProfile userEventProfile) {
        this.thread = thread;
        this.dataSorter = dataSorter;
        this.userEventProfile = userEventProfile;
        this.userEvent = userEventProfile.getUserEvent();
    }

    public int getNodeID() {
        return this.thread.getNodeID();
    }

    public int getContextID() {
        return this.thread.getContextID();
    }

    public int getThreadID() {
        return this.thread.getThreadID();
    }

    public UserEvent getUserEvent() {
        return this.userEvent;
    }

    public String getUserEventName() {
        return this.userEvent.getName();
    }

    public Color getColor() {
        return this.userEvent.getColor();
    }

    public UserEventProfile getUserEventProfile() {
        return this.userEventProfile;
    }

    public int getUserEventNumberValue() {
        return this.userEventProfile.getUserEventNumberValue();
    }

    public double getUserEventMinValue() {
        return this.userEventProfile.getUserEventMinValue();
    }

    public double getUserEventMaxValue() {
        return this.userEventProfile.getUserEventMaxValue();
    }

    public double getUserEventMeanValue() {
        return this.userEventProfile.getUserEventMeanValue();
    }

    public double getStdDev() {
        return this.userEventProfile.getUserEventStdDev();
    }

    public String getUserEventStatString(int n) {
        int n2;
        int n3 = 90;
        int n4 = 0;
        char[] cArray = new char[n3];
        PPUserEventProfile.insertSpaces(cArray, 0, 90);
        char[] cArray2 = Integer.toString(this.getUserEventNumberValue()).toCharArray();
        for (n2 = 0; n2 < cArray2.length; ++n2) {
            cArray[n4] = cArray2[n2];
            ++n4;
        }
        n4 = 18;
        String string = UtilFncs.getOutputString((int)0, (double)this.getUserEventMaxValue(), (int)n);
        cArray2 = string.toCharArray();
        for (n2 = 0; n2 < cArray2.length; ++n2) {
            cArray[n4] = cArray2[n2];
            ++n4;
        }
        n4 = 36;
        string = UtilFncs.getOutputString((int)0, (double)this.getUserEventMinValue(), (int)n);
        cArray2 = string.toCharArray();
        for (n2 = 0; n2 < cArray2.length; ++n2) {
            cArray[n4] = cArray2[n2];
            ++n4;
        }
        n4 = 54;
        string = UtilFncs.getOutputString((int)0, (double)this.getUserEventMeanValue(), (int)n);
        cArray2 = string.toCharArray();
        for (n2 = 0; n2 < cArray2.length; ++n2) {
            cArray[n4] = cArray2[n2];
            ++n4;
        }
        n4 = 72;
        string = UtilFncs.getOutputString((int)0, (double)this.getStdDev(), (int)n);
        cArray2 = string.toCharArray();
        for (n2 = 0; n2 < cArray2.length; ++n2) {
            cArray[n4] = cArray2[n2];
            ++n4;
        }
        return new String(cArray);
    }

    private static int insertSpaces(char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            cArray[n] = 32;
            ++n;
        }
        return n;
    }

    private int checkDescending(int n) {
        if (this.dataSorter.getDescendingOrder()) {
            return -n;
        }
        return n;
    }

    public int compareTo(Object object) {
        UserEventValueType userEventValueType = this.dataSorter.getUserEventValueType();
        PPUserEventProfile pPUserEventProfile = (PPUserEventProfile)object;
        if (this.dataSorter.getSortType() == SortType.NAME) {
            return this.checkDescending(pPUserEventProfile.getUserEventName().compareTo(this.getUserEventName()));
        }
        if (this.dataSorter.getSortType() == SortType.NCT) {
            if (pPUserEventProfile.getNodeID() != this.getNodeID()) {
                return this.checkDescending(this.getNodeID() - pPUserEventProfile.getNodeID());
            }
            if (pPUserEventProfile.getContextID() != this.getContextID()) {
                return this.checkDescending(this.getContextID() - pPUserEventProfile.getContextID());
            }
            return this.checkDescending(this.getThreadID() - pPUserEventProfile.getThreadID());
        }
        if (this.dataSorter.getSortType() == SortType.VALUE || this.dataSorter.getSortType() == SortType.MEAN_VALUE) {
            return this.checkDescending(this.compareToHelper(userEventValueType.getValue(this.getUserEventProfile()), userEventValueType.getValue(pPUserEventProfile.getUserEventProfile())));
        }
        throw new ParaProfException("Unexpected sort type: " + this.dataSorter.getSortType());
    }

    private int compareToHelper(double d, double d2) {
        double d3 = d - d2;
        if (d3 < 0.0) {
            return -1;
        }
        if (d3 == 0.0) {
            return 0;
        }
        return 1;
    }

    public void setDrawCoords(int n, int n2, int n3, int n4) {
        this.xBeg = n;
        this.xEnd = n2;
        this.yBeg = n3;
        this.yEnd = n4;
    }

    public int getXBeg() {
        return this.xBeg;
    }

    public int getXEnd() {
        return this.xEnd;
    }

    public int getYBeg() {
        return this.yBeg;
    }

    public int getYEnd() {
        return this.yEnd;
    }

    public boolean getStatDrawnTo() {
        return this.statDrawnTo;
    }

    public void setStatDrawnTo(boolean bl) {
        this.statDrawnTo = bl;
    }

    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setSortType(int n) {
        this.sortType = n;
    }
}

