/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.PPThread;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.PreferencesWindow;
import edu.uoregon.tau.paraprof.SearchPanel;
import edu.uoregon.tau.paraprof.ThreadDataWindowPanel;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.paraprof.interfaces.ScrollBarController;
import edu.uoregon.tau.paraprof.interfaces.SearchableOwner;
import edu.uoregon.tau.paraprof.interfaces.UnitListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class ThreadDataWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer,
ChangeListener,
KeyListener,
SearchableOwner,
ScrollBarController,
ParaProfWindow,
UnitListener {
    private PPThread ppThread;
    private ParaProfTrial ppTrial = null;
    private DataSorter dataSorter = null;
    private JMenu optionsMenu = null;
    private JMenu unitsSubMenu = null;
    private JCheckBoxMenuItem sortByName = null;
    private JCheckBoxMenuItem descendingOrder = null;
    private JCheckBoxMenuItem showValuesAsPercent = null;
    private JCheckBoxMenuItem showPathTitleInReverse = null;
    private JCheckBoxMenuItem showMetaData = null;
    private JCheckBoxMenuItem showFindPanelBox;
    private JLabel barLengthLabel = new JLabel("Bar Width");
    private JSlider barLengthSlider = new JSlider(0, 2000, 250);
    private Container contentPane = null;
    private GridBagLayout gbl = null;
    private GridBagConstraints gbc = null;
    private JScrollPane jScrollPane;
    private ThreadDataWindowPanel panel;
    private Vector list = new Vector();
    private boolean percent = ParaProf.preferences.getShowValuesAsPercent();
    private int units = ParaProf.preferences.getUnits();
    private SearchPanel searchPanel;
    private boolean exclusivePercentOver100 = false;
    private Thread thread;

    public ThreadDataWindow(ParaProfTrial paraProfTrial, Thread thread) {
        this.ppTrial = paraProfTrial;
        paraProfTrial.getSystemEvents().addObserver(this);
        this.dataSorter = new DataSorter(paraProfTrial);
        this.dataSorter.setSelectedMetricID(paraProfTrial.getDefaultMetricID());
        this.dataSorter.setValueType(ValueType.EXCLUSIVE_PERCENT);
        this.thread = thread;
        this.ppThread = new PPThread(thread, paraProfTrial);
        this.setSize(new Dimension(700, 450));
        if (thread.getNodeID() == -1) {
            this.setTitle("Mean Data Window: " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        } else {
            this.setTitle(this.ppThread.getName() + " - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ThreadDataWindow.this.thisWindowClosing(windowEvent);
            }
        });
        if (ParaProf.helpWindow.isVisible()) {
            this.help(false);
        }
        this.contentPane = this.getContentPane();
        this.contentPane.setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.insets = new Insets(5, 5, 0, 5);
        this.panel = new ThreadDataWindowPanel(paraProfTrial, thread, this);
        this.addKeyListener(this);
        this.setupMenus();
        this.jScrollPane = new JScrollPane(this.panel);
        this.jScrollPane.setAutoscrolls(false);
        JScrollBar jScrollBar = this.jScrollPane.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(35);
        this.setHeader();
        this.requestFocus();
        this.barLengthSlider.setPaintTicks(true);
        this.barLengthSlider.setMajorTickSpacing(400);
        this.barLengthSlider.setMinorTickSpacing(50);
        this.barLengthSlider.setPaintLabels(true);
        this.barLengthSlider.setSnapToTicks(false);
        this.barLengthSlider.addChangeListener(this);
        this.gbc.fill = 1;
        this.gbc.anchor = 10;
        this.gbc.weightx = 0.95;
        this.gbc.weighty = 0.98;
        this.addCompItem(this.jScrollPane, this.gbc, 0, 1, 2, 1);
        this.sortLocalData();
        ParaProf.incrementNumWindows();
    }

    private Component createMetricMenu(final ValueType valueType, boolean bl, ButtonGroup buttonGroup) {
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        if (this.ppTrial.getNumberOfMetrics() == 1) {
            jRadioButtonMenuItem = new JRadioButtonMenuItem(valueType.toString(), bl);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ThreadDataWindow.this.dataSorter.setValueType(valueType);
                    ThreadDataWindow.this.sortLocalData();
                    ThreadDataWindow.this.panel.repaint();
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            return jRadioButtonMenuItem;
        }
        JMenu jMenu = new JMenu(valueType.toString() + "...");
        int n = 0;
        while (n < this.ppTrial.getNumberOfMetrics()) {
            jRadioButtonMenuItem = n == this.dataSorter.getSelectedMetricID() && bl ? new JRadioButtonMenuItem(this.ppTrial.getMetric(n).getName(), true) : new JRadioButtonMenuItem(this.ppTrial.getMetric(n).getName());
            final int n2 = n++;
            jRadioButtonMenuItem.addActionListener(new ActionListener(){
                final int metric;
                {
                    this.metric = n2;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ThreadDataWindow.this.dataSorter.setSelectedMetricID(this.metric);
                    ThreadDataWindow.this.dataSorter.setValueType(valueType);
                    ThreadDataWindow.this.sortLocalData();
                    ThreadDataWindow.this.panel.repaint();
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
        }
        return jMenu;
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.addKeyListener(this);
        JMenu jMenu = null;
        Object var3_3 = null;
        this.optionsMenu = new JMenu("Options");
        JCheckBoxMenuItem jCheckBoxMenuItem = null;
        ButtonGroup buttonGroup = null;
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThreadDataWindow.this.sortLocalData();
                ThreadDataWindow.this.panel.repaint();
            }
        };
        jCheckBoxMenuItem = new JCheckBoxMenuItem("Show Width Slider", false);
        jCheckBoxMenuItem.addActionListener(this);
        this.optionsMenu.add(jCheckBoxMenuItem);
        this.showFindPanelBox = new JCheckBoxMenuItem("Show Find Panel", false);
        this.showFindPanelBox.addActionListener(this);
        this.optionsMenu.add(this.showFindPanelBox);
        this.showMetaData = new JCheckBoxMenuItem("Show Meta Data in Panel", true);
        this.showMetaData.addActionListener(this);
        this.optionsMenu.add(this.showMetaData);
        this.optionsMenu.add(new JSeparator());
        this.sortByName = new JCheckBoxMenuItem("Sort By Name", false);
        this.sortByName.addActionListener(this);
        this.optionsMenu.add(this.sortByName);
        this.descendingOrder = new JCheckBoxMenuItem("Descending Order", true);
        this.descendingOrder.addActionListener(this);
        this.optionsMenu.add(this.descendingOrder);
        this.showValuesAsPercent = new JCheckBoxMenuItem("Show Values as Percent", ParaProf.preferences.getShowValuesAsPercent());
        this.showValuesAsPercent.addActionListener(this);
        this.optionsMenu.add(this.showValuesAsPercent);
        this.unitsSubMenu = ParaProfUtils.createUnitsMenu(this, this.units, true);
        this.optionsMenu.add(this.unitsSubMenu);
        jMenu = new JMenu("Select Metric...");
        buttonGroup = new ButtonGroup();
        jMenu.add(this.createMetricMenu(ValueType.EXCLUSIVE, this.dataSorter.getValueType() == ValueType.EXCLUSIVE || this.dataSorter.getValueType() == ValueType.EXCLUSIVE_PERCENT, buttonGroup));
        jMenu.add(this.createMetricMenu(ValueType.INCLUSIVE, this.dataSorter.getValueType() == ValueType.INCLUSIVE || this.dataSorter.getValueType() == ValueType.INCLUSIVE_PERCENT, buttonGroup));
        jMenu.add(this.createMetricMenu(ValueType.INCLUSIVE_PER_CALL, this.dataSorter.getValueType() == ValueType.INCLUSIVE_PER_CALL, buttonGroup));
        jMenu.add(this.createMetricMenu(ValueType.EXCLUSIVE_PER_CALL, this.dataSorter.getValueType() == ValueType.EXCLUSIVE_PER_CALL, buttonGroup));
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Calls", this.dataSorter.getValueType() == ValueType.NUMCALLS);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThreadDataWindow.this.dataSorter.setValueType(ValueType.NUMCALLS);
                ThreadDataWindow.this.sortLocalData();
                ThreadDataWindow.this.panel.repaint();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Child Calls", this.dataSorter.getValueType() == ValueType.NUMSUBR);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThreadDataWindow.this.dataSorter.setValueType(ValueType.NUMSUBR);
                ThreadDataWindow.this.sortLocalData();
                ThreadDataWindow.this.panel.repaint();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        this.optionsMenu.add(jMenu);
        this.optionsMenu.addMenuListener(this);
        jMenuBar.add(ParaProfUtils.createFileMenu(this, this.panel, this.panel));
        jMenuBar.add(this.optionsMenu);
        jMenuBar.add(ParaProfUtils.createWindowsMenu(this.ppTrial, this));
        jMenuBar.add(ParaProfUtils.createHelpMenu(this, this));
        this.setJMenuBar(jMenuBar);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Sort By Name")) {
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Descending Order")) {
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Show Values as Percent")) {
                    this.percent = this.showValuesAsPercent.isSelected();
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Exclusive")) {
                    if (this.exclusivePercentOver100) {
                        this.percent = false;
                        this.showValuesAsPercent.setEnabled(false);
                        this.showValuesAsPercent.setSelected(false);
                    }
                    this.dataSorter.setValueType(ValueType.EXCLUSIVE);
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Inclusive")) {
                    this.dataSorter.setValueType(ValueType.INCLUSIVE);
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Number of Calls")) {
                    this.dataSorter.setValueType(ValueType.NUMCALLS);
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Number of Child Calls")) {
                    this.dataSorter.setValueType(ValueType.NUMSUBR);
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Inclusive per Call")) {
                    this.dataSorter.setValueType(ValueType.INCLUSIVE_PER_CALL);
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Exclusive per Call")) {
                    this.dataSorter.setValueType(ValueType.EXCLUSIVE_PER_CALL);
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Show Width Slider")) {
                    if (((JCheckBoxMenuItem)object).isSelected()) {
                        this.showWidthSlider(true);
                    } else {
                        this.showWidthSlider(false);
                    }
                } else if (string.equals("Show Find Panel")) {
                    if (this.showFindPanelBox.isSelected()) {
                        this.showSearchPanel(true);
                    } else {
                        this.showSearchPanel(false);
                    }
                } else if (string.equals("Show Path Title in Reverse")) {
                    if (this.ppThread.getNodeID() == -1) {
                        this.setTitle("Mean Data Window: " + this.ppTrial.getTrialIdentifier(this.showPathTitleInReverse.isSelected()));
                    } else {
                        this.setTitle("n,c,t, " + this.ppThread.getNodeID() + "," + this.ppThread.getContextID() + "," + this.ppThread.getThreadID() + " - " + this.ppTrial.getTrialIdentifier(this.showPathTitleInReverse.isSelected()));
                    }
                } else if (string.equals("Show Meta Data in Panel")) {
                    this.setHeader();
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.panel.setBarLength(this.barLengthSlider.getValue());
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        try {
            if (this.dataSorter.getValueType() == ValueType.EXCLUSIVE || this.dataSorter.getValueType() == ValueType.INCLUSIVE || this.dataSorter.getValueType() == ValueType.EXCLUSIVE_PERCENT || this.dataSorter.getValueType() == ValueType.INCLUSIVE_PERCENT) {
                this.showValuesAsPercent.setEnabled(true);
                if (this.showValuesAsPercent.isSelected()) {
                    this.unitsSubMenu.setEnabled(false);
                } else {
                    String string = this.ppTrial.getMetricName(this.dataSorter.getSelectedMetricID());
                    string = string.toUpperCase();
                    if (this.dataSorter.isTimeMetric()) {
                        this.unitsSubMenu.setEnabled(true);
                    } else {
                        this.unitsSubMenu.setEnabled(false);
                    }
                }
            } else {
                this.showValuesAsPercent.setEnabled(false);
                if (this.dataSorter.getValueType() == ValueType.EXCLUSIVE_PER_CALL || this.dataSorter.getValueType() == ValueType.INCLUSIVE_PER_CALL) {
                    if (this.dataSorter.isTimeMetric()) {
                        this.unitsSubMenu.setEnabled(true);
                    } else {
                        this.unitsSubMenu.setEnabled(false);
                    }
                }
            }
            if (this.dataSorter.getValueType() == ValueType.EXCLUSIVE && this.exclusivePercentOver100) {
                this.percent = false;
                this.showValuesAsPercent.setEnabled(false);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("prefEvent")) {
            this.setHeader();
            this.panel.repaint();
        } else if (string.equals("colorEvent")) {
            this.panel.repaint();
        } else if (string.equals("dataEvent")) {
            this.sortLocalData();
            if (!this.ppTrial.isTimeMetric()) {
                this.units = 0;
            }
            this.setHeader();
            this.panel.repaint();
        } else if (string.equals("subWindowCloseEvent")) {
            this.closeThisWindow();
        }
    }

    public void help(boolean bl) {
        ParaProf.helpWindow.clearText();
        if (bl) {
            ParaProf.helpWindow.show();
        }
        ParaProf.helpWindow.writeText("This is the thread data window");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("This window shows you the values for all functions on this thread.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Right click on any function within this window to bring up a popup");
        ParaProf.helpWindow.writeText("menu. In this menu you can change or reset the default color");
        ParaProf.helpWindow.writeText("for the function, or to show more details about the function.");
        ParaProf.helpWindow.writeText("You can also left click any function to highlight it in the system.");
    }

    public DataSorter getDataSorter() {
        return this.dataSorter;
    }

    private void sortLocalData() {
        this.dataSorter.setDescendingOrder(this.descendingOrder.isSelected());
        if (this.showValuesAsPercent.isSelected()) {
            if (this.dataSorter.getValueType() == ValueType.EXCLUSIVE) {
                this.dataSorter.setValueType(ValueType.EXCLUSIVE_PERCENT);
            } else if (this.dataSorter.getValueType() == ValueType.INCLUSIVE) {
                this.dataSorter.setValueType(ValueType.INCLUSIVE_PERCENT);
            }
        } else if (this.dataSorter.getValueType() == ValueType.EXCLUSIVE_PERCENT) {
            this.dataSorter.setValueType(ValueType.EXCLUSIVE);
        } else if (this.dataSorter.getValueType() == ValueType.INCLUSIVE_PERCENT) {
            this.dataSorter.setValueType(ValueType.INCLUSIVE);
        }
        this.setHeader();
        if (this.sortByName.isSelected()) {
            this.dataSorter.setSortType(SortType.NAME);
        } else {
            this.dataSorter.setSortType(SortType.VALUE);
        }
        this.list = this.ppThread.getSortedFunctionProfiles(this.dataSorter, false);
        if (this.ppThread.getMaxExclusivePercent() > 100.0) {
            this.exclusivePercentOver100 = true;
            this.percent = false;
        }
        this.panel.resetStringSize();
    }

    public Vector getData() {
        return this.list;
    }

    public boolean isPercent() {
        return this.percent;
    }

    public int units() {
        if (this.showValuesAsPercent.isEnabled() && this.showValuesAsPercent.isSelected()) {
            return 0;
        }
        if (!this.dataSorter.isTimeMetric()) {
            return 0;
        }
        if (this.dataSorter.getValueType() == ValueType.NUMCALLS || this.dataSorter.getValueType() == ValueType.NUMSUBR) {
            return 0;
        }
        return this.units;
    }

    public Dimension getViewportSize() {
        return this.jScrollPane.getViewport().getExtentSize();
    }

    public Rectangle getViewRect() {
        return this.jScrollPane.getViewport().getViewRect();
    }

    public void setVerticalScrollBarPosition(int n) {
        JScrollBar jScrollBar = this.jScrollPane.getVerticalScrollBar();
        jScrollBar.setValue(n);
    }

    public void setHorizontalScrollBarPosition(int n) {
        JScrollBar jScrollBar = this.jScrollPane.getHorizontalScrollBar();
        jScrollBar.setValue(n);
    }

    public void setHeader() {
        if (this.showMetaData.isSelected()) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setEditable(false);
            PreferencesWindow preferencesWindow = this.ppTrial.getPreferencesWindow();
            jTextArea.setFont(new Font(preferencesWindow.getParaProfFont(), preferencesWindow.getFontStyle(), preferencesWindow.getFontSize()));
            jTextArea.append(this.getHeaderString());
            this.jScrollPane.setColumnHeaderView(jTextArea);
            jTextArea.addKeyListener(this);
        } else {
            this.jScrollPane.setColumnHeaderView(null);
        }
    }

    public String getHeaderString() {
        if (this.dataSorter.getValueType() == ValueType.NUMCALLS || this.dataSorter.getValueType() == ValueType.NUMSUBR || this.showValuesAsPercent.isSelected()) {
            return "Metric Name: " + this.ppTrial.getMetricName(this.dataSorter.getSelectedMetricID()) + "\n" + "Value Type: " + this.dataSorter.getValueType() + "\n";
        }
        return "Metric Name: " + this.ppTrial.getMetricName(this.dataSorter.getSelectedMetricID()) + "\n" + "Value Type: " + this.dataSorter.getValueType() + "\n" + "Units: " + UtilFncs.getUnitsString((int)this.units, (boolean)this.dataSorter.isTimeMetric(), (boolean)this.dataSorter.isDerivedMetric()) + "\n";
    }

    public void showSearchPanel(boolean bl) {
        if (bl) {
            if (this.searchPanel == null) {
                this.searchPanel = new SearchPanel(this, this.panel.getSearcher());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 10;
                gridBagConstraints.weightx = 0.1;
                gridBagConstraints.weighty = 0.01;
                this.addCompItem(this.searchPanel, gridBagConstraints, 0, 3, 2, 1);
                this.searchPanel.setFocus();
            }
        } else {
            this.getContentPane().remove(this.searchPanel);
            this.searchPanel = null;
        }
        this.showFindPanelBox.setSelected(bl);
        this.validate();
    }

    private void showWidthSlider(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (bl) {
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.barLengthLabel, gridBagConstraints, 0, 0, 1, 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.7;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.barLengthSlider, gridBagConstraints, 1, 0, 1, 1);
        } else {
            this.getContentPane().remove(this.barLengthLabel);
            this.getContentPane().remove(this.barLengthSlider);
        }
        this.validate();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    public void closeThisWindow() {
        try {
            this.setVisible(false);
            this.ppTrial.getSystemEvents().deleteObserver(this);
            ParaProf.decrementNumWindows();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
    }

    public PPThread getPPThread() {
        return this.ppThread;
    }

    public JScrollPane getJScrollPane() {
        return this.jScrollPane;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 70) {
            this.showSearchPanel(true);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public Dimension getThisViewportSize() {
        return this.getViewportSize();
    }

    public void setUnits(int n) {
        this.units = n;
        this.setHeader();
        this.panel.repaint();
    }
}

